from Observable import Observable

import gtk
import os



#
# Class for reporting when a file has changed.
#
class FileWatcher(Observable):

    OBS_CHANGE = 0



    def __init__(self, path):

        self.__path = path
        self.__mtime = 0
        
        gtk.timeout_add(500, self.__check_mtime)



    def __check_mtime(self):

        try:
            new_mtime = os.path.getmtime(self.__path)
            if (new_mtime != self.__mtime):
                self.__mtime = new_mtime
                self.update_observer(self.OBS_CHANGE, self.__path)
        except:
            if (not os.path.exists(self.__path)): return gtk.FALSE

        return gtk.TRUE
