
# 
# Copyright 1999-2006 University of Chicago
# 
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
# 
# http://www.apache.org/licenses/LICENSE-2.0
# 
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
# 

my $gpath = $ENV{GPT_LOCATION};

if (!defined($gpath))
{
  $gpath = "/usr";
}

@INC = (@INC, "$gpath/lib/perl");

require Grid::GPT::Setup;

my $metadata = new Grid::GPT::Setup(package_name => "globus_rls_server_setup");

require Globus::Core::Paths;

my $globusdir = $Globus::Core::Paths::prefix;
if (!defined($globusdir))
{
  $globusdir = $gpath;
}

my $setupdir = $Globus::Core::Paths::setupdir;
if (!defined($setupdir))
{
  $setupdir = "$globusdir/setup/globus";
}

my $libdir = $Globus::Core::Paths::libdir;
if (!defined($libdir))
{
  $libdir = "$globusdir/lib";
}

my $localstatedir = $Globus::Core::Paths::localstatedir;
if (!defined($localstatedir))
{
  $localstatedir = "$globusdir/var";
}

my $sbindir = $Globus::Core::Paths::sbindir;
if (!defined($sbindir))
{
  $sbindir = "$globusdir/sbin";
}

my $sysconfdir = $Globus::Core::Paths::sysconfdir;
if (!defined($sysconfdir))
{
  $sysconfdir = "$globusdir/etc";
}


my $shell = $ENV{GLOBUS_SH};
if (!defined($shell)) {
  $shell = "/bin/sh";
}

my $odbclib = "$libdir";

my $iodbc = $ENV{GLOBUS_IODBC_PATH};
if (defined($iodbc)) {
    $odbclib = "$iodbc/lib";
}
else {
    $iodbc = $ENV{GLOBUS_IODBC_LIBS};
    if (defined($iodbc)) {
        $odbclib = "$iodbc";
    }
    else {
        my $unixodbc = $ENV{GLOBUS_UNIXODBC_LIBS};
        if (defined($unixodbc)) {
            $odbclib = "$unixodbc";
        }
    }
}

my $odbcini = $ENV{ODBCINI};
if (!defined($odbcini)) {
  $odbcini = "$localstatedir/odbc.ini";
}

# Determine sysname
my $os = lc $^O;    # Convert sysname to lower case
$os =~ tr/a-z//cd;  # Remove digits, underscore, etc. from exotic sysnames

# Determine libsuffix
my $libsuffix = "so";  # Default to Linux/SunOS suffix
if ($os eq "darwin")
{
    $libsuffix = "dylib";
}   # Handle other os cases here, as needed

# Query GPT metadata for sqliteodbc flavor
my $sqliteodbcflavor = "";
my $sqliteodbc_pkgname = "globus_database_sqliteodbc";
my $installation = new Grid::GPT::Installation(globusdir => $gpath);
my $pkgs = $installation->query(
    pkgname => $sqliteodbc_pkgname,
    pkgtype => "dev");

if (@$pkgs < 1) {
    print "WARNING: $sqliteodbc_pkgname package not found. You may need to adjust the driver settings in $gpath/var/odbc.ini\n.";
}
if (@$pkgs > 1) {
    print "WARNING: More than one $sqliteodbc_pkgname package found. You may need to adjust the driver settings in $gpath/var/odbc.ini\n.";
}
if (@$pkgs >= 1) {
    $sqliteodbcflavor = "_" . @$pkgs[0]->flavor();
}

for my $f ("SXXrls", "globus-rls-server.conf", "rls-ldif.conf", "odbc.ini") {
  print "creating $f\n";
  open(FIN, "<$setupdir/${f}.in") || die "Can't find $setupdir/${f}.in";
  open(FOUT, ">$setupdir/${f}") || die "Can't open $setupdir/${f}.in";
  while (<FIN>) {
    s/\@GLOBUS_LOCATION\@/$globusdir/g;
    s/\@libdir\@/$libdir/g;
    s/\@localstatedir\@/$localstatedir/g;
    s/\@sbindir\@/$sbindir/g;
    s/\@ODBCLIB\@/$odbclib/g;
    s/\@ODBCINI\@/$odbcini/g;
    s/\@SHELL\@/$shell/g;
    s/\@LIBSUFFIX\@/$libsuffix/g;
    s/\@SQLITEODBCFLAVOR\@/$sqliteodbcflavor/g;
    print FOUT;
  }
  close FIN;
  close FOUT;
}

system("cp $setupdir/SXXrls $sbindir");
system("chmod 0755 $sbindir/SXXrls");

if (-e "$sysconfdir/globus-rls-server.conf") {
  print "$sysconfdir/globus-rls-server.conf already exists, not replacing with $setupdir/globus-rls-server.conf\n";
} else {
  system("cp $setupdir/globus-rls-server.conf $sysconfdir");
  system("chmod 0600 $sysconfdir/globus-rls-server.conf");
}

system("cp $setupdir/rls-ldif.conf $sysconfdir");
system("chmod 0644 $sysconfdir/rls-ldif.conf");

if (-e "$localstatedir/odbc.ini") {
  print "$localstatedir/odbc.ini already exists, not replacing with $setupdir/odbc.ini\n";
} else {
  system("cp $setupdir/odbc.ini $localstatedir");
  system("chmod 0644 $localstatedir/odbc.ini");
}

if (-e "$localstatedir/lrc1000.db") {
  print "$localstatedir/lrc1000.db already exists, not recreating lrc1000 database.\n";
} else {
  system("sqlite3 $localstatedir/lrc1000.db < $setupdir/globus-rls-lrc-sqlite.sql");
}

if (-e "$localstatedir/rli1000.db") {
  print "$localstatedir/rli1000.db already exists, not recreating rli1000 database.\n";
} else {
  system("sqlite3 $localstatedir/rli1000.db < $setupdir/globus-rls-rli-sqlite.sql");
}

print "Done\n";

$metadata->finish();
