/*
 * This file is part of GNAC - Gnome Audio Converter
 *
 * Copyright (C) 2007 - 2012 Gnac
 *
 *    - DUPASQUIER  Benoit    <bdupasqu@src.gnome.org>
 *    - JOAQUIM     David     <djoaquim@src.gnome.org>
 *    - ROUX        Alexandre <alexroux@src.gnome.org>
 *
 * GNAC is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNAC is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNAC; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, 
 * Boston, MA  02110-1301  USA
 */

#ifndef GNAC_PREFS_H
#define GNAC_PREFS_H

#include <gtk/gtk.h>

G_BEGIN_DECLS

void
gnac_prefs_window_show(void);

void
gnac_prefs_strip_special_toggled(GtkWidget *widget,
                                 gpointer   data);

void
gnac_prefs_same_radio_toggled(GtkWidget *widget,
                              gpointer   data);

void
gnac_prefs_subfolder_radio_toggled(GtkWidget *widget,
                                   gpointer   data);
void
gnac_prefs_subfolder_editing_done(GtkWidget *widget,
                                  gpointer   data);

void
gnac_prefs_selected_radio_toggled(GtkWidget *widget,
                                  gpointer   data);

void
gnac_prefs_selected_uri_changed(GtkWidget *widget,
                                gpointer   data);

void
gnac_prefs_update_example_label(GtkWidget *widget,
                                gpointer   data);

gboolean
gnac_prefs_button_press_event_cb(GtkWidget      *combo, 
                                 GdkEventButton *event, 
                                 gpointer        user_data);

void
gnac_prefs_pattern_changed_cb(GtkWidget *widget,
                              gpointer   data);

void
gnac_prefs_folder_hierarchy_changed_cb(GtkWidget *widget,
                                       gpointer   data);

gboolean
gnac_prefs_query_tooltip_cb(GtkWidget  *widget,
                            gint        x,
                            gint        y,
                            gboolean    keyboard_mode,
                            GtkTooltip *tooltip,
                            gpointer    user_data);

void
gnac_prefs_on_close(GtkWidget *widget,
                    gpointer   data);

void
gnac_prefs_destroy(void);

G_END_DECLS

#endif /* GNAC_PREFS_H */
