#include "xincs.h"
#include "fxver.h"
#include "fxdefs.h"
#include "FXArray.h"
#include "FXHash.h"
#include "FXStream.h"
#include "FXTextCodec.h"
#include "FXCP1257Codec.h"

namespace FX {

FXIMPLEMENT(FXCP1257Codec,FXTextCodec,nullptr,0)


//// Created by codec tool on 03/25/2005 from: CP1257.TXT ////
static const unsigned short forward_data[256]={
   0,    1,    2,    3,    4,    5,    6,    7,    8,    9,    10,   11,   12,   13,   14,   15,
   16,   17,   18,   19,   20,   21,   22,   23,   24,   25,   26,   27,   28,   29,   30,   31,
   32,   33,   34,   35,   36,   37,   38,   39,   40,   41,   42,   43,   44,   45,   46,   47,
   48,   49,   50,   51,   52,   53,   54,   55,   56,   57,   58,   59,   60,   61,   62,   63,
   64,   65,   66,   67,   68,   69,   70,   71,   72,   73,   74,   75,   76,   77,   78,   79,
   80,   81,   82,   83,   84,   85,   86,   87,   88,   89,   90,   91,   92,   93,   94,   95,
   96,   97,   98,   99,   100,  101,  102,  103,  104,  105,  106,  107,  108,  109,  110,  111,
   112,  113,  114,  115,  116,  117,  118,  119,  120,  121,  122,  123,  124,  125,  126,  127,
   8364, 65533, 8218, 65533, 8222, 8230, 8224, 8225, 65533, 8240, 65533, 8249, 65533, 168,  711,  184,
   65533, 8216, 8217, 8220, 8221, 8226, 8211, 8212, 65533, 8482, 65533, 8250, 65533, 175,  731,  65533,
   160,  65533, 162,  163,  164,  65533, 166,  167,  216,  169,  342,  171,  172,  173,  174,  198,
   176,  177,  178,  179,  180,  181,  182,  183,  248,  185,  343,  187,  188,  189,  190,  230,
   260,  302,  256,  262,  196,  197,  280,  274,  268,  201,  377,  278,  290,  310,  298,  315,
   352,  323,  325,  211,  332,  213,  214,  215,  370,  321,  346,  362,  220,  379,  381,  223,
   261,  303,  257,  263,  228,  229,  281,  275,  269,  233,  378,  279,  291,  311,  299,  316,
   353,  324,  326,  243,  333,  245,  246,  247,  371,  322,  347,  363,  252,  380,  382,  729,
  };


static const unsigned char reverse_plane[17]={
  0, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9,
  };

static const unsigned char reverse_pages[73]={
  0,  46, 46, 46, 46, 46, 46, 46, 109,46, 46, 46, 46, 46, 46, 46,
  46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46,
  46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46,
  46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46,
  46, 46, 46, 46, 46, 46, 46, 46, 46,
  };

static const unsigned short reverse_block[173]={
  0,   16,  32,  48,  64,  80,  96,  112, 128, 128, 144, 160, 175, 188, 204, 217,
  233, 247, 261, 277, 292, 306, 322, 336, 128, 128, 128, 128, 128, 128, 128, 128,
  128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 351, 359, 128, 128,
  128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128,
  128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128,
  128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128,
  128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 372, 388,
  404, 128, 128, 128, 128, 128, 128, 415, 128, 128, 128, 128, 128, 128, 128, 429,
  128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128,
  128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128,
  128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128,
  };

static const unsigned char reverse_data[445]={
   0,    1,    2,    3,    4,    5,    6,    7,    8,    9,    10,   11,   12,   13,   14,   15,
   16,   17,   18,   19,   20,   21,   22,   23,   24,   25,   26,   27,   28,   29,   30,   31,
   32,   33,   34,   35,   36,   37,   38,   39,   40,   41,   42,   43,   44,   45,   46,   47,
   48,   49,   50,   51,   52,   53,   54,   55,   56,   57,   58,   59,   60,   61,   62,   63,
   64,   65,   66,   67,   68,   69,   70,   71,   72,   73,   74,   75,   76,   77,   78,   79,
   80,   81,   82,   83,   84,   85,   86,   87,   88,   89,   90,   91,   92,   93,   94,   95,
   96,   97,   98,   99,   100,  101,  102,  103,  104,  105,  106,  107,  108,  109,  110,  111,
   112,  113,  114,  115,  116,  117,  118,  119,  120,  121,  122,  123,  124,  125,  126,  127,
   26,   26,   26,   26,   26,   26,   26,   26,   26,   26,   26,   26,   26,   26,   26,   26,
   160,  26,   162,  163,  164,  26,   166,  167,  141,  169,  26,   171,  172,  173,  174,  157,
   176,  177,  178,  179,  180,  181,  182,  183,  143,  185,  26,   187,  188,  189,  190,  26,
   26,   26,   26,   196,  197,  175,  26,   26,   201,  26,   26,   26,   26,   26,   26,   211,
   26,   213,  214,  215,  168,  26,   26,   26,   220,  26,   26,   223,  26,   26,   26,   26,
   228,  229,  191,  26,   26,   233,  26,   26,   26,   26,   26,   26,   243,  26,   245,  246,
   247,  184,  26,   26,   26,   252,  26,   26,   26,   194,  226,  26,   26,   192,  224,  195,
   227,  26,   26,   26,   26,   200,  232,  26,   26,   199,  231,  26,   26,   203,  235,  198,
   230,  26,   26,   26,   26,   26,   26,   204,  236,  26,   26,   26,   26,   26,   26,   206,
   238,  26,   26,   193,  225,  26,   26,   26,   26,   26,   26,   205,  237,  26,   26,   26,
   207,  239,  26,   26,   26,   217,  249,  209,  241,  210,  242,  26,   26,   26,   26,   26,
   212,  244,  26,   26,   26,   26,   26,   26,   170,  186,  26,   26,   218,  250,  26,   26,
   26,   26,   208,  240,  26,   26,   26,   26,   26,   26,   26,   26,   219,  251,  26,   26,
   26,   26,   216,  248,  26,   26,   26,   26,   26,   202,  234,  221,  253,  222,  254,  26,
   26,   26,   26,   26,   26,   26,   142,  26,   26,   26,   26,   26,   26,   26,   26,   26,
   255,  26,   158,  26,   26,   26,   26,   150,  151,  26,   26,   26,   145,  146,  130,  26,
   147,  148,  132,  26,   134,  135,  149,  26,   26,   26,   133,  26,   26,   26,   26,   26,
   26,   26,   26,   26,   137,  26,   26,   26,   26,   26,   26,   26,   26,   139,  155,  26,
   26,   26,   26,   26,   26,   26,   26,   26,   26,   26,   26,   128,  26,   26,   26,   153,
   26,   26,   26,   26,   26,   26,   26,   26,   26,   26,   26,   26,   26,
  };


FXint FXCP1257Codec::mb2wc(FXwchar& wc,const FXchar* src,FXint nsrc) const {
  if(nsrc<1) return -1;
  wc=forward_data[(FXuchar)src[0]];
  return 1;
  }


FXint FXCP1257Codec::wc2mb(FXchar* dst,FXint ndst,FXwchar wc) const {
  if(ndst<1) return -1;
  dst[0]=reverse_data[reverse_block[reverse_pages[reverse_plane[wc>>16]+((wc>>10)&63)]+((wc>>4)&63)]+(wc&15)];
  return 1;
  }

FXint FXCP1257Codec::mibEnum() const {
  return 2257;
  }


const FXchar* FXCP1257Codec::name() const {
  return "windows-1257";
  }


const FXchar* FXCP1257Codec::mimeName() const {
  return "windows-1257";
  }


const FXchar* const* FXCP1257Codec::aliases() const {
  static const FXchar *const list[]={"microsoft-cp1257","windows-1257","cp1257","microsoft-cp1257",nullptr};
  return list;
  }

}

