package web

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/validation"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// AppServiceEnvironmentsClient is the webSite Management Client
type AppServiceEnvironmentsClient struct {
	BaseClient
}

// NewAppServiceEnvironmentsClient creates an instance of the AppServiceEnvironmentsClient client.
func NewAppServiceEnvironmentsClient(subscriptionID string) AppServiceEnvironmentsClient {
	return NewAppServiceEnvironmentsClientWithBaseURI(DefaultBaseURI, subscriptionID)
}

// NewAppServiceEnvironmentsClientWithBaseURI creates an instance of the AppServiceEnvironmentsClient client using a
// custom endpoint.  Use this when interacting with an Azure cloud that uses a non-standard base URI (sovereign clouds,
// Azure stack).
func NewAppServiceEnvironmentsClientWithBaseURI(baseURI string, subscriptionID string) AppServiceEnvironmentsClient {
	return AppServiceEnvironmentsClient{NewWithBaseURI(baseURI, subscriptionID)}
}

// ChangeVnet move an App Service Environment to a different VNET.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the App Service Environment.
// vnetInfo - details for the new virtual network.
func (client AppServiceEnvironmentsClient) ChangeVnet(ctx context.Context, resourceGroupName string, name string, vnetInfo VirtualNetworkProfile) (result AppServiceEnvironmentsChangeVnetFuture, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppServiceEnvironmentsClient.ChangeVnet")
		defer func() {
			sc := -1
			if result.Response() != nil {
				sc = result.Response().StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppServiceEnvironmentsClient", "ChangeVnet", err.Error())
	}

	req, err := client.ChangeVnetPreparer(ctx, resourceGroupName, name, vnetInfo)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "ChangeVnet", nil, "Failure preparing request")
		return
	}

	result, err = client.ChangeVnetSender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "ChangeVnet", result.Response(), "Failure sending request")
		return
	}

	return
}

// ChangeVnetPreparer prepares the ChangeVnet request.
func (client AppServiceEnvironmentsClient) ChangeVnetPreparer(ctx context.Context, resourceGroupName string, name string, vnetInfo VirtualNetworkProfile) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2018-02-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	vnetInfo.Name = nil
	vnetInfo.Type = nil
	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/changeVirtualNetwork", pathParameters),
		autorest.WithJSON(vnetInfo),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ChangeVnetSender sends the ChangeVnet request. The method will close the
// http.Response Body if it receives an error.
func (client AppServiceEnvironmentsClient) ChangeVnetSender(req *http.Request) (future AppServiceEnvironmentsChangeVnetFuture, err error) {
	var resp *http.Response
	resp, err = client.Send(req, azure.DoRetryWithRegistration(client.Client))
	if err != nil {
		return
	}
	future.Future, err = azure.NewFutureFromResponse(resp)
	return
}

// ChangeVnetResponder handles the response to the ChangeVnet request. The method always
// closes the http.Response Body.
func (client AppServiceEnvironmentsClient) ChangeVnetResponder(resp *http.Response) (result AppCollectionPage, err error) {
	result.ac, err = client.changeVnetResponder(resp)
	result.fn = client.changeVnetNextResults
	return
}

func (client AppServiceEnvironmentsClient) changeVnetResponder(resp *http.Response) (result AppCollection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// changeVnetNextResults retrieves the next set of results, if any.
func (client AppServiceEnvironmentsClient) changeVnetNextResults(ctx context.Context, lastResults AppCollection) (result AppCollection, err error) {
	req, err := lastResults.appCollectionPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "changeVnetNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	var resp *http.Response
	resp, err = client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "changeVnetNextResults", resp, "Failure sending next results request")
	}
	return client.changeVnetResponder(resp)
}

// ChangeVnetComplete enumerates all values, automatically crossing page boundaries as required.
func (client AppServiceEnvironmentsClient) ChangeVnetComplete(ctx context.Context, resourceGroupName string, name string, vnetInfo VirtualNetworkProfile) (result AppServiceEnvironmentsChangeVnetAllFuture, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppServiceEnvironmentsClient.ChangeVnet")
		defer func() {
			sc := -1
			if result.Response() != nil {
				sc = result.Response().StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	var future AppServiceEnvironmentsChangeVnetFuture
	future, err = client.ChangeVnet(ctx, resourceGroupName, name, vnetInfo)
	result.Future = future.Future
	return
}

// CreateOrUpdate create or update an App Service Environment.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the App Service Environment.
// hostingEnvironmentEnvelope - configuration details of the App Service Environment.
func (client AppServiceEnvironmentsClient) CreateOrUpdate(ctx context.Context, resourceGroupName string, name string, hostingEnvironmentEnvelope AppServiceEnvironmentResource) (result AppServiceEnvironmentsCreateOrUpdateFuture, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppServiceEnvironmentsClient.CreateOrUpdate")
		defer func() {
			sc := -1
			if result.Response() != nil {
				sc = result.Response().StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}},
		{TargetValue: hostingEnvironmentEnvelope,
			Constraints: []validation.Constraint{{Target: "hostingEnvironmentEnvelope.AppServiceEnvironment", Name: validation.Null, Rule: false,
				Chain: []validation.Constraint{{Target: "hostingEnvironmentEnvelope.AppServiceEnvironment.Name", Name: validation.Null, Rule: true, Chain: nil},
					{Target: "hostingEnvironmentEnvelope.AppServiceEnvironment.Location", Name: validation.Null, Rule: true, Chain: nil},
					{Target: "hostingEnvironmentEnvelope.AppServiceEnvironment.VirtualNetwork", Name: validation.Null, Rule: true, Chain: nil},
					{Target: "hostingEnvironmentEnvelope.AppServiceEnvironment.WorkerPools", Name: validation.Null, Rule: true, Chain: nil},
				}}}}}); err != nil {
		return result, validation.NewError("web.AppServiceEnvironmentsClient", "CreateOrUpdate", err.Error())
	}

	req, err := client.CreateOrUpdatePreparer(ctx, resourceGroupName, name, hostingEnvironmentEnvelope)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "CreateOrUpdate", nil, "Failure preparing request")
		return
	}

	result, err = client.CreateOrUpdateSender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "CreateOrUpdate", result.Response(), "Failure sending request")
		return
	}

	return
}

// CreateOrUpdatePreparer prepares the CreateOrUpdate request.
func (client AppServiceEnvironmentsClient) CreateOrUpdatePreparer(ctx context.Context, resourceGroupName string, name string, hostingEnvironmentEnvelope AppServiceEnvironmentResource) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2018-02-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}", pathParameters),
		autorest.WithJSON(hostingEnvironmentEnvelope),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// CreateOrUpdateSender sends the CreateOrUpdate request. The method will close the
// http.Response Body if it receives an error.
func (client AppServiceEnvironmentsClient) CreateOrUpdateSender(req *http.Request) (future AppServiceEnvironmentsCreateOrUpdateFuture, err error) {
	var resp *http.Response
	resp, err = client.Send(req, azure.DoRetryWithRegistration(client.Client))
	if err != nil {
		return
	}
	future.Future, err = azure.NewFutureFromResponse(resp)
	return
}

// CreateOrUpdateResponder handles the response to the CreateOrUpdate request. The method always
// closes the http.Response Body.
func (client AppServiceEnvironmentsClient) CreateOrUpdateResponder(resp *http.Response) (result AppServiceEnvironmentResource, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted, http.StatusBadRequest, http.StatusNotFound, http.StatusConflict),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// CreateOrUpdateMultiRolePool create or update a multi-role pool.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the App Service Environment.
// multiRolePoolEnvelope - properties of the multi-role pool.
func (client AppServiceEnvironmentsClient) CreateOrUpdateMultiRolePool(ctx context.Context, resourceGroupName string, name string, multiRolePoolEnvelope WorkerPoolResource) (result AppServiceEnvironmentsCreateOrUpdateMultiRolePoolFuture, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppServiceEnvironmentsClient.CreateOrUpdateMultiRolePool")
		defer func() {
			sc := -1
			if result.Response() != nil {
				sc = result.Response().StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppServiceEnvironmentsClient", "CreateOrUpdateMultiRolePool", err.Error())
	}

	req, err := client.CreateOrUpdateMultiRolePoolPreparer(ctx, resourceGroupName, name, multiRolePoolEnvelope)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "CreateOrUpdateMultiRolePool", nil, "Failure preparing request")
		return
	}

	result, err = client.CreateOrUpdateMultiRolePoolSender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "CreateOrUpdateMultiRolePool", result.Response(), "Failure sending request")
		return
	}

	return
}

// CreateOrUpdateMultiRolePoolPreparer prepares the CreateOrUpdateMultiRolePool request.
func (client AppServiceEnvironmentsClient) CreateOrUpdateMultiRolePoolPreparer(ctx context.Context, resourceGroupName string, name string, multiRolePoolEnvelope WorkerPoolResource) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2018-02-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/multiRolePools/default", pathParameters),
		autorest.WithJSON(multiRolePoolEnvelope),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// CreateOrUpdateMultiRolePoolSender sends the CreateOrUpdateMultiRolePool request. The method will close the
// http.Response Body if it receives an error.
func (client AppServiceEnvironmentsClient) CreateOrUpdateMultiRolePoolSender(req *http.Request) (future AppServiceEnvironmentsCreateOrUpdateMultiRolePoolFuture, err error) {
	var resp *http.Response
	resp, err = client.Send(req, azure.DoRetryWithRegistration(client.Client))
	if err != nil {
		return
	}
	future.Future, err = azure.NewFutureFromResponse(resp)
	return
}

// CreateOrUpdateMultiRolePoolResponder handles the response to the CreateOrUpdateMultiRolePool request. The method always
// closes the http.Response Body.
func (client AppServiceEnvironmentsClient) CreateOrUpdateMultiRolePoolResponder(resp *http.Response) (result WorkerPoolResource, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted, http.StatusBadRequest, http.StatusNotFound, http.StatusConflict),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// CreateOrUpdateWorkerPool create or update a worker pool.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the App Service Environment.
// workerPoolName - name of the worker pool.
// workerPoolEnvelope - properties of the worker pool.
func (client AppServiceEnvironmentsClient) CreateOrUpdateWorkerPool(ctx context.Context, resourceGroupName string, name string, workerPoolName string, workerPoolEnvelope WorkerPoolResource) (result AppServiceEnvironmentsCreateOrUpdateWorkerPoolFuture, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppServiceEnvironmentsClient.CreateOrUpdateWorkerPool")
		defer func() {
			sc := -1
			if result.Response() != nil {
				sc = result.Response().StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppServiceEnvironmentsClient", "CreateOrUpdateWorkerPool", err.Error())
	}

	req, err := client.CreateOrUpdateWorkerPoolPreparer(ctx, resourceGroupName, name, workerPoolName, workerPoolEnvelope)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "CreateOrUpdateWorkerPool", nil, "Failure preparing request")
		return
	}

	result, err = client.CreateOrUpdateWorkerPoolSender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "CreateOrUpdateWorkerPool", result.Response(), "Failure sending request")
		return
	}

	return
}

// CreateOrUpdateWorkerPoolPreparer prepares the CreateOrUpdateWorkerPool request.
func (client AppServiceEnvironmentsClient) CreateOrUpdateWorkerPoolPreparer(ctx context.Context, resourceGroupName string, name string, workerPoolName string, workerPoolEnvelope WorkerPoolResource) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
		"workerPoolName":    autorest.Encode("path", workerPoolName),
	}

	const APIVersion = "2018-02-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/workerPools/{workerPoolName}", pathParameters),
		autorest.WithJSON(workerPoolEnvelope),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// CreateOrUpdateWorkerPoolSender sends the CreateOrUpdateWorkerPool request. The method will close the
// http.Response Body if it receives an error.
func (client AppServiceEnvironmentsClient) CreateOrUpdateWorkerPoolSender(req *http.Request) (future AppServiceEnvironmentsCreateOrUpdateWorkerPoolFuture, err error) {
	var resp *http.Response
	resp, err = client.Send(req, azure.DoRetryWithRegistration(client.Client))
	if err != nil {
		return
	}
	future.Future, err = azure.NewFutureFromResponse(resp)
	return
}

// CreateOrUpdateWorkerPoolResponder handles the response to the CreateOrUpdateWorkerPool request. The method always
// closes the http.Response Body.
func (client AppServiceEnvironmentsClient) CreateOrUpdateWorkerPoolResponder(resp *http.Response) (result WorkerPoolResource, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted, http.StatusBadRequest, http.StatusNotFound, http.StatusConflict),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// Delete delete an App Service Environment.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the App Service Environment.
// forceDelete - specify <code>true</code> to force the deletion even if the App Service Environment contains
// resources. The default is <code>false</code>.
func (client AppServiceEnvironmentsClient) Delete(ctx context.Context, resourceGroupName string, name string, forceDelete *bool) (result AppServiceEnvironmentsDeleteFuture, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppServiceEnvironmentsClient.Delete")
		defer func() {
			sc := -1
			if result.Response() != nil {
				sc = result.Response().StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppServiceEnvironmentsClient", "Delete", err.Error())
	}

	req, err := client.DeletePreparer(ctx, resourceGroupName, name, forceDelete)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "Delete", nil, "Failure preparing request")
		return
	}

	result, err = client.DeleteSender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "Delete", result.Response(), "Failure sending request")
		return
	}

	return
}

// DeletePreparer prepares the Delete request.
func (client AppServiceEnvironmentsClient) DeletePreparer(ctx context.Context, resourceGroupName string, name string, forceDelete *bool) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2018-02-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if forceDelete != nil {
		queryParameters["forceDelete"] = autorest.Encode("query", *forceDelete)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeleteSender sends the Delete request. The method will close the
// http.Response Body if it receives an error.
func (client AppServiceEnvironmentsClient) DeleteSender(req *http.Request) (future AppServiceEnvironmentsDeleteFuture, err error) {
	var resp *http.Response
	resp, err = client.Send(req, azure.DoRetryWithRegistration(client.Client))
	if err != nil {
		return
	}
	future.Future, err = azure.NewFutureFromResponse(resp)
	return
}

// DeleteResponder handles the response to the Delete request. The method always
// closes the http.Response Body.
func (client AppServiceEnvironmentsClient) DeleteResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted, http.StatusNoContent, http.StatusBadRequest, http.StatusNotFound, http.StatusConflict),
		autorest.ByClosing())
	result.Response = resp
	return
}

// Get get the properties of an App Service Environment.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the App Service Environment.
func (client AppServiceEnvironmentsClient) Get(ctx context.Context, resourceGroupName string, name string) (result AppServiceEnvironmentResource, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppServiceEnvironmentsClient.Get")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppServiceEnvironmentsClient", "Get", err.Error())
	}

	req, err := client.GetPreparer(ctx, resourceGroupName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "Get", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "Get", resp, "Failure sending request")
		return
	}

	result, err = client.GetResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "Get", resp, "Failure responding to request")
	}

	return
}

// GetPreparer prepares the Get request.
func (client AppServiceEnvironmentsClient) GetPreparer(ctx context.Context, resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2018-02-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetSender sends the Get request. The method will close the
// http.Response Body if it receives an error.
func (client AppServiceEnvironmentsClient) GetSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetResponder handles the response to the Get request. The method always
// closes the http.Response Body.
func (client AppServiceEnvironmentsClient) GetResponder(resp *http.Response) (result AppServiceEnvironmentResource, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetDiagnosticsItem get a diagnostics item for an App Service Environment.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the App Service Environment.
// diagnosticsName - name of the diagnostics item.
func (client AppServiceEnvironmentsClient) GetDiagnosticsItem(ctx context.Context, resourceGroupName string, name string, diagnosticsName string) (result HostingEnvironmentDiagnostics, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppServiceEnvironmentsClient.GetDiagnosticsItem")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppServiceEnvironmentsClient", "GetDiagnosticsItem", err.Error())
	}

	req, err := client.GetDiagnosticsItemPreparer(ctx, resourceGroupName, name, diagnosticsName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "GetDiagnosticsItem", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetDiagnosticsItemSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "GetDiagnosticsItem", resp, "Failure sending request")
		return
	}

	result, err = client.GetDiagnosticsItemResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "GetDiagnosticsItem", resp, "Failure responding to request")
	}

	return
}

// GetDiagnosticsItemPreparer prepares the GetDiagnosticsItem request.
func (client AppServiceEnvironmentsClient) GetDiagnosticsItemPreparer(ctx context.Context, resourceGroupName string, name string, diagnosticsName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"diagnosticsName":   autorest.Encode("path", diagnosticsName),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2018-02-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/diagnostics/{diagnosticsName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetDiagnosticsItemSender sends the GetDiagnosticsItem request. The method will close the
// http.Response Body if it receives an error.
func (client AppServiceEnvironmentsClient) GetDiagnosticsItemSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetDiagnosticsItemResponder handles the response to the GetDiagnosticsItem request. The method always
// closes the http.Response Body.
func (client AppServiceEnvironmentsClient) GetDiagnosticsItemResponder(resp *http.Response) (result HostingEnvironmentDiagnostics, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetInboundNetworkDependenciesEndpoints get the network endpoints of all inbound dependencies of an App Service
// Environment.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the App Service Environment.
func (client AppServiceEnvironmentsClient) GetInboundNetworkDependenciesEndpoints(ctx context.Context, resourceGroupName string, name string) (result InboundEnvironmentEndpointCollectionPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppServiceEnvironmentsClient.GetInboundNetworkDependenciesEndpoints")
		defer func() {
			sc := -1
			if result.ieec.Response.Response != nil {
				sc = result.ieec.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppServiceEnvironmentsClient", "GetInboundNetworkDependenciesEndpoints", err.Error())
	}

	result.fn = client.getInboundNetworkDependenciesEndpointsNextResults
	req, err := client.GetInboundNetworkDependenciesEndpointsPreparer(ctx, resourceGroupName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "GetInboundNetworkDependenciesEndpoints", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetInboundNetworkDependenciesEndpointsSender(req)
	if err != nil {
		result.ieec.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "GetInboundNetworkDependenciesEndpoints", resp, "Failure sending request")
		return
	}

	result.ieec, err = client.GetInboundNetworkDependenciesEndpointsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "GetInboundNetworkDependenciesEndpoints", resp, "Failure responding to request")
	}

	return
}

// GetInboundNetworkDependenciesEndpointsPreparer prepares the GetInboundNetworkDependenciesEndpoints request.
func (client AppServiceEnvironmentsClient) GetInboundNetworkDependenciesEndpointsPreparer(ctx context.Context, resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2018-02-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/inboundNetworkDependenciesEndpoints", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetInboundNetworkDependenciesEndpointsSender sends the GetInboundNetworkDependenciesEndpoints request. The method will close the
// http.Response Body if it receives an error.
func (client AppServiceEnvironmentsClient) GetInboundNetworkDependenciesEndpointsSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetInboundNetworkDependenciesEndpointsResponder handles the response to the GetInboundNetworkDependenciesEndpoints request. The method always
// closes the http.Response Body.
func (client AppServiceEnvironmentsClient) GetInboundNetworkDependenciesEndpointsResponder(resp *http.Response) (result InboundEnvironmentEndpointCollection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// getInboundNetworkDependenciesEndpointsNextResults retrieves the next set of results, if any.
func (client AppServiceEnvironmentsClient) getInboundNetworkDependenciesEndpointsNextResults(ctx context.Context, lastResults InboundEnvironmentEndpointCollection) (result InboundEnvironmentEndpointCollection, err error) {
	req, err := lastResults.inboundEnvironmentEndpointCollectionPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "getInboundNetworkDependenciesEndpointsNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.GetInboundNetworkDependenciesEndpointsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "getInboundNetworkDependenciesEndpointsNextResults", resp, "Failure sending next results request")
	}
	result, err = client.GetInboundNetworkDependenciesEndpointsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "getInboundNetworkDependenciesEndpointsNextResults", resp, "Failure responding to next results request")
	}
	return
}

// GetInboundNetworkDependenciesEndpointsComplete enumerates all values, automatically crossing page boundaries as required.
func (client AppServiceEnvironmentsClient) GetInboundNetworkDependenciesEndpointsComplete(ctx context.Context, resourceGroupName string, name string) (result InboundEnvironmentEndpointCollectionIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppServiceEnvironmentsClient.GetInboundNetworkDependenciesEndpoints")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.GetInboundNetworkDependenciesEndpoints(ctx, resourceGroupName, name)
	return
}

// GetMultiRolePool get properties of a multi-role pool.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the App Service Environment.
func (client AppServiceEnvironmentsClient) GetMultiRolePool(ctx context.Context, resourceGroupName string, name string) (result WorkerPoolResource, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppServiceEnvironmentsClient.GetMultiRolePool")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppServiceEnvironmentsClient", "GetMultiRolePool", err.Error())
	}

	req, err := client.GetMultiRolePoolPreparer(ctx, resourceGroupName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "GetMultiRolePool", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetMultiRolePoolSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "GetMultiRolePool", resp, "Failure sending request")
		return
	}

	result, err = client.GetMultiRolePoolResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "GetMultiRolePool", resp, "Failure responding to request")
	}

	return
}

// GetMultiRolePoolPreparer prepares the GetMultiRolePool request.
func (client AppServiceEnvironmentsClient) GetMultiRolePoolPreparer(ctx context.Context, resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2018-02-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/multiRolePools/default", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetMultiRolePoolSender sends the GetMultiRolePool request. The method will close the
// http.Response Body if it receives an error.
func (client AppServiceEnvironmentsClient) GetMultiRolePoolSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetMultiRolePoolResponder handles the response to the GetMultiRolePool request. The method always
// closes the http.Response Body.
func (client AppServiceEnvironmentsClient) GetMultiRolePoolResponder(resp *http.Response) (result WorkerPoolResource, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetOutboundNetworkDependenciesEndpoints get the network endpoints of all outbound dependencies of an App Service
// Environment.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the App Service Environment.
func (client AppServiceEnvironmentsClient) GetOutboundNetworkDependenciesEndpoints(ctx context.Context, resourceGroupName string, name string) (result OutboundEnvironmentEndpointCollectionPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppServiceEnvironmentsClient.GetOutboundNetworkDependenciesEndpoints")
		defer func() {
			sc := -1
			if result.oeec.Response.Response != nil {
				sc = result.oeec.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppServiceEnvironmentsClient", "GetOutboundNetworkDependenciesEndpoints", err.Error())
	}

	result.fn = client.getOutboundNetworkDependenciesEndpointsNextResults
	req, err := client.GetOutboundNetworkDependenciesEndpointsPreparer(ctx, resourceGroupName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "GetOutboundNetworkDependenciesEndpoints", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetOutboundNetworkDependenciesEndpointsSender(req)
	if err != nil {
		result.oeec.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "GetOutboundNetworkDependenciesEndpoints", resp, "Failure sending request")
		return
	}

	result.oeec, err = client.GetOutboundNetworkDependenciesEndpointsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "GetOutboundNetworkDependenciesEndpoints", resp, "Failure responding to request")
	}

	return
}

// GetOutboundNetworkDependenciesEndpointsPreparer prepares the GetOutboundNetworkDependenciesEndpoints request.
func (client AppServiceEnvironmentsClient) GetOutboundNetworkDependenciesEndpointsPreparer(ctx context.Context, resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2018-02-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/outboundNetworkDependenciesEndpoints", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetOutboundNetworkDependenciesEndpointsSender sends the GetOutboundNetworkDependenciesEndpoints request. The method will close the
// http.Response Body if it receives an error.
func (client AppServiceEnvironmentsClient) GetOutboundNetworkDependenciesEndpointsSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetOutboundNetworkDependenciesEndpointsResponder handles the response to the GetOutboundNetworkDependenciesEndpoints request. The method always
// closes the http.Response Body.
func (client AppServiceEnvironmentsClient) GetOutboundNetworkDependenciesEndpointsResponder(resp *http.Response) (result OutboundEnvironmentEndpointCollection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// getOutboundNetworkDependenciesEndpointsNextResults retrieves the next set of results, if any.
func (client AppServiceEnvironmentsClient) getOutboundNetworkDependenciesEndpointsNextResults(ctx context.Context, lastResults OutboundEnvironmentEndpointCollection) (result OutboundEnvironmentEndpointCollection, err error) {
	req, err := lastResults.outboundEnvironmentEndpointCollectionPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "getOutboundNetworkDependenciesEndpointsNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.GetOutboundNetworkDependenciesEndpointsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "getOutboundNetworkDependenciesEndpointsNextResults", resp, "Failure sending next results request")
	}
	result, err = client.GetOutboundNetworkDependenciesEndpointsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "getOutboundNetworkDependenciesEndpointsNextResults", resp, "Failure responding to next results request")
	}
	return
}

// GetOutboundNetworkDependenciesEndpointsComplete enumerates all values, automatically crossing page boundaries as required.
func (client AppServiceEnvironmentsClient) GetOutboundNetworkDependenciesEndpointsComplete(ctx context.Context, resourceGroupName string, name string) (result OutboundEnvironmentEndpointCollectionIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppServiceEnvironmentsClient.GetOutboundNetworkDependenciesEndpoints")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.GetOutboundNetworkDependenciesEndpoints(ctx, resourceGroupName, name)
	return
}

// GetWorkerPool get properties of a worker pool.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the App Service Environment.
// workerPoolName - name of the worker pool.
func (client AppServiceEnvironmentsClient) GetWorkerPool(ctx context.Context, resourceGroupName string, name string, workerPoolName string) (result WorkerPoolResource, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppServiceEnvironmentsClient.GetWorkerPool")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppServiceEnvironmentsClient", "GetWorkerPool", err.Error())
	}

	req, err := client.GetWorkerPoolPreparer(ctx, resourceGroupName, name, workerPoolName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "GetWorkerPool", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetWorkerPoolSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "GetWorkerPool", resp, "Failure sending request")
		return
	}

	result, err = client.GetWorkerPoolResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "GetWorkerPool", resp, "Failure responding to request")
	}

	return
}

// GetWorkerPoolPreparer prepares the GetWorkerPool request.
func (client AppServiceEnvironmentsClient) GetWorkerPoolPreparer(ctx context.Context, resourceGroupName string, name string, workerPoolName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
		"workerPoolName":    autorest.Encode("path", workerPoolName),
	}

	const APIVersion = "2018-02-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/workerPools/{workerPoolName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetWorkerPoolSender sends the GetWorkerPool request. The method will close the
// http.Response Body if it receives an error.
func (client AppServiceEnvironmentsClient) GetWorkerPoolSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetWorkerPoolResponder handles the response to the GetWorkerPool request. The method always
// closes the http.Response Body.
func (client AppServiceEnvironmentsClient) GetWorkerPoolResponder(resp *http.Response) (result WorkerPoolResource, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// List get all App Service Environments for a subscription.
func (client AppServiceEnvironmentsClient) List(ctx context.Context) (result AppServiceEnvironmentCollectionPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppServiceEnvironmentsClient.List")
		defer func() {
			sc := -1
			if result.asec.Response.Response != nil {
				sc = result.asec.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.fn = client.listNextResults
	req, err := client.ListPreparer(ctx)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "List", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListSender(req)
	if err != nil {
		result.asec.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "List", resp, "Failure sending request")
		return
	}

	result.asec, err = client.ListResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "List", resp, "Failure responding to request")
	}

	return
}

// ListPreparer prepares the List request.
func (client AppServiceEnvironmentsClient) ListPreparer(ctx context.Context) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"subscriptionId": autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2018-02-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/providers/Microsoft.Web/hostingEnvironments", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListSender sends the List request. The method will close the
// http.Response Body if it receives an error.
func (client AppServiceEnvironmentsClient) ListSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListResponder handles the response to the List request. The method always
// closes the http.Response Body.
func (client AppServiceEnvironmentsClient) ListResponder(resp *http.Response) (result AppServiceEnvironmentCollection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listNextResults retrieves the next set of results, if any.
func (client AppServiceEnvironmentsClient) listNextResults(ctx context.Context, lastResults AppServiceEnvironmentCollection) (result AppServiceEnvironmentCollection, err error) {
	req, err := lastResults.appServiceEnvironmentCollectionPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "listNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "listNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "listNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListComplete enumerates all values, automatically crossing page boundaries as required.
func (client AppServiceEnvironmentsClient) ListComplete(ctx context.Context) (result AppServiceEnvironmentCollectionIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppServiceEnvironmentsClient.List")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.List(ctx)
	return
}

// ListAppServicePlans get all App Service plans in an App Service Environment.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the App Service Environment.
func (client AppServiceEnvironmentsClient) ListAppServicePlans(ctx context.Context, resourceGroupName string, name string) (result AppServicePlanCollectionPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppServiceEnvironmentsClient.ListAppServicePlans")
		defer func() {
			sc := -1
			if result.aspc.Response.Response != nil {
				sc = result.aspc.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppServiceEnvironmentsClient", "ListAppServicePlans", err.Error())
	}

	result.fn = client.listAppServicePlansNextResults
	req, err := client.ListAppServicePlansPreparer(ctx, resourceGroupName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "ListAppServicePlans", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListAppServicePlansSender(req)
	if err != nil {
		result.aspc.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "ListAppServicePlans", resp, "Failure sending request")
		return
	}

	result.aspc, err = client.ListAppServicePlansResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "ListAppServicePlans", resp, "Failure responding to request")
	}

	return
}

// ListAppServicePlansPreparer prepares the ListAppServicePlans request.
func (client AppServiceEnvironmentsClient) ListAppServicePlansPreparer(ctx context.Context, resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2018-02-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/serverfarms", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListAppServicePlansSender sends the ListAppServicePlans request. The method will close the
// http.Response Body if it receives an error.
func (client AppServiceEnvironmentsClient) ListAppServicePlansSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListAppServicePlansResponder handles the response to the ListAppServicePlans request. The method always
// closes the http.Response Body.
func (client AppServiceEnvironmentsClient) ListAppServicePlansResponder(resp *http.Response) (result AppServicePlanCollection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listAppServicePlansNextResults retrieves the next set of results, if any.
func (client AppServiceEnvironmentsClient) listAppServicePlansNextResults(ctx context.Context, lastResults AppServicePlanCollection) (result AppServicePlanCollection, err error) {
	req, err := lastResults.appServicePlanCollectionPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "listAppServicePlansNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListAppServicePlansSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "listAppServicePlansNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListAppServicePlansResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "listAppServicePlansNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListAppServicePlansComplete enumerates all values, automatically crossing page boundaries as required.
func (client AppServiceEnvironmentsClient) ListAppServicePlansComplete(ctx context.Context, resourceGroupName string, name string) (result AppServicePlanCollectionIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppServiceEnvironmentsClient.ListAppServicePlans")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.ListAppServicePlans(ctx, resourceGroupName, name)
	return
}

// ListByResourceGroup get all App Service Environments in a resource group.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
func (client AppServiceEnvironmentsClient) ListByResourceGroup(ctx context.Context, resourceGroupName string) (result AppServiceEnvironmentCollectionPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppServiceEnvironmentsClient.ListByResourceGroup")
		defer func() {
			sc := -1
			if result.asec.Response.Response != nil {
				sc = result.asec.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppServiceEnvironmentsClient", "ListByResourceGroup", err.Error())
	}

	result.fn = client.listByResourceGroupNextResults
	req, err := client.ListByResourceGroupPreparer(ctx, resourceGroupName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "ListByResourceGroup", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListByResourceGroupSender(req)
	if err != nil {
		result.asec.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "ListByResourceGroup", resp, "Failure sending request")
		return
	}

	result.asec, err = client.ListByResourceGroupResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "ListByResourceGroup", resp, "Failure responding to request")
	}

	return
}

// ListByResourceGroupPreparer prepares the ListByResourceGroup request.
func (client AppServiceEnvironmentsClient) ListByResourceGroupPreparer(ctx context.Context, resourceGroupName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2018-02-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListByResourceGroupSender sends the ListByResourceGroup request. The method will close the
// http.Response Body if it receives an error.
func (client AppServiceEnvironmentsClient) ListByResourceGroupSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListByResourceGroupResponder handles the response to the ListByResourceGroup request. The method always
// closes the http.Response Body.
func (client AppServiceEnvironmentsClient) ListByResourceGroupResponder(resp *http.Response) (result AppServiceEnvironmentCollection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listByResourceGroupNextResults retrieves the next set of results, if any.
func (client AppServiceEnvironmentsClient) listByResourceGroupNextResults(ctx context.Context, lastResults AppServiceEnvironmentCollection) (result AppServiceEnvironmentCollection, err error) {
	req, err := lastResults.appServiceEnvironmentCollectionPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "listByResourceGroupNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListByResourceGroupSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "listByResourceGroupNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListByResourceGroupResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "listByResourceGroupNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListByResourceGroupComplete enumerates all values, automatically crossing page boundaries as required.
func (client AppServiceEnvironmentsClient) ListByResourceGroupComplete(ctx context.Context, resourceGroupName string) (result AppServiceEnvironmentCollectionIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppServiceEnvironmentsClient.ListByResourceGroup")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.ListByResourceGroup(ctx, resourceGroupName)
	return
}

// ListCapacities get the used, available, and total worker capacity an App Service Environment.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the App Service Environment.
func (client AppServiceEnvironmentsClient) ListCapacities(ctx context.Context, resourceGroupName string, name string) (result StampCapacityCollectionPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppServiceEnvironmentsClient.ListCapacities")
		defer func() {
			sc := -1
			if result.scc.Response.Response != nil {
				sc = result.scc.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppServiceEnvironmentsClient", "ListCapacities", err.Error())
	}

	result.fn = client.listCapacitiesNextResults
	req, err := client.ListCapacitiesPreparer(ctx, resourceGroupName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "ListCapacities", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListCapacitiesSender(req)
	if err != nil {
		result.scc.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "ListCapacities", resp, "Failure sending request")
		return
	}

	result.scc, err = client.ListCapacitiesResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "ListCapacities", resp, "Failure responding to request")
	}

	return
}

// ListCapacitiesPreparer prepares the ListCapacities request.
func (client AppServiceEnvironmentsClient) ListCapacitiesPreparer(ctx context.Context, resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2018-02-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/capacities/compute", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListCapacitiesSender sends the ListCapacities request. The method will close the
// http.Response Body if it receives an error.
func (client AppServiceEnvironmentsClient) ListCapacitiesSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListCapacitiesResponder handles the response to the ListCapacities request. The method always
// closes the http.Response Body.
func (client AppServiceEnvironmentsClient) ListCapacitiesResponder(resp *http.Response) (result StampCapacityCollection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listCapacitiesNextResults retrieves the next set of results, if any.
func (client AppServiceEnvironmentsClient) listCapacitiesNextResults(ctx context.Context, lastResults StampCapacityCollection) (result StampCapacityCollection, err error) {
	req, err := lastResults.stampCapacityCollectionPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "listCapacitiesNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListCapacitiesSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "listCapacitiesNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListCapacitiesResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "listCapacitiesNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListCapacitiesComplete enumerates all values, automatically crossing page boundaries as required.
func (client AppServiceEnvironmentsClient) ListCapacitiesComplete(ctx context.Context, resourceGroupName string, name string) (result StampCapacityCollectionIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppServiceEnvironmentsClient.ListCapacities")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.ListCapacities(ctx, resourceGroupName, name)
	return
}

// ListDiagnostics get diagnostic information for an App Service Environment.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the App Service Environment.
func (client AppServiceEnvironmentsClient) ListDiagnostics(ctx context.Context, resourceGroupName string, name string) (result ListHostingEnvironmentDiagnostics, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppServiceEnvironmentsClient.ListDiagnostics")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppServiceEnvironmentsClient", "ListDiagnostics", err.Error())
	}

	req, err := client.ListDiagnosticsPreparer(ctx, resourceGroupName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "ListDiagnostics", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListDiagnosticsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "ListDiagnostics", resp, "Failure sending request")
		return
	}

	result, err = client.ListDiagnosticsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "ListDiagnostics", resp, "Failure responding to request")
	}

	return
}

// ListDiagnosticsPreparer prepares the ListDiagnostics request.
func (client AppServiceEnvironmentsClient) ListDiagnosticsPreparer(ctx context.Context, resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2018-02-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/diagnostics", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListDiagnosticsSender sends the ListDiagnostics request. The method will close the
// http.Response Body if it receives an error.
func (client AppServiceEnvironmentsClient) ListDiagnosticsSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListDiagnosticsResponder handles the response to the ListDiagnostics request. The method always
// closes the http.Response Body.
func (client AppServiceEnvironmentsClient) ListDiagnosticsResponder(resp *http.Response) (result ListHostingEnvironmentDiagnostics, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListMetricDefinitions get global metric definitions of an App Service Environment.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the App Service Environment.
func (client AppServiceEnvironmentsClient) ListMetricDefinitions(ctx context.Context, resourceGroupName string, name string) (result MetricDefinition, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppServiceEnvironmentsClient.ListMetricDefinitions")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppServiceEnvironmentsClient", "ListMetricDefinitions", err.Error())
	}

	req, err := client.ListMetricDefinitionsPreparer(ctx, resourceGroupName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "ListMetricDefinitions", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListMetricDefinitionsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "ListMetricDefinitions", resp, "Failure sending request")
		return
	}

	result, err = client.ListMetricDefinitionsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "ListMetricDefinitions", resp, "Failure responding to request")
	}

	return
}

// ListMetricDefinitionsPreparer prepares the ListMetricDefinitions request.
func (client AppServiceEnvironmentsClient) ListMetricDefinitionsPreparer(ctx context.Context, resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2018-02-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/metricdefinitions", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListMetricDefinitionsSender sends the ListMetricDefinitions request. The method will close the
// http.Response Body if it receives an error.
func (client AppServiceEnvironmentsClient) ListMetricDefinitionsSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListMetricDefinitionsResponder handles the response to the ListMetricDefinitions request. The method always
// closes the http.Response Body.
func (client AppServiceEnvironmentsClient) ListMetricDefinitionsResponder(resp *http.Response) (result MetricDefinition, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListMetrics get global metrics of an App Service Environment.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the App Service Environment.
// details - specify <code>true</code> to include instance details. The default is <code>false</code>.
// filter - return only usages/metrics specified in the filter. Filter conforms to odata syntax. Example:
// $filter=(name.value eq 'Metric1' or name.value eq 'Metric2') and startTime eq 2014-01-01T00:00:00Z and
// endTime eq 2014-12-31T23:59:59Z and timeGrain eq duration'[Hour|Minute|Day]'.
func (client AppServiceEnvironmentsClient) ListMetrics(ctx context.Context, resourceGroupName string, name string, details *bool, filter string) (result ResourceMetricCollectionPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppServiceEnvironmentsClient.ListMetrics")
		defer func() {
			sc := -1
			if result.rmc.Response.Response != nil {
				sc = result.rmc.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppServiceEnvironmentsClient", "ListMetrics", err.Error())
	}

	result.fn = client.listMetricsNextResults
	req, err := client.ListMetricsPreparer(ctx, resourceGroupName, name, details, filter)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "ListMetrics", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListMetricsSender(req)
	if err != nil {
		result.rmc.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "ListMetrics", resp, "Failure sending request")
		return
	}

	result.rmc, err = client.ListMetricsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "ListMetrics", resp, "Failure responding to request")
	}

	return
}

// ListMetricsPreparer prepares the ListMetrics request.
func (client AppServiceEnvironmentsClient) ListMetricsPreparer(ctx context.Context, resourceGroupName string, name string, details *bool, filter string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2018-02-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if details != nil {
		queryParameters["details"] = autorest.Encode("query", *details)
	}
	if len(filter) > 0 {
		queryParameters["$filter"] = filter
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/metrics", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListMetricsSender sends the ListMetrics request. The method will close the
// http.Response Body if it receives an error.
func (client AppServiceEnvironmentsClient) ListMetricsSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListMetricsResponder handles the response to the ListMetrics request. The method always
// closes the http.Response Body.
func (client AppServiceEnvironmentsClient) ListMetricsResponder(resp *http.Response) (result ResourceMetricCollection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listMetricsNextResults retrieves the next set of results, if any.
func (client AppServiceEnvironmentsClient) listMetricsNextResults(ctx context.Context, lastResults ResourceMetricCollection) (result ResourceMetricCollection, err error) {
	req, err := lastResults.resourceMetricCollectionPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "listMetricsNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListMetricsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "listMetricsNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListMetricsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "listMetricsNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListMetricsComplete enumerates all values, automatically crossing page boundaries as required.
func (client AppServiceEnvironmentsClient) ListMetricsComplete(ctx context.Context, resourceGroupName string, name string, details *bool, filter string) (result ResourceMetricCollectionIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppServiceEnvironmentsClient.ListMetrics")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.ListMetrics(ctx, resourceGroupName, name, details, filter)
	return
}

// ListMultiRoleMetricDefinitions get metric definitions for a multi-role pool of an App Service Environment.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the App Service Environment.
func (client AppServiceEnvironmentsClient) ListMultiRoleMetricDefinitions(ctx context.Context, resourceGroupName string, name string) (result ResourceMetricDefinitionCollectionPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppServiceEnvironmentsClient.ListMultiRoleMetricDefinitions")
		defer func() {
			sc := -1
			if result.rmdc.Response.Response != nil {
				sc = result.rmdc.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppServiceEnvironmentsClient", "ListMultiRoleMetricDefinitions", err.Error())
	}

	result.fn = client.listMultiRoleMetricDefinitionsNextResults
	req, err := client.ListMultiRoleMetricDefinitionsPreparer(ctx, resourceGroupName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "ListMultiRoleMetricDefinitions", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListMultiRoleMetricDefinitionsSender(req)
	if err != nil {
		result.rmdc.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "ListMultiRoleMetricDefinitions", resp, "Failure sending request")
		return
	}

	result.rmdc, err = client.ListMultiRoleMetricDefinitionsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "ListMultiRoleMetricDefinitions", resp, "Failure responding to request")
	}

	return
}

// ListMultiRoleMetricDefinitionsPreparer prepares the ListMultiRoleMetricDefinitions request.
func (client AppServiceEnvironmentsClient) ListMultiRoleMetricDefinitionsPreparer(ctx context.Context, resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2018-02-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/multiRolePools/default/metricdefinitions", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListMultiRoleMetricDefinitionsSender sends the ListMultiRoleMetricDefinitions request. The method will close the
// http.Response Body if it receives an error.
func (client AppServiceEnvironmentsClient) ListMultiRoleMetricDefinitionsSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListMultiRoleMetricDefinitionsResponder handles the response to the ListMultiRoleMetricDefinitions request. The method always
// closes the http.Response Body.
func (client AppServiceEnvironmentsClient) ListMultiRoleMetricDefinitionsResponder(resp *http.Response) (result ResourceMetricDefinitionCollection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listMultiRoleMetricDefinitionsNextResults retrieves the next set of results, if any.
func (client AppServiceEnvironmentsClient) listMultiRoleMetricDefinitionsNextResults(ctx context.Context, lastResults ResourceMetricDefinitionCollection) (result ResourceMetricDefinitionCollection, err error) {
	req, err := lastResults.resourceMetricDefinitionCollectionPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "listMultiRoleMetricDefinitionsNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListMultiRoleMetricDefinitionsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "listMultiRoleMetricDefinitionsNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListMultiRoleMetricDefinitionsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "listMultiRoleMetricDefinitionsNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListMultiRoleMetricDefinitionsComplete enumerates all values, automatically crossing page boundaries as required.
func (client AppServiceEnvironmentsClient) ListMultiRoleMetricDefinitionsComplete(ctx context.Context, resourceGroupName string, name string) (result ResourceMetricDefinitionCollectionIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppServiceEnvironmentsClient.ListMultiRoleMetricDefinitions")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.ListMultiRoleMetricDefinitions(ctx, resourceGroupName, name)
	return
}

// ListMultiRoleMetrics get metrics for a multi-role pool of an App Service Environment.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the App Service Environment.
// startTime - beginning time of the metrics query.
// endTime - end time of the metrics query.
// timeGrain - time granularity of the metrics query.
// details - specify <code>true</code> to include instance details. The default is <code>false</code>.
// filter - return only usages/metrics specified in the filter. Filter conforms to odata syntax. Example:
// $filter=(name.value eq 'Metric1' or name.value eq 'Metric2') and startTime eq 2014-01-01T00:00:00Z and
// endTime eq 2014-12-31T23:59:59Z and timeGrain eq duration'[Hour|Minute|Day]'.
func (client AppServiceEnvironmentsClient) ListMultiRoleMetrics(ctx context.Context, resourceGroupName string, name string, startTime string, endTime string, timeGrain string, details *bool, filter string) (result ResourceMetricCollectionPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppServiceEnvironmentsClient.ListMultiRoleMetrics")
		defer func() {
			sc := -1
			if result.rmc.Response.Response != nil {
				sc = result.rmc.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppServiceEnvironmentsClient", "ListMultiRoleMetrics", err.Error())
	}

	result.fn = client.listMultiRoleMetricsNextResults
	req, err := client.ListMultiRoleMetricsPreparer(ctx, resourceGroupName, name, startTime, endTime, timeGrain, details, filter)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "ListMultiRoleMetrics", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListMultiRoleMetricsSender(req)
	if err != nil {
		result.rmc.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "ListMultiRoleMetrics", resp, "Failure sending request")
		return
	}

	result.rmc, err = client.ListMultiRoleMetricsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "ListMultiRoleMetrics", resp, "Failure responding to request")
	}

	return
}

// ListMultiRoleMetricsPreparer prepares the ListMultiRoleMetrics request.
func (client AppServiceEnvironmentsClient) ListMultiRoleMetricsPreparer(ctx context.Context, resourceGroupName string, name string, startTime string, endTime string, timeGrain string, details *bool, filter string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2018-02-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if len(startTime) > 0 {
		queryParameters["startTime"] = autorest.Encode("query", startTime)
	}
	if len(endTime) > 0 {
		queryParameters["endTime"] = autorest.Encode("query", endTime)
	}
	if len(timeGrain) > 0 {
		queryParameters["timeGrain"] = autorest.Encode("query", timeGrain)
	}
	if details != nil {
		queryParameters["details"] = autorest.Encode("query", *details)
	}
	if len(filter) > 0 {
		queryParameters["$filter"] = filter
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/multiRolePools/default/metrics", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListMultiRoleMetricsSender sends the ListMultiRoleMetrics request. The method will close the
// http.Response Body if it receives an error.
func (client AppServiceEnvironmentsClient) ListMultiRoleMetricsSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListMultiRoleMetricsResponder handles the response to the ListMultiRoleMetrics request. The method always
// closes the http.Response Body.
func (client AppServiceEnvironmentsClient) ListMultiRoleMetricsResponder(resp *http.Response) (result ResourceMetricCollection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listMultiRoleMetricsNextResults retrieves the next set of results, if any.
func (client AppServiceEnvironmentsClient) listMultiRoleMetricsNextResults(ctx context.Context, lastResults ResourceMetricCollection) (result ResourceMetricCollection, err error) {
	req, err := lastResults.resourceMetricCollectionPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "listMultiRoleMetricsNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListMultiRoleMetricsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "listMultiRoleMetricsNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListMultiRoleMetricsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "listMultiRoleMetricsNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListMultiRoleMetricsComplete enumerates all values, automatically crossing page boundaries as required.
func (client AppServiceEnvironmentsClient) ListMultiRoleMetricsComplete(ctx context.Context, resourceGroupName string, name string, startTime string, endTime string, timeGrain string, details *bool, filter string) (result ResourceMetricCollectionIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppServiceEnvironmentsClient.ListMultiRoleMetrics")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.ListMultiRoleMetrics(ctx, resourceGroupName, name, startTime, endTime, timeGrain, details, filter)
	return
}

// ListMultiRolePoolInstanceMetricDefinitions get metric definitions for a specific instance of a multi-role pool of an
// App Service Environment.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the App Service Environment.
// instance - name of the instance in the multi-role pool.
func (client AppServiceEnvironmentsClient) ListMultiRolePoolInstanceMetricDefinitions(ctx context.Context, resourceGroupName string, name string, instance string) (result ResourceMetricDefinitionCollectionPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppServiceEnvironmentsClient.ListMultiRolePoolInstanceMetricDefinitions")
		defer func() {
			sc := -1
			if result.rmdc.Response.Response != nil {
				sc = result.rmdc.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppServiceEnvironmentsClient", "ListMultiRolePoolInstanceMetricDefinitions", err.Error())
	}

	result.fn = client.listMultiRolePoolInstanceMetricDefinitionsNextResults
	req, err := client.ListMultiRolePoolInstanceMetricDefinitionsPreparer(ctx, resourceGroupName, name, instance)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "ListMultiRolePoolInstanceMetricDefinitions", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListMultiRolePoolInstanceMetricDefinitionsSender(req)
	if err != nil {
		result.rmdc.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "ListMultiRolePoolInstanceMetricDefinitions", resp, "Failure sending request")
		return
	}

	result.rmdc, err = client.ListMultiRolePoolInstanceMetricDefinitionsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "ListMultiRolePoolInstanceMetricDefinitions", resp, "Failure responding to request")
	}

	return
}

// ListMultiRolePoolInstanceMetricDefinitionsPreparer prepares the ListMultiRolePoolInstanceMetricDefinitions request.
func (client AppServiceEnvironmentsClient) ListMultiRolePoolInstanceMetricDefinitionsPreparer(ctx context.Context, resourceGroupName string, name string, instance string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"instance":          autorest.Encode("path", instance),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2018-02-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/multiRolePools/default/instances/{instance}/metricdefinitions", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListMultiRolePoolInstanceMetricDefinitionsSender sends the ListMultiRolePoolInstanceMetricDefinitions request. The method will close the
// http.Response Body if it receives an error.
func (client AppServiceEnvironmentsClient) ListMultiRolePoolInstanceMetricDefinitionsSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListMultiRolePoolInstanceMetricDefinitionsResponder handles the response to the ListMultiRolePoolInstanceMetricDefinitions request. The method always
// closes the http.Response Body.
func (client AppServiceEnvironmentsClient) ListMultiRolePoolInstanceMetricDefinitionsResponder(resp *http.Response) (result ResourceMetricDefinitionCollection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listMultiRolePoolInstanceMetricDefinitionsNextResults retrieves the next set of results, if any.
func (client AppServiceEnvironmentsClient) listMultiRolePoolInstanceMetricDefinitionsNextResults(ctx context.Context, lastResults ResourceMetricDefinitionCollection) (result ResourceMetricDefinitionCollection, err error) {
	req, err := lastResults.resourceMetricDefinitionCollectionPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "listMultiRolePoolInstanceMetricDefinitionsNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListMultiRolePoolInstanceMetricDefinitionsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "listMultiRolePoolInstanceMetricDefinitionsNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListMultiRolePoolInstanceMetricDefinitionsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "listMultiRolePoolInstanceMetricDefinitionsNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListMultiRolePoolInstanceMetricDefinitionsComplete enumerates all values, automatically crossing page boundaries as required.
func (client AppServiceEnvironmentsClient) ListMultiRolePoolInstanceMetricDefinitionsComplete(ctx context.Context, resourceGroupName string, name string, instance string) (result ResourceMetricDefinitionCollectionIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppServiceEnvironmentsClient.ListMultiRolePoolInstanceMetricDefinitions")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.ListMultiRolePoolInstanceMetricDefinitions(ctx, resourceGroupName, name, instance)
	return
}

// ListMultiRolePoolInstanceMetrics get metrics for a specific instance of a multi-role pool of an App Service
// Environment.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the App Service Environment.
// instance - name of the instance in the multi-role pool.
// details - specify <code>true</code> to include instance details. The default is <code>false</code>.
func (client AppServiceEnvironmentsClient) ListMultiRolePoolInstanceMetrics(ctx context.Context, resourceGroupName string, name string, instance string, details *bool) (result ResourceMetricCollectionPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppServiceEnvironmentsClient.ListMultiRolePoolInstanceMetrics")
		defer func() {
			sc := -1
			if result.rmc.Response.Response != nil {
				sc = result.rmc.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppServiceEnvironmentsClient", "ListMultiRolePoolInstanceMetrics", err.Error())
	}

	result.fn = client.listMultiRolePoolInstanceMetricsNextResults
	req, err := client.ListMultiRolePoolInstanceMetricsPreparer(ctx, resourceGroupName, name, instance, details)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "ListMultiRolePoolInstanceMetrics", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListMultiRolePoolInstanceMetricsSender(req)
	if err != nil {
		result.rmc.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "ListMultiRolePoolInstanceMetrics", resp, "Failure sending request")
		return
	}

	result.rmc, err = client.ListMultiRolePoolInstanceMetricsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "ListMultiRolePoolInstanceMetrics", resp, "Failure responding to request")
	}

	return
}

// ListMultiRolePoolInstanceMetricsPreparer prepares the ListMultiRolePoolInstanceMetrics request.
func (client AppServiceEnvironmentsClient) ListMultiRolePoolInstanceMetricsPreparer(ctx context.Context, resourceGroupName string, name string, instance string, details *bool) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"instance":          autorest.Encode("path", instance),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2018-02-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if details != nil {
		queryParameters["details"] = autorest.Encode("query", *details)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/multiRolePools/default/instances/{instance}/metrics", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListMultiRolePoolInstanceMetricsSender sends the ListMultiRolePoolInstanceMetrics request. The method will close the
// http.Response Body if it receives an error.
func (client AppServiceEnvironmentsClient) ListMultiRolePoolInstanceMetricsSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListMultiRolePoolInstanceMetricsResponder handles the response to the ListMultiRolePoolInstanceMetrics request. The method always
// closes the http.Response Body.
func (client AppServiceEnvironmentsClient) ListMultiRolePoolInstanceMetricsResponder(resp *http.Response) (result ResourceMetricCollection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listMultiRolePoolInstanceMetricsNextResults retrieves the next set of results, if any.
func (client AppServiceEnvironmentsClient) listMultiRolePoolInstanceMetricsNextResults(ctx context.Context, lastResults ResourceMetricCollection) (result ResourceMetricCollection, err error) {
	req, err := lastResults.resourceMetricCollectionPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "listMultiRolePoolInstanceMetricsNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListMultiRolePoolInstanceMetricsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "listMultiRolePoolInstanceMetricsNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListMultiRolePoolInstanceMetricsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "listMultiRolePoolInstanceMetricsNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListMultiRolePoolInstanceMetricsComplete enumerates all values, automatically crossing page boundaries as required.
func (client AppServiceEnvironmentsClient) ListMultiRolePoolInstanceMetricsComplete(ctx context.Context, resourceGroupName string, name string, instance string, details *bool) (result ResourceMetricCollectionIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppServiceEnvironmentsClient.ListMultiRolePoolInstanceMetrics")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.ListMultiRolePoolInstanceMetrics(ctx, resourceGroupName, name, instance, details)
	return
}

// ListMultiRolePools get all multi-role pools.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the App Service Environment.
func (client AppServiceEnvironmentsClient) ListMultiRolePools(ctx context.Context, resourceGroupName string, name string) (result WorkerPoolCollectionPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppServiceEnvironmentsClient.ListMultiRolePools")
		defer func() {
			sc := -1
			if result.wpc.Response.Response != nil {
				sc = result.wpc.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppServiceEnvironmentsClient", "ListMultiRolePools", err.Error())
	}

	result.fn = client.listMultiRolePoolsNextResults
	req, err := client.ListMultiRolePoolsPreparer(ctx, resourceGroupName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "ListMultiRolePools", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListMultiRolePoolsSender(req)
	if err != nil {
		result.wpc.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "ListMultiRolePools", resp, "Failure sending request")
		return
	}

	result.wpc, err = client.ListMultiRolePoolsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "ListMultiRolePools", resp, "Failure responding to request")
	}

	return
}

// ListMultiRolePoolsPreparer prepares the ListMultiRolePools request.
func (client AppServiceEnvironmentsClient) ListMultiRolePoolsPreparer(ctx context.Context, resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2018-02-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/multiRolePools", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListMultiRolePoolsSender sends the ListMultiRolePools request. The method will close the
// http.Response Body if it receives an error.
func (client AppServiceEnvironmentsClient) ListMultiRolePoolsSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListMultiRolePoolsResponder handles the response to the ListMultiRolePools request. The method always
// closes the http.Response Body.
func (client AppServiceEnvironmentsClient) ListMultiRolePoolsResponder(resp *http.Response) (result WorkerPoolCollection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listMultiRolePoolsNextResults retrieves the next set of results, if any.
func (client AppServiceEnvironmentsClient) listMultiRolePoolsNextResults(ctx context.Context, lastResults WorkerPoolCollection) (result WorkerPoolCollection, err error) {
	req, err := lastResults.workerPoolCollectionPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "listMultiRolePoolsNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListMultiRolePoolsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "listMultiRolePoolsNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListMultiRolePoolsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "listMultiRolePoolsNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListMultiRolePoolsComplete enumerates all values, automatically crossing page boundaries as required.
func (client AppServiceEnvironmentsClient) ListMultiRolePoolsComplete(ctx context.Context, resourceGroupName string, name string) (result WorkerPoolCollectionIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppServiceEnvironmentsClient.ListMultiRolePools")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.ListMultiRolePools(ctx, resourceGroupName, name)
	return
}

// ListMultiRolePoolSkus get available SKUs for scaling a multi-role pool.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the App Service Environment.
func (client AppServiceEnvironmentsClient) ListMultiRolePoolSkus(ctx context.Context, resourceGroupName string, name string) (result SkuInfoCollectionPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppServiceEnvironmentsClient.ListMultiRolePoolSkus")
		defer func() {
			sc := -1
			if result.sic.Response.Response != nil {
				sc = result.sic.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppServiceEnvironmentsClient", "ListMultiRolePoolSkus", err.Error())
	}

	result.fn = client.listMultiRolePoolSkusNextResults
	req, err := client.ListMultiRolePoolSkusPreparer(ctx, resourceGroupName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "ListMultiRolePoolSkus", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListMultiRolePoolSkusSender(req)
	if err != nil {
		result.sic.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "ListMultiRolePoolSkus", resp, "Failure sending request")
		return
	}

	result.sic, err = client.ListMultiRolePoolSkusResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "ListMultiRolePoolSkus", resp, "Failure responding to request")
	}

	return
}

// ListMultiRolePoolSkusPreparer prepares the ListMultiRolePoolSkus request.
func (client AppServiceEnvironmentsClient) ListMultiRolePoolSkusPreparer(ctx context.Context, resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2018-02-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/multiRolePools/default/skus", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListMultiRolePoolSkusSender sends the ListMultiRolePoolSkus request. The method will close the
// http.Response Body if it receives an error.
func (client AppServiceEnvironmentsClient) ListMultiRolePoolSkusSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListMultiRolePoolSkusResponder handles the response to the ListMultiRolePoolSkus request. The method always
// closes the http.Response Body.
func (client AppServiceEnvironmentsClient) ListMultiRolePoolSkusResponder(resp *http.Response) (result SkuInfoCollection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listMultiRolePoolSkusNextResults retrieves the next set of results, if any.
func (client AppServiceEnvironmentsClient) listMultiRolePoolSkusNextResults(ctx context.Context, lastResults SkuInfoCollection) (result SkuInfoCollection, err error) {
	req, err := lastResults.skuInfoCollectionPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "listMultiRolePoolSkusNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListMultiRolePoolSkusSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "listMultiRolePoolSkusNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListMultiRolePoolSkusResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "listMultiRolePoolSkusNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListMultiRolePoolSkusComplete enumerates all values, automatically crossing page boundaries as required.
func (client AppServiceEnvironmentsClient) ListMultiRolePoolSkusComplete(ctx context.Context, resourceGroupName string, name string) (result SkuInfoCollectionIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppServiceEnvironmentsClient.ListMultiRolePoolSkus")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.ListMultiRolePoolSkus(ctx, resourceGroupName, name)
	return
}

// ListMultiRoleUsages get usage metrics for a multi-role pool of an App Service Environment.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the App Service Environment.
func (client AppServiceEnvironmentsClient) ListMultiRoleUsages(ctx context.Context, resourceGroupName string, name string) (result UsageCollectionPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppServiceEnvironmentsClient.ListMultiRoleUsages")
		defer func() {
			sc := -1
			if result.uc.Response.Response != nil {
				sc = result.uc.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppServiceEnvironmentsClient", "ListMultiRoleUsages", err.Error())
	}

	result.fn = client.listMultiRoleUsagesNextResults
	req, err := client.ListMultiRoleUsagesPreparer(ctx, resourceGroupName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "ListMultiRoleUsages", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListMultiRoleUsagesSender(req)
	if err != nil {
		result.uc.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "ListMultiRoleUsages", resp, "Failure sending request")
		return
	}

	result.uc, err = client.ListMultiRoleUsagesResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "ListMultiRoleUsages", resp, "Failure responding to request")
	}

	return
}

// ListMultiRoleUsagesPreparer prepares the ListMultiRoleUsages request.
func (client AppServiceEnvironmentsClient) ListMultiRoleUsagesPreparer(ctx context.Context, resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2018-02-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/multiRolePools/default/usages", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListMultiRoleUsagesSender sends the ListMultiRoleUsages request. The method will close the
// http.Response Body if it receives an error.
func (client AppServiceEnvironmentsClient) ListMultiRoleUsagesSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListMultiRoleUsagesResponder handles the response to the ListMultiRoleUsages request. The method always
// closes the http.Response Body.
func (client AppServiceEnvironmentsClient) ListMultiRoleUsagesResponder(resp *http.Response) (result UsageCollection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listMultiRoleUsagesNextResults retrieves the next set of results, if any.
func (client AppServiceEnvironmentsClient) listMultiRoleUsagesNextResults(ctx context.Context, lastResults UsageCollection) (result UsageCollection, err error) {
	req, err := lastResults.usageCollectionPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "listMultiRoleUsagesNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListMultiRoleUsagesSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "listMultiRoleUsagesNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListMultiRoleUsagesResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "listMultiRoleUsagesNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListMultiRoleUsagesComplete enumerates all values, automatically crossing page boundaries as required.
func (client AppServiceEnvironmentsClient) ListMultiRoleUsagesComplete(ctx context.Context, resourceGroupName string, name string) (result UsageCollectionIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppServiceEnvironmentsClient.ListMultiRoleUsages")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.ListMultiRoleUsages(ctx, resourceGroupName, name)
	return
}

// ListOperations list all currently running operations on the App Service Environment.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the App Service Environment.
func (client AppServiceEnvironmentsClient) ListOperations(ctx context.Context, resourceGroupName string, name string) (result ListOperation, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppServiceEnvironmentsClient.ListOperations")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppServiceEnvironmentsClient", "ListOperations", err.Error())
	}

	req, err := client.ListOperationsPreparer(ctx, resourceGroupName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "ListOperations", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListOperationsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "ListOperations", resp, "Failure sending request")
		return
	}

	result, err = client.ListOperationsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "ListOperations", resp, "Failure responding to request")
	}

	return
}

// ListOperationsPreparer prepares the ListOperations request.
func (client AppServiceEnvironmentsClient) ListOperationsPreparer(ctx context.Context, resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2018-02-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/operations", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListOperationsSender sends the ListOperations request. The method will close the
// http.Response Body if it receives an error.
func (client AppServiceEnvironmentsClient) ListOperationsSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListOperationsResponder handles the response to the ListOperations request. The method always
// closes the http.Response Body.
func (client AppServiceEnvironmentsClient) ListOperationsResponder(resp *http.Response) (result ListOperation, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListUsages get global usage metrics of an App Service Environment.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the App Service Environment.
// filter - return only usages/metrics specified in the filter. Filter conforms to odata syntax. Example:
// $filter=(name.value eq 'Metric1' or name.value eq 'Metric2') and startTime eq 2014-01-01T00:00:00Z and
// endTime eq 2014-12-31T23:59:59Z and timeGrain eq duration'[Hour|Minute|Day]'.
func (client AppServiceEnvironmentsClient) ListUsages(ctx context.Context, resourceGroupName string, name string, filter string) (result CsmUsageQuotaCollectionPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppServiceEnvironmentsClient.ListUsages")
		defer func() {
			sc := -1
			if result.cuqc.Response.Response != nil {
				sc = result.cuqc.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppServiceEnvironmentsClient", "ListUsages", err.Error())
	}

	result.fn = client.listUsagesNextResults
	req, err := client.ListUsagesPreparer(ctx, resourceGroupName, name, filter)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "ListUsages", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListUsagesSender(req)
	if err != nil {
		result.cuqc.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "ListUsages", resp, "Failure sending request")
		return
	}

	result.cuqc, err = client.ListUsagesResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "ListUsages", resp, "Failure responding to request")
	}

	return
}

// ListUsagesPreparer prepares the ListUsages request.
func (client AppServiceEnvironmentsClient) ListUsagesPreparer(ctx context.Context, resourceGroupName string, name string, filter string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2018-02-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if len(filter) > 0 {
		queryParameters["$filter"] = filter
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/usages", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListUsagesSender sends the ListUsages request. The method will close the
// http.Response Body if it receives an error.
func (client AppServiceEnvironmentsClient) ListUsagesSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListUsagesResponder handles the response to the ListUsages request. The method always
// closes the http.Response Body.
func (client AppServiceEnvironmentsClient) ListUsagesResponder(resp *http.Response) (result CsmUsageQuotaCollection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listUsagesNextResults retrieves the next set of results, if any.
func (client AppServiceEnvironmentsClient) listUsagesNextResults(ctx context.Context, lastResults CsmUsageQuotaCollection) (result CsmUsageQuotaCollection, err error) {
	req, err := lastResults.csmUsageQuotaCollectionPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "listUsagesNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListUsagesSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "listUsagesNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListUsagesResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "listUsagesNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListUsagesComplete enumerates all values, automatically crossing page boundaries as required.
func (client AppServiceEnvironmentsClient) ListUsagesComplete(ctx context.Context, resourceGroupName string, name string, filter string) (result CsmUsageQuotaCollectionIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppServiceEnvironmentsClient.ListUsages")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.ListUsages(ctx, resourceGroupName, name, filter)
	return
}

// ListVips get IP addresses assigned to an App Service Environment.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the App Service Environment.
func (client AppServiceEnvironmentsClient) ListVips(ctx context.Context, resourceGroupName string, name string) (result AddressResponse, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppServiceEnvironmentsClient.ListVips")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppServiceEnvironmentsClient", "ListVips", err.Error())
	}

	req, err := client.ListVipsPreparer(ctx, resourceGroupName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "ListVips", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListVipsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "ListVips", resp, "Failure sending request")
		return
	}

	result, err = client.ListVipsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "ListVips", resp, "Failure responding to request")
	}

	return
}

// ListVipsPreparer prepares the ListVips request.
func (client AppServiceEnvironmentsClient) ListVipsPreparer(ctx context.Context, resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2018-02-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/capacities/virtualip", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListVipsSender sends the ListVips request. The method will close the
// http.Response Body if it receives an error.
func (client AppServiceEnvironmentsClient) ListVipsSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListVipsResponder handles the response to the ListVips request. The method always
// closes the http.Response Body.
func (client AppServiceEnvironmentsClient) ListVipsResponder(resp *http.Response) (result AddressResponse, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListWebApps get all apps in an App Service Environment.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the App Service Environment.
// propertiesToInclude - comma separated list of app properties to include.
func (client AppServiceEnvironmentsClient) ListWebApps(ctx context.Context, resourceGroupName string, name string, propertiesToInclude string) (result AppCollectionPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppServiceEnvironmentsClient.ListWebApps")
		defer func() {
			sc := -1
			if result.ac.Response.Response != nil {
				sc = result.ac.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppServiceEnvironmentsClient", "ListWebApps", err.Error())
	}

	result.fn = client.listWebAppsNextResults
	req, err := client.ListWebAppsPreparer(ctx, resourceGroupName, name, propertiesToInclude)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "ListWebApps", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListWebAppsSender(req)
	if err != nil {
		result.ac.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "ListWebApps", resp, "Failure sending request")
		return
	}

	result.ac, err = client.ListWebAppsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "ListWebApps", resp, "Failure responding to request")
	}

	return
}

// ListWebAppsPreparer prepares the ListWebApps request.
func (client AppServiceEnvironmentsClient) ListWebAppsPreparer(ctx context.Context, resourceGroupName string, name string, propertiesToInclude string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2018-02-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if len(propertiesToInclude) > 0 {
		queryParameters["propertiesToInclude"] = autorest.Encode("query", propertiesToInclude)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/sites", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListWebAppsSender sends the ListWebApps request. The method will close the
// http.Response Body if it receives an error.
func (client AppServiceEnvironmentsClient) ListWebAppsSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListWebAppsResponder handles the response to the ListWebApps request. The method always
// closes the http.Response Body.
func (client AppServiceEnvironmentsClient) ListWebAppsResponder(resp *http.Response) (result AppCollection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listWebAppsNextResults retrieves the next set of results, if any.
func (client AppServiceEnvironmentsClient) listWebAppsNextResults(ctx context.Context, lastResults AppCollection) (result AppCollection, err error) {
	req, err := lastResults.appCollectionPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "listWebAppsNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListWebAppsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "listWebAppsNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListWebAppsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "listWebAppsNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListWebAppsComplete enumerates all values, automatically crossing page boundaries as required.
func (client AppServiceEnvironmentsClient) ListWebAppsComplete(ctx context.Context, resourceGroupName string, name string, propertiesToInclude string) (result AppCollectionIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppServiceEnvironmentsClient.ListWebApps")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.ListWebApps(ctx, resourceGroupName, name, propertiesToInclude)
	return
}

// ListWebWorkerMetricDefinitions get metric definitions for a worker pool of an App Service Environment.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the App Service Environment.
// workerPoolName - name of the worker pool.
func (client AppServiceEnvironmentsClient) ListWebWorkerMetricDefinitions(ctx context.Context, resourceGroupName string, name string, workerPoolName string) (result ResourceMetricDefinitionCollectionPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppServiceEnvironmentsClient.ListWebWorkerMetricDefinitions")
		defer func() {
			sc := -1
			if result.rmdc.Response.Response != nil {
				sc = result.rmdc.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppServiceEnvironmentsClient", "ListWebWorkerMetricDefinitions", err.Error())
	}

	result.fn = client.listWebWorkerMetricDefinitionsNextResults
	req, err := client.ListWebWorkerMetricDefinitionsPreparer(ctx, resourceGroupName, name, workerPoolName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "ListWebWorkerMetricDefinitions", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListWebWorkerMetricDefinitionsSender(req)
	if err != nil {
		result.rmdc.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "ListWebWorkerMetricDefinitions", resp, "Failure sending request")
		return
	}

	result.rmdc, err = client.ListWebWorkerMetricDefinitionsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "ListWebWorkerMetricDefinitions", resp, "Failure responding to request")
	}

	return
}

// ListWebWorkerMetricDefinitionsPreparer prepares the ListWebWorkerMetricDefinitions request.
func (client AppServiceEnvironmentsClient) ListWebWorkerMetricDefinitionsPreparer(ctx context.Context, resourceGroupName string, name string, workerPoolName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
		"workerPoolName":    autorest.Encode("path", workerPoolName),
	}

	const APIVersion = "2018-02-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/workerPools/{workerPoolName}/metricdefinitions", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListWebWorkerMetricDefinitionsSender sends the ListWebWorkerMetricDefinitions request. The method will close the
// http.Response Body if it receives an error.
func (client AppServiceEnvironmentsClient) ListWebWorkerMetricDefinitionsSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListWebWorkerMetricDefinitionsResponder handles the response to the ListWebWorkerMetricDefinitions request. The method always
// closes the http.Response Body.
func (client AppServiceEnvironmentsClient) ListWebWorkerMetricDefinitionsResponder(resp *http.Response) (result ResourceMetricDefinitionCollection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listWebWorkerMetricDefinitionsNextResults retrieves the next set of results, if any.
func (client AppServiceEnvironmentsClient) listWebWorkerMetricDefinitionsNextResults(ctx context.Context, lastResults ResourceMetricDefinitionCollection) (result ResourceMetricDefinitionCollection, err error) {
	req, err := lastResults.resourceMetricDefinitionCollectionPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "listWebWorkerMetricDefinitionsNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListWebWorkerMetricDefinitionsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "listWebWorkerMetricDefinitionsNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListWebWorkerMetricDefinitionsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "listWebWorkerMetricDefinitionsNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListWebWorkerMetricDefinitionsComplete enumerates all values, automatically crossing page boundaries as required.
func (client AppServiceEnvironmentsClient) ListWebWorkerMetricDefinitionsComplete(ctx context.Context, resourceGroupName string, name string, workerPoolName string) (result ResourceMetricDefinitionCollectionIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppServiceEnvironmentsClient.ListWebWorkerMetricDefinitions")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.ListWebWorkerMetricDefinitions(ctx, resourceGroupName, name, workerPoolName)
	return
}

// ListWebWorkerMetrics get metrics for a worker pool of a AppServiceEnvironment (App Service Environment).
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the App Service Environment.
// workerPoolName - name of worker pool
// details - specify <code>true</code> to include instance details. The default is <code>false</code>.
// filter - return only usages/metrics specified in the filter. Filter conforms to odata syntax. Example:
// $filter=(name.value eq 'Metric1' or name.value eq 'Metric2') and startTime eq 2014-01-01T00:00:00Z and
// endTime eq 2014-12-31T23:59:59Z and timeGrain eq duration'[Hour|Minute|Day]'.
func (client AppServiceEnvironmentsClient) ListWebWorkerMetrics(ctx context.Context, resourceGroupName string, name string, workerPoolName string, details *bool, filter string) (result ResourceMetricCollectionPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppServiceEnvironmentsClient.ListWebWorkerMetrics")
		defer func() {
			sc := -1
			if result.rmc.Response.Response != nil {
				sc = result.rmc.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppServiceEnvironmentsClient", "ListWebWorkerMetrics", err.Error())
	}

	result.fn = client.listWebWorkerMetricsNextResults
	req, err := client.ListWebWorkerMetricsPreparer(ctx, resourceGroupName, name, workerPoolName, details, filter)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "ListWebWorkerMetrics", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListWebWorkerMetricsSender(req)
	if err != nil {
		result.rmc.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "ListWebWorkerMetrics", resp, "Failure sending request")
		return
	}

	result.rmc, err = client.ListWebWorkerMetricsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "ListWebWorkerMetrics", resp, "Failure responding to request")
	}

	return
}

// ListWebWorkerMetricsPreparer prepares the ListWebWorkerMetrics request.
func (client AppServiceEnvironmentsClient) ListWebWorkerMetricsPreparer(ctx context.Context, resourceGroupName string, name string, workerPoolName string, details *bool, filter string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
		"workerPoolName":    autorest.Encode("path", workerPoolName),
	}

	const APIVersion = "2018-02-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if details != nil {
		queryParameters["details"] = autorest.Encode("query", *details)
	}
	if len(filter) > 0 {
		queryParameters["$filter"] = filter
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/workerPools/{workerPoolName}/metrics", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListWebWorkerMetricsSender sends the ListWebWorkerMetrics request. The method will close the
// http.Response Body if it receives an error.
func (client AppServiceEnvironmentsClient) ListWebWorkerMetricsSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListWebWorkerMetricsResponder handles the response to the ListWebWorkerMetrics request. The method always
// closes the http.Response Body.
func (client AppServiceEnvironmentsClient) ListWebWorkerMetricsResponder(resp *http.Response) (result ResourceMetricCollection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listWebWorkerMetricsNextResults retrieves the next set of results, if any.
func (client AppServiceEnvironmentsClient) listWebWorkerMetricsNextResults(ctx context.Context, lastResults ResourceMetricCollection) (result ResourceMetricCollection, err error) {
	req, err := lastResults.resourceMetricCollectionPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "listWebWorkerMetricsNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListWebWorkerMetricsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "listWebWorkerMetricsNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListWebWorkerMetricsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "listWebWorkerMetricsNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListWebWorkerMetricsComplete enumerates all values, automatically crossing page boundaries as required.
func (client AppServiceEnvironmentsClient) ListWebWorkerMetricsComplete(ctx context.Context, resourceGroupName string, name string, workerPoolName string, details *bool, filter string) (result ResourceMetricCollectionIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppServiceEnvironmentsClient.ListWebWorkerMetrics")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.ListWebWorkerMetrics(ctx, resourceGroupName, name, workerPoolName, details, filter)
	return
}

// ListWebWorkerUsages get usage metrics for a worker pool of an App Service Environment.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the App Service Environment.
// workerPoolName - name of the worker pool.
func (client AppServiceEnvironmentsClient) ListWebWorkerUsages(ctx context.Context, resourceGroupName string, name string, workerPoolName string) (result UsageCollectionPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppServiceEnvironmentsClient.ListWebWorkerUsages")
		defer func() {
			sc := -1
			if result.uc.Response.Response != nil {
				sc = result.uc.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppServiceEnvironmentsClient", "ListWebWorkerUsages", err.Error())
	}

	result.fn = client.listWebWorkerUsagesNextResults
	req, err := client.ListWebWorkerUsagesPreparer(ctx, resourceGroupName, name, workerPoolName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "ListWebWorkerUsages", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListWebWorkerUsagesSender(req)
	if err != nil {
		result.uc.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "ListWebWorkerUsages", resp, "Failure sending request")
		return
	}

	result.uc, err = client.ListWebWorkerUsagesResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "ListWebWorkerUsages", resp, "Failure responding to request")
	}

	return
}

// ListWebWorkerUsagesPreparer prepares the ListWebWorkerUsages request.
func (client AppServiceEnvironmentsClient) ListWebWorkerUsagesPreparer(ctx context.Context, resourceGroupName string, name string, workerPoolName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
		"workerPoolName":    autorest.Encode("path", workerPoolName),
	}

	const APIVersion = "2018-02-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/workerPools/{workerPoolName}/usages", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListWebWorkerUsagesSender sends the ListWebWorkerUsages request. The method will close the
// http.Response Body if it receives an error.
func (client AppServiceEnvironmentsClient) ListWebWorkerUsagesSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListWebWorkerUsagesResponder handles the response to the ListWebWorkerUsages request. The method always
// closes the http.Response Body.
func (client AppServiceEnvironmentsClient) ListWebWorkerUsagesResponder(resp *http.Response) (result UsageCollection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listWebWorkerUsagesNextResults retrieves the next set of results, if any.
func (client AppServiceEnvironmentsClient) listWebWorkerUsagesNextResults(ctx context.Context, lastResults UsageCollection) (result UsageCollection, err error) {
	req, err := lastResults.usageCollectionPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "listWebWorkerUsagesNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListWebWorkerUsagesSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "listWebWorkerUsagesNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListWebWorkerUsagesResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "listWebWorkerUsagesNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListWebWorkerUsagesComplete enumerates all values, automatically crossing page boundaries as required.
func (client AppServiceEnvironmentsClient) ListWebWorkerUsagesComplete(ctx context.Context, resourceGroupName string, name string, workerPoolName string) (result UsageCollectionIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppServiceEnvironmentsClient.ListWebWorkerUsages")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.ListWebWorkerUsages(ctx, resourceGroupName, name, workerPoolName)
	return
}

// ListWorkerPoolInstanceMetricDefinitions get metric definitions for a specific instance of a worker pool of an App
// Service Environment.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the App Service Environment.
// workerPoolName - name of the worker pool.
// instance - name of the instance in the worker pool.
func (client AppServiceEnvironmentsClient) ListWorkerPoolInstanceMetricDefinitions(ctx context.Context, resourceGroupName string, name string, workerPoolName string, instance string) (result ResourceMetricDefinitionCollectionPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppServiceEnvironmentsClient.ListWorkerPoolInstanceMetricDefinitions")
		defer func() {
			sc := -1
			if result.rmdc.Response.Response != nil {
				sc = result.rmdc.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppServiceEnvironmentsClient", "ListWorkerPoolInstanceMetricDefinitions", err.Error())
	}

	result.fn = client.listWorkerPoolInstanceMetricDefinitionsNextResults
	req, err := client.ListWorkerPoolInstanceMetricDefinitionsPreparer(ctx, resourceGroupName, name, workerPoolName, instance)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "ListWorkerPoolInstanceMetricDefinitions", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListWorkerPoolInstanceMetricDefinitionsSender(req)
	if err != nil {
		result.rmdc.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "ListWorkerPoolInstanceMetricDefinitions", resp, "Failure sending request")
		return
	}

	result.rmdc, err = client.ListWorkerPoolInstanceMetricDefinitionsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "ListWorkerPoolInstanceMetricDefinitions", resp, "Failure responding to request")
	}

	return
}

// ListWorkerPoolInstanceMetricDefinitionsPreparer prepares the ListWorkerPoolInstanceMetricDefinitions request.
func (client AppServiceEnvironmentsClient) ListWorkerPoolInstanceMetricDefinitionsPreparer(ctx context.Context, resourceGroupName string, name string, workerPoolName string, instance string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"instance":          autorest.Encode("path", instance),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
		"workerPoolName":    autorest.Encode("path", workerPoolName),
	}

	const APIVersion = "2018-02-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/workerPools/{workerPoolName}/instances/{instance}/metricdefinitions", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListWorkerPoolInstanceMetricDefinitionsSender sends the ListWorkerPoolInstanceMetricDefinitions request. The method will close the
// http.Response Body if it receives an error.
func (client AppServiceEnvironmentsClient) ListWorkerPoolInstanceMetricDefinitionsSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListWorkerPoolInstanceMetricDefinitionsResponder handles the response to the ListWorkerPoolInstanceMetricDefinitions request. The method always
// closes the http.Response Body.
func (client AppServiceEnvironmentsClient) ListWorkerPoolInstanceMetricDefinitionsResponder(resp *http.Response) (result ResourceMetricDefinitionCollection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listWorkerPoolInstanceMetricDefinitionsNextResults retrieves the next set of results, if any.
func (client AppServiceEnvironmentsClient) listWorkerPoolInstanceMetricDefinitionsNextResults(ctx context.Context, lastResults ResourceMetricDefinitionCollection) (result ResourceMetricDefinitionCollection, err error) {
	req, err := lastResults.resourceMetricDefinitionCollectionPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "listWorkerPoolInstanceMetricDefinitionsNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListWorkerPoolInstanceMetricDefinitionsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "listWorkerPoolInstanceMetricDefinitionsNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListWorkerPoolInstanceMetricDefinitionsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "listWorkerPoolInstanceMetricDefinitionsNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListWorkerPoolInstanceMetricDefinitionsComplete enumerates all values, automatically crossing page boundaries as required.
func (client AppServiceEnvironmentsClient) ListWorkerPoolInstanceMetricDefinitionsComplete(ctx context.Context, resourceGroupName string, name string, workerPoolName string, instance string) (result ResourceMetricDefinitionCollectionIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppServiceEnvironmentsClient.ListWorkerPoolInstanceMetricDefinitions")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.ListWorkerPoolInstanceMetricDefinitions(ctx, resourceGroupName, name, workerPoolName, instance)
	return
}

// ListWorkerPoolInstanceMetrics get metrics for a specific instance of a worker pool of an App Service Environment.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the App Service Environment.
// workerPoolName - name of the worker pool.
// instance - name of the instance in the worker pool.
// details - specify <code>true</code> to include instance details. The default is <code>false</code>.
// filter - return only usages/metrics specified in the filter. Filter conforms to odata syntax. Example:
// $filter=(name.value eq 'Metric1' or name.value eq 'Metric2') and startTime eq 2014-01-01T00:00:00Z and
// endTime eq 2014-12-31T23:59:59Z and timeGrain eq duration'[Hour|Minute|Day]'.
func (client AppServiceEnvironmentsClient) ListWorkerPoolInstanceMetrics(ctx context.Context, resourceGroupName string, name string, workerPoolName string, instance string, details *bool, filter string) (result ResourceMetricCollectionPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppServiceEnvironmentsClient.ListWorkerPoolInstanceMetrics")
		defer func() {
			sc := -1
			if result.rmc.Response.Response != nil {
				sc = result.rmc.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppServiceEnvironmentsClient", "ListWorkerPoolInstanceMetrics", err.Error())
	}

	result.fn = client.listWorkerPoolInstanceMetricsNextResults
	req, err := client.ListWorkerPoolInstanceMetricsPreparer(ctx, resourceGroupName, name, workerPoolName, instance, details, filter)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "ListWorkerPoolInstanceMetrics", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListWorkerPoolInstanceMetricsSender(req)
	if err != nil {
		result.rmc.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "ListWorkerPoolInstanceMetrics", resp, "Failure sending request")
		return
	}

	result.rmc, err = client.ListWorkerPoolInstanceMetricsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "ListWorkerPoolInstanceMetrics", resp, "Failure responding to request")
	}

	return
}

// ListWorkerPoolInstanceMetricsPreparer prepares the ListWorkerPoolInstanceMetrics request.
func (client AppServiceEnvironmentsClient) ListWorkerPoolInstanceMetricsPreparer(ctx context.Context, resourceGroupName string, name string, workerPoolName string, instance string, details *bool, filter string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"instance":          autorest.Encode("path", instance),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
		"workerPoolName":    autorest.Encode("path", workerPoolName),
	}

	const APIVersion = "2018-02-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if details != nil {
		queryParameters["details"] = autorest.Encode("query", *details)
	}
	if len(filter) > 0 {
		queryParameters["$filter"] = filter
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/workerPools/{workerPoolName}/instances/{instance}/metrics", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListWorkerPoolInstanceMetricsSender sends the ListWorkerPoolInstanceMetrics request. The method will close the
// http.Response Body if it receives an error.
func (client AppServiceEnvironmentsClient) ListWorkerPoolInstanceMetricsSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListWorkerPoolInstanceMetricsResponder handles the response to the ListWorkerPoolInstanceMetrics request. The method always
// closes the http.Response Body.
func (client AppServiceEnvironmentsClient) ListWorkerPoolInstanceMetricsResponder(resp *http.Response) (result ResourceMetricCollection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listWorkerPoolInstanceMetricsNextResults retrieves the next set of results, if any.
func (client AppServiceEnvironmentsClient) listWorkerPoolInstanceMetricsNextResults(ctx context.Context, lastResults ResourceMetricCollection) (result ResourceMetricCollection, err error) {
	req, err := lastResults.resourceMetricCollectionPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "listWorkerPoolInstanceMetricsNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListWorkerPoolInstanceMetricsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "listWorkerPoolInstanceMetricsNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListWorkerPoolInstanceMetricsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "listWorkerPoolInstanceMetricsNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListWorkerPoolInstanceMetricsComplete enumerates all values, automatically crossing page boundaries as required.
func (client AppServiceEnvironmentsClient) ListWorkerPoolInstanceMetricsComplete(ctx context.Context, resourceGroupName string, name string, workerPoolName string, instance string, details *bool, filter string) (result ResourceMetricCollectionIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppServiceEnvironmentsClient.ListWorkerPoolInstanceMetrics")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.ListWorkerPoolInstanceMetrics(ctx, resourceGroupName, name, workerPoolName, instance, details, filter)
	return
}

// ListWorkerPools get all worker pools of an App Service Environment.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the App Service Environment.
func (client AppServiceEnvironmentsClient) ListWorkerPools(ctx context.Context, resourceGroupName string, name string) (result WorkerPoolCollectionPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppServiceEnvironmentsClient.ListWorkerPools")
		defer func() {
			sc := -1
			if result.wpc.Response.Response != nil {
				sc = result.wpc.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppServiceEnvironmentsClient", "ListWorkerPools", err.Error())
	}

	result.fn = client.listWorkerPoolsNextResults
	req, err := client.ListWorkerPoolsPreparer(ctx, resourceGroupName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "ListWorkerPools", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListWorkerPoolsSender(req)
	if err != nil {
		result.wpc.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "ListWorkerPools", resp, "Failure sending request")
		return
	}

	result.wpc, err = client.ListWorkerPoolsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "ListWorkerPools", resp, "Failure responding to request")
	}

	return
}

// ListWorkerPoolsPreparer prepares the ListWorkerPools request.
func (client AppServiceEnvironmentsClient) ListWorkerPoolsPreparer(ctx context.Context, resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2018-02-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/workerPools", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListWorkerPoolsSender sends the ListWorkerPools request. The method will close the
// http.Response Body if it receives an error.
func (client AppServiceEnvironmentsClient) ListWorkerPoolsSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListWorkerPoolsResponder handles the response to the ListWorkerPools request. The method always
// closes the http.Response Body.
func (client AppServiceEnvironmentsClient) ListWorkerPoolsResponder(resp *http.Response) (result WorkerPoolCollection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listWorkerPoolsNextResults retrieves the next set of results, if any.
func (client AppServiceEnvironmentsClient) listWorkerPoolsNextResults(ctx context.Context, lastResults WorkerPoolCollection) (result WorkerPoolCollection, err error) {
	req, err := lastResults.workerPoolCollectionPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "listWorkerPoolsNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListWorkerPoolsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "listWorkerPoolsNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListWorkerPoolsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "listWorkerPoolsNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListWorkerPoolsComplete enumerates all values, automatically crossing page boundaries as required.
func (client AppServiceEnvironmentsClient) ListWorkerPoolsComplete(ctx context.Context, resourceGroupName string, name string) (result WorkerPoolCollectionIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppServiceEnvironmentsClient.ListWorkerPools")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.ListWorkerPools(ctx, resourceGroupName, name)
	return
}

// ListWorkerPoolSkus get available SKUs for scaling a worker pool.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the App Service Environment.
// workerPoolName - name of the worker pool.
func (client AppServiceEnvironmentsClient) ListWorkerPoolSkus(ctx context.Context, resourceGroupName string, name string, workerPoolName string) (result SkuInfoCollectionPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppServiceEnvironmentsClient.ListWorkerPoolSkus")
		defer func() {
			sc := -1
			if result.sic.Response.Response != nil {
				sc = result.sic.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppServiceEnvironmentsClient", "ListWorkerPoolSkus", err.Error())
	}

	result.fn = client.listWorkerPoolSkusNextResults
	req, err := client.ListWorkerPoolSkusPreparer(ctx, resourceGroupName, name, workerPoolName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "ListWorkerPoolSkus", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListWorkerPoolSkusSender(req)
	if err != nil {
		result.sic.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "ListWorkerPoolSkus", resp, "Failure sending request")
		return
	}

	result.sic, err = client.ListWorkerPoolSkusResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "ListWorkerPoolSkus", resp, "Failure responding to request")
	}

	return
}

// ListWorkerPoolSkusPreparer prepares the ListWorkerPoolSkus request.
func (client AppServiceEnvironmentsClient) ListWorkerPoolSkusPreparer(ctx context.Context, resourceGroupName string, name string, workerPoolName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
		"workerPoolName":    autorest.Encode("path", workerPoolName),
	}

	const APIVersion = "2018-02-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/workerPools/{workerPoolName}/skus", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListWorkerPoolSkusSender sends the ListWorkerPoolSkus request. The method will close the
// http.Response Body if it receives an error.
func (client AppServiceEnvironmentsClient) ListWorkerPoolSkusSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListWorkerPoolSkusResponder handles the response to the ListWorkerPoolSkus request. The method always
// closes the http.Response Body.
func (client AppServiceEnvironmentsClient) ListWorkerPoolSkusResponder(resp *http.Response) (result SkuInfoCollection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listWorkerPoolSkusNextResults retrieves the next set of results, if any.
func (client AppServiceEnvironmentsClient) listWorkerPoolSkusNextResults(ctx context.Context, lastResults SkuInfoCollection) (result SkuInfoCollection, err error) {
	req, err := lastResults.skuInfoCollectionPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "listWorkerPoolSkusNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListWorkerPoolSkusSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "listWorkerPoolSkusNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListWorkerPoolSkusResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "listWorkerPoolSkusNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListWorkerPoolSkusComplete enumerates all values, automatically crossing page boundaries as required.
func (client AppServiceEnvironmentsClient) ListWorkerPoolSkusComplete(ctx context.Context, resourceGroupName string, name string, workerPoolName string) (result SkuInfoCollectionIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppServiceEnvironmentsClient.ListWorkerPoolSkus")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.ListWorkerPoolSkus(ctx, resourceGroupName, name, workerPoolName)
	return
}

// Reboot reboot all machines in an App Service Environment.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the App Service Environment.
func (client AppServiceEnvironmentsClient) Reboot(ctx context.Context, resourceGroupName string, name string) (result autorest.Response, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppServiceEnvironmentsClient.Reboot")
		defer func() {
			sc := -1
			if result.Response != nil {
				sc = result.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppServiceEnvironmentsClient", "Reboot", err.Error())
	}

	req, err := client.RebootPreparer(ctx, resourceGroupName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "Reboot", nil, "Failure preparing request")
		return
	}

	resp, err := client.RebootSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "Reboot", resp, "Failure sending request")
		return
	}

	result, err = client.RebootResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "Reboot", resp, "Failure responding to request")
	}

	return
}

// RebootPreparer prepares the Reboot request.
func (client AppServiceEnvironmentsClient) RebootPreparer(ctx context.Context, resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2018-02-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/reboot", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// RebootSender sends the Reboot request. The method will close the
// http.Response Body if it receives an error.
func (client AppServiceEnvironmentsClient) RebootSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// RebootResponder handles the response to the Reboot request. The method always
// closes the http.Response Body.
func (client AppServiceEnvironmentsClient) RebootResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted, http.StatusBadRequest, http.StatusNotFound, http.StatusConflict),
		autorest.ByClosing())
	result.Response = resp
	return
}

// Resume resume an App Service Environment.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the App Service Environment.
func (client AppServiceEnvironmentsClient) Resume(ctx context.Context, resourceGroupName string, name string) (result AppServiceEnvironmentsResumeFuture, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppServiceEnvironmentsClient.Resume")
		defer func() {
			sc := -1
			if result.Response() != nil {
				sc = result.Response().StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppServiceEnvironmentsClient", "Resume", err.Error())
	}

	req, err := client.ResumePreparer(ctx, resourceGroupName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "Resume", nil, "Failure preparing request")
		return
	}

	result, err = client.ResumeSender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "Resume", result.Response(), "Failure sending request")
		return
	}

	return
}

// ResumePreparer prepares the Resume request.
func (client AppServiceEnvironmentsClient) ResumePreparer(ctx context.Context, resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2018-02-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/resume", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ResumeSender sends the Resume request. The method will close the
// http.Response Body if it receives an error.
func (client AppServiceEnvironmentsClient) ResumeSender(req *http.Request) (future AppServiceEnvironmentsResumeFuture, err error) {
	var resp *http.Response
	resp, err = client.Send(req, azure.DoRetryWithRegistration(client.Client))
	if err != nil {
		return
	}
	future.Future, err = azure.NewFutureFromResponse(resp)
	return
}

// ResumeResponder handles the response to the Resume request. The method always
// closes the http.Response Body.
func (client AppServiceEnvironmentsClient) ResumeResponder(resp *http.Response) (result AppCollectionPage, err error) {
	result.ac, err = client.resumeResponder(resp)
	result.fn = client.resumeNextResults
	return
}

func (client AppServiceEnvironmentsClient) resumeResponder(resp *http.Response) (result AppCollection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// resumeNextResults retrieves the next set of results, if any.
func (client AppServiceEnvironmentsClient) resumeNextResults(ctx context.Context, lastResults AppCollection) (result AppCollection, err error) {
	req, err := lastResults.appCollectionPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "resumeNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	var resp *http.Response
	resp, err = client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "resumeNextResults", resp, "Failure sending next results request")
	}
	return client.resumeResponder(resp)
}

// ResumeComplete enumerates all values, automatically crossing page boundaries as required.
func (client AppServiceEnvironmentsClient) ResumeComplete(ctx context.Context, resourceGroupName string, name string) (result AppServiceEnvironmentsResumeAllFuture, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppServiceEnvironmentsClient.Resume")
		defer func() {
			sc := -1
			if result.Response() != nil {
				sc = result.Response().StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	var future AppServiceEnvironmentsResumeFuture
	future, err = client.Resume(ctx, resourceGroupName, name)
	result.Future = future.Future
	return
}

// Suspend suspend an App Service Environment.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the App Service Environment.
func (client AppServiceEnvironmentsClient) Suspend(ctx context.Context, resourceGroupName string, name string) (result AppServiceEnvironmentsSuspendFuture, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppServiceEnvironmentsClient.Suspend")
		defer func() {
			sc := -1
			if result.Response() != nil {
				sc = result.Response().StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppServiceEnvironmentsClient", "Suspend", err.Error())
	}

	req, err := client.SuspendPreparer(ctx, resourceGroupName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "Suspend", nil, "Failure preparing request")
		return
	}

	result, err = client.SuspendSender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "Suspend", result.Response(), "Failure sending request")
		return
	}

	return
}

// SuspendPreparer prepares the Suspend request.
func (client AppServiceEnvironmentsClient) SuspendPreparer(ctx context.Context, resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2018-02-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/suspend", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// SuspendSender sends the Suspend request. The method will close the
// http.Response Body if it receives an error.
func (client AppServiceEnvironmentsClient) SuspendSender(req *http.Request) (future AppServiceEnvironmentsSuspendFuture, err error) {
	var resp *http.Response
	resp, err = client.Send(req, azure.DoRetryWithRegistration(client.Client))
	if err != nil {
		return
	}
	future.Future, err = azure.NewFutureFromResponse(resp)
	return
}

// SuspendResponder handles the response to the Suspend request. The method always
// closes the http.Response Body.
func (client AppServiceEnvironmentsClient) SuspendResponder(resp *http.Response) (result AppCollectionPage, err error) {
	result.ac, err = client.suspendResponder(resp)
	result.fn = client.suspendNextResults
	return
}

func (client AppServiceEnvironmentsClient) suspendResponder(resp *http.Response) (result AppCollection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// suspendNextResults retrieves the next set of results, if any.
func (client AppServiceEnvironmentsClient) suspendNextResults(ctx context.Context, lastResults AppCollection) (result AppCollection, err error) {
	req, err := lastResults.appCollectionPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "suspendNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	var resp *http.Response
	resp, err = client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "suspendNextResults", resp, "Failure sending next results request")
	}
	return client.suspendResponder(resp)
}

// SuspendComplete enumerates all values, automatically crossing page boundaries as required.
func (client AppServiceEnvironmentsClient) SuspendComplete(ctx context.Context, resourceGroupName string, name string) (result AppServiceEnvironmentsSuspendAllFuture, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppServiceEnvironmentsClient.Suspend")
		defer func() {
			sc := -1
			if result.Response() != nil {
				sc = result.Response().StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	var future AppServiceEnvironmentsSuspendFuture
	future, err = client.Suspend(ctx, resourceGroupName, name)
	result.Future = future.Future
	return
}

// Update create or update an App Service Environment.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the App Service Environment.
// hostingEnvironmentEnvelope - configuration details of the App Service Environment.
func (client AppServiceEnvironmentsClient) Update(ctx context.Context, resourceGroupName string, name string, hostingEnvironmentEnvelope AppServiceEnvironmentPatchResource) (result AppServiceEnvironmentResource, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppServiceEnvironmentsClient.Update")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppServiceEnvironmentsClient", "Update", err.Error())
	}

	req, err := client.UpdatePreparer(ctx, resourceGroupName, name, hostingEnvironmentEnvelope)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "Update", nil, "Failure preparing request")
		return
	}

	resp, err := client.UpdateSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "Update", resp, "Failure sending request")
		return
	}

	result, err = client.UpdateResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "Update", resp, "Failure responding to request")
	}

	return
}

// UpdatePreparer prepares the Update request.
func (client AppServiceEnvironmentsClient) UpdatePreparer(ctx context.Context, resourceGroupName string, name string, hostingEnvironmentEnvelope AppServiceEnvironmentPatchResource) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2018-02-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPatch(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}", pathParameters),
		autorest.WithJSON(hostingEnvironmentEnvelope),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// UpdateSender sends the Update request. The method will close the
// http.Response Body if it receives an error.
func (client AppServiceEnvironmentsClient) UpdateSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// UpdateResponder handles the response to the Update request. The method always
// closes the http.Response Body.
func (client AppServiceEnvironmentsClient) UpdateResponder(resp *http.Response) (result AppServiceEnvironmentResource, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted, http.StatusBadRequest, http.StatusNotFound, http.StatusConflict),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// UpdateMultiRolePool create or update a multi-role pool.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the App Service Environment.
// multiRolePoolEnvelope - properties of the multi-role pool.
func (client AppServiceEnvironmentsClient) UpdateMultiRolePool(ctx context.Context, resourceGroupName string, name string, multiRolePoolEnvelope WorkerPoolResource) (result WorkerPoolResource, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppServiceEnvironmentsClient.UpdateMultiRolePool")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppServiceEnvironmentsClient", "UpdateMultiRolePool", err.Error())
	}

	req, err := client.UpdateMultiRolePoolPreparer(ctx, resourceGroupName, name, multiRolePoolEnvelope)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "UpdateMultiRolePool", nil, "Failure preparing request")
		return
	}

	resp, err := client.UpdateMultiRolePoolSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "UpdateMultiRolePool", resp, "Failure sending request")
		return
	}

	result, err = client.UpdateMultiRolePoolResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "UpdateMultiRolePool", resp, "Failure responding to request")
	}

	return
}

// UpdateMultiRolePoolPreparer prepares the UpdateMultiRolePool request.
func (client AppServiceEnvironmentsClient) UpdateMultiRolePoolPreparer(ctx context.Context, resourceGroupName string, name string, multiRolePoolEnvelope WorkerPoolResource) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2018-02-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPatch(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/multiRolePools/default", pathParameters),
		autorest.WithJSON(multiRolePoolEnvelope),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// UpdateMultiRolePoolSender sends the UpdateMultiRolePool request. The method will close the
// http.Response Body if it receives an error.
func (client AppServiceEnvironmentsClient) UpdateMultiRolePoolSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// UpdateMultiRolePoolResponder handles the response to the UpdateMultiRolePool request. The method always
// closes the http.Response Body.
func (client AppServiceEnvironmentsClient) UpdateMultiRolePoolResponder(resp *http.Response) (result WorkerPoolResource, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted, http.StatusBadRequest, http.StatusNotFound, http.StatusConflict),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// UpdateWorkerPool create or update a worker pool.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the App Service Environment.
// workerPoolName - name of the worker pool.
// workerPoolEnvelope - properties of the worker pool.
func (client AppServiceEnvironmentsClient) UpdateWorkerPool(ctx context.Context, resourceGroupName string, name string, workerPoolName string, workerPoolEnvelope WorkerPoolResource) (result WorkerPoolResource, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppServiceEnvironmentsClient.UpdateWorkerPool")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppServiceEnvironmentsClient", "UpdateWorkerPool", err.Error())
	}

	req, err := client.UpdateWorkerPoolPreparer(ctx, resourceGroupName, name, workerPoolName, workerPoolEnvelope)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "UpdateWorkerPool", nil, "Failure preparing request")
		return
	}

	resp, err := client.UpdateWorkerPoolSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "UpdateWorkerPool", resp, "Failure sending request")
		return
	}

	result, err = client.UpdateWorkerPoolResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsClient", "UpdateWorkerPool", resp, "Failure responding to request")
	}

	return
}

// UpdateWorkerPoolPreparer prepares the UpdateWorkerPool request.
func (client AppServiceEnvironmentsClient) UpdateWorkerPoolPreparer(ctx context.Context, resourceGroupName string, name string, workerPoolName string, workerPoolEnvelope WorkerPoolResource) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
		"workerPoolName":    autorest.Encode("path", workerPoolName),
	}

	const APIVersion = "2018-02-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPatch(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/workerPools/{workerPoolName}", pathParameters),
		autorest.WithJSON(workerPoolEnvelope),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// UpdateWorkerPoolSender sends the UpdateWorkerPool request. The method will close the
// http.Response Body if it receives an error.
func (client AppServiceEnvironmentsClient) UpdateWorkerPoolSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// UpdateWorkerPoolResponder handles the response to the UpdateWorkerPool request. The method always
// closes the http.Response Body.
func (client AppServiceEnvironmentsClient) UpdateWorkerPoolResponder(resp *http.Response) (result WorkerPoolResource, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted, http.StatusBadRequest, http.StatusNotFound, http.StatusConflict),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}
