package metrics

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/validation"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// AlertsStatusClient is the monitor Management Client
type AlertsStatusClient struct {
	BaseClient
}

// NewAlertsStatusClient creates an instance of the AlertsStatusClient client.
func NewAlertsStatusClient(subscriptionID string) AlertsStatusClient {
	return NewAlertsStatusClientWithBaseURI(DefaultBaseURI, subscriptionID)
}

// NewAlertsStatusClientWithBaseURI creates an instance of the AlertsStatusClient client using a custom endpoint.  Use
// this when interacting with an Azure cloud that uses a non-standard base URI (sovereign clouds, Azure stack).
func NewAlertsStatusClientWithBaseURI(baseURI string, subscriptionID string) AlertsStatusClient {
	return AlertsStatusClient{NewWithBaseURI(baseURI, subscriptionID)}
}

// List retrieve an alert rule status.
// Parameters:
// resourceGroupName - the name of the resource group. The name is case insensitive.
// ruleName - the name of the rule.
func (client AlertsStatusClient) List(ctx context.Context, resourceGroupName string, ruleName string) (result AlertStatusCollection, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AlertsStatusClient.List")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: client.SubscriptionID,
			Constraints: []validation.Constraint{{Target: "client.SubscriptionID", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil}}}}); err != nil {
		return result, validation.NewError("metrics.AlertsStatusClient", "List", err.Error())
	}

	req, err := client.ListPreparer(ctx, resourceGroupName, ruleName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "metrics.AlertsStatusClient", "List", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "metrics.AlertsStatusClient", "List", resp, "Failure sending request")
		return
	}

	result, err = client.ListResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "metrics.AlertsStatusClient", "List", resp, "Failure responding to request")
		return
	}

	return
}

// ListPreparer prepares the List request.
func (client AlertsStatusClient) ListPreparer(ctx context.Context, resourceGroupName string, ruleName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"ruleName":          autorest.Encode("path", ruleName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2018-03-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/metricAlerts/{ruleName}/status", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListSender sends the List request. The method will close the
// http.Response Body if it receives an error.
func (client AlertsStatusClient) ListSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListResponder handles the response to the List request. The method always
// closes the http.Response Body.
func (client AlertsStatusClient) ListResponder(resp *http.Response) (result AlertStatusCollection, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListByName retrieve an alert rule status.
// Parameters:
// resourceGroupName - the name of the resource group. The name is case insensitive.
// ruleName - the name of the rule.
// statusName - the name of the status.
func (client AlertsStatusClient) ListByName(ctx context.Context, resourceGroupName string, ruleName string, statusName string) (result AlertStatusCollection, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AlertsStatusClient.ListByName")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: client.SubscriptionID,
			Constraints: []validation.Constraint{{Target: "client.SubscriptionID", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil}}}}); err != nil {
		return result, validation.NewError("metrics.AlertsStatusClient", "ListByName", err.Error())
	}

	req, err := client.ListByNamePreparer(ctx, resourceGroupName, ruleName, statusName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "metrics.AlertsStatusClient", "ListByName", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListByNameSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "metrics.AlertsStatusClient", "ListByName", resp, "Failure sending request")
		return
	}

	result, err = client.ListByNameResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "metrics.AlertsStatusClient", "ListByName", resp, "Failure responding to request")
		return
	}

	return
}

// ListByNamePreparer prepares the ListByName request.
func (client AlertsStatusClient) ListByNamePreparer(ctx context.Context, resourceGroupName string, ruleName string, statusName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"ruleName":          autorest.Encode("path", ruleName),
		"statusName":        autorest.Encode("path", statusName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2018-03-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/metricAlerts/{ruleName}/status/{statusName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListByNameSender sends the ListByName request. The method will close the
// http.Response Body if it receives an error.
func (client AlertsStatusClient) ListByNameSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListByNameResponder handles the response to the ListByName request. The method always
// closes the http.Response Body.
func (client AlertsStatusClient) ListByNameResponder(resp *http.Response) (result AlertStatusCollection, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}
