package servicebus

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

// AccessRights enumerates the values for access rights.
type AccessRights string

const (
	// Listen ...
	Listen AccessRights = "Listen"
	// Manage ...
	Manage AccessRights = "Manage"
	// SendEnumValue ...
	SendEnumValue AccessRights = "Send"
)

// PossibleAccessRightsValues returns an array of possible values for the AccessRights const type.
func PossibleAccessRightsValues() []AccessRights {
	return []AccessRights{Listen, Manage, SendEnumValue}
}

// CreatedByType enumerates the values for created by type.
type CreatedByType string

const (
	// Application ...
	Application CreatedByType = "Application"
	// Key ...
	Key CreatedByType = "Key"
	// ManagedIdentity ...
	ManagedIdentity CreatedByType = "ManagedIdentity"
	// User ...
	User CreatedByType = "User"
)

// PossibleCreatedByTypeValues returns an array of possible values for the CreatedByType const type.
func PossibleCreatedByTypeValues() []CreatedByType {
	return []CreatedByType{Application, Key, ManagedIdentity, User}
}

// DefaultAction enumerates the values for default action.
type DefaultAction string

const (
	// Allow ...
	Allow DefaultAction = "Allow"
	// Deny ...
	Deny DefaultAction = "Deny"
)

// PossibleDefaultActionValues returns an array of possible values for the DefaultAction const type.
func PossibleDefaultActionValues() []DefaultAction {
	return []DefaultAction{Allow, Deny}
}

// EndPointProvisioningState enumerates the values for end point provisioning state.
type EndPointProvisioningState string

const (
	// Canceled ...
	Canceled EndPointProvisioningState = "Canceled"
	// Creating ...
	Creating EndPointProvisioningState = "Creating"
	// Deleting ...
	Deleting EndPointProvisioningState = "Deleting"
	// Failed ...
	Failed EndPointProvisioningState = "Failed"
	// Succeeded ...
	Succeeded EndPointProvisioningState = "Succeeded"
	// Updating ...
	Updating EndPointProvisioningState = "Updating"
)

// PossibleEndPointProvisioningStateValues returns an array of possible values for the EndPointProvisioningState const type.
func PossibleEndPointProvisioningStateValues() []EndPointProvisioningState {
	return []EndPointProvisioningState{Canceled, Creating, Deleting, Failed, Succeeded, Updating}
}

// EntityStatus enumerates the values for entity status.
type EntityStatus string

const (
	// EntityStatusActive ...
	EntityStatusActive EntityStatus = "Active"
	// EntityStatusCreating ...
	EntityStatusCreating EntityStatus = "Creating"
	// EntityStatusDeleting ...
	EntityStatusDeleting EntityStatus = "Deleting"
	// EntityStatusDisabled ...
	EntityStatusDisabled EntityStatus = "Disabled"
	// EntityStatusReceiveDisabled ...
	EntityStatusReceiveDisabled EntityStatus = "ReceiveDisabled"
	// EntityStatusRenaming ...
	EntityStatusRenaming EntityStatus = "Renaming"
	// EntityStatusRestoring ...
	EntityStatusRestoring EntityStatus = "Restoring"
	// EntityStatusSendDisabled ...
	EntityStatusSendDisabled EntityStatus = "SendDisabled"
	// EntityStatusUnknown ...
	EntityStatusUnknown EntityStatus = "Unknown"
)

// PossibleEntityStatusValues returns an array of possible values for the EntityStatus const type.
func PossibleEntityStatusValues() []EntityStatus {
	return []EntityStatus{EntityStatusActive, EntityStatusCreating, EntityStatusDeleting, EntityStatusDisabled, EntityStatusReceiveDisabled, EntityStatusRenaming, EntityStatusRestoring, EntityStatusSendDisabled, EntityStatusUnknown}
}

// FilterType enumerates the values for filter type.
type FilterType string

const (
	// FilterTypeCorrelationFilter ...
	FilterTypeCorrelationFilter FilterType = "CorrelationFilter"
	// FilterTypeSQLFilter ...
	FilterTypeSQLFilter FilterType = "SqlFilter"
)

// PossibleFilterTypeValues returns an array of possible values for the FilterType const type.
func PossibleFilterTypeValues() []FilterType {
	return []FilterType{FilterTypeCorrelationFilter, FilterTypeSQLFilter}
}

// KeySource enumerates the values for key source.
type KeySource string

const (
	// MicrosoftKeyVault ...
	MicrosoftKeyVault KeySource = "Microsoft.KeyVault"
)

// PossibleKeySourceValues returns an array of possible values for the KeySource const type.
func PossibleKeySourceValues() []KeySource {
	return []KeySource{MicrosoftKeyVault}
}

// KeyType enumerates the values for key type.
type KeyType string

const (
	// PrimaryKey ...
	PrimaryKey KeyType = "PrimaryKey"
	// SecondaryKey ...
	SecondaryKey KeyType = "SecondaryKey"
)

// PossibleKeyTypeValues returns an array of possible values for the KeyType const type.
func PossibleKeyTypeValues() []KeyType {
	return []KeyType{PrimaryKey, SecondaryKey}
}

// ManagedServiceIdentityType enumerates the values for managed service identity type.
type ManagedServiceIdentityType string

const (
	// None ...
	None ManagedServiceIdentityType = "None"
	// SystemAssigned ...
	SystemAssigned ManagedServiceIdentityType = "SystemAssigned"
	// SystemAssignedUserAssigned ...
	SystemAssignedUserAssigned ManagedServiceIdentityType = "SystemAssigned, UserAssigned"
	// UserAssigned ...
	UserAssigned ManagedServiceIdentityType = "UserAssigned"
)

// PossibleManagedServiceIdentityTypeValues returns an array of possible values for the ManagedServiceIdentityType const type.
func PossibleManagedServiceIdentityTypeValues() []ManagedServiceIdentityType {
	return []ManagedServiceIdentityType{None, SystemAssigned, SystemAssignedUserAssigned, UserAssigned}
}

// NetworkRuleIPAction enumerates the values for network rule ip action.
type NetworkRuleIPAction string

const (
	// NetworkRuleIPActionAllow ...
	NetworkRuleIPActionAllow NetworkRuleIPAction = "Allow"
)

// PossibleNetworkRuleIPActionValues returns an array of possible values for the NetworkRuleIPAction const type.
func PossibleNetworkRuleIPActionValues() []NetworkRuleIPAction {
	return []NetworkRuleIPAction{NetworkRuleIPActionAllow}
}

// PrivateLinkConnectionStatus enumerates the values for private link connection status.
type PrivateLinkConnectionStatus string

const (
	// Approved ...
	Approved PrivateLinkConnectionStatus = "Approved"
	// Disconnected ...
	Disconnected PrivateLinkConnectionStatus = "Disconnected"
	// Pending ...
	Pending PrivateLinkConnectionStatus = "Pending"
	// Rejected ...
	Rejected PrivateLinkConnectionStatus = "Rejected"
)

// PossiblePrivateLinkConnectionStatusValues returns an array of possible values for the PrivateLinkConnectionStatus const type.
func PossiblePrivateLinkConnectionStatusValues() []PrivateLinkConnectionStatus {
	return []PrivateLinkConnectionStatus{Approved, Disconnected, Pending, Rejected}
}

// ProvisioningStateDR enumerates the values for provisioning state dr.
type ProvisioningStateDR string

const (
	// ProvisioningStateDRAccepted ...
	ProvisioningStateDRAccepted ProvisioningStateDR = "Accepted"
	// ProvisioningStateDRFailed ...
	ProvisioningStateDRFailed ProvisioningStateDR = "Failed"
	// ProvisioningStateDRSucceeded ...
	ProvisioningStateDRSucceeded ProvisioningStateDR = "Succeeded"
)

// PossibleProvisioningStateDRValues returns an array of possible values for the ProvisioningStateDR const type.
func PossibleProvisioningStateDRValues() []ProvisioningStateDR {
	return []ProvisioningStateDR{ProvisioningStateDRAccepted, ProvisioningStateDRFailed, ProvisioningStateDRSucceeded}
}

// PublicNetworkAccess enumerates the values for public network access.
type PublicNetworkAccess string

const (
	// Disabled ...
	Disabled PublicNetworkAccess = "Disabled"
	// Enabled ...
	Enabled PublicNetworkAccess = "Enabled"
	// SecuredByPerimeter ...
	SecuredByPerimeter PublicNetworkAccess = "SecuredByPerimeter"
)

// PossiblePublicNetworkAccessValues returns an array of possible values for the PublicNetworkAccess const type.
func PossiblePublicNetworkAccessValues() []PublicNetworkAccess {
	return []PublicNetworkAccess{Disabled, Enabled, SecuredByPerimeter}
}

// PublicNetworkAccessFlag enumerates the values for public network access flag.
type PublicNetworkAccessFlag string

const (
	// PublicNetworkAccessFlagDisabled ...
	PublicNetworkAccessFlagDisabled PublicNetworkAccessFlag = "Disabled"
	// PublicNetworkAccessFlagEnabled ...
	PublicNetworkAccessFlagEnabled PublicNetworkAccessFlag = "Enabled"
)

// PossiblePublicNetworkAccessFlagValues returns an array of possible values for the PublicNetworkAccessFlag const type.
func PossiblePublicNetworkAccessFlagValues() []PublicNetworkAccessFlag {
	return []PublicNetworkAccessFlag{PublicNetworkAccessFlagDisabled, PublicNetworkAccessFlagEnabled}
}

// RoleDisasterRecovery enumerates the values for role disaster recovery.
type RoleDisasterRecovery string

const (
	// Primary ...
	Primary RoleDisasterRecovery = "Primary"
	// PrimaryNotReplicating ...
	PrimaryNotReplicating RoleDisasterRecovery = "PrimaryNotReplicating"
	// Secondary ...
	Secondary RoleDisasterRecovery = "Secondary"
)

// PossibleRoleDisasterRecoveryValues returns an array of possible values for the RoleDisasterRecovery const type.
func PossibleRoleDisasterRecoveryValues() []RoleDisasterRecovery {
	return []RoleDisasterRecovery{Primary, PrimaryNotReplicating, Secondary}
}

// SkuName enumerates the values for sku name.
type SkuName string

const (
	// Basic ...
	Basic SkuName = "Basic"
	// Premium ...
	Premium SkuName = "Premium"
	// Standard ...
	Standard SkuName = "Standard"
)

// PossibleSkuNameValues returns an array of possible values for the SkuName const type.
func PossibleSkuNameValues() []SkuName {
	return []SkuName{Basic, Premium, Standard}
}

// SkuTier enumerates the values for sku tier.
type SkuTier string

const (
	// SkuTierBasic ...
	SkuTierBasic SkuTier = "Basic"
	// SkuTierPremium ...
	SkuTierPremium SkuTier = "Premium"
	// SkuTierStandard ...
	SkuTierStandard SkuTier = "Standard"
)

// PossibleSkuTierValues returns an array of possible values for the SkuTier const type.
func PossibleSkuTierValues() []SkuTier {
	return []SkuTier{SkuTierBasic, SkuTierPremium, SkuTierStandard}
}

// TLSVersion enumerates the values for tls version.
type TLSVersion string

const (
	// OneFullStopOne ...
	OneFullStopOne TLSVersion = "1.1"
	// OneFullStopTwo ...
	OneFullStopTwo TLSVersion = "1.2"
	// OneFullStopZero ...
	OneFullStopZero TLSVersion = "1.0"
)

// PossibleTLSVersionValues returns an array of possible values for the TLSVersion const type.
func PossibleTLSVersionValues() []TLSVersion {
	return []TLSVersion{OneFullStopOne, OneFullStopTwo, OneFullStopZero}
}

// UnavailableReason enumerates the values for unavailable reason.
type UnavailableReason string

const (
	// UnavailableReasonInvalidName ...
	UnavailableReasonInvalidName UnavailableReason = "InvalidName"
	// UnavailableReasonNameInLockdown ...
	UnavailableReasonNameInLockdown UnavailableReason = "NameInLockdown"
	// UnavailableReasonNameInUse ...
	UnavailableReasonNameInUse UnavailableReason = "NameInUse"
	// UnavailableReasonNone ...
	UnavailableReasonNone UnavailableReason = "None"
	// UnavailableReasonSubscriptionIsDisabled ...
	UnavailableReasonSubscriptionIsDisabled UnavailableReason = "SubscriptionIsDisabled"
	// UnavailableReasonTooManyNamespaceInCurrentSubscription ...
	UnavailableReasonTooManyNamespaceInCurrentSubscription UnavailableReason = "TooManyNamespaceInCurrentSubscription"
)

// PossibleUnavailableReasonValues returns an array of possible values for the UnavailableReason const type.
func PossibleUnavailableReasonValues() []UnavailableReason {
	return []UnavailableReason{UnavailableReasonInvalidName, UnavailableReasonNameInLockdown, UnavailableReasonNameInUse, UnavailableReasonNone, UnavailableReasonSubscriptionIsDisabled, UnavailableReasonTooManyNamespaceInCurrentSubscription}
}
