package sql

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// DatabaseSQLVulnerabilityAssessmentScansClient is the the Azure SQL Database management API provides a RESTful set of
// web services that interact with Azure SQL Database services to manage your databases. The API enables you to create,
// retrieve, update, and delete databases.
type DatabaseSQLVulnerabilityAssessmentScansClient struct {
	BaseClient
}

// NewDatabaseSQLVulnerabilityAssessmentScansClient creates an instance of the
// DatabaseSQLVulnerabilityAssessmentScansClient client.
func NewDatabaseSQLVulnerabilityAssessmentScansClient(subscriptionID string) DatabaseSQLVulnerabilityAssessmentScansClient {
	return NewDatabaseSQLVulnerabilityAssessmentScansClientWithBaseURI(DefaultBaseURI, subscriptionID)
}

// NewDatabaseSQLVulnerabilityAssessmentScansClientWithBaseURI creates an instance of the
// DatabaseSQLVulnerabilityAssessmentScansClient client using a custom endpoint.  Use this when interacting with an
// Azure cloud that uses a non-standard base URI (sovereign clouds, Azure stack).
func NewDatabaseSQLVulnerabilityAssessmentScansClientWithBaseURI(baseURI string, subscriptionID string) DatabaseSQLVulnerabilityAssessmentScansClient {
	return DatabaseSQLVulnerabilityAssessmentScansClient{NewWithBaseURI(baseURI, subscriptionID)}
}

// Get get a database vulnerability assessment scan result.
// Parameters:
// resourceGroupName - the name of the resource group that contains the resource. You can obtain this value
// from the Azure Resource Manager API or the portal.
// serverName - the name of the server.
// databaseName - the name of the database.
// scanID - the vulnerability assessment scan Id of the scan to retrieve.
func (client DatabaseSQLVulnerabilityAssessmentScansClient) Get(ctx context.Context, resourceGroupName string, serverName string, databaseName string, scanID string) (result VulnerabilityAssessmentScanRecordType, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DatabaseSQLVulnerabilityAssessmentScansClient.Get")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetPreparer(ctx, resourceGroupName, serverName, databaseName, scanID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.DatabaseSQLVulnerabilityAssessmentScansClient", "Get", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "sql.DatabaseSQLVulnerabilityAssessmentScansClient", "Get", resp, "Failure sending request")
		return
	}

	result, err = client.GetResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.DatabaseSQLVulnerabilityAssessmentScansClient", "Get", resp, "Failure responding to request")
		return
	}

	return
}

// GetPreparer prepares the Get request.
func (client DatabaseSQLVulnerabilityAssessmentScansClient) GetPreparer(ctx context.Context, resourceGroupName string, serverName string, databaseName string, scanID string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"databaseName":                autorest.Encode("path", databaseName),
		"resourceGroupName":           autorest.Encode("path", resourceGroupName),
		"scanId":                      autorest.Encode("path", scanID),
		"serverName":                  autorest.Encode("path", serverName),
		"subscriptionId":              autorest.Encode("path", client.SubscriptionID),
		"vulnerabilityAssessmentName": autorest.Encode("path", "default"),
	}

	const APIVersion = "2022-02-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/sqlVulnerabilityAssessments/{vulnerabilityAssessmentName}/scans/{scanId}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetSender sends the Get request. The method will close the
// http.Response Body if it receives an error.
func (client DatabaseSQLVulnerabilityAssessmentScansClient) GetSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetResponder handles the response to the Get request. The method always
// closes the http.Response Body.
func (client DatabaseSQLVulnerabilityAssessmentScansClient) GetResponder(resp *http.Response) (result VulnerabilityAssessmentScanRecordType, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListBySQLVulnerabilityAssessments lists the vulnerability assessment scans of a database.
// Parameters:
// resourceGroupName - the name of the resource group that contains the resource. You can obtain this value
// from the Azure Resource Manager API or the portal.
// serverName - the name of the server.
// databaseName - the name of the database.
func (client DatabaseSQLVulnerabilityAssessmentScansClient) ListBySQLVulnerabilityAssessments(ctx context.Context, resourceGroupName string, serverName string, databaseName string) (result VulnerabilityAssessmentScanRecordListResultTypePage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DatabaseSQLVulnerabilityAssessmentScansClient.ListBySQLVulnerabilityAssessments")
		defer func() {
			sc := -1
			if result.vasrlrt.Response.Response != nil {
				sc = result.vasrlrt.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.fn = client.listBySQLVulnerabilityAssessmentsNextResults
	req, err := client.ListBySQLVulnerabilityAssessmentsPreparer(ctx, resourceGroupName, serverName, databaseName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.DatabaseSQLVulnerabilityAssessmentScansClient", "ListBySQLVulnerabilityAssessments", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListBySQLVulnerabilityAssessmentsSender(req)
	if err != nil {
		result.vasrlrt.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "sql.DatabaseSQLVulnerabilityAssessmentScansClient", "ListBySQLVulnerabilityAssessments", resp, "Failure sending request")
		return
	}

	result.vasrlrt, err = client.ListBySQLVulnerabilityAssessmentsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.DatabaseSQLVulnerabilityAssessmentScansClient", "ListBySQLVulnerabilityAssessments", resp, "Failure responding to request")
		return
	}
	if result.vasrlrt.hasNextLink() && result.vasrlrt.IsEmpty() {
		err = result.NextWithContext(ctx)
		return
	}

	return
}

// ListBySQLVulnerabilityAssessmentsPreparer prepares the ListBySQLVulnerabilityAssessments request.
func (client DatabaseSQLVulnerabilityAssessmentScansClient) ListBySQLVulnerabilityAssessmentsPreparer(ctx context.Context, resourceGroupName string, serverName string, databaseName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"databaseName":                autorest.Encode("path", databaseName),
		"resourceGroupName":           autorest.Encode("path", resourceGroupName),
		"serverName":                  autorest.Encode("path", serverName),
		"subscriptionId":              autorest.Encode("path", client.SubscriptionID),
		"vulnerabilityAssessmentName": autorest.Encode("path", "default"),
	}

	const APIVersion = "2022-02-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/sqlVulnerabilityAssessments/{vulnerabilityAssessmentName}/scans", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListBySQLVulnerabilityAssessmentsSender sends the ListBySQLVulnerabilityAssessments request. The method will close the
// http.Response Body if it receives an error.
func (client DatabaseSQLVulnerabilityAssessmentScansClient) ListBySQLVulnerabilityAssessmentsSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListBySQLVulnerabilityAssessmentsResponder handles the response to the ListBySQLVulnerabilityAssessments request. The method always
// closes the http.Response Body.
func (client DatabaseSQLVulnerabilityAssessmentScansClient) ListBySQLVulnerabilityAssessmentsResponder(resp *http.Response) (result VulnerabilityAssessmentScanRecordListResultType, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listBySQLVulnerabilityAssessmentsNextResults retrieves the next set of results, if any.
func (client DatabaseSQLVulnerabilityAssessmentScansClient) listBySQLVulnerabilityAssessmentsNextResults(ctx context.Context, lastResults VulnerabilityAssessmentScanRecordListResultType) (result VulnerabilityAssessmentScanRecordListResultType, err error) {
	req, err := lastResults.vulnerabilityAssessmentScanRecordListResultTypePreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "sql.DatabaseSQLVulnerabilityAssessmentScansClient", "listBySQLVulnerabilityAssessmentsNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListBySQLVulnerabilityAssessmentsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "sql.DatabaseSQLVulnerabilityAssessmentScansClient", "listBySQLVulnerabilityAssessmentsNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListBySQLVulnerabilityAssessmentsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.DatabaseSQLVulnerabilityAssessmentScansClient", "listBySQLVulnerabilityAssessmentsNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListBySQLVulnerabilityAssessmentsComplete enumerates all values, automatically crossing page boundaries as required.
func (client DatabaseSQLVulnerabilityAssessmentScansClient) ListBySQLVulnerabilityAssessmentsComplete(ctx context.Context, resourceGroupName string, serverName string, databaseName string) (result VulnerabilityAssessmentScanRecordListResultTypeIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DatabaseSQLVulnerabilityAssessmentScansClient.ListBySQLVulnerabilityAssessments")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.ListBySQLVulnerabilityAssessments(ctx, resourceGroupName, serverName, databaseName)
	return
}
