;; Tests for f64x2 [abs, min, max] operations on major boundary values and all special values.


(module
  (func (export "f64x2.min") (param v128 v128) (result v128) (f64x2.min (local.get 0) (local.get 1)))
  (func (export "f64x2.max") (param v128 v128) (result v128) (f64x2.max (local.get 0) (local.get 1)))
  (func (export "f64x2.abs") (param v128) (result v128) (f64x2.abs (local.get 0)))
  ;; f64x2.min const vs const
  (func (export "f64x2.min_with_const_0") (result v128) (f64x2.min (v128.const f64x2 0 1) (v128.const f64x2 0 2)))
  (func (export "f64x2.min_with_const_1") (result v128) (f64x2.min (v128.const f64x2 2 -3) (v128.const f64x2 1 3)))
  (func (export "f64x2.min_with_const_2") (result v128) (f64x2.min (v128.const f64x2 0 1) (v128.const f64x2 0 1)))
  (func (export "f64x2.min_with_const_3") (result v128) (f64x2.min (v128.const f64x2 2 3) (v128.const f64x2 2 3)))
  (func (export "f64x2.min_with_const_4") (result v128) (f64x2.min (v128.const f64x2 0x00 0x01) (v128.const f64x2 0x00 0x02)))
  (func (export "f64x2.min_with_const_5") (result v128) (f64x2.min (v128.const f64x2 0x02 0x80000000) (v128.const f64x2 0x01 2147483648)))
  (func (export "f64x2.min_with_const_6") (result v128) (f64x2.min (v128.const f64x2 0x00 0x01) (v128.const f64x2 0x00 0x01)))
  (func (export "f64x2.min_with_const_7") (result v128) (f64x2.min (v128.const f64x2 0x02 0x80000000) (v128.const f64x2 0x02 0x80000000)))
  ;; f64x2.min param vs const
  (func (export "f64x2.min_with_const_9") (param v128) (result v128) (f64x2.min (local.get 0) (v128.const f64x2 0 1)))
  (func (export "f64x2.min_with_const_10") (param v128) (result v128) (f64x2.min (v128.const f64x2 2 -3) (local.get 0)))
  (func (export "f64x2.min_with_const_11") (param v128) (result v128) (f64x2.min (v128.const f64x2 0 1) (local.get 0)))
  (func (export "f64x2.min_with_const_12") (param v128) (result v128) (f64x2.min (local.get 0) (v128.const f64x2 2 3)))
  (func (export "f64x2.min_with_const_13") (param v128) (result v128) (f64x2.min (v128.const f64x2 0x00 0x01) (local.get 0)))
  (func (export "f64x2.min_with_const_14") (param v128) (result v128) (f64x2.min (v128.const f64x2 0x02 0x80000000) (local.get 0)))
  (func (export "f64x2.min_with_const_15") (param v128) (result v128) (f64x2.min (v128.const f64x2 0x00 0x01) (local.get 0)))
  (func (export "f64x2.min_with_const_16") (param v128) (result v128) (f64x2.min (v128.const f64x2 0x02 0x80000000) (local.get 0)))
  ;; f64x2.max const vs const
  (func (export "f64x2.max_with_const_18") (result v128) (f64x2.max (v128.const f64x2 0 1) (v128.const f64x2 0 2)))
  (func (export "f64x2.max_with_const_19") (result v128) (f64x2.max (v128.const f64x2 2 -3) (v128.const f64x2 1 3)))
  (func (export "f64x2.max_with_const_20") (result v128) (f64x2.max (v128.const f64x2 0 1) (v128.const f64x2 0 1)))
  (func (export "f64x2.max_with_const_21") (result v128) (f64x2.max (v128.const f64x2 2 3) (v128.const f64x2 2 3)))
  (func (export "f64x2.max_with_const_22") (result v128) (f64x2.max (v128.const f64x2 0x00 0x01) (v128.const f64x2 0x00 0x02)))
  (func (export "f64x2.max_with_const_23") (result v128) (f64x2.max (v128.const f64x2 0x02 0x80000000) (v128.const f64x2 0x01 2147483648)))
  (func (export "f64x2.max_with_const_24") (result v128) (f64x2.max (v128.const f64x2 0x00 0x01) (v128.const f64x2 0x00 0x01)))
  (func (export "f64x2.max_with_const_25") (result v128) (f64x2.max (v128.const f64x2 0x02 0x80000000) (v128.const f64x2 0x02 0x80000000)))
  ;; f64x2.max param vs const
  (func (export "f64x2.max_with_const_27") (param v128) (result v128) (f64x2.max (local.get 0) (v128.const f64x2 0 1)))
  (func (export "f64x2.max_with_const_28") (param v128) (result v128) (f64x2.max (v128.const f64x2 2 -3) (local.get 0)))
  (func (export "f64x2.max_with_const_29") (param v128) (result v128) (f64x2.max (v128.const f64x2 0 1) (local.get 0)))
  (func (export "f64x2.max_with_const_30") (param v128) (result v128) (f64x2.max (local.get 0) (v128.const f64x2 2 3)))
  (func (export "f64x2.max_with_const_31") (param v128) (result v128) (f64x2.max (v128.const f64x2 0x00 0x01) (local.get 0)))
  (func (export "f64x2.max_with_const_32") (param v128) (result v128) (f64x2.max (v128.const f64x2 0x02 0x80000000) (local.get 0)))
  (func (export "f64x2.max_with_const_33") (param v128) (result v128) (f64x2.max (v128.const f64x2 0x00 0x01) (local.get 0)))
  (func (export "f64x2.max_with_const_34") (param v128) (result v128) (f64x2.max (v128.const f64x2 0x02 0x80000000) (local.get 0)))

  (func (export "f64x2.abs_with_const_35") (result v128) (f64x2.abs (v128.const f64x2 -0 -1)))
  (func (export "f64x2.abs_with_const_36") (result v128) (f64x2.abs (v128.const f64x2 -2 -3)))
)

;; f64x2.min const vs const
(assert_return (invoke "f64x2.min_with_const_0") (v128.const f64x2 0 1))
(assert_return (invoke "f64x2.min_with_const_1") (v128.const f64x2 1 -3))
(assert_return (invoke "f64x2.min_with_const_2") (v128.const f64x2 0 1))
(assert_return (invoke "f64x2.min_with_const_3") (v128.const f64x2 2 3))
;; f64x2.min param vs const
(assert_return (invoke "f64x2.min_with_const_4") (v128.const f64x2 0x00 0x01))
(assert_return (invoke "f64x2.min_with_const_5") (v128.const f64x2 0x01 0x80000000))
(assert_return (invoke "f64x2.min_with_const_6") (v128.const f64x2 0x00 0x01))
(assert_return (invoke "f64x2.min_with_const_7") (v128.const f64x2 0x02 0x80000000))
(assert_return (invoke "f64x2.min_with_const_9" (v128.const f64x2 0 2))
                                                (v128.const f64x2 0 1))
(assert_return (invoke "f64x2.min_with_const_10" (v128.const f64x2 1 3))
                                                 (v128.const f64x2 1 -3))
(assert_return (invoke "f64x2.min_with_const_11" (v128.const f64x2 0 1))
                                                 (v128.const f64x2 0 1))
(assert_return (invoke "f64x2.min_with_const_12" (v128.const f64x2 2 3))
                                                 (v128.const f64x2 2 3))
(assert_return (invoke "f64x2.min_with_const_13" (v128.const f64x2 0x00 0x02))
                                                 (v128.const f64x2 0x00 0x01))
(assert_return (invoke "f64x2.min_with_const_14" (v128.const f64x2 0x01 2147483648))
                                                 (v128.const f64x2 0x01 0x80000000))
(assert_return (invoke "f64x2.min_with_const_15" (v128.const f64x2 0x00 0x01))
                                                 (v128.const f64x2 0x00 0x01))
(assert_return (invoke "f64x2.min_with_const_16" (v128.const f64x2 0x02 0x80000000))
                                                 (v128.const f64x2 0x02 0x80000000))
;; f64x2.max const vs const
(assert_return (invoke "f64x2.max_with_const_18") (v128.const f64x2 0 2))
(assert_return (invoke "f64x2.max_with_const_19") (v128.const f64x2 2 3))
(assert_return (invoke "f64x2.max_with_const_20") (v128.const f64x2 0 1))
(assert_return (invoke "f64x2.max_with_const_21") (v128.const f64x2 2 3))
;; f64x2.max param vs const
(assert_return (invoke "f64x2.max_with_const_22") (v128.const f64x2 0x00 0x02))
(assert_return (invoke "f64x2.max_with_const_23") (v128.const f64x2 0x02 2147483648))
(assert_return (invoke "f64x2.max_with_const_24") (v128.const f64x2 0x00 0x01))
(assert_return (invoke "f64x2.max_with_const_25") (v128.const f64x2 0x02 0x80000000))
(assert_return (invoke "f64x2.max_with_const_27" (v128.const f64x2 0 2))
                                                 (v128.const f64x2 0 2))
(assert_return (invoke "f64x2.max_with_const_28" (v128.const f64x2 1 3))
                                                 (v128.const f64x2 2 3))
(assert_return (invoke "f64x2.max_with_const_29" (v128.const f64x2 0 1))
                                                 (v128.const f64x2 0 1))
(assert_return (invoke "f64x2.max_with_const_30" (v128.const f64x2 2 3))
                                                 (v128.const f64x2 2 3))
(assert_return (invoke "f64x2.max_with_const_31" (v128.const f64x2 0x00 0x02))
                                                 (v128.const f64x2 0x00 0x02))
(assert_return (invoke "f64x2.max_with_const_32" (v128.const f64x2 0x01 2147483648))
                                                 (v128.const f64x2 0x02 2147483648))
(assert_return (invoke "f64x2.max_with_const_33" (v128.const f64x2 0x00 0x01))
                                                 (v128.const f64x2 0x00 0x01))
(assert_return (invoke "f64x2.max_with_const_34" (v128.const f64x2 0x02 0x80000000))
                                                 (v128.const f64x2 0x02 0x80000000))

(assert_return (invoke "f64x2.abs_with_const_35") (v128.const f64x2 0 1))
(assert_return (invoke "f64x2.abs_with_const_36") (v128.const f64x2 2 3))

;; Test different lanes go through different if-then clauses
;; f64x2.min
(assert_return
  (invoke "f64x2.min"
    (v128.const f64x2 nan 0)
    (v128.const f64x2 0 1)
  )
  (v128.const f64x2 nan:canonical 0)
)
;; f64x2.min
(assert_return
  (invoke "f64x2.min"
    (v128.const f64x2 0 1)
    (v128.const f64x2 -nan 0)
  )
  (v128.const f64x2 nan:canonical 0)
)
;; f64x2.min
(assert_return
  (invoke "f64x2.min"
    (v128.const f64x2 0 1)
    (v128.const f64x2 -nan 1)
  )
  (v128.const f64x2 nan:canonical 1)
)
;; f64x2.max
(assert_return
  (invoke "f64x2.max"
    (v128.const f64x2 nan 0)
    (v128.const f64x2 0 1)
  )
  (v128.const f64x2 nan:canonical 1)
)
;; f64x2.max
(assert_return
  (invoke "f64x2.max"
    (v128.const f64x2 0 1)
    (v128.const f64x2 -nan 0)
  )
  (v128.const f64x2 nan:canonical 1)
)
;; f64x2.max
(assert_return
  (invoke "f64x2.max"
    (v128.const f64x2 0 1)
    (v128.const f64x2 -nan 1)
  )
  (v128.const f64x2 nan:canonical 1)
)

(assert_return (invoke "f64x2.min" (v128.const f64x2 0x0p+0 0x0p+0)
                                   (v128.const f64x2 0x0p+0 0x0p+0))
                                   (v128.const f64x2 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f64x2.min" (v128.const f64x2 0x0p+0 0x0p+0)
                                   (v128.const f64x2 -0x0p+0 -0x0p+0))
                                   (v128.const f64x2 -0x0p+0 -0x0p+0))
(assert_return (invoke "f64x2.min" (v128.const f64x2 0x0p+0 0x0p+0)
                                   (v128.const f64x2 0x1p-1074 0x1p-1074))
                                   (v128.const f64x2 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f64x2.min" (v128.const f64x2 0x0p+0 0x0p+0)
                                   (v128.const f64x2 -0x1p-1074 -0x1p-1074))
                                   (v128.const f64x2 -0x0.0000000000001p-1022 -0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.min" (v128.const f64x2 0x0p+0 0x0p+0)
                                   (v128.const f64x2 0x1p-1022 0x1p-1022))
                                   (v128.const f64x2 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f64x2.min" (v128.const f64x2 0x0p+0 0x0p+0)
                                   (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                   (v128.const f64x2 -0x1.0000000000000p-1022 -0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.min" (v128.const f64x2 0x0p+0 0x0p+0)
                                   (v128.const f64x2 0x1p-1 0x1p-1))
                                   (v128.const f64x2 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f64x2.min" (v128.const f64x2 0x0p+0 0x0p+0)
                                   (v128.const f64x2 -0x1p-1 -0x1p-1))
                                   (v128.const f64x2 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f64x2.min" (v128.const f64x2 0x0p+0 0x0p+0)
                                   (v128.const f64x2 0x1p+0 0x1p+0))
                                   (v128.const f64x2 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f64x2.min" (v128.const f64x2 0x0p+0 0x0p+0)
                                   (v128.const f64x2 -0x1p+0 -0x1p+0))
                                   (v128.const f64x2 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f64x2.min" (v128.const f64x2 0x0p+0 0x0p+0)
                                   (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                   (v128.const f64x2 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f64x2.min" (v128.const f64x2 0x0p+0 0x0p+0)
                                   (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                   (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.min" (v128.const f64x2 0x0p+0 0x0p+0)
                                   (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                   (v128.const f64x2 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f64x2.min" (v128.const f64x2 0x0p+0 0x0p+0)
                                   (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                   (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.min" (v128.const f64x2 0x0p+0 0x0p+0)
                                   (v128.const f64x2 inf inf))
                                   (v128.const f64x2 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f64x2.min" (v128.const f64x2 0x0p+0 0x0p+0)
                                   (v128.const f64x2 -inf -inf))
                                   (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.min" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                   (v128.const f64x2 0x0p+0 0x0p+0))
                                   (v128.const f64x2 -0x0p+0 -0x0p+0))
(assert_return (invoke "f64x2.min" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                   (v128.const f64x2 -0x0p+0 -0x0p+0))
                                   (v128.const f64x2 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f64x2.min" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                   (v128.const f64x2 0x1p-1074 0x1p-1074))
                                   (v128.const f64x2 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f64x2.min" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                   (v128.const f64x2 -0x1p-1074 -0x1p-1074))
                                   (v128.const f64x2 -0x0.0000000000001p-1022 -0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.min" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                   (v128.const f64x2 0x1p-1022 0x1p-1022))
                                   (v128.const f64x2 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f64x2.min" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                   (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                   (v128.const f64x2 -0x1.0000000000000p-1022 -0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.min" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                   (v128.const f64x2 0x1p-1 0x1p-1))
                                   (v128.const f64x2 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f64x2.min" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                   (v128.const f64x2 -0x1p-1 -0x1p-1))
                                   (v128.const f64x2 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f64x2.min" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                   (v128.const f64x2 0x1p+0 0x1p+0))
                                   (v128.const f64x2 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f64x2.min" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                   (v128.const f64x2 -0x1p+0 -0x1p+0))
                                   (v128.const f64x2 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f64x2.min" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                   (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                   (v128.const f64x2 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f64x2.min" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                   (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                   (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.min" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                   (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                   (v128.const f64x2 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f64x2.min" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                   (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                   (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.min" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                   (v128.const f64x2 inf inf))
                                   (v128.const f64x2 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f64x2.min" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                   (v128.const f64x2 -inf -inf))
                                   (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.min" (v128.const f64x2 0x1p-1074 0x1p-1074)
                                   (v128.const f64x2 0x0p+0 0x0p+0))
                                   (v128.const f64x2 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f64x2.min" (v128.const f64x2 0x1p-1074 0x1p-1074)
                                   (v128.const f64x2 -0x0p+0 -0x0p+0))
                                   (v128.const f64x2 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f64x2.min" (v128.const f64x2 0x1p-1074 0x1p-1074)
                                   (v128.const f64x2 0x1p-1074 0x1p-1074))
                                   (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.min" (v128.const f64x2 0x1p-1074 0x1p-1074)
                                   (v128.const f64x2 -0x1p-1074 -0x1p-1074))
                                   (v128.const f64x2 -0x0.0000000000001p-1022 -0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.min" (v128.const f64x2 0x1p-1074 0x1p-1074)
                                   (v128.const f64x2 0x1p-1022 0x1p-1022))
                                   (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.min" (v128.const f64x2 0x1p-1074 0x1p-1074)
                                   (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                   (v128.const f64x2 -0x1.0000000000000p-1022 -0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.min" (v128.const f64x2 0x1p-1074 0x1p-1074)
                                   (v128.const f64x2 0x1p-1 0x1p-1))
                                   (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.min" (v128.const f64x2 0x1p-1074 0x1p-1074)
                                   (v128.const f64x2 -0x1p-1 -0x1p-1))
                                   (v128.const f64x2 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f64x2.min" (v128.const f64x2 0x1p-1074 0x1p-1074)
                                   (v128.const f64x2 0x1p+0 0x1p+0))
                                   (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.min" (v128.const f64x2 0x1p-1074 0x1p-1074)
                                   (v128.const f64x2 -0x1p+0 -0x1p+0))
                                   (v128.const f64x2 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f64x2.min" (v128.const f64x2 0x1p-1074 0x1p-1074)
                                   (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                   (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.min" (v128.const f64x2 0x1p-1074 0x1p-1074)
                                   (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                   (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.min" (v128.const f64x2 0x1p-1074 0x1p-1074)
                                   (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                   (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.min" (v128.const f64x2 0x1p-1074 0x1p-1074)
                                   (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                   (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.min" (v128.const f64x2 0x1p-1074 0x1p-1074)
                                   (v128.const f64x2 inf inf))
                                   (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.min" (v128.const f64x2 0x1p-1074 0x1p-1074)
                                   (v128.const f64x2 -inf -inf))
                                   (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.min" (v128.const f64x2 -0x1p-1074 -0x1p-1074)
                                   (v128.const f64x2 0x0p+0 0x0p+0))
                                   (v128.const f64x2 -0x0.0000000000001p-1022 -0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.min" (v128.const f64x2 -0x1p-1074 -0x1p-1074)
                                   (v128.const f64x2 -0x0p+0 -0x0p+0))
                                   (v128.const f64x2 -0x0.0000000000001p-1022 -0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.min" (v128.const f64x2 -0x1p-1074 -0x1p-1074)
                                   (v128.const f64x2 0x1p-1074 0x1p-1074))
                                   (v128.const f64x2 -0x0.0000000000001p-1022 -0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.min" (v128.const f64x2 -0x1p-1074 -0x1p-1074)
                                   (v128.const f64x2 -0x1p-1074 -0x1p-1074))
                                   (v128.const f64x2 -0x0.0000000000001p-1022 -0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.min" (v128.const f64x2 -0x1p-1074 -0x1p-1074)
                                   (v128.const f64x2 0x1p-1022 0x1p-1022))
                                   (v128.const f64x2 -0x0.0000000000001p-1022 -0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.min" (v128.const f64x2 -0x1p-1074 -0x1p-1074)
                                   (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                   (v128.const f64x2 -0x1.0000000000000p-1022 -0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.min" (v128.const f64x2 -0x1p-1074 -0x1p-1074)
                                   (v128.const f64x2 0x1p-1 0x1p-1))
                                   (v128.const f64x2 -0x0.0000000000001p-1022 -0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.min" (v128.const f64x2 -0x1p-1074 -0x1p-1074)
                                   (v128.const f64x2 -0x1p-1 -0x1p-1))
                                   (v128.const f64x2 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f64x2.min" (v128.const f64x2 -0x1p-1074 -0x1p-1074)
                                   (v128.const f64x2 0x1p+0 0x1p+0))
                                   (v128.const f64x2 -0x0.0000000000001p-1022 -0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.min" (v128.const f64x2 -0x1p-1074 -0x1p-1074)
                                   (v128.const f64x2 -0x1p+0 -0x1p+0))
                                   (v128.const f64x2 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f64x2.min" (v128.const f64x2 -0x1p-1074 -0x1p-1074)
                                   (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                   (v128.const f64x2 -0x0.0000000000001p-1022 -0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.min" (v128.const f64x2 -0x1p-1074 -0x1p-1074)
                                   (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                   (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.min" (v128.const f64x2 -0x1p-1074 -0x1p-1074)
                                   (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                   (v128.const f64x2 -0x0.0000000000001p-1022 -0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.min" (v128.const f64x2 -0x1p-1074 -0x1p-1074)
                                   (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                   (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.min" (v128.const f64x2 -0x1p-1074 -0x1p-1074)
                                   (v128.const f64x2 inf inf))
                                   (v128.const f64x2 -0x0.0000000000001p-1022 -0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.min" (v128.const f64x2 -0x1p-1074 -0x1p-1074)
                                   (v128.const f64x2 -inf -inf))
                                   (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.min" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                   (v128.const f64x2 0x0p+0 0x0p+0))
                                   (v128.const f64x2 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f64x2.min" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                   (v128.const f64x2 -0x0p+0 -0x0p+0))
                                   (v128.const f64x2 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f64x2.min" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                   (v128.const f64x2 0x1p-1074 0x1p-1074))
                                   (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.min" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                   (v128.const f64x2 -0x1p-1074 -0x1p-1074))
                                   (v128.const f64x2 -0x0.0000000000001p-1022 -0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.min" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                   (v128.const f64x2 0x1p-1022 0x1p-1022))
                                   (v128.const f64x2 0x1.0000000000000p-1022 0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.min" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                   (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                   (v128.const f64x2 -0x1.0000000000000p-1022 -0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.min" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                   (v128.const f64x2 0x1p-1 0x1p-1))
                                   (v128.const f64x2 0x1.0000000000000p-1022 0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.min" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                   (v128.const f64x2 -0x1p-1 -0x1p-1))
                                   (v128.const f64x2 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f64x2.min" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                   (v128.const f64x2 0x1p+0 0x1p+0))
                                   (v128.const f64x2 0x1.0000000000000p-1022 0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.min" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                   (v128.const f64x2 -0x1p+0 -0x1p+0))
                                   (v128.const f64x2 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f64x2.min" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                   (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                   (v128.const f64x2 0x1.0000000000000p-1022 0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.min" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                   (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                   (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.min" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                   (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                   (v128.const f64x2 0x1.0000000000000p-1022 0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.min" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                   (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                   (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.min" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                   (v128.const f64x2 inf inf))
                                   (v128.const f64x2 0x1.0000000000000p-1022 0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.min" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                   (v128.const f64x2 -inf -inf))
                                   (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.min" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                   (v128.const f64x2 0x0p+0 0x0p+0))
                                   (v128.const f64x2 -0x1.0000000000000p-1022 -0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.min" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                   (v128.const f64x2 -0x0p+0 -0x0p+0))
                                   (v128.const f64x2 -0x1.0000000000000p-1022 -0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.min" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                   (v128.const f64x2 0x1p-1074 0x1p-1074))
                                   (v128.const f64x2 -0x1.0000000000000p-1022 -0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.min" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                   (v128.const f64x2 -0x1p-1074 -0x1p-1074))
                                   (v128.const f64x2 -0x1.0000000000000p-1022 -0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.min" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                   (v128.const f64x2 0x1p-1022 0x1p-1022))
                                   (v128.const f64x2 -0x1.0000000000000p-1022 -0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.min" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                   (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                   (v128.const f64x2 -0x1.0000000000000p-1022 -0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.min" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                   (v128.const f64x2 0x1p-1 0x1p-1))
                                   (v128.const f64x2 -0x1.0000000000000p-1022 -0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.min" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                   (v128.const f64x2 -0x1p-1 -0x1p-1))
                                   (v128.const f64x2 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f64x2.min" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                   (v128.const f64x2 0x1p+0 0x1p+0))
                                   (v128.const f64x2 -0x1.0000000000000p-1022 -0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.min" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                   (v128.const f64x2 -0x1p+0 -0x1p+0))
                                   (v128.const f64x2 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f64x2.min" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                   (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                   (v128.const f64x2 -0x1.0000000000000p-1022 -0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.min" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                   (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                   (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.min" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                   (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                   (v128.const f64x2 -0x1.0000000000000p-1022 -0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.min" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                   (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                   (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.min" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                   (v128.const f64x2 inf inf))
                                   (v128.const f64x2 -0x1.0000000000000p-1022 -0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.min" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                   (v128.const f64x2 -inf -inf))
                                   (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.min" (v128.const f64x2 0x1p-1 0x1p-1)
                                   (v128.const f64x2 0x0p+0 0x0p+0))
                                   (v128.const f64x2 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f64x2.min" (v128.const f64x2 0x1p-1 0x1p-1)
                                   (v128.const f64x2 -0x0p+0 -0x0p+0))
                                   (v128.const f64x2 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f64x2.min" (v128.const f64x2 0x1p-1 0x1p-1)
                                   (v128.const f64x2 0x1p-1074 0x1p-1074))
                                   (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.min" (v128.const f64x2 0x1p-1 0x1p-1)
                                   (v128.const f64x2 -0x1p-1074 -0x1p-1074))
                                   (v128.const f64x2 -0x0.0000000000001p-1022 -0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.min" (v128.const f64x2 0x1p-1 0x1p-1)
                                   (v128.const f64x2 0x1p-1022 0x1p-1022))
                                   (v128.const f64x2 0x1.0000000000000p-1022 0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.min" (v128.const f64x2 0x1p-1 0x1p-1)
                                   (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                   (v128.const f64x2 -0x1.0000000000000p-1022 -0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.min" (v128.const f64x2 0x1p-1 0x1p-1)
                                   (v128.const f64x2 0x1p-1 0x1p-1))
                                   (v128.const f64x2 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f64x2.min" (v128.const f64x2 0x1p-1 0x1p-1)
                                   (v128.const f64x2 -0x1p-1 -0x1p-1))
                                   (v128.const f64x2 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f64x2.min" (v128.const f64x2 0x1p-1 0x1p-1)
                                   (v128.const f64x2 0x1p+0 0x1p+0))
                                   (v128.const f64x2 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f64x2.min" (v128.const f64x2 0x1p-1 0x1p-1)
                                   (v128.const f64x2 -0x1p+0 -0x1p+0))
                                   (v128.const f64x2 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f64x2.min" (v128.const f64x2 0x1p-1 0x1p-1)
                                   (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                   (v128.const f64x2 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f64x2.min" (v128.const f64x2 0x1p-1 0x1p-1)
                                   (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                   (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.min" (v128.const f64x2 0x1p-1 0x1p-1)
                                   (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                   (v128.const f64x2 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f64x2.min" (v128.const f64x2 0x1p-1 0x1p-1)
                                   (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                   (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.min" (v128.const f64x2 0x1p-1 0x1p-1)
                                   (v128.const f64x2 inf inf))
                                   (v128.const f64x2 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f64x2.min" (v128.const f64x2 0x1p-1 0x1p-1)
                                   (v128.const f64x2 -inf -inf))
                                   (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.min" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                   (v128.const f64x2 0x0p+0 0x0p+0))
                                   (v128.const f64x2 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f64x2.min" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                   (v128.const f64x2 -0x0p+0 -0x0p+0))
                                   (v128.const f64x2 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f64x2.min" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                   (v128.const f64x2 0x1p-1074 0x1p-1074))
                                   (v128.const f64x2 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f64x2.min" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                   (v128.const f64x2 -0x1p-1074 -0x1p-1074))
                                   (v128.const f64x2 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f64x2.min" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                   (v128.const f64x2 0x1p-1022 0x1p-1022))
                                   (v128.const f64x2 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f64x2.min" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                   (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                   (v128.const f64x2 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f64x2.min" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                   (v128.const f64x2 0x1p-1 0x1p-1))
                                   (v128.const f64x2 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f64x2.min" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                   (v128.const f64x2 -0x1p-1 -0x1p-1))
                                   (v128.const f64x2 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f64x2.min" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                   (v128.const f64x2 0x1p+0 0x1p+0))
                                   (v128.const f64x2 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f64x2.min" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                   (v128.const f64x2 -0x1p+0 -0x1p+0))
                                   (v128.const f64x2 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f64x2.min" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                   (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                   (v128.const f64x2 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f64x2.min" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                   (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                   (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.min" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                   (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                   (v128.const f64x2 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f64x2.min" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                   (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                   (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.min" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                   (v128.const f64x2 inf inf))
                                   (v128.const f64x2 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f64x2.min" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                   (v128.const f64x2 -inf -inf))
                                   (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.min" (v128.const f64x2 0x1p+0 0x1p+0)
                                   (v128.const f64x2 0x0p+0 0x0p+0))
                                   (v128.const f64x2 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f64x2.min" (v128.const f64x2 0x1p+0 0x1p+0)
                                   (v128.const f64x2 -0x0p+0 -0x0p+0))
                                   (v128.const f64x2 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f64x2.min" (v128.const f64x2 0x1p+0 0x1p+0)
                                   (v128.const f64x2 0x1p-1074 0x1p-1074))
                                   (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.min" (v128.const f64x2 0x1p+0 0x1p+0)
                                   (v128.const f64x2 -0x1p-1074 -0x1p-1074))
                                   (v128.const f64x2 -0x0.0000000000001p-1022 -0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.min" (v128.const f64x2 0x1p+0 0x1p+0)
                                   (v128.const f64x2 0x1p-1022 0x1p-1022))
                                   (v128.const f64x2 0x1.0000000000000p-1022 0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.min" (v128.const f64x2 0x1p+0 0x1p+0)
                                   (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                   (v128.const f64x2 -0x1.0000000000000p-1022 -0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.min" (v128.const f64x2 0x1p+0 0x1p+0)
                                   (v128.const f64x2 0x1p-1 0x1p-1))
                                   (v128.const f64x2 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f64x2.min" (v128.const f64x2 0x1p+0 0x1p+0)
                                   (v128.const f64x2 -0x1p-1 -0x1p-1))
                                   (v128.const f64x2 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f64x2.min" (v128.const f64x2 0x1p+0 0x1p+0)
                                   (v128.const f64x2 0x1p+0 0x1p+0))
                                   (v128.const f64x2 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f64x2.min" (v128.const f64x2 0x1p+0 0x1p+0)
                                   (v128.const f64x2 -0x1p+0 -0x1p+0))
                                   (v128.const f64x2 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f64x2.min" (v128.const f64x2 0x1p+0 0x1p+0)
                                   (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                   (v128.const f64x2 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f64x2.min" (v128.const f64x2 0x1p+0 0x1p+0)
                                   (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                   (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.min" (v128.const f64x2 0x1p+0 0x1p+0)
                                   (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                   (v128.const f64x2 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f64x2.min" (v128.const f64x2 0x1p+0 0x1p+0)
                                   (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                   (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.min" (v128.const f64x2 0x1p+0 0x1p+0)
                                   (v128.const f64x2 inf inf))
                                   (v128.const f64x2 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f64x2.min" (v128.const f64x2 0x1p+0 0x1p+0)
                                   (v128.const f64x2 -inf -inf))
                                   (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.min" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                   (v128.const f64x2 0x0p+0 0x0p+0))
                                   (v128.const f64x2 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f64x2.min" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                   (v128.const f64x2 -0x0p+0 -0x0p+0))
                                   (v128.const f64x2 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f64x2.min" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                   (v128.const f64x2 0x1p-1074 0x1p-1074))
                                   (v128.const f64x2 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f64x2.min" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                   (v128.const f64x2 -0x1p-1074 -0x1p-1074))
                                   (v128.const f64x2 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f64x2.min" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                   (v128.const f64x2 0x1p-1022 0x1p-1022))
                                   (v128.const f64x2 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f64x2.min" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                   (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                   (v128.const f64x2 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f64x2.min" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                   (v128.const f64x2 0x1p-1 0x1p-1))
                                   (v128.const f64x2 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f64x2.min" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                   (v128.const f64x2 -0x1p-1 -0x1p-1))
                                   (v128.const f64x2 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f64x2.min" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                   (v128.const f64x2 0x1p+0 0x1p+0))
                                   (v128.const f64x2 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f64x2.min" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                   (v128.const f64x2 -0x1p+0 -0x1p+0))
                                   (v128.const f64x2 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f64x2.min" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                   (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                   (v128.const f64x2 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f64x2.min" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                   (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                   (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.min" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                   (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                   (v128.const f64x2 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f64x2.min" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                   (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                   (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.min" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                   (v128.const f64x2 inf inf))
                                   (v128.const f64x2 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f64x2.min" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                   (v128.const f64x2 -inf -inf))
                                   (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.min" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                   (v128.const f64x2 0x0p+0 0x0p+0))
                                   (v128.const f64x2 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f64x2.min" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                   (v128.const f64x2 -0x0p+0 -0x0p+0))
                                   (v128.const f64x2 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f64x2.min" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                   (v128.const f64x2 0x1p-1074 0x1p-1074))
                                   (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.min" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                   (v128.const f64x2 -0x1p-1074 -0x1p-1074))
                                   (v128.const f64x2 -0x0.0000000000001p-1022 -0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.min" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                   (v128.const f64x2 0x1p-1022 0x1p-1022))
                                   (v128.const f64x2 0x1.0000000000000p-1022 0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.min" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                   (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                   (v128.const f64x2 -0x1.0000000000000p-1022 -0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.min" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                   (v128.const f64x2 0x1p-1 0x1p-1))
                                   (v128.const f64x2 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f64x2.min" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                   (v128.const f64x2 -0x1p-1 -0x1p-1))
                                   (v128.const f64x2 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f64x2.min" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                   (v128.const f64x2 0x1p+0 0x1p+0))
                                   (v128.const f64x2 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f64x2.min" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                   (v128.const f64x2 -0x1p+0 -0x1p+0))
                                   (v128.const f64x2 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f64x2.min" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                   (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                   (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.min" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                   (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                   (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.min" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                   (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                   (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.min" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                   (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                   (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.min" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                   (v128.const f64x2 inf inf))
                                   (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.min" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                   (v128.const f64x2 -inf -inf))
                                   (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.min" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                   (v128.const f64x2 0x0p+0 0x0p+0))
                                   (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.min" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                   (v128.const f64x2 -0x0p+0 -0x0p+0))
                                   (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.min" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                   (v128.const f64x2 0x1p-1074 0x1p-1074))
                                   (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.min" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                   (v128.const f64x2 -0x1p-1074 -0x1p-1074))
                                   (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.min" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                   (v128.const f64x2 0x1p-1022 0x1p-1022))
                                   (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.min" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                   (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                   (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.min" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                   (v128.const f64x2 0x1p-1 0x1p-1))
                                   (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.min" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                   (v128.const f64x2 -0x1p-1 -0x1p-1))
                                   (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.min" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                   (v128.const f64x2 0x1p+0 0x1p+0))
                                   (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.min" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                   (v128.const f64x2 -0x1p+0 -0x1p+0))
                                   (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.min" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                   (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                   (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.min" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                   (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                   (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.min" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                   (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                   (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.min" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                   (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                   (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.min" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                   (v128.const f64x2 inf inf))
                                   (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.min" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                   (v128.const f64x2 -inf -inf))
                                   (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.min" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                   (v128.const f64x2 0x0p+0 0x0p+0))
                                   (v128.const f64x2 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f64x2.min" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                   (v128.const f64x2 -0x0p+0 -0x0p+0))
                                   (v128.const f64x2 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f64x2.min" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                   (v128.const f64x2 0x1p-1074 0x1p-1074))
                                   (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.min" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                   (v128.const f64x2 -0x1p-1074 -0x1p-1074))
                                   (v128.const f64x2 -0x0.0000000000001p-1022 -0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.min" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                   (v128.const f64x2 0x1p-1022 0x1p-1022))
                                   (v128.const f64x2 0x1.0000000000000p-1022 0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.min" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                   (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                   (v128.const f64x2 -0x1.0000000000000p-1022 -0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.min" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                   (v128.const f64x2 0x1p-1 0x1p-1))
                                   (v128.const f64x2 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f64x2.min" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                   (v128.const f64x2 -0x1p-1 -0x1p-1))
                                   (v128.const f64x2 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f64x2.min" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                   (v128.const f64x2 0x1p+0 0x1p+0))
                                   (v128.const f64x2 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f64x2.min" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                   (v128.const f64x2 -0x1p+0 -0x1p+0))
                                   (v128.const f64x2 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f64x2.min" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                   (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                   (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.min" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                   (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                   (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.min" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                   (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                   (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.min" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                   (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                   (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.min" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                   (v128.const f64x2 inf inf))
                                   (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.min" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                   (v128.const f64x2 -inf -inf))
                                   (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.min" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                   (v128.const f64x2 0x0p+0 0x0p+0))
                                   (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.min" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                   (v128.const f64x2 -0x0p+0 -0x0p+0))
                                   (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.min" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                   (v128.const f64x2 0x1p-1074 0x1p-1074))
                                   (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.min" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                   (v128.const f64x2 -0x1p-1074 -0x1p-1074))
                                   (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.min" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                   (v128.const f64x2 0x1p-1022 0x1p-1022))
                                   (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.min" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                   (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                   (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.min" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                   (v128.const f64x2 0x1p-1 0x1p-1))
                                   (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.min" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                   (v128.const f64x2 -0x1p-1 -0x1p-1))
                                   (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.min" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                   (v128.const f64x2 0x1p+0 0x1p+0))
                                   (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.min" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                   (v128.const f64x2 -0x1p+0 -0x1p+0))
                                   (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.min" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                   (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                   (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.min" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                   (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                   (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.min" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                   (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                   (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.min" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                   (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                   (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.min" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                   (v128.const f64x2 inf inf))
                                   (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.min" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                   (v128.const f64x2 -inf -inf))
                                   (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.min" (v128.const f64x2 inf inf)
                                   (v128.const f64x2 0x0p+0 0x0p+0))
                                   (v128.const f64x2 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f64x2.min" (v128.const f64x2 inf inf)
                                   (v128.const f64x2 -0x0p+0 -0x0p+0))
                                   (v128.const f64x2 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f64x2.min" (v128.const f64x2 inf inf)
                                   (v128.const f64x2 0x1p-1074 0x1p-1074))
                                   (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.min" (v128.const f64x2 inf inf)
                                   (v128.const f64x2 -0x1p-1074 -0x1p-1074))
                                   (v128.const f64x2 -0x0.0000000000001p-1022 -0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.min" (v128.const f64x2 inf inf)
                                   (v128.const f64x2 0x1p-1022 0x1p-1022))
                                   (v128.const f64x2 0x1.0000000000000p-1022 0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.min" (v128.const f64x2 inf inf)
                                   (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                   (v128.const f64x2 -0x1.0000000000000p-1022 -0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.min" (v128.const f64x2 inf inf)
                                   (v128.const f64x2 0x1p-1 0x1p-1))
                                   (v128.const f64x2 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f64x2.min" (v128.const f64x2 inf inf)
                                   (v128.const f64x2 -0x1p-1 -0x1p-1))
                                   (v128.const f64x2 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f64x2.min" (v128.const f64x2 inf inf)
                                   (v128.const f64x2 0x1p+0 0x1p+0))
                                   (v128.const f64x2 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f64x2.min" (v128.const f64x2 inf inf)
                                   (v128.const f64x2 -0x1p+0 -0x1p+0))
                                   (v128.const f64x2 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f64x2.min" (v128.const f64x2 inf inf)
                                   (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                   (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.min" (v128.const f64x2 inf inf)
                                   (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                   (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.min" (v128.const f64x2 inf inf)
                                   (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                   (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.min" (v128.const f64x2 inf inf)
                                   (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                   (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.min" (v128.const f64x2 inf inf)
                                   (v128.const f64x2 inf inf))
                                   (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.min" (v128.const f64x2 inf inf)
                                   (v128.const f64x2 -inf -inf))
                                   (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.min" (v128.const f64x2 -inf -inf)
                                   (v128.const f64x2 0x0p+0 0x0p+0))
                                   (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.min" (v128.const f64x2 -inf -inf)
                                   (v128.const f64x2 -0x0p+0 -0x0p+0))
                                   (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.min" (v128.const f64x2 -inf -inf)
                                   (v128.const f64x2 0x1p-1074 0x1p-1074))
                                   (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.min" (v128.const f64x2 -inf -inf)
                                   (v128.const f64x2 -0x1p-1074 -0x1p-1074))
                                   (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.min" (v128.const f64x2 -inf -inf)
                                   (v128.const f64x2 0x1p-1022 0x1p-1022))
                                   (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.min" (v128.const f64x2 -inf -inf)
                                   (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                   (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.min" (v128.const f64x2 -inf -inf)
                                   (v128.const f64x2 0x1p-1 0x1p-1))
                                   (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.min" (v128.const f64x2 -inf -inf)
                                   (v128.const f64x2 -0x1p-1 -0x1p-1))
                                   (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.min" (v128.const f64x2 -inf -inf)
                                   (v128.const f64x2 0x1p+0 0x1p+0))
                                   (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.min" (v128.const f64x2 -inf -inf)
                                   (v128.const f64x2 -0x1p+0 -0x1p+0))
                                   (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.min" (v128.const f64x2 -inf -inf)
                                   (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                   (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.min" (v128.const f64x2 -inf -inf)
                                   (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                   (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.min" (v128.const f64x2 -inf -inf)
                                   (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                   (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.min" (v128.const f64x2 -inf -inf)
                                   (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                   (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.min" (v128.const f64x2 -inf -inf)
                                   (v128.const f64x2 inf inf))
                                   (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.min" (v128.const f64x2 -inf -inf)
                                   (v128.const f64x2 -inf -inf))
                                   (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.min" (v128.const f64x2 nan nan)
                                   (v128.const f64x2 0x0p+0 0x0p+0))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.min" (v128.const f64x2 nan nan)
                                   (v128.const f64x2 -0x0p+0 -0x0p+0))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.min" (v128.const f64x2 nan nan)
                                   (v128.const f64x2 0x1p-1074 0x1p-1074))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.min" (v128.const f64x2 nan nan)
                                   (v128.const f64x2 -0x1p-1074 -0x1p-1074))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.min" (v128.const f64x2 nan nan)
                                   (v128.const f64x2 0x1p-1022 0x1p-1022))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.min" (v128.const f64x2 nan nan)
                                   (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.min" (v128.const f64x2 nan nan)
                                   (v128.const f64x2 0x1p-1 0x1p-1))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.min" (v128.const f64x2 nan nan)
                                   (v128.const f64x2 -0x1p-1 -0x1p-1))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.min" (v128.const f64x2 nan nan)
                                   (v128.const f64x2 0x1p+0 0x1p+0))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.min" (v128.const f64x2 nan nan)
                                   (v128.const f64x2 -0x1p+0 -0x1p+0))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.min" (v128.const f64x2 nan nan)
                                   (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.min" (v128.const f64x2 nan nan)
                                   (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.min" (v128.const f64x2 nan nan)
                                   (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.min" (v128.const f64x2 nan nan)
                                   (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.min" (v128.const f64x2 nan nan)
                                   (v128.const f64x2 inf inf))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.min" (v128.const f64x2 nan nan)
                                   (v128.const f64x2 -inf -inf))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.min" (v128.const f64x2 nan nan)
                                   (v128.const f64x2 nan nan))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.min" (v128.const f64x2 nan nan)
                                   (v128.const f64x2 -nan -nan))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.min" (v128.const f64x2 nan nan)
                                   (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.min" (v128.const f64x2 nan nan)
                                   (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.min" (v128.const f64x2 -nan -nan)
                                   (v128.const f64x2 0x0p+0 0x0p+0))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.min" (v128.const f64x2 -nan -nan)
                                   (v128.const f64x2 -0x0p+0 -0x0p+0))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.min" (v128.const f64x2 -nan -nan)
                                   (v128.const f64x2 0x1p-1074 0x1p-1074))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.min" (v128.const f64x2 -nan -nan)
                                   (v128.const f64x2 -0x1p-1074 -0x1p-1074))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.min" (v128.const f64x2 -nan -nan)
                                   (v128.const f64x2 0x1p-1022 0x1p-1022))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.min" (v128.const f64x2 -nan -nan)
                                   (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.min" (v128.const f64x2 -nan -nan)
                                   (v128.const f64x2 0x1p-1 0x1p-1))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.min" (v128.const f64x2 -nan -nan)
                                   (v128.const f64x2 -0x1p-1 -0x1p-1))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.min" (v128.const f64x2 -nan -nan)
                                   (v128.const f64x2 0x1p+0 0x1p+0))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.min" (v128.const f64x2 -nan -nan)
                                   (v128.const f64x2 -0x1p+0 -0x1p+0))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.min" (v128.const f64x2 -nan -nan)
                                   (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.min" (v128.const f64x2 -nan -nan)
                                   (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.min" (v128.const f64x2 -nan -nan)
                                   (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.min" (v128.const f64x2 -nan -nan)
                                   (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.min" (v128.const f64x2 -nan -nan)
                                   (v128.const f64x2 inf inf))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.min" (v128.const f64x2 -nan -nan)
                                   (v128.const f64x2 -inf -inf))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.min" (v128.const f64x2 -nan -nan)
                                   (v128.const f64x2 nan nan))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.min" (v128.const f64x2 -nan -nan)
                                   (v128.const f64x2 -nan -nan))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.min" (v128.const f64x2 -nan -nan)
                                   (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.min" (v128.const f64x2 -nan -nan)
                                   (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.min" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                   (v128.const f64x2 0x0p+0 0x0p+0))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.min" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                   (v128.const f64x2 -0x0p+0 -0x0p+0))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.min" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                   (v128.const f64x2 0x1p-1074 0x1p-1074))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.min" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                   (v128.const f64x2 -0x1p-1074 -0x1p-1074))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.min" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                   (v128.const f64x2 0x1p-1022 0x1p-1022))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.min" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                   (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.min" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                   (v128.const f64x2 0x1p-1 0x1p-1))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.min" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                   (v128.const f64x2 -0x1p-1 -0x1p-1))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.min" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                   (v128.const f64x2 0x1p+0 0x1p+0))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.min" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                   (v128.const f64x2 -0x1p+0 -0x1p+0))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.min" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                   (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.min" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                   (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.min" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                   (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.min" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                   (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.min" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                   (v128.const f64x2 inf inf))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.min" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                   (v128.const f64x2 -inf -inf))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.min" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                   (v128.const f64x2 nan nan))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.min" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                   (v128.const f64x2 -nan -nan))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.min" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                   (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.min" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                   (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.min" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                   (v128.const f64x2 0x0p+0 0x0p+0))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.min" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                   (v128.const f64x2 -0x0p+0 -0x0p+0))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.min" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                   (v128.const f64x2 0x1p-1074 0x1p-1074))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.min" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                   (v128.const f64x2 -0x1p-1074 -0x1p-1074))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.min" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                   (v128.const f64x2 0x1p-1022 0x1p-1022))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.min" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                   (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.min" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                   (v128.const f64x2 0x1p-1 0x1p-1))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.min" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                   (v128.const f64x2 -0x1p-1 -0x1p-1))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.min" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                   (v128.const f64x2 0x1p+0 0x1p+0))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.min" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                   (v128.const f64x2 -0x1p+0 -0x1p+0))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.min" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                   (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.min" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                   (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.min" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                   (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.min" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                   (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.min" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                   (v128.const f64x2 inf inf))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.min" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                   (v128.const f64x2 -inf -inf))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.min" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                   (v128.const f64x2 nan nan))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.min" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                   (v128.const f64x2 -nan -nan))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.min" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                   (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.min" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                   (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.min" (v128.const f64x2 01234567890123456789e038 01234567890123456789e038)
                                   (v128.const f64x2 01234567890123456789e038 01234567890123456789e038))
                                   (v128.const f64x2 01234567890123456789e038 01234567890123456789e038))
(assert_return (invoke "f64x2.min" (v128.const f64x2 01234567890123456789e038 01234567890123456789e038)
                                   (v128.const f64x2 01234567890123456789e-038 01234567890123456789e-038))
                                   (v128.const f64x2 01234567890123456789e-038 01234567890123456789e-038))
(assert_return (invoke "f64x2.min" (v128.const f64x2 01234567890123456789e038 01234567890123456789e038)
                                   (v128.const f64x2 0123456789.e038 0123456789.e038))
                                   (v128.const f64x2 0123456789.e038 0123456789.e038))
(assert_return (invoke "f64x2.min" (v128.const f64x2 01234567890123456789e038 01234567890123456789e038)
                                   (v128.const f64x2 0123456789.e+038 0123456789.e+038))
                                   (v128.const f64x2 0123456789.e+038 0123456789.e+038))
(assert_return (invoke "f64x2.min" (v128.const f64x2 01234567890123456789e038 01234567890123456789e038)
                                   (v128.const f64x2 -01234567890123456789.01234567890123456789 -01234567890123456789.01234567890123456789))
                                   (v128.const f64x2 -01234567890123456789.01234567890123456789 -01234567890123456789.01234567890123456789))
(assert_return (invoke "f64x2.min" (v128.const f64x2 01234567890123456789e-038 01234567890123456789e-038)
                                   (v128.const f64x2 01234567890123456789e038 01234567890123456789e038))
                                   (v128.const f64x2 01234567890123456789e-038 01234567890123456789e-038))
(assert_return (invoke "f64x2.min" (v128.const f64x2 01234567890123456789e-038 01234567890123456789e-038)
                                   (v128.const f64x2 01234567890123456789e-038 01234567890123456789e-038))
                                   (v128.const f64x2 01234567890123456789e-038 01234567890123456789e-038))
(assert_return (invoke "f64x2.min" (v128.const f64x2 01234567890123456789e-038 01234567890123456789e-038)
                                   (v128.const f64x2 0123456789.e038 0123456789.e038))
                                   (v128.const f64x2 01234567890123456789e-038 01234567890123456789e-038))
(assert_return (invoke "f64x2.min" (v128.const f64x2 01234567890123456789e-038 01234567890123456789e-038)
                                   (v128.const f64x2 0123456789.e+038 0123456789.e+038))
                                   (v128.const f64x2 01234567890123456789e-038 01234567890123456789e-038))
(assert_return (invoke "f64x2.min" (v128.const f64x2 01234567890123456789e-038 01234567890123456789e-038)
                                   (v128.const f64x2 -01234567890123456789.01234567890123456789 -01234567890123456789.01234567890123456789))
                                   (v128.const f64x2 -01234567890123456789.01234567890123456789 -01234567890123456789.01234567890123456789))
(assert_return (invoke "f64x2.min" (v128.const f64x2 0123456789.e038 0123456789.e038)
                                   (v128.const f64x2 01234567890123456789e038 01234567890123456789e038))
                                   (v128.const f64x2 0123456789.e038 0123456789.e038))
(assert_return (invoke "f64x2.min" (v128.const f64x2 0123456789.e038 0123456789.e038)
                                   (v128.const f64x2 01234567890123456789e-038 01234567890123456789e-038))
                                   (v128.const f64x2 01234567890123456789e-038 01234567890123456789e-038))
(assert_return (invoke "f64x2.min" (v128.const f64x2 0123456789.e038 0123456789.e038)
                                   (v128.const f64x2 0123456789.e038 0123456789.e038))
                                   (v128.const f64x2 0123456789.e038 0123456789.e038))
(assert_return (invoke "f64x2.min" (v128.const f64x2 0123456789.e038 0123456789.e038)
                                   (v128.const f64x2 0123456789.e+038 0123456789.e+038))
                                   (v128.const f64x2 0123456789.e038 0123456789.e038))
(assert_return (invoke "f64x2.min" (v128.const f64x2 0123456789.e038 0123456789.e038)
                                   (v128.const f64x2 -01234567890123456789.01234567890123456789 -01234567890123456789.01234567890123456789))
                                   (v128.const f64x2 -01234567890123456789.01234567890123456789 -01234567890123456789.01234567890123456789))
(assert_return (invoke "f64x2.min" (v128.const f64x2 0123456789.e+038 0123456789.e+038)
                                   (v128.const f64x2 01234567890123456789e038 01234567890123456789e038))
                                   (v128.const f64x2 0123456789.e+038 0123456789.e+038))
(assert_return (invoke "f64x2.min" (v128.const f64x2 0123456789.e+038 0123456789.e+038)
                                   (v128.const f64x2 01234567890123456789e-038 01234567890123456789e-038))
                                   (v128.const f64x2 01234567890123456789e-038 01234567890123456789e-038))
(assert_return (invoke "f64x2.min" (v128.const f64x2 0123456789.e+038 0123456789.e+038)
                                   (v128.const f64x2 0123456789.e038 0123456789.e038))
                                   (v128.const f64x2 0123456789.e+038 0123456789.e+038))
(assert_return (invoke "f64x2.min" (v128.const f64x2 0123456789.e+038 0123456789.e+038)
                                   (v128.const f64x2 0123456789.e+038 0123456789.e+038))
                                   (v128.const f64x2 0123456789.e+038 0123456789.e+038))
(assert_return (invoke "f64x2.min" (v128.const f64x2 0123456789.e+038 0123456789.e+038)
                                   (v128.const f64x2 -01234567890123456789.01234567890123456789 -01234567890123456789.01234567890123456789))
                                   (v128.const f64x2 -01234567890123456789.01234567890123456789 -01234567890123456789.01234567890123456789))
(assert_return (invoke "f64x2.min" (v128.const f64x2 -01234567890123456789.01234567890123456789 -01234567890123456789.01234567890123456789)
                                   (v128.const f64x2 01234567890123456789e038 01234567890123456789e038))
                                   (v128.const f64x2 -01234567890123456789.01234567890123456789 -01234567890123456789.01234567890123456789))
(assert_return (invoke "f64x2.min" (v128.const f64x2 -01234567890123456789.01234567890123456789 -01234567890123456789.01234567890123456789)
                                   (v128.const f64x2 01234567890123456789e-038 01234567890123456789e-038))
                                   (v128.const f64x2 -01234567890123456789.01234567890123456789 -01234567890123456789.01234567890123456789))
(assert_return (invoke "f64x2.min" (v128.const f64x2 -01234567890123456789.01234567890123456789 -01234567890123456789.01234567890123456789)
                                   (v128.const f64x2 0123456789.e038 0123456789.e038))
                                   (v128.const f64x2 -01234567890123456789.01234567890123456789 -01234567890123456789.01234567890123456789))
(assert_return (invoke "f64x2.min" (v128.const f64x2 -01234567890123456789.01234567890123456789 -01234567890123456789.01234567890123456789)
                                   (v128.const f64x2 0123456789.e+038 0123456789.e+038))
                                   (v128.const f64x2 -01234567890123456789.01234567890123456789 -01234567890123456789.01234567890123456789))
(assert_return (invoke "f64x2.min" (v128.const f64x2 -01234567890123456789.01234567890123456789 -01234567890123456789.01234567890123456789)
                                   (v128.const f64x2 -01234567890123456789.01234567890123456789 -01234567890123456789.01234567890123456789))
                                   (v128.const f64x2 -01234567890123456789.01234567890123456789 -01234567890123456789.01234567890123456789))
(assert_return (invoke "f64x2.max" (v128.const f64x2 0x0p+0 0x0p+0)
                                   (v128.const f64x2 0x0p+0 0x0p+0))
                                   (v128.const f64x2 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f64x2.max" (v128.const f64x2 0x0p+0 0x0p+0)
                                   (v128.const f64x2 -0x0p+0 -0x0p+0))
                                   (v128.const f64x2 0x0p+0 0x0p+0))
(assert_return (invoke "f64x2.max" (v128.const f64x2 0x0p+0 0x0p+0)
                                   (v128.const f64x2 0x1p-1074 0x1p-1074))
                                   (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.max" (v128.const f64x2 0x0p+0 0x0p+0)
                                   (v128.const f64x2 -0x1p-1074 -0x1p-1074))
                                   (v128.const f64x2 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f64x2.max" (v128.const f64x2 0x0p+0 0x0p+0)
                                   (v128.const f64x2 0x1p-1022 0x1p-1022))
                                   (v128.const f64x2 0x1.0000000000000p-1022 0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.max" (v128.const f64x2 0x0p+0 0x0p+0)
                                   (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                   (v128.const f64x2 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f64x2.max" (v128.const f64x2 0x0p+0 0x0p+0)
                                   (v128.const f64x2 0x1p-1 0x1p-1))
                                   (v128.const f64x2 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f64x2.max" (v128.const f64x2 0x0p+0 0x0p+0)
                                   (v128.const f64x2 -0x1p-1 -0x1p-1))
                                   (v128.const f64x2 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f64x2.max" (v128.const f64x2 0x0p+0 0x0p+0)
                                   (v128.const f64x2 0x1p+0 0x1p+0))
                                   (v128.const f64x2 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f64x2.max" (v128.const f64x2 0x0p+0 0x0p+0)
                                   (v128.const f64x2 -0x1p+0 -0x1p+0))
                                   (v128.const f64x2 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f64x2.max" (v128.const f64x2 0x0p+0 0x0p+0)
                                   (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                   (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.max" (v128.const f64x2 0x0p+0 0x0p+0)
                                   (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                   (v128.const f64x2 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f64x2.max" (v128.const f64x2 0x0p+0 0x0p+0)
                                   (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                   (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.max" (v128.const f64x2 0x0p+0 0x0p+0)
                                   (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                   (v128.const f64x2 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f64x2.max" (v128.const f64x2 0x0p+0 0x0p+0)
                                   (v128.const f64x2 inf inf))
                                   (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.max" (v128.const f64x2 0x0p+0 0x0p+0)
                                   (v128.const f64x2 -inf -inf))
                                   (v128.const f64x2 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f64x2.max" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                   (v128.const f64x2 0x0p+0 0x0p+0))
                                   (v128.const f64x2 0x0p+0 0x0p+0))
(assert_return (invoke "f64x2.max" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                   (v128.const f64x2 -0x0p+0 -0x0p+0))
                                   (v128.const f64x2 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f64x2.max" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                   (v128.const f64x2 0x1p-1074 0x1p-1074))
                                   (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.max" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                   (v128.const f64x2 -0x1p-1074 -0x1p-1074))
                                   (v128.const f64x2 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f64x2.max" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                   (v128.const f64x2 0x1p-1022 0x1p-1022))
                                   (v128.const f64x2 0x1.0000000000000p-1022 0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.max" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                   (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                   (v128.const f64x2 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f64x2.max" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                   (v128.const f64x2 0x1p-1 0x1p-1))
                                   (v128.const f64x2 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f64x2.max" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                   (v128.const f64x2 -0x1p-1 -0x1p-1))
                                   (v128.const f64x2 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f64x2.max" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                   (v128.const f64x2 0x1p+0 0x1p+0))
                                   (v128.const f64x2 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f64x2.max" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                   (v128.const f64x2 -0x1p+0 -0x1p+0))
                                   (v128.const f64x2 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f64x2.max" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                   (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                   (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.max" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                   (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                   (v128.const f64x2 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f64x2.max" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                   (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                   (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.max" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                   (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                   (v128.const f64x2 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f64x2.max" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                   (v128.const f64x2 inf inf))
                                   (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.max" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                   (v128.const f64x2 -inf -inf))
                                   (v128.const f64x2 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f64x2.max" (v128.const f64x2 0x1p-1074 0x1p-1074)
                                   (v128.const f64x2 0x0p+0 0x0p+0))
                                   (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.max" (v128.const f64x2 0x1p-1074 0x1p-1074)
                                   (v128.const f64x2 -0x0p+0 -0x0p+0))
                                   (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.max" (v128.const f64x2 0x1p-1074 0x1p-1074)
                                   (v128.const f64x2 0x1p-1074 0x1p-1074))
                                   (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.max" (v128.const f64x2 0x1p-1074 0x1p-1074)
                                   (v128.const f64x2 -0x1p-1074 -0x1p-1074))
                                   (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.max" (v128.const f64x2 0x1p-1074 0x1p-1074)
                                   (v128.const f64x2 0x1p-1022 0x1p-1022))
                                   (v128.const f64x2 0x1.0000000000000p-1022 0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.max" (v128.const f64x2 0x1p-1074 0x1p-1074)
                                   (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                   (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.max" (v128.const f64x2 0x1p-1074 0x1p-1074)
                                   (v128.const f64x2 0x1p-1 0x1p-1))
                                   (v128.const f64x2 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f64x2.max" (v128.const f64x2 0x1p-1074 0x1p-1074)
                                   (v128.const f64x2 -0x1p-1 -0x1p-1))
                                   (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.max" (v128.const f64x2 0x1p-1074 0x1p-1074)
                                   (v128.const f64x2 0x1p+0 0x1p+0))
                                   (v128.const f64x2 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f64x2.max" (v128.const f64x2 0x1p-1074 0x1p-1074)
                                   (v128.const f64x2 -0x1p+0 -0x1p+0))
                                   (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.max" (v128.const f64x2 0x1p-1074 0x1p-1074)
                                   (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                   (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.max" (v128.const f64x2 0x1p-1074 0x1p-1074)
                                   (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                   (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.max" (v128.const f64x2 0x1p-1074 0x1p-1074)
                                   (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                   (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.max" (v128.const f64x2 0x1p-1074 0x1p-1074)
                                   (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                   (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.max" (v128.const f64x2 0x1p-1074 0x1p-1074)
                                   (v128.const f64x2 inf inf))
                                   (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.max" (v128.const f64x2 0x1p-1074 0x1p-1074)
                                   (v128.const f64x2 -inf -inf))
                                   (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.max" (v128.const f64x2 -0x1p-1074 -0x1p-1074)
                                   (v128.const f64x2 0x0p+0 0x0p+0))
                                   (v128.const f64x2 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f64x2.max" (v128.const f64x2 -0x1p-1074 -0x1p-1074)
                                   (v128.const f64x2 -0x0p+0 -0x0p+0))
                                   (v128.const f64x2 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f64x2.max" (v128.const f64x2 -0x1p-1074 -0x1p-1074)
                                   (v128.const f64x2 0x1p-1074 0x1p-1074))
                                   (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.max" (v128.const f64x2 -0x1p-1074 -0x1p-1074)
                                   (v128.const f64x2 -0x1p-1074 -0x1p-1074))
                                   (v128.const f64x2 -0x0.0000000000001p-1022 -0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.max" (v128.const f64x2 -0x1p-1074 -0x1p-1074)
                                   (v128.const f64x2 0x1p-1022 0x1p-1022))
                                   (v128.const f64x2 0x1.0000000000000p-1022 0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.max" (v128.const f64x2 -0x1p-1074 -0x1p-1074)
                                   (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                   (v128.const f64x2 -0x0.0000000000001p-1022 -0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.max" (v128.const f64x2 -0x1p-1074 -0x1p-1074)
                                   (v128.const f64x2 0x1p-1 0x1p-1))
                                   (v128.const f64x2 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f64x2.max" (v128.const f64x2 -0x1p-1074 -0x1p-1074)
                                   (v128.const f64x2 -0x1p-1 -0x1p-1))
                                   (v128.const f64x2 -0x0.0000000000001p-1022 -0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.max" (v128.const f64x2 -0x1p-1074 -0x1p-1074)
                                   (v128.const f64x2 0x1p+0 0x1p+0))
                                   (v128.const f64x2 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f64x2.max" (v128.const f64x2 -0x1p-1074 -0x1p-1074)
                                   (v128.const f64x2 -0x1p+0 -0x1p+0))
                                   (v128.const f64x2 -0x0.0000000000001p-1022 -0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.max" (v128.const f64x2 -0x1p-1074 -0x1p-1074)
                                   (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                   (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.max" (v128.const f64x2 -0x1p-1074 -0x1p-1074)
                                   (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                   (v128.const f64x2 -0x0.0000000000001p-1022 -0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.max" (v128.const f64x2 -0x1p-1074 -0x1p-1074)
                                   (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                   (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.max" (v128.const f64x2 -0x1p-1074 -0x1p-1074)
                                   (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                   (v128.const f64x2 -0x0.0000000000001p-1022 -0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.max" (v128.const f64x2 -0x1p-1074 -0x1p-1074)
                                   (v128.const f64x2 inf inf))
                                   (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.max" (v128.const f64x2 -0x1p-1074 -0x1p-1074)
                                   (v128.const f64x2 -inf -inf))
                                   (v128.const f64x2 -0x0.0000000000001p-1022 -0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.max" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                   (v128.const f64x2 0x0p+0 0x0p+0))
                                   (v128.const f64x2 0x1.0000000000000p-1022 0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.max" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                   (v128.const f64x2 -0x0p+0 -0x0p+0))
                                   (v128.const f64x2 0x1.0000000000000p-1022 0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.max" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                   (v128.const f64x2 0x1p-1074 0x1p-1074))
                                   (v128.const f64x2 0x1.0000000000000p-1022 0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.max" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                   (v128.const f64x2 -0x1p-1074 -0x1p-1074))
                                   (v128.const f64x2 0x1.0000000000000p-1022 0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.max" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                   (v128.const f64x2 0x1p-1022 0x1p-1022))
                                   (v128.const f64x2 0x1.0000000000000p-1022 0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.max" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                   (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                   (v128.const f64x2 0x1.0000000000000p-1022 0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.max" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                   (v128.const f64x2 0x1p-1 0x1p-1))
                                   (v128.const f64x2 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f64x2.max" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                   (v128.const f64x2 -0x1p-1 -0x1p-1))
                                   (v128.const f64x2 0x1.0000000000000p-1022 0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.max" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                   (v128.const f64x2 0x1p+0 0x1p+0))
                                   (v128.const f64x2 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f64x2.max" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                   (v128.const f64x2 -0x1p+0 -0x1p+0))
                                   (v128.const f64x2 0x1.0000000000000p-1022 0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.max" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                   (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                   (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.max" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                   (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                   (v128.const f64x2 0x1.0000000000000p-1022 0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.max" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                   (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                   (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.max" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                   (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                   (v128.const f64x2 0x1.0000000000000p-1022 0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.max" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                   (v128.const f64x2 inf inf))
                                   (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.max" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                   (v128.const f64x2 -inf -inf))
                                   (v128.const f64x2 0x1.0000000000000p-1022 0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.max" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                   (v128.const f64x2 0x0p+0 0x0p+0))
                                   (v128.const f64x2 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f64x2.max" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                   (v128.const f64x2 -0x0p+0 -0x0p+0))
                                   (v128.const f64x2 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f64x2.max" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                   (v128.const f64x2 0x1p-1074 0x1p-1074))
                                   (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.max" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                   (v128.const f64x2 -0x1p-1074 -0x1p-1074))
                                   (v128.const f64x2 -0x0.0000000000001p-1022 -0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.max" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                   (v128.const f64x2 0x1p-1022 0x1p-1022))
                                   (v128.const f64x2 0x1.0000000000000p-1022 0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.max" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                   (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                   (v128.const f64x2 -0x1.0000000000000p-1022 -0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.max" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                   (v128.const f64x2 0x1p-1 0x1p-1))
                                   (v128.const f64x2 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f64x2.max" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                   (v128.const f64x2 -0x1p-1 -0x1p-1))
                                   (v128.const f64x2 -0x1.0000000000000p-1022 -0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.max" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                   (v128.const f64x2 0x1p+0 0x1p+0))
                                   (v128.const f64x2 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f64x2.max" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                   (v128.const f64x2 -0x1p+0 -0x1p+0))
                                   (v128.const f64x2 -0x1.0000000000000p-1022 -0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.max" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                   (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                   (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.max" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                   (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                   (v128.const f64x2 -0x1.0000000000000p-1022 -0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.max" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                   (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                   (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.max" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                   (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                   (v128.const f64x2 -0x1.0000000000000p-1022 -0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.max" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                   (v128.const f64x2 inf inf))
                                   (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.max" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                   (v128.const f64x2 -inf -inf))
                                   (v128.const f64x2 -0x1.0000000000000p-1022 -0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.max" (v128.const f64x2 0x1p-1 0x1p-1)
                                   (v128.const f64x2 0x0p+0 0x0p+0))
                                   (v128.const f64x2 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f64x2.max" (v128.const f64x2 0x1p-1 0x1p-1)
                                   (v128.const f64x2 -0x0p+0 -0x0p+0))
                                   (v128.const f64x2 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f64x2.max" (v128.const f64x2 0x1p-1 0x1p-1)
                                   (v128.const f64x2 0x1p-1074 0x1p-1074))
                                   (v128.const f64x2 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f64x2.max" (v128.const f64x2 0x1p-1 0x1p-1)
                                   (v128.const f64x2 -0x1p-1074 -0x1p-1074))
                                   (v128.const f64x2 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f64x2.max" (v128.const f64x2 0x1p-1 0x1p-1)
                                   (v128.const f64x2 0x1p-1022 0x1p-1022))
                                   (v128.const f64x2 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f64x2.max" (v128.const f64x2 0x1p-1 0x1p-1)
                                   (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                   (v128.const f64x2 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f64x2.max" (v128.const f64x2 0x1p-1 0x1p-1)
                                   (v128.const f64x2 0x1p-1 0x1p-1))
                                   (v128.const f64x2 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f64x2.max" (v128.const f64x2 0x1p-1 0x1p-1)
                                   (v128.const f64x2 -0x1p-1 -0x1p-1))
                                   (v128.const f64x2 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f64x2.max" (v128.const f64x2 0x1p-1 0x1p-1)
                                   (v128.const f64x2 0x1p+0 0x1p+0))
                                   (v128.const f64x2 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f64x2.max" (v128.const f64x2 0x1p-1 0x1p-1)
                                   (v128.const f64x2 -0x1p+0 -0x1p+0))
                                   (v128.const f64x2 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f64x2.max" (v128.const f64x2 0x1p-1 0x1p-1)
                                   (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                   (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.max" (v128.const f64x2 0x1p-1 0x1p-1)
                                   (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                   (v128.const f64x2 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f64x2.max" (v128.const f64x2 0x1p-1 0x1p-1)
                                   (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                   (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.max" (v128.const f64x2 0x1p-1 0x1p-1)
                                   (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                   (v128.const f64x2 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f64x2.max" (v128.const f64x2 0x1p-1 0x1p-1)
                                   (v128.const f64x2 inf inf))
                                   (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.max" (v128.const f64x2 0x1p-1 0x1p-1)
                                   (v128.const f64x2 -inf -inf))
                                   (v128.const f64x2 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f64x2.max" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                   (v128.const f64x2 0x0p+0 0x0p+0))
                                   (v128.const f64x2 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f64x2.max" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                   (v128.const f64x2 -0x0p+0 -0x0p+0))
                                   (v128.const f64x2 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f64x2.max" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                   (v128.const f64x2 0x1p-1074 0x1p-1074))
                                   (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.max" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                   (v128.const f64x2 -0x1p-1074 -0x1p-1074))
                                   (v128.const f64x2 -0x0.0000000000001p-1022 -0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.max" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                   (v128.const f64x2 0x1p-1022 0x1p-1022))
                                   (v128.const f64x2 0x1.0000000000000p-1022 0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.max" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                   (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                   (v128.const f64x2 -0x1.0000000000000p-1022 -0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.max" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                   (v128.const f64x2 0x1p-1 0x1p-1))
                                   (v128.const f64x2 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f64x2.max" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                   (v128.const f64x2 -0x1p-1 -0x1p-1))
                                   (v128.const f64x2 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f64x2.max" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                   (v128.const f64x2 0x1p+0 0x1p+0))
                                   (v128.const f64x2 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f64x2.max" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                   (v128.const f64x2 -0x1p+0 -0x1p+0))
                                   (v128.const f64x2 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f64x2.max" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                   (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                   (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.max" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                   (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                   (v128.const f64x2 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f64x2.max" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                   (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                   (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.max" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                   (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                   (v128.const f64x2 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f64x2.max" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                   (v128.const f64x2 inf inf))
                                   (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.max" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                   (v128.const f64x2 -inf -inf))
                                   (v128.const f64x2 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f64x2.max" (v128.const f64x2 0x1p+0 0x1p+0)
                                   (v128.const f64x2 0x0p+0 0x0p+0))
                                   (v128.const f64x2 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f64x2.max" (v128.const f64x2 0x1p+0 0x1p+0)
                                   (v128.const f64x2 -0x0p+0 -0x0p+0))
                                   (v128.const f64x2 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f64x2.max" (v128.const f64x2 0x1p+0 0x1p+0)
                                   (v128.const f64x2 0x1p-1074 0x1p-1074))
                                   (v128.const f64x2 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f64x2.max" (v128.const f64x2 0x1p+0 0x1p+0)
                                   (v128.const f64x2 -0x1p-1074 -0x1p-1074))
                                   (v128.const f64x2 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f64x2.max" (v128.const f64x2 0x1p+0 0x1p+0)
                                   (v128.const f64x2 0x1p-1022 0x1p-1022))
                                   (v128.const f64x2 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f64x2.max" (v128.const f64x2 0x1p+0 0x1p+0)
                                   (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                   (v128.const f64x2 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f64x2.max" (v128.const f64x2 0x1p+0 0x1p+0)
                                   (v128.const f64x2 0x1p-1 0x1p-1))
                                   (v128.const f64x2 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f64x2.max" (v128.const f64x2 0x1p+0 0x1p+0)
                                   (v128.const f64x2 -0x1p-1 -0x1p-1))
                                   (v128.const f64x2 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f64x2.max" (v128.const f64x2 0x1p+0 0x1p+0)
                                   (v128.const f64x2 0x1p+0 0x1p+0))
                                   (v128.const f64x2 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f64x2.max" (v128.const f64x2 0x1p+0 0x1p+0)
                                   (v128.const f64x2 -0x1p+0 -0x1p+0))
                                   (v128.const f64x2 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f64x2.max" (v128.const f64x2 0x1p+0 0x1p+0)
                                   (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                   (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.max" (v128.const f64x2 0x1p+0 0x1p+0)
                                   (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                   (v128.const f64x2 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f64x2.max" (v128.const f64x2 0x1p+0 0x1p+0)
                                   (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                   (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.max" (v128.const f64x2 0x1p+0 0x1p+0)
                                   (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                   (v128.const f64x2 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f64x2.max" (v128.const f64x2 0x1p+0 0x1p+0)
                                   (v128.const f64x2 inf inf))
                                   (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.max" (v128.const f64x2 0x1p+0 0x1p+0)
                                   (v128.const f64x2 -inf -inf))
                                   (v128.const f64x2 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f64x2.max" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                   (v128.const f64x2 0x0p+0 0x0p+0))
                                   (v128.const f64x2 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f64x2.max" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                   (v128.const f64x2 -0x0p+0 -0x0p+0))
                                   (v128.const f64x2 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f64x2.max" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                   (v128.const f64x2 0x1p-1074 0x1p-1074))
                                   (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.max" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                   (v128.const f64x2 -0x1p-1074 -0x1p-1074))
                                   (v128.const f64x2 -0x0.0000000000001p-1022 -0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.max" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                   (v128.const f64x2 0x1p-1022 0x1p-1022))
                                   (v128.const f64x2 0x1.0000000000000p-1022 0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.max" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                   (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                   (v128.const f64x2 -0x1.0000000000000p-1022 -0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.max" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                   (v128.const f64x2 0x1p-1 0x1p-1))
                                   (v128.const f64x2 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f64x2.max" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                   (v128.const f64x2 -0x1p-1 -0x1p-1))
                                   (v128.const f64x2 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f64x2.max" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                   (v128.const f64x2 0x1p+0 0x1p+0))
                                   (v128.const f64x2 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f64x2.max" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                   (v128.const f64x2 -0x1p+0 -0x1p+0))
                                   (v128.const f64x2 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f64x2.max" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                   (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                   (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.max" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                   (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                   (v128.const f64x2 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f64x2.max" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                   (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                   (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.max" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                   (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                   (v128.const f64x2 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f64x2.max" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                   (v128.const f64x2 inf inf))
                                   (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.max" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                   (v128.const f64x2 -inf -inf))
                                   (v128.const f64x2 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f64x2.max" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                   (v128.const f64x2 0x0p+0 0x0p+0))
                                   (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.max" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                   (v128.const f64x2 -0x0p+0 -0x0p+0))
                                   (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.max" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                   (v128.const f64x2 0x1p-1074 0x1p-1074))
                                   (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.max" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                   (v128.const f64x2 -0x1p-1074 -0x1p-1074))
                                   (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.max" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                   (v128.const f64x2 0x1p-1022 0x1p-1022))
                                   (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.max" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                   (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                   (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.max" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                   (v128.const f64x2 0x1p-1 0x1p-1))
                                   (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.max" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                   (v128.const f64x2 -0x1p-1 -0x1p-1))
                                   (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.max" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                   (v128.const f64x2 0x1p+0 0x1p+0))
                                   (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.max" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                   (v128.const f64x2 -0x1p+0 -0x1p+0))
                                   (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.max" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                   (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                   (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.max" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                   (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                   (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.max" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                   (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                   (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.max" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                   (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                   (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.max" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                   (v128.const f64x2 inf inf))
                                   (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.max" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                   (v128.const f64x2 -inf -inf))
                                   (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.max" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                   (v128.const f64x2 0x0p+0 0x0p+0))
                                   (v128.const f64x2 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f64x2.max" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                   (v128.const f64x2 -0x0p+0 -0x0p+0))
                                   (v128.const f64x2 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f64x2.max" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                   (v128.const f64x2 0x1p-1074 0x1p-1074))
                                   (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.max" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                   (v128.const f64x2 -0x1p-1074 -0x1p-1074))
                                   (v128.const f64x2 -0x0.0000000000001p-1022 -0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.max" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                   (v128.const f64x2 0x1p-1022 0x1p-1022))
                                   (v128.const f64x2 0x1.0000000000000p-1022 0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.max" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                   (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                   (v128.const f64x2 -0x1.0000000000000p-1022 -0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.max" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                   (v128.const f64x2 0x1p-1 0x1p-1))
                                   (v128.const f64x2 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f64x2.max" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                   (v128.const f64x2 -0x1p-1 -0x1p-1))
                                   (v128.const f64x2 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f64x2.max" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                   (v128.const f64x2 0x1p+0 0x1p+0))
                                   (v128.const f64x2 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f64x2.max" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                   (v128.const f64x2 -0x1p+0 -0x1p+0))
                                   (v128.const f64x2 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f64x2.max" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                   (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                   (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.max" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                   (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                   (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.max" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                   (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                   (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.max" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                   (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                   (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.max" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                   (v128.const f64x2 inf inf))
                                   (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.max" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                   (v128.const f64x2 -inf -inf))
                                   (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.max" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                   (v128.const f64x2 0x0p+0 0x0p+0))
                                   (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.max" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                   (v128.const f64x2 -0x0p+0 -0x0p+0))
                                   (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.max" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                   (v128.const f64x2 0x1p-1074 0x1p-1074))
                                   (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.max" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                   (v128.const f64x2 -0x1p-1074 -0x1p-1074))
                                   (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.max" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                   (v128.const f64x2 0x1p-1022 0x1p-1022))
                                   (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.max" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                   (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                   (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.max" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                   (v128.const f64x2 0x1p-1 0x1p-1))
                                   (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.max" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                   (v128.const f64x2 -0x1p-1 -0x1p-1))
                                   (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.max" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                   (v128.const f64x2 0x1p+0 0x1p+0))
                                   (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.max" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                   (v128.const f64x2 -0x1p+0 -0x1p+0))
                                   (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.max" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                   (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                   (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.max" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                   (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                   (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.max" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                   (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                   (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.max" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                   (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                   (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.max" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                   (v128.const f64x2 inf inf))
                                   (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.max" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                   (v128.const f64x2 -inf -inf))
                                   (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.max" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                   (v128.const f64x2 0x0p+0 0x0p+0))
                                   (v128.const f64x2 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f64x2.max" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                   (v128.const f64x2 -0x0p+0 -0x0p+0))
                                   (v128.const f64x2 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f64x2.max" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                   (v128.const f64x2 0x1p-1074 0x1p-1074))
                                   (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.max" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                   (v128.const f64x2 -0x1p-1074 -0x1p-1074))
                                   (v128.const f64x2 -0x0.0000000000001p-1022 -0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.max" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                   (v128.const f64x2 0x1p-1022 0x1p-1022))
                                   (v128.const f64x2 0x1.0000000000000p-1022 0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.max" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                   (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                   (v128.const f64x2 -0x1.0000000000000p-1022 -0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.max" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                   (v128.const f64x2 0x1p-1 0x1p-1))
                                   (v128.const f64x2 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f64x2.max" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                   (v128.const f64x2 -0x1p-1 -0x1p-1))
                                   (v128.const f64x2 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f64x2.max" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                   (v128.const f64x2 0x1p+0 0x1p+0))
                                   (v128.const f64x2 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f64x2.max" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                   (v128.const f64x2 -0x1p+0 -0x1p+0))
                                   (v128.const f64x2 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f64x2.max" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                   (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                   (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.max" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                   (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                   (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.max" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                   (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                   (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.max" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                   (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                   (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.max" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                   (v128.const f64x2 inf inf))
                                   (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.max" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                   (v128.const f64x2 -inf -inf))
                                   (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.max" (v128.const f64x2 inf inf)
                                   (v128.const f64x2 0x0p+0 0x0p+0))
                                   (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.max" (v128.const f64x2 inf inf)
                                   (v128.const f64x2 -0x0p+0 -0x0p+0))
                                   (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.max" (v128.const f64x2 inf inf)
                                   (v128.const f64x2 0x1p-1074 0x1p-1074))
                                   (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.max" (v128.const f64x2 inf inf)
                                   (v128.const f64x2 -0x1p-1074 -0x1p-1074))
                                   (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.max" (v128.const f64x2 inf inf)
                                   (v128.const f64x2 0x1p-1022 0x1p-1022))
                                   (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.max" (v128.const f64x2 inf inf)
                                   (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                   (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.max" (v128.const f64x2 inf inf)
                                   (v128.const f64x2 0x1p-1 0x1p-1))
                                   (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.max" (v128.const f64x2 inf inf)
                                   (v128.const f64x2 -0x1p-1 -0x1p-1))
                                   (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.max" (v128.const f64x2 inf inf)
                                   (v128.const f64x2 0x1p+0 0x1p+0))
                                   (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.max" (v128.const f64x2 inf inf)
                                   (v128.const f64x2 -0x1p+0 -0x1p+0))
                                   (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.max" (v128.const f64x2 inf inf)
                                   (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                   (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.max" (v128.const f64x2 inf inf)
                                   (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                   (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.max" (v128.const f64x2 inf inf)
                                   (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                   (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.max" (v128.const f64x2 inf inf)
                                   (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                   (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.max" (v128.const f64x2 inf inf)
                                   (v128.const f64x2 inf inf))
                                   (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.max" (v128.const f64x2 inf inf)
                                   (v128.const f64x2 -inf -inf))
                                   (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.max" (v128.const f64x2 -inf -inf)
                                   (v128.const f64x2 0x0p+0 0x0p+0))
                                   (v128.const f64x2 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f64x2.max" (v128.const f64x2 -inf -inf)
                                   (v128.const f64x2 -0x0p+0 -0x0p+0))
                                   (v128.const f64x2 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f64x2.max" (v128.const f64x2 -inf -inf)
                                   (v128.const f64x2 0x1p-1074 0x1p-1074))
                                   (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.max" (v128.const f64x2 -inf -inf)
                                   (v128.const f64x2 -0x1p-1074 -0x1p-1074))
                                   (v128.const f64x2 -0x0.0000000000001p-1022 -0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.max" (v128.const f64x2 -inf -inf)
                                   (v128.const f64x2 0x1p-1022 0x1p-1022))
                                   (v128.const f64x2 0x1.0000000000000p-1022 0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.max" (v128.const f64x2 -inf -inf)
                                   (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                   (v128.const f64x2 -0x1.0000000000000p-1022 -0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.max" (v128.const f64x2 -inf -inf)
                                   (v128.const f64x2 0x1p-1 0x1p-1))
                                   (v128.const f64x2 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f64x2.max" (v128.const f64x2 -inf -inf)
                                   (v128.const f64x2 -0x1p-1 -0x1p-1))
                                   (v128.const f64x2 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f64x2.max" (v128.const f64x2 -inf -inf)
                                   (v128.const f64x2 0x1p+0 0x1p+0))
                                   (v128.const f64x2 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f64x2.max" (v128.const f64x2 -inf -inf)
                                   (v128.const f64x2 -0x1p+0 -0x1p+0))
                                   (v128.const f64x2 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f64x2.max" (v128.const f64x2 -inf -inf)
                                   (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                   (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.max" (v128.const f64x2 -inf -inf)
                                   (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                   (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.max" (v128.const f64x2 -inf -inf)
                                   (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                   (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.max" (v128.const f64x2 -inf -inf)
                                   (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                   (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.max" (v128.const f64x2 -inf -inf)
                                   (v128.const f64x2 inf inf))
                                   (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.max" (v128.const f64x2 -inf -inf)
                                   (v128.const f64x2 -inf -inf))
                                   (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.max" (v128.const f64x2 nan nan)
                                   (v128.const f64x2 0x0p+0 0x0p+0))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.max" (v128.const f64x2 nan nan)
                                   (v128.const f64x2 -0x0p+0 -0x0p+0))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.max" (v128.const f64x2 nan nan)
                                   (v128.const f64x2 0x1p-1074 0x1p-1074))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.max" (v128.const f64x2 nan nan)
                                   (v128.const f64x2 -0x1p-1074 -0x1p-1074))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.max" (v128.const f64x2 nan nan)
                                   (v128.const f64x2 0x1p-1022 0x1p-1022))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.max" (v128.const f64x2 nan nan)
                                   (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.max" (v128.const f64x2 nan nan)
                                   (v128.const f64x2 0x1p-1 0x1p-1))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.max" (v128.const f64x2 nan nan)
                                   (v128.const f64x2 -0x1p-1 -0x1p-1))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.max" (v128.const f64x2 nan nan)
                                   (v128.const f64x2 0x1p+0 0x1p+0))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.max" (v128.const f64x2 nan nan)
                                   (v128.const f64x2 -0x1p+0 -0x1p+0))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.max" (v128.const f64x2 nan nan)
                                   (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.max" (v128.const f64x2 nan nan)
                                   (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.max" (v128.const f64x2 nan nan)
                                   (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.max" (v128.const f64x2 nan nan)
                                   (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.max" (v128.const f64x2 nan nan)
                                   (v128.const f64x2 inf inf))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.max" (v128.const f64x2 nan nan)
                                   (v128.const f64x2 -inf -inf))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.max" (v128.const f64x2 nan nan)
                                   (v128.const f64x2 nan nan))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.max" (v128.const f64x2 nan nan)
                                   (v128.const f64x2 -nan -nan))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.max" (v128.const f64x2 nan nan)
                                   (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.max" (v128.const f64x2 nan nan)
                                   (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.max" (v128.const f64x2 -nan -nan)
                                   (v128.const f64x2 0x0p+0 0x0p+0))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.max" (v128.const f64x2 -nan -nan)
                                   (v128.const f64x2 -0x0p+0 -0x0p+0))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.max" (v128.const f64x2 -nan -nan)
                                   (v128.const f64x2 0x1p-1074 0x1p-1074))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.max" (v128.const f64x2 -nan -nan)
                                   (v128.const f64x2 -0x1p-1074 -0x1p-1074))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.max" (v128.const f64x2 -nan -nan)
                                   (v128.const f64x2 0x1p-1022 0x1p-1022))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.max" (v128.const f64x2 -nan -nan)
                                   (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.max" (v128.const f64x2 -nan -nan)
                                   (v128.const f64x2 0x1p-1 0x1p-1))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.max" (v128.const f64x2 -nan -nan)
                                   (v128.const f64x2 -0x1p-1 -0x1p-1))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.max" (v128.const f64x2 -nan -nan)
                                   (v128.const f64x2 0x1p+0 0x1p+0))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.max" (v128.const f64x2 -nan -nan)
                                   (v128.const f64x2 -0x1p+0 -0x1p+0))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.max" (v128.const f64x2 -nan -nan)
                                   (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.max" (v128.const f64x2 -nan -nan)
                                   (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.max" (v128.const f64x2 -nan -nan)
                                   (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.max" (v128.const f64x2 -nan -nan)
                                   (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.max" (v128.const f64x2 -nan -nan)
                                   (v128.const f64x2 inf inf))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.max" (v128.const f64x2 -nan -nan)
                                   (v128.const f64x2 -inf -inf))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.max" (v128.const f64x2 -nan -nan)
                                   (v128.const f64x2 nan nan))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.max" (v128.const f64x2 -nan -nan)
                                   (v128.const f64x2 -nan -nan))
                                   (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.max" (v128.const f64x2 -nan -nan)
                                   (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.max" (v128.const f64x2 -nan -nan)
                                   (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.max" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                   (v128.const f64x2 0x0p+0 0x0p+0))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.max" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                   (v128.const f64x2 -0x0p+0 -0x0p+0))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.max" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                   (v128.const f64x2 0x1p-1074 0x1p-1074))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.max" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                   (v128.const f64x2 -0x1p-1074 -0x1p-1074))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.max" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                   (v128.const f64x2 0x1p-1022 0x1p-1022))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.max" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                   (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.max" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                   (v128.const f64x2 0x1p-1 0x1p-1))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.max" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                   (v128.const f64x2 -0x1p-1 -0x1p-1))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.max" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                   (v128.const f64x2 0x1p+0 0x1p+0))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.max" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                   (v128.const f64x2 -0x1p+0 -0x1p+0))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.max" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                   (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.max" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                   (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.max" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                   (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.max" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                   (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.max" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                   (v128.const f64x2 inf inf))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.max" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                   (v128.const f64x2 -inf -inf))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.max" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                   (v128.const f64x2 nan nan))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.max" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                   (v128.const f64x2 -nan -nan))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.max" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                   (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.max" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                   (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.max" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                   (v128.const f64x2 0x0p+0 0x0p+0))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.max" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                   (v128.const f64x2 -0x0p+0 -0x0p+0))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.max" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                   (v128.const f64x2 0x1p-1074 0x1p-1074))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.max" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                   (v128.const f64x2 -0x1p-1074 -0x1p-1074))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.max" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                   (v128.const f64x2 0x1p-1022 0x1p-1022))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.max" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                   (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.max" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                   (v128.const f64x2 0x1p-1 0x1p-1))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.max" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                   (v128.const f64x2 -0x1p-1 -0x1p-1))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.max" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                   (v128.const f64x2 0x1p+0 0x1p+0))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.max" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                   (v128.const f64x2 -0x1p+0 -0x1p+0))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.max" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                   (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.max" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                   (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.max" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                   (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.max" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                   (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.max" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                   (v128.const f64x2 inf inf))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.max" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                   (v128.const f64x2 -inf -inf))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.max" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                   (v128.const f64x2 nan nan))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.max" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                   (v128.const f64x2 -nan -nan))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.max" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                   (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.max" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                   (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                   (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.max" (v128.const f64x2 01234567890123456789e038 01234567890123456789e038)
                                   (v128.const f64x2 01234567890123456789e038 01234567890123456789e038))
                                   (v128.const f64x2 01234567890123456789e038 01234567890123456789e038))
(assert_return (invoke "f64x2.max" (v128.const f64x2 01234567890123456789e038 01234567890123456789e038)
                                   (v128.const f64x2 01234567890123456789e-038 01234567890123456789e-038))
                                   (v128.const f64x2 01234567890123456789e038 01234567890123456789e038))
(assert_return (invoke "f64x2.max" (v128.const f64x2 01234567890123456789e038 01234567890123456789e038)
                                   (v128.const f64x2 0123456789.e038 0123456789.e038))
                                   (v128.const f64x2 01234567890123456789e038 01234567890123456789e038))
(assert_return (invoke "f64x2.max" (v128.const f64x2 01234567890123456789e038 01234567890123456789e038)
                                   (v128.const f64x2 0123456789.e+038 0123456789.e+038))
                                   (v128.const f64x2 01234567890123456789e038 01234567890123456789e038))
(assert_return (invoke "f64x2.max" (v128.const f64x2 01234567890123456789e038 01234567890123456789e038)
                                   (v128.const f64x2 -01234567890123456789.01234567890123456789 -01234567890123456789.01234567890123456789))
                                   (v128.const f64x2 01234567890123456789e038 01234567890123456789e038))
(assert_return (invoke "f64x2.max" (v128.const f64x2 01234567890123456789e-038 01234567890123456789e-038)
                                   (v128.const f64x2 01234567890123456789e038 01234567890123456789e038))
                                   (v128.const f64x2 01234567890123456789e038 01234567890123456789e038))
(assert_return (invoke "f64x2.max" (v128.const f64x2 01234567890123456789e-038 01234567890123456789e-038)
                                   (v128.const f64x2 01234567890123456789e-038 01234567890123456789e-038))
                                   (v128.const f64x2 01234567890123456789e-038 01234567890123456789e-038))
(assert_return (invoke "f64x2.max" (v128.const f64x2 01234567890123456789e-038 01234567890123456789e-038)
                                   (v128.const f64x2 0123456789.e038 0123456789.e038))
                                   (v128.const f64x2 0123456789.e038 0123456789.e038))
(assert_return (invoke "f64x2.max" (v128.const f64x2 01234567890123456789e-038 01234567890123456789e-038)
                                   (v128.const f64x2 0123456789.e+038 0123456789.e+038))
                                   (v128.const f64x2 0123456789.e+038 0123456789.e+038))
(assert_return (invoke "f64x2.max" (v128.const f64x2 01234567890123456789e-038 01234567890123456789e-038)
                                   (v128.const f64x2 -01234567890123456789.01234567890123456789 -01234567890123456789.01234567890123456789))
                                   (v128.const f64x2 01234567890123456789e-038 01234567890123456789e-038))
(assert_return (invoke "f64x2.max" (v128.const f64x2 0123456789.e038 0123456789.e038)
                                   (v128.const f64x2 01234567890123456789e038 01234567890123456789e038))
                                   (v128.const f64x2 01234567890123456789e038 01234567890123456789e038))
(assert_return (invoke "f64x2.max" (v128.const f64x2 0123456789.e038 0123456789.e038)
                                   (v128.const f64x2 01234567890123456789e-038 01234567890123456789e-038))
                                   (v128.const f64x2 0123456789.e038 0123456789.e038))
(assert_return (invoke "f64x2.max" (v128.const f64x2 0123456789.e038 0123456789.e038)
                                   (v128.const f64x2 0123456789.e038 0123456789.e038))
                                   (v128.const f64x2 0123456789.e038 0123456789.e038))
(assert_return (invoke "f64x2.max" (v128.const f64x2 0123456789.e038 0123456789.e038)
                                   (v128.const f64x2 0123456789.e+038 0123456789.e+038))
                                   (v128.const f64x2 0123456789.e+038 0123456789.e+038))
(assert_return (invoke "f64x2.max" (v128.const f64x2 0123456789.e038 0123456789.e038)
                                   (v128.const f64x2 -01234567890123456789.01234567890123456789 -01234567890123456789.01234567890123456789))
                                   (v128.const f64x2 0123456789.e038 0123456789.e038))
(assert_return (invoke "f64x2.max" (v128.const f64x2 0123456789.e+038 0123456789.e+038)
                                   (v128.const f64x2 01234567890123456789e038 01234567890123456789e038))
                                   (v128.const f64x2 01234567890123456789e038 01234567890123456789e038))
(assert_return (invoke "f64x2.max" (v128.const f64x2 0123456789.e+038 0123456789.e+038)
                                   (v128.const f64x2 01234567890123456789e-038 01234567890123456789e-038))
                                   (v128.const f64x2 0123456789.e+038 0123456789.e+038))
(assert_return (invoke "f64x2.max" (v128.const f64x2 0123456789.e+038 0123456789.e+038)
                                   (v128.const f64x2 0123456789.e038 0123456789.e038))
                                   (v128.const f64x2 0123456789.e038 0123456789.e038))
(assert_return (invoke "f64x2.max" (v128.const f64x2 0123456789.e+038 0123456789.e+038)
                                   (v128.const f64x2 0123456789.e+038 0123456789.e+038))
                                   (v128.const f64x2 0123456789.e+038 0123456789.e+038))
(assert_return (invoke "f64x2.max" (v128.const f64x2 0123456789.e+038 0123456789.e+038)
                                   (v128.const f64x2 -01234567890123456789.01234567890123456789 -01234567890123456789.01234567890123456789))
                                   (v128.const f64x2 0123456789.e+038 0123456789.e+038))
(assert_return (invoke "f64x2.max" (v128.const f64x2 -01234567890123456789.01234567890123456789 -01234567890123456789.01234567890123456789)
                                   (v128.const f64x2 01234567890123456789e038 01234567890123456789e038))
                                   (v128.const f64x2 01234567890123456789e038 01234567890123456789e038))
(assert_return (invoke "f64x2.max" (v128.const f64x2 -01234567890123456789.01234567890123456789 -01234567890123456789.01234567890123456789)
                                   (v128.const f64x2 01234567890123456789e-038 01234567890123456789e-038))
                                   (v128.const f64x2 01234567890123456789e-038 01234567890123456789e-038))
(assert_return (invoke "f64x2.max" (v128.const f64x2 -01234567890123456789.01234567890123456789 -01234567890123456789.01234567890123456789)
                                   (v128.const f64x2 0123456789.e038 0123456789.e038))
                                   (v128.const f64x2 0123456789.e038 0123456789.e038))
(assert_return (invoke "f64x2.max" (v128.const f64x2 -01234567890123456789.01234567890123456789 -01234567890123456789.01234567890123456789)
                                   (v128.const f64x2 0123456789.e+038 0123456789.e+038))
                                   (v128.const f64x2 0123456789.e+038 0123456789.e+038))
(assert_return (invoke "f64x2.max" (v128.const f64x2 -01234567890123456789.01234567890123456789 -01234567890123456789.01234567890123456789)
                                   (v128.const f64x2 -01234567890123456789.01234567890123456789 -01234567890123456789.01234567890123456789))
                                   (v128.const f64x2 -01234567890123456789.01234567890123456789 -01234567890123456789.01234567890123456789))

;; Test opposite signs of zero
(assert_return (invoke "f64x2.min" (v128.const f64x2 0 0)
                                   (v128.const f64x2 +0 -0))
                                   (v128.const f64x2 0 -0))
(assert_return (invoke "f64x2.min" (v128.const f64x2 -0 +0)
                                   (v128.const f64x2 +0 -0))
                                   (v128.const f64x2 -0 -0))
(assert_return (invoke "f64x2.min" (v128.const f64x2 -0 -0)
                                   (v128.const f64x2 +0 +0))
                                   (v128.const f64x2 -0 -0))
(assert_return (invoke "f64x2.max" (v128.const f64x2 0 0)
                                   (v128.const f64x2 +0 -0))
                                   (v128.const f64x2 0 0))
(assert_return (invoke "f64x2.max" (v128.const f64x2 -0 +0)
                                   (v128.const f64x2 +0 -0))
                                   (v128.const f64x2 0 0))
(assert_return (invoke "f64x2.max" (v128.const f64x2 -0 -0)
                                   (v128.const f64x2 +0 +0))
                                   (v128.const f64x2 +0 +0))


(assert_return (invoke "f64x2.abs" (v128.const f64x2 0x0p+0 0x0p+0))
                                   (v128.const f64x2 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f64x2.abs" (v128.const f64x2 -0x0p+0 -0x0p+0))
                                   (v128.const f64x2 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f64x2.abs" (v128.const f64x2 0x1p-1074 0x1p-1074))
                                   (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.abs" (v128.const f64x2 -0x1p-1074 -0x1p-1074))
                                   (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.abs" (v128.const f64x2 0x1p-1022 0x1p-1022))
                                   (v128.const f64x2 0x1.0000000000000p-1022 0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.abs" (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                   (v128.const f64x2 0x1.0000000000000p-1022 0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.abs" (v128.const f64x2 0x1p-1 0x1p-1))
                                   (v128.const f64x2 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f64x2.abs" (v128.const f64x2 -0x1p-1 -0x1p-1))
                                   (v128.const f64x2 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f64x2.abs" (v128.const f64x2 0x1p+0 0x1p+0))
                                   (v128.const f64x2 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f64x2.abs" (v128.const f64x2 -0x1p+0 -0x1p+0))
                                   (v128.const f64x2 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f64x2.abs" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                   (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.abs" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                   (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.abs" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                   (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.abs" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                   (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.abs" (v128.const f64x2 inf inf))
                                   (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.abs" (v128.const f64x2 -inf -inf))
                                   (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.abs" (v128.const f64x2 01234567890123456789e038 01234567890123456789e038))
                                   (v128.const f64x2 01234567890123456789e038 01234567890123456789e038))
(assert_return (invoke "f64x2.abs" (v128.const f64x2 01234567890123456789e-038 01234567890123456789e-038))
                                   (v128.const f64x2 01234567890123456789e-038 01234567890123456789e-038))
(assert_return (invoke "f64x2.abs" (v128.const f64x2 0123456789.e038 0123456789.e038))
                                   (v128.const f64x2 0123456789.e038 0123456789.e038))
(assert_return (invoke "f64x2.abs" (v128.const f64x2 0123456789.e+038 0123456789.e+038))
                                   (v128.const f64x2 0123456789.e+038 0123456789.e+038))
(assert_return (invoke "f64x2.abs" (v128.const f64x2 -01234567890123456789.01234567890123456789 -01234567890123456789.01234567890123456789))
                                   (v128.const f64x2 01234567890123456789.01234567890123456789 01234567890123456789.01234567890123456789))

;; type check
(assert_invalid (module (func (result v128) (f64x2.abs (i32.const 0)))) "type mismatch")
(assert_invalid (module (func (result v128) (f64x2.min (i32.const 0) (f32.const 0.0)))) "type mismatch")
(assert_invalid (module (func (result v128) (f64x2.max (i32.const 0) (f32.const 0.0)))) "type mismatch")

;; Test operation with empty argument

(assert_invalid
  (module
    (func $f64x2.abs-arg-empty (result v128)
      (f64x2.abs)
    )
  )
  "type mismatch"
)
(assert_invalid
  (module
    (func $f64x2.min-1st-arg-empty (result v128)
      (f64x2.min (v128.const f64x2 0 0))
    )
  )
  "type mismatch"
)
(assert_invalid
  (module
    (func $f64x2.min-arg-empty (result v128)
      (f64x2.min)
    )
  )
  "type mismatch"
)
(assert_invalid
  (module
    (func $f64x2.max-1st-arg-empty (result v128)
      (f64x2.max (v128.const f64x2 0 0))
    )
  )
  "type mismatch"
)
(assert_invalid
  (module
    (func $f64x2.max-arg-empty (result v128)
      (f64x2.max)
    )
  )
  "type mismatch"
)

;; combination
(module
  (func (export "max-min") (param v128 v128 v128) (result v128)
    (f64x2.max (f64x2.min (local.get 0) (local.get 1))(local.get 2)))
  (func (export "min-max") (param v128 v128 v128) (result v128)
    (f64x2.min (f64x2.max (local.get 0) (local.get 1))(local.get 2)))
  (func (export "max-abs") (param v128 v128) (result v128)
    (f64x2.max (f64x2.abs (local.get 0)) (local.get 1)))
  (func (export "min-abs") (param v128 v128) (result v128)
    (f64x2.min (f64x2.abs (local.get 0)) (local.get 1)))
)

(assert_return (invoke "max-min" (v128.const f64x2 1.125 1.125)
                                 (v128.const f64x2 0.25 0.25)
                                 (v128.const f64x2 0.125 0.125))
                                 (v128.const f64x2 0.25 0.25))
(assert_return (invoke "min-max" (v128.const f64x2 1.125 1.125)
                                 (v128.const f64x2 0.25 0.25)
                                 (v128.const f64x2 0.125 0.125))
                                 (v128.const f64x2 0.125 0.125))
(assert_return (invoke "max-abs" (v128.const f64x2 -1.125 -1.125)
                                 (v128.const f64x2 0.125 0.125))
                                 (v128.const f64x2 1.125 1.125))
(assert_return (invoke "min-abs" (v128.const f64x2 -1.125 -1.125)
                                 (v128.const f64x2 0.125 0.125))
                                 (v128.const f64x2 0.125 0.125))