/*
 * Decompiled with CFR 0.152.
 */
package com.dsi.ant.plugins.antplus.pcc;

import android.app.Activity;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Message;
import com.dsi.ant.plugins.antplus.pcc.defines.EventFlag;
import com.dsi.ant.plugins.antplus.pccbase.AntPluginPcc;
import com.dsi.ant.plugins.antplus.pccbase.AntPlusBikeSpdCadCommonPcc;
import com.dsi.ant.plugins.antplus.pccbase.PccReleaseHandle;
import com.dsi.ant.plugins.utility.log.LogAnt;
import java.math.BigDecimal;
import java.util.EnumSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AntPlusBikeCadencePcc
extends AntPlusBikeSpdCadCommonPcc {
    private static final String TAG = AntPlusBikeCadencePcc.class.getSimpleName();
    ICalculatedCadenceReceiver mCalculatedCadenceReceiver;
    IRawCadenceDataReceiver mRawCadenceDataReceiver;
    IMotionAndCadenceDataReceiver mMotionAndCadenceDataReceiver;

    public static PccReleaseHandle<AntPlusBikeCadencePcc> requestAccess(Activity userActivity, Context bindToContext, boolean skipPreferredSearch, int searchProximityThreshold, AntPluginPcc.IPluginAccessResultReceiver<AntPlusBikeCadencePcc> resultReceiver, AntPluginPcc.IDeviceStateChangeReceiver stateReceiver) {
        AntPlusBikeCadencePcc potentialRetObj = new AntPlusBikeCadencePcc();
        return AntPlusBikeCadencePcc.requestAccessBSC_helper(true, userActivity, bindToContext, skipPreferredSearch, searchProximityThreshold, resultReceiver, stateReceiver, potentialRetObj);
    }

    public static PccReleaseHandle<AntPlusBikeCadencePcc> requestAccess(Activity userActivity, Context bindToContext, AntPluginPcc.IPluginAccessResultReceiver<AntPlusBikeCadencePcc> resultReceiver, AntPluginPcc.IDeviceStateChangeReceiver stateReceiver) {
        return AntPlusBikeCadencePcc.requestAccess(userActivity, bindToContext, false, -1, resultReceiver, stateReceiver);
    }

    public static PccReleaseHandle<AntPlusBikeCadencePcc> requestAccess(Context bindToContext, int antDeviceNumber, int searchProximityThreshold, boolean isSpdCadCombinedSensor, AntPluginPcc.IPluginAccessResultReceiver<AntPlusBikeCadencePcc> resultReceiver, AntPluginPcc.IDeviceStateChangeReceiver stateReceiver) {
        AntPlusBikeCadencePcc potentialRetObj = new AntPlusBikeCadencePcc();
        return AntPlusBikeCadencePcc.requestAccessBSC_helper(true, bindToContext, antDeviceNumber, searchProximityThreshold, isSpdCadCombinedSensor, resultReceiver, stateReceiver, potentialRetObj);
    }

    public static AntPlusBikeSpdCadCommonPcc.BikeSpdCadAsyncScanController<AntPlusBikeCadencePcc> requestAsyncScanController(Context bindToContext, int searchProximityThreshold, AntPlusBikeSpdCadCommonPcc.IBikeSpdCadAsyncScanResultReceiver scanResultReceiver) {
        AntPlusBikeCadencePcc potentialRetObj = new AntPlusBikeCadencePcc();
        return AntPlusBikeCadencePcc.requestAccessBSC_Helper_AsyncScanController(true, bindToContext, searchProximityThreshold, potentialRetObj, scanResultReceiver);
    }

    private AntPlusBikeCadencePcc() {
        super(true);
    }

    @Override
    protected Intent getServiceBindIntent() {
        Intent it = new Intent();
        it.setComponent(new ComponentName("com.dsi.ant.plugins.antplus", "com.dsi.ant.plugins.antplus.bikespdcad.CombinedBikeSpdCadService"));
        return it;
    }

    @Override
    protected String getPluginPrintableName() {
        return "ANT+ Plugin: Bike Cadence";
    }

    @Override
    protected void handlePluginEvent(Message eventMsg) {
        switch (eventMsg.arg1) {
            case 301: {
                if (this.mCalculatedCadenceReceiver == null) break;
                Bundle b = eventMsg.getData();
                long estTimestamp = b.getLong("long_EstTimestamp");
                EnumSet<EventFlag> eventFlags = EventFlag.getEventFlagsFromLong(b.getLong("long_EventFlags"));
                BigDecimal calculatedCadence = (BigDecimal)b.getSerializable("decimal_calculatedCadence");
                this.mCalculatedCadenceReceiver.onNewCalculatedCadence(estTimestamp, eventFlags, calculatedCadence);
                break;
            }
            case 302: {
                if (this.mRawCadenceDataReceiver == null) break;
                Bundle b = eventMsg.getData();
                long estTimestamp = b.getLong("long_EstTimestamp");
                EnumSet<EventFlag> eventFlags = EventFlag.getEventFlagsFromLong(b.getLong("long_EventFlags"));
                BigDecimal timestampOfLastEvent = (BigDecimal)b.getSerializable("decimal_timestampOfLastEvent");
                long cumulativeRevolutions = b.getLong("long_cumulativeRevolutions");
                this.mRawCadenceDataReceiver.onNewRawCadenceData(estTimestamp, eventFlags, timestampOfLastEvent, cumulativeRevolutions);
                break;
            }
            case 303: {
                if (this.mMotionAndCadenceDataReceiver == null) break;
                Bundle b = eventMsg.getData();
                long estTimestamp = b.getLong("long_EstTimestamp");
                EnumSet<EventFlag> eventFlags = EventFlag.getEventFlagsFromLong(b.getLong("long_EventFlags"));
                boolean isStopped = b.getBoolean("bool_isStopped");
                this.mMotionAndCadenceDataReceiver.onNewMotionAndCadenceData(estTimestamp, eventFlags, isStopped);
            }
            default: {
                super.handlePluginEvent(eventMsg);
            }
        }
    }

    public void subscribeCalculatedCadenceEvent(ICalculatedCadenceReceiver CalculatedCadenceReceiver) {
        this.mCalculatedCadenceReceiver = CalculatedCadenceReceiver;
        if (CalculatedCadenceReceiver != null) {
            this.subscribeToEvent(301);
        } else {
            this.unsubscribeFromEvent(301);
        }
    }

    public void subscribeRawCadenceDataEvent(IRawCadenceDataReceiver RawCadenceDataReceiver) {
        this.mRawCadenceDataReceiver = RawCadenceDataReceiver;
        if (RawCadenceDataReceiver != null) {
            this.subscribeToEvent(302);
        } else {
            this.unsubscribeFromEvent(302);
        }
    }

    public boolean subscribeMotionAndCadenceDataEvent(IMotionAndCadenceDataReceiver motionAndCadenceDataReceiver) {
        if (this.reportedServiceVersion < 20208) {
            LogAnt.w(TAG, "subscribeMotionAndCadenceDataEvent requires ANT+ Plugins Service >20208, installed: " + this.reportedServiceVersion);
            return false;
        }
        this.mMotionAndCadenceDataReceiver = motionAndCadenceDataReceiver;
        if (motionAndCadenceDataReceiver != null) {
            return this.subscribeToEvent(303);
        }
        this.unsubscribeFromEvent(303);
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface IMotionAndCadenceDataReceiver {
        public void onNewMotionAndCadenceData(long var1, EnumSet<EventFlag> var3, boolean var4);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface IRawCadenceDataReceiver {
        public void onNewRawCadenceData(long var1, EnumSet<EventFlag> var3, BigDecimal var4, long var5);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface ICalculatedCadenceReceiver {
        public void onNewCalculatedCadence(long var1, EnumSet<EventFlag> var3, BigDecimal var4);
    }

    public class IpcDefines {
        public static final int MSG_EVENT_BIKECADENCE_whatCALCULATEDCADENCE = 301;
        public static final String MSG_EVENT_BIKECADENCE_CALCULATEDCADENCE_PARAM_decimalCALCULATEDCADENCE = "decimal_calculatedCadence";
        public static final int MSG_EVENT_BIKECADENCE_whatRAWCADENCEDATA = 302;
        public static final String MSG_EVENT_BIKECADENCE_RAWCADENCEDATA_PARAM_decimalTIMESTAMPOFLASTEVENT = "decimal_timestampOfLastEvent";
        public static final String MSG_EVENT_BIKECADENCE_RAWCADENCEDATA_PARAM_longCUMULATIVEREVOLUTIONS = "long_cumulativeRevolutions";
        public static final int MSG_EVENT_BIKECADENCE_whatMOTIONANDCADENCEDATA = 303;
        public static final String MSG_EVENT_BIKECADENCE_MOTIONANDCADENCEDATA_PARAM_boolISSTOPPED = "bool_isStopped";
    }
}

