# gozerbot/xmpp/wait.py
#
#

""" wait for ircevent based on ircevent.CMND """

__copyright__ = 'this file is in the public domain'

# gozerbot imports
from gozerbot.utils.log import rlog
from gozerbot.utils.locking import lockdec
import gozerbot.threads.thr as thr

# xmpp imports
from gozerbot.wait import Wait

# basic imports
import time, thread

# locks
waitlock = thread.allocate_lock()
locked = lockdec(waitlock)

class XMPPWait(Wait):

    """ wait object for jabber messages. """

    def register(self, catch, queue, timeout=15):

        """ register wait for privmsg. """

        rlog(1, 'xmpp-wait', 'registering for %s' % catch)
        self.ticket += 1
        self.waitlist.append((catch, queue, self.ticket))
        if timeout:
            thr.start_new_thread(self.dotimeout, (timeout, self.ticket))
        return self.ticket

    def check(self, msg):

        """ check if <msg> is waited for. """

        for teller in range(len(self.waitlist)-1, -1, -1):
            i = self.waitlist[teller]
            if i[0] == msg.userhost:
                msg.ticket = i[2]
                i[1].put_nowait(msg)
                self.delete(msg.ticket)
                rlog(10, 'xmpp-wait', 'got response for %s' % i[0])
                msg.isresponse = 1

    @locked
    def delete(self, ticket):

        """ delete wait item with ticket nr. """

        for itemnr in range(len(self.waitlist)-1, -1, -1):
            item = self.waitlist[itemnr]
            if item[2] == ticket:
                item[1].put_nowait(None)
                try:
                    del self.waitlist[itemnr]
                    rlog(1, 'xmpp-wait', 'deleted ' + str(ticket))
                except IndexError:
                    pass
                return 1

class XMPPErrorWait(XMPPWait):

    """ wait for jabber errors. """

    def check(self, msg):

        """ check if <msg> is waited for. """

        if not msg.type == 'error':
            return

        errorcode = msg.error

        for teller in range(len(self.waitlist)-1, -1, -1):
            i = self.waitlist[teller]
            if i[0] == 'ALL' or i[0] == errorcode:
                msg.error = msg.error
                msg.ticket = i[2]
                i[1].put_nowait(msg)
                self.delete(msg.ticket)
                rlog(10,'xmpp-errorwait','got error response for %s' % i[0])
