list      p=12F683        ; list directive to define processor
	#include <p12F683.inc>    ; processor specific variable definitions

	errorlevel  -302          ; suppress message 302 from list file

	__CONFIG   _FCMEN_ON & _IESO_OFF & _CP_OFF & _CPD_OFF & _BOD_OFF & _MCLRE_ON & _WDT_OFF & _PWRTE_ON & _INTRC_OSC_NOCLKOUT 	
	cblock 0x20
		KeyBuffer:4
		Keys
		Previous
		codevalue
		d1
		d2
	endc
	        org   	0x0000      	; org sets the origin, 0x0000
                goto    main   		; go to beginning of program 
		org	  	0x0004			;interrupt vector
		goto 	main
	
main
		movlw   07h            		; Set GPIO <2:0) to
                movwf   CMCON0          	; digital I/O
		movlw	b'001111'
		banksel	TRISIO
		movwf	TRISIO
		clrf   	ANSEL           	; digital I/0
		banksel	GPIO
		clrf	GPIO	  
		clrf	Previous
GetLoop		movlw	KeyBuffer
		movwf	FSR
		movlw	b'1001'
		movwf	codevalue
		call   	KeyLoop

		movfw	KeyBuffer	;test the first key press
		xorlw	b'0001'		;was it key 1	
		btfss	STATUS,Z	;yes so skip
		goto	GetLoop		;no so go back and get new keys

		movfw	KeyBuffer+1	;test the second key press
		xorlw	b'0010'		;2
		btfss	STATUS,Z
		goto	GetLoop

		movfw	KeyBuffer+2	;test the third key press
		xorlw	b'0100'		;3
		btfss	STATUS,Z
		goto	GetLoop

		movfw	KeyBuffer+3	;test the fourth key press
		xorlw	b'0001'		;1
		btfss	STATUS,Z
		goto	GetLoop

;if it get's to here then keys 1,2,3,1 were pressed.

	;turn on LED here
LedOn	
		banksel	GPIO
		bsf	    GPIO,GP5	;turn on a led and hang out here
		goto	LedOn

                goto 	GetLoop

KeyLoop		
		call	Delay10mS	;debounce delay
		movfw	Keys		;keep copy of previous keys
		movwf	Previous
		movfw	GPIO		;get key state
		xorlw	0xff		;1 = key pressed
		andlw	0x0f		;keep only 0-3 bits  <-added
		movwf	Keys		;save for later
		xorwf	Previous,W	;find keys that have changed
		andwf	Keys,W		;and are currently pressed
		btfsc	STATUS,Z	
		goto	KeyLoop
		movwf	INDF		;store the key
		incf	FSR,f		;move pointer forward
		movfw	FSR		    ;see if we have 4 keys yet
		xorlw	KeyBuffer+4
		btfss	STATUS,Z
		goto	KeyLoop
;here KeyBuffer will contain 4 key values.
		return		 



Delay10mS		        	;9998 cycles
		movlw	0xCF
		movwf	d1
		movlw	0x08
		movwf	d2
Delay_0
		decfsz	d1, f
		goto	$+2
		decfsz	d2, f
		goto	Delay_0

			;2 cycles
		goto	$+1
		return
 end
