#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>
#include <gconf/gconf-client.h>

#include "callbacks.h"
#include "interface.h"
#include "support.h"
#include "main.h"


void
on_file_new_type_menu_activate (GtkMenuItem * menuitem, gpointer user_data)
{
	rcm_show_ConnectionTypesWindow();
}


void
on_edit_delete_menu_activate (GtkMenuItem * menuitem, gpointer user_data)
{
	GnomeIconList *icon_list;
	gint i;
	GList *l;
	gchar *name;
	Connection *connection;
	GtkWidget *yes_no_dialog;
	int ret;
	gchar buff[MAX_BUFFER_LENGTH];

	icon_list = GNOME_ICON_LIST (lookup_widget (MainWindow, "MainList"));
	g_return_if_fail (icon_list != NULL);
	l = gnome_icon_list_get_selection (icon_list);

	if (l)
	{
		i = GPOINTER_TO_INT (l->data);
		connection = g_slist_nth_data (ConnectionsSList, i);
		g_return_if_fail (connection != NULL);
		snprintf (buff, MAX_BUFFER_LENGTH,
			  _("Are you sure you want to delete %s?"),
			  connection->Name);
		yes_no_dialog =
			gnome_message_box_new (buff,
					       GNOME_MESSAGE_BOX_QUESTION,
					       GNOME_STOCK_BUTTON_YES,
					       GNOME_STOCK_BUTTON_NO, NULL);
		ret = gnome_dialog_run (GNOME_DIALOG (yes_no_dialog));

		if (ret == 1)
			return;
		connection =
			rcm_remove_connection_from_list_by_name (connection->
								 Name,
								 ConnectionsSList);
		if (connection)
			free (connection);
		rcm_update_main_window ();	// causing assertion
		rcm_save_connections_to_disk ();
	}
}

void
on_help_help_menu_activate (GtkMenuItem * menuitem, gpointer user_data)
{
	GtkWidget *dialog = create_AboutWindow ();
	gnome_dialog_run_and_close (GNOME_DIALOG (dialog));
}


void
on_about_activate (GtkMenuItem * menuitem, gpointer user_data)
{
	GtkWidget *AboutWindow = create_AboutWindow ();
	//gtk_window_set_transient_for (GTK_WINDOW (AboutWindow),
	//			      GTK_WINDOW (MainWindow));
	//gtk_window_set_modal (GTK_WINDOW (AboutWindow), TRUE);
	gtk_dialog_run (GTK_DIALOG (AboutWindow));
	//gtk_widget_destroy(AboutWindow);
}


void
on_TbTypesBtn_clicked (GtkButton * button, gpointer user_data)
{
	rcm_show_ConnectionTypesWindow();
}


void
on_TbConnectionBtn_clicked (GtkButton * button, gpointer user_data)
{
	rcm_show_ConnectionsWindow();
}


gboolean
on_ConnectionsWindow_delete_event (GtkWidget * widget,
				   GdkEvent * event, gpointer user_data)
{
	GtkWidget *yes_no_dialog;
	gint ret;
	gint width, height;
	GConfClient *gconf_client = NULL;

	gconf_client = gconf_client_get_default ();
	gtk_window_get_size (GTK_WINDOW (ConnectionsWindow), &width, &height);
	gconf_client_set_int (gconf_client, GCONF_CONNECTIONS_WINDOW_WIDTH,
			      width, NULL);
	gconf_client_set_int (gconf_client, GCONF_CONNECTIONS_WINDOW_HEIGHT,
			      height, NULL);
	gconf_client_suggest_sync (gconf_client, NULL);
	g_object_unref (gconf_client);

	if (ConnectionsSListIsDirty)
	{
		yes_no_dialog =
			gnome_message_box_new
			(_("Do you want to save your changes?"),
			 GNOME_MESSAGE_BOX_QUESTION,
			 GNOME_STOCK_BUTTON_YES, GNOME_STOCK_BUTTON_NO, NULL);
		ret = gnome_dialog_run (GNOME_DIALOG (yes_no_dialog));
		switch (ret)
		{
		case 0:
		{
			if (!rcm_save_connections_to_disk ())
				rcm_error
					(_("There was a problem saving."),
					 ConnectionsWindow);
			gtk_widget_hide (ConnectionsWindow);
			return;
		}
		case 1:
		{
			if (!rcm_load_connections_from_disk ())
				rcm_error
					(_("A serious error has occured."),
					 ConnectionsWindow);
			rcm_update_connections_window_list ();
			gtk_widget_hide (GTK_WIDGET (ConnectionsWindow));
			return;
		}
		}
	}
	rcm_update_main_window ();
	gtk_widget_hide (GTK_WIDGET (ConnectionsWindow));
	return TRUE;
}

gboolean
on_ConnectionTypesWindow_delete_event (GtkWidget * widget,
				       GdkEvent * event, gpointer user_data)
{
	GtkWidget *yes_no_dialog;
	gint ret;
	gint width, height;
	GConfClient *gconf_client = NULL;

	gconf_client = gconf_client_get_default ();
	gtk_window_get_size (GTK_WINDOW (ConnectionTypesWindow), &width,
			     &height);
	gconf_client_set_int (gconf_client,
			      GCONF_CONNECTION_TYPES_WINDOW_WIDTH, width,
			      NULL);
	gconf_client_set_int (gconf_client,
			      GCONF_CONNECTION_TYPES_WINDOW_HEIGHT, height,
			      NULL);
	gconf_client_suggest_sync (gconf_client, NULL);
	g_object_unref (gconf_client);

	if (ConnectionTypesSListIsDirty)
	{
		yes_no_dialog =
			gnome_message_box_new
			(_("Do you want to save your changes?"),
			 GNOME_MESSAGE_BOX_QUESTION,
			 GNOME_STOCK_BUTTON_YES, GNOME_STOCK_BUTTON_NO, NULL);
		ret = gnome_dialog_run (GNOME_DIALOG (yes_no_dialog));
		switch (ret)
		{
		case 0:
		{
			if (!rcm_save_types_to_disk ())
				rcm_error
					(_("There was a problem saving."),
					 ConnectionTypesWindow);
			gtk_widget_hide (ConnectionTypesWindow);
			return;
		}
		case 1:
		{
			if (!rcm_load_types_from_disk ())
				rcm_error
					(_("A serious error has occured."),
					 ConnectionTypesWindow);
			rcm_update_connectiontypes_window_list ();
			gtk_widget_hide (ConnectionTypesWindow);
			return;
		}
		}
	}
	rcm_update_main_window ();
	gtk_widget_hide (GTK_WIDGET (ConnectionTypesWindow));
	return TRUE;
}

void
on_ConnectionTypesClearBtn_clicked (GtkButton * button, gpointer user_data)
{
	rcm_clear_types_window ();
}


void
on_ConnectionTypesSaveBtn_clicked (GtkButton * button, gpointer user_data)
{
	GtkWidget *widget = NULL;
	gchar *name = NULL;
	gchar *command = NULL;
	gchar* arguments = NULL;
	gboolean terminal = FALSE;
	gchar *icon = NULL;
	ConnectionType type;

	widget = NULL;
	widget = lookup_widget (ConnectionTypesWindow,
				"ConnectionTypesNameEntry");
	g_return_if_fail (widget != NULL);
	name = gtk_editable_get_chars (GTK_EDITABLE (widget), 0, -1);
	if (strnlen (name,NAMELEN) == 0)
	{
		g_free (name);
		rcm_warn (_("Conenction Type name is not set."),
			  ConnectionTypesWindow);
		return;
	}
	strncpy (type.Name, name, NAMELEN);
	// need this below g_free (name);

	widget = NULL;
	widget = lookup_widget (ConnectionTypesWindow,
				"ConnectionTypesCommandEntry");
	g_return_if_fail (widget != NULL);
	command = gtk_editable_get_chars (GTK_EDITABLE (widget), 0, -1);
	if (strnlen (command,COMMANDLEN) == 0)
	{
		g_free (command);
		rcm_warn (_("Conenction Type command is not set."),
			  ConnectionTypesWindow);
		return;
	}
	strncpy (type.Command, command, COMMANDLEN);
	g_free (command);

	widget = NULL;
	widget = lookup_widget (ConnectionTypesWindow,
				"ConnectionTypesArgumentsEntry");
	g_return_if_fail (widget != NULL);
	arguments = gtk_editable_get_chars (GTK_EDITABLE (widget), 0, -1);
	if (strnlen (arguments,ARGUMENTSLEN) == 0)
		strncpy (type.Arguments, "", ARGUMENTSLEN);	
	else
		strncpy (type.Arguments, arguments, ARGUMENTSLEN);
	g_free (arguments);
	
	widget = NULL;
	widget = lookup_widget (ConnectionTypesWindow,
				"ConnectionTypesTerminalChkBox");
	g_return_if_fail (widget != NULL);
	type.Terminal =
		gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (widget));

	widget = NULL;
	widget = lookup_widget (ConnectionTypesWindow,
				"ConnectionTypesIconEntry");
	g_return_if_fail (widget != NULL);
	icon = gnome_icon_entry_get_filename (GNOME_ICON_ENTRY (widget));
	if (icon == NULL)
	{
		type.Icon[0] = '\0';
	}
	else
	{
		strncpy (type.Icon, icon, ICONLEN);
		g_free (icon);
	}

	rcm_save_type (type);
	rcm_update_connectiontypes_window_list ();
	rcm_select_type_by_name (name);
	rcm_clear_types_window ();
	rcm_update_main_window();
	g_free (name);
}


void
on_ConnectionTypesOkBtn_clicked (GtkButton * button, gpointer user_data)
{
	gint width, height;
	GConfClient *gconf_client = NULL;

	gconf_client = gconf_client_get_default ();
	gtk_window_get_size (GTK_WINDOW (ConnectionTypesWindow), &width,
			     &height);
	gconf_client_set_int (gconf_client,
			      GCONF_CONNECTION_TYPES_WINDOW_WIDTH, width,
			      NULL);
	gconf_client_set_int (gconf_client,
			      GCONF_CONNECTION_TYPES_WINDOW_HEIGHT, height,
			      NULL);
	gconf_client_suggest_sync (gconf_client, NULL);
	g_object_unref (gconf_client);
	if (!rcm_save_types_to_disk ())
		rcm_error (_("There was a problem saving."),
			   ConnectionTypesWindow);
	rcm_update_main_window ();
	gtk_widget_hide (ConnectionTypesWindow);
}


void
on_ConnectionTypesCancelBtn_clicked (GtkButton * button, gpointer user_data)
{
	gint width, height;
	GConfClient *gconf_client = NULL;

	gconf_client = gconf_client_get_default ();
	gtk_window_get_size (GTK_WINDOW (ConnectionTypesWindow), &width,
			     &height);
	gconf_client_set_int (gconf_client,
			      GCONF_CONNECTION_TYPES_WINDOW_WIDTH, width,
			      NULL);
	gconf_client_set_int (gconf_client,
			      GCONF_CONNECTION_TYPES_WINDOW_HEIGHT, height,
			      NULL);
	gconf_client_suggest_sync (gconf_client, NULL);
	g_object_unref (gconf_client);
	if (!rcm_load_types_from_disk ())
		rcm_error (_("A serious error has occured."),
			   ConnectionTypesWindow);
	rcm_update_main_window ();
	gtk_widget_hide (ConnectionTypesWindow);
}


void
on_ConnectionTypesDeleteBtn_clicked (GtkButton * button, gpointer user_data)
{
	GtkWidget *widget;
	GtkTreeIter iter;
	GtkTreeModel *model;
	GtkTreeSelection *select;
	gchar *name;

	GtkWidget *ConnectionTypesList =
		lookup_widget (ConnectionTypesWindow, "ConnectionTypesList");

	select = gtk_tree_view_get_selection (GTK_TREE_VIEW
					      (ConnectionTypesList));
	if (gtk_tree_selection_get_selected (select, &model, &iter))
	{
		gtk_tree_model_get (model, &iter, CONNECTION_TYPE_NAME_COLUMN,
				    &name, -1);
		rcm_remove_type_from_list_by_name (name,
						   ConnectionTypesSList);
		rcm_update_connectiontypes_window_list ();
		rcm_clear_types_window ();
	}
	else
	{
		rcm_warn (_("You must select a type from the list first."),
			  ConnectionTypesWindow);
	}
}


void
on_ConnectionsList_selection_changed_cb (GtkTreeSelection * selection,
					 gpointer data)
{
	GtkWidget *widget;
	GtkTreeIter iter;
	GtkTreeModel *model;
	GtkTreeSelection *select;
	gchar *name;
	Connection *connection;
	ConnectionType *type;

	GtkWidget *ConnectionsList =
		lookup_widget (ConnectionsWindow, "ConnectionsList");

	select = gtk_tree_view_get_selection (GTK_TREE_VIEW
					      (ConnectionsList));
	if (gtk_tree_selection_get_selected (select, &model, &iter))
	{
		gtk_tree_model_get (model, &iter, CONNECTION_NAME_COLUMN,
				    &name, -1);
		connection = rcm_find_connection_by_name_in_list (name,
								  ConnectionsSList);
		g_return_if_fail (connection != NULL);
		widget = lookup_widget (ConnectionsWindow,
					"ConnectionNameEntry");
		g_return_if_fail (widget != NULL);
		gtk_entry_set_text (GTK_ENTRY (widget), connection->Name);

		widget = NULL;
		widget = lookup_widget (ConnectionsWindow,
					"ConnectionHostnameEntry");
		g_return_if_fail (widget != NULL);
		gtk_entry_set_text (GTK_ENTRY (widget), connection->Hostname);

		type = g_slist_nth_data (ConnectionTypesSList,
					 connection->Type);
		widget = NULL;
		widget = lookup_widget (ConnectionsWindow,
					"ConnectionTypeCombo");
		g_return_if_fail (widget != NULL);
		gtk_entry_set_text (GTK_ENTRY (GTK_COMBO (widget)->entry),
				    type->Name);

		widget = NULL;
		widget = lookup_widget (ConnectionsWindow,
					"ConnectionUsernameEntry");
		g_return_if_fail (widget != NULL);
		gtk_entry_set_text (GTK_ENTRY (widget), connection->Username);

		widget = NULL;
		widget = lookup_widget (ConnectionsWindow,
					"ConnectionArgumentsEntry");
		g_return_if_fail (widget != NULL);
		gtk_entry_set_text (GTK_ENTRY (widget),
				    connection->Arguments);
	}
}

void
on_ConnectionTypesList_selection_changed_cb (GtkTreeSelection * selection,
					     gpointer data)
{
	GtkWidget *widget;
	GtkTreeIter iter;
	GtkTreeModel *model;
	GtkTreeSelection *select;
	gchar *name;
	ConnectionType *type;

	GtkWidget *ConnectionTypesList =
		lookup_widget (ConnectionTypesWindow, "ConnectionTypesList");

	select = gtk_tree_view_get_selection (GTK_TREE_VIEW
					      (ConnectionTypesList));
	if (gtk_tree_selection_get_selected (select, &model, &iter))
	{
		gtk_tree_model_get (model, &iter, CONNECTION_TYPE_NAME_COLUMN,
				    &name, -1);
		type = rcm_find_type_by_name_in_list (name,
						      ConnectionTypesSList);
		g_return_if_fail (type != NULL);
		widget = lookup_widget (ConnectionTypesWindow,
					"ConnectionTypesNameEntry");
		g_return_if_fail (widget != NULL);
		gtk_entry_set_text (GTK_ENTRY (widget), type->Name);

		widget = NULL;
		widget = lookup_widget (ConnectionTypesWindow,
					"ConnectionTypesCommandEntry");
		g_return_if_fail (widget != NULL);
		gtk_entry_set_text (GTK_ENTRY (widget), type->Command);

		widget = NULL;
		widget = lookup_widget (ConnectionTypesWindow,
					"ConnectionTypesArgumentsEntry");
		g_return_if_fail (widget != NULL);
		gtk_entry_set_text (GTK_ENTRY (widget), type->Arguments);
		
		widget = NULL;
		widget = lookup_widget (ConnectionTypesWindow,
					"ConnectionTypesTerminalChkBox");
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (widget),
					      type->Terminal);

		widget = NULL;
		widget = lookup_widget (ConnectionTypesWindow,
					"ConnectionTypesIconEntry");
		g_return_if_fail (widget != NULL);
		gnome_icon_entry_set_filename (GNOME_ICON_ENTRY (widget),
					       type->Icon);
	}
}

gboolean
on_MainWindow_delete_event (GtkWidget * widget,
			    GdkEvent * event, gpointer user_data)
{
	rcm_quit ();
	return FALSE;
}


void
on_file_new_connection_activate (GtkMenuItem * menuitem, gpointer user_data)
{
	rcm_show_ConnectionsWindow();
}


void
on_edit_preferences_activate (GtkMenuItem * menuitem, gpointer user_data)
{
	GtkWidget* ascchk;
	GtkWidget* deschk;
	GtkWidget* typchk;
	GtkWidget* nonchk;
	GtkWidget* terminal;
	GtkWidget* arguments;
	GtkWidget* usernames;
	
	ascchk = lookup_widget(PropertiesDialog,"PropertyAscendingSort");
	deschk = lookup_widget(PropertiesDialog,"PropertyDescendingSort");
	typchk = lookup_widget(PropertiesDialog,"PropertyTypeSort");
	nonchk = lookup_widget(PropertiesDialog,"PropertyNoneSort");
	terminal = lookup_widget(PropertiesDialog,"PropertyTerminalEntry");
	arguments = lookup_widget(PropertiesDialog,"PropertyTerminalArgumentsEntry");
	usernames = lookup_widget(PropertiesDialog,"PropertyShowUserNames");
	
	g_return_if_fail(ascchk != NULL || deschk != NULL || typchk != NULL || nonchk != NULL || arguments != NULL || arguments != NULL);
	
	if(SortOption == SORT_ASCENDING)
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(ascchk),TRUE);
	else if(SortOption == SORT_DESCENDING)
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(deschk),TRUE);
	else if(SortOption == SORT_TYPE)
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(typchk),TRUE);
	else if(SortOption == SORT_NONE)
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(nonchk),TRUE);
	
	gtk_entry_set_text(GTK_ENTRY(terminal),TerminalProgram);
	gtk_entry_set_text(GTK_ENTRY(arguments),TerminalProgramOptions);
	
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(usernames),DisplayUsernameInMainWindow);
	
	gtk_widget_show(PropertiesDialog);
}


void
on_edit_properties_activate (GtkMenuItem * menuitem, gpointer user_data)
{
	GnomeIconList *icon_list;
	gint i;
	GList *l;

	g_return_if_fail (ConnectionsWindow != NULL);
	rcm_update_connections_window_list ();

	icon_list = GNOME_ICON_LIST (lookup_widget (MainWindow, "MainList"));
	g_return_if_fail (icon_list != NULL);
	l = gnome_icon_list_get_selection (icon_list);

	if (l)
	{
		i = GPOINTER_TO_INT (l->data);
		rcm_select_connection_by_index (i);
		gtk_widget_show (ConnectionsWindow);
	}
}


void
on_ConnectionsSaveBtn_clicked (GtkButton * button, gpointer user_data)
{
	GtkWidget *widget = NULL;
	gchar *name = NULL;
	gchar *tmp = NULL;
	gchar *hostname = NULL;
	gchar *username = NULL;
	gchar *arguments = NULL;
	Connection connection;

	widget = NULL;
	widget = lookup_widget (ConnectionsWindow, "ConnectionNameEntry");
	g_return_if_fail (widget != NULL);
	name = gtk_editable_get_chars (GTK_EDITABLE (widget), 0, -1);
	if (strnlen (name,NAMELEN) == 0)
	{
		g_free (name);
		rcm_warn (_("Conenction name is not set."),
			  ConnectionsWindow);
		return;
	}
	strncpy (connection.Name, name, NAMELEN);
	// need this below g_free (name);

	widget = NULL;
	widget = lookup_widget (ConnectionsWindow, "ConnectionTypeCombo");
	g_return_if_fail (widget != NULL);
	tmp = gtk_editable_get_chars (GTK_EDITABLE
				      (GTK_COMBO (widget)->entry), 0, -1);
	if (tmp == NULL || strnlen (tmp,NAMELEN) == 0)
	{
		g_free (tmp);
		rcm_warn (_("Conenction Type is not set."),
			  ConnectionsWindow);
		return;
	}
	connection.Type = rcm_lookup_type_by_name (tmp);
	widget = NULL;
	widget = lookup_widget (ConnectionsWindow, "ConnectionHostnameEntry");
	g_return_if_fail (widget != NULL);
	hostname = gtk_editable_get_chars (GTK_EDITABLE (widget), 0, -1);
	if (strnlen (hostname,HOSTNAMELEN) == 0)
	{
		g_free (hostname);
		rcm_warn (_("Conenction hostname is not set."),
			  ConnectionsWindow);
		return;
	}
	strncpy (connection.Hostname, hostname, HOSTNAMELEN);

	widget = NULL;
	widget = lookup_widget (ConnectionsWindow, "ConnectionUsernameEntry");
	g_return_if_fail (widget != NULL);
	username = gtk_editable_get_chars (GTK_EDITABLE (widget), 0, -1);
	if (strnlen (username,USERNAMELEN) != 0)
		strncpy (connection.Username, username, USERNAMELEN);

	widget = NULL;
	widget = lookup_widget (ConnectionsWindow,
				"ConnectionArgumentsEntry");
	g_return_if_fail (widget != NULL);
	arguments = gtk_editable_get_chars (GTK_EDITABLE (widget), 0, -1);
	if (strnlen (arguments,ARGUMENTSLEN) != 0)
		strncpy (connection.Arguments, arguments, ARGUMENTSLEN);

	rcm_save_connection (connection);
	rcm_update_connections_window_list ();
	rcm_select_connection_by_name (name);
	rcm_clear_connections_window ();
	g_free (name);

}


void
on_ConnectionsDeleteBtn_clicked (GtkButton * button, gpointer user_data)
{
	GtkWidget *widget;
	GtkTreeIter iter;
	GtkTreeModel *model;
	GtkTreeSelection *select;
	gchar *name;
	Connection* connection = NULL;

	GtkWidget *ConnectionsList =
		lookup_widget (ConnectionsWindow, "ConnectionsList");

	select = gtk_tree_view_get_selection (GTK_TREE_VIEW
					      (ConnectionsList));
	if (gtk_tree_selection_get_selected (select, &model, &iter))
	{
		gtk_tree_model_get (model, &iter, CONNECTION_NAME_COLUMN,
				    &name, -1);
		connection = rcm_remove_connection_from_list_by_name (name,
							 ConnectionsSList);
		if(connection != NULL)
			free(connection);
		rcm_update_connections_window_list ();
		rcm_update_main_window();
		rcm_clear_connections_window ();
	}
	else
	{
		rcm_warn (_
			  ("You must select a connection from the list first."),
			  ConnectionsWindow);
	}
}


void
on_ConnectionsClearBtn_clicked (GtkButton * button, gpointer user_data)
{
	rcm_clear_connections_window ();
}


void
on_ConnectionsOkBtn_clicked (GtkButton * button, gpointer user_data)
{
	gint width, height;
	GConfClient *gconf_client = NULL;

	gconf_client = gconf_client_get_default ();
	gtk_window_get_size (GTK_WINDOW (ConnectionsWindow), &width, &height);
	gconf_client_set_int (gconf_client, GCONF_CONNECTIONS_WINDOW_WIDTH,
			      width, NULL);
	gconf_client_set_int (gconf_client, GCONF_CONNECTIONS_WINDOW_HEIGHT,
			      height, NULL);
	gconf_client_suggest_sync (gconf_client, NULL);
	g_object_unref (gconf_client);
	if (!rcm_save_connections_to_disk ())
		rcm_error (_("There was a problem saving."),
			   ConnectionsWindow);
	rcm_update_main_window ();
	gtk_widget_hide (ConnectionsWindow);
}


void
on_TbPropertiesBtn_clicked (GtkButton * button, gpointer user_data)
{
	GnomeIconList *icon_list;
	gint i;
	GList *l;

	g_return_if_fail (ConnectionsWindow != NULL);
	rcm_update_connections_window_list ();

	icon_list = GNOME_ICON_LIST (lookup_widget (MainWindow, "MainList"));
	g_return_if_fail (icon_list != NULL);
	l = gnome_icon_list_get_selection (icon_list);

	if (l)
	{
		i = GPOINTER_TO_INT (l->data);
		rcm_select_connection_by_index (i);
		gtk_widget_show (ConnectionsWindow);
	}
}


void
on_TbDeleteBtn_clicked (GtkButton * button, gpointer user_data)
{
	GnomeIconList *icon_list;
	gint i;
	GList *l;
	gchar *name;
	Connection *connection;
	GtkWidget *yes_no_dialog;
	int ret;
	gchar buff[MAX_BUFFER_LENGTH];

	icon_list = GNOME_ICON_LIST (lookup_widget (MainWindow, "MainList"));
	g_return_if_fail (icon_list != NULL);
	l = gnome_icon_list_get_selection (icon_list);

	if (l)
	{
		i = GPOINTER_TO_INT (l->data);
		connection = g_slist_nth_data (ConnectionsSList, i);
		g_return_if_fail (connection != NULL);
		snprintf (buff, MAX_BUFFER_LENGTH,
			  _("Are you sure you want to delete %s?"),
			  connection->Name);
		yes_no_dialog =
			gnome_message_box_new (buff,
					       GNOME_MESSAGE_BOX_QUESTION,
					       GNOME_STOCK_BUTTON_YES,
					       GNOME_STOCK_BUTTON_NO, NULL);
		ret = gnome_dialog_run (GNOME_DIALOG (yes_no_dialog));

		if (ret == 1)
			return;
		connection =
			rcm_remove_connection_from_list_by_name (connection->
								 Name,
								 ConnectionsSList);
		if (connection)
			free (connection);
		rcm_update_main_window ();	// causing assertion
		rcm_save_connections_to_disk ();
	}
}

void
on_ConnectionsCancelBtn_clicked (GtkButton * button, gpointer user_data)
{
	gint width, height;
	GConfClient *gconf_client = NULL;

	gconf_client = gconf_client_get_default ();
	gtk_window_get_size (GTK_WINDOW (ConnectionsWindow), &width, &height);
	gconf_client_set_int (gconf_client, GCONF_CONNECTIONS_WINDOW_WIDTH,
			      width, NULL);
	gconf_client_set_int (gconf_client, GCONF_CONNECTIONS_WINDOW_HEIGHT,
			      height, NULL);
	gconf_client_suggest_sync (gconf_client, NULL);
	g_object_unref (gconf_client);
	if (!rcm_load_connections_from_disk ())
		rcm_error (_("A serious error has occured."),
			   ConnectionsWindow);
	rcm_update_main_window ();
	gtk_widget_hide (ConnectionsWindow);
}


void
on_file_quit_activate (GtkMenuItem * menuitem, gpointer user_data)
{
	rcm_quit ();
}


void
on_MainList_select_icon (GnomeIconList * gnomeiconlist,
			 gint arg1, GdkEvent * event, gpointer user_data)
{

}


gboolean
on_MainList_button_press_event (GtkWidget * widget,
				GdkEventButton * event, gpointer user_data)
{
	GtkWidget *icon_list;
	GtkWidget* popupmenu;
	GtkWidget* popupmenuitem;
	GList *l;
	gint i;
	Connection *connection;

	if (event->type == GDK_2BUTTON_PRESS && event->button == 1)
	{
		icon_list = lookup_widget (MainWindow, "MainList");
		g_return_if_fail (icon_list != NULL);
		l = gnome_icon_list_get_selection (GNOME_ICON_LIST
						   (icon_list));

		if (l)
		{
			i = GPOINTER_TO_INT (l->data);
			connection = g_slist_nth_data (ConnectionsSList, i);
			g_return_if_fail (connection != NULL);
			rcm_launch_connection_by_name (connection->Name);
		}
	}
	else if(event->button == 3)
	{
		popupmenu = create_MainWindowPopupMenu();
		icon_list = lookup_widget (MainWindow, "MainList");
		g_return_if_fail (icon_list != NULL);
		l = gnome_icon_list_get_selection (GNOME_ICON_LIST
						   (icon_list));

		if (!l)
		{
			popupmenuitem = lookup_widget(popupmenu,"ExecutePopupMenuItem");
			gtk_widget_set_sensitive(popupmenuitem,FALSE);
			popupmenuitem = lookup_widget(popupmenu,"EditPopupMenuItem");
			gtk_widget_set_sensitive(popupmenuitem,FALSE);
			popupmenuitem = lookup_widget(popupmenu,"DeletePopupMenuItem");
			gtk_widget_set_sensitive(popupmenuitem,FALSE);
			
		}
		gtk_menu_popup(GTK_MENU(popupmenu),NULL,NULL,NULL,NULL,event->button,event->time);
	}
	return FALSE;
}

void
on_TbExecuteBtn_clicked (GtkButton * button, gpointer user_data)
{
	GtkWidget *icon_list;
	GList *l;
	gint i;
	Connection *connection;

	icon_list = lookup_widget (MainWindow, "MainList");
	g_return_if_fail (icon_list != NULL);
	l = gnome_icon_list_get_selection (GNOME_ICON_LIST (icon_list));

	if (l)
	{
		i = GPOINTER_TO_INT (l->data);
		connection = g_slist_nth_data (ConnectionsSList, i);
		g_return_if_fail (connection != NULL);
		rcm_launch_connection_by_name (connection->Name);
	}
}

void
on_ConnectionTypeCombo_changed         (GtkEditable     *editable,
                                        gpointer         user_data)
{
	GtkWidget* widget = NULL;
	gchar* type_name;
	ConnectionType* type = NULL;
	gint index;
	
	widget = lookup_widget(ConnectionsWindow, "ConnectionTypeCombo");
	g_return_if_fail(widget != NULL);
	
	type_name = gtk_editable_get_chars (GTK_EDITABLE (GTK_COMBO(widget)->entry), 0, -1);
	g_return_if_fail(type_name != NULL);
	
	index = rcm_lookup_type_by_name(type_name);
	type = g_slist_nth_data(ConnectionTypesSList,index);
	if(type == NULL)
		return;
	
	widget = lookup_widget(ConnectionsWindow, "ConnectionArgumentsEntry");
	g_return_if_fail(widget != NULL);
	
	gtk_entry_set_text(GTK_ENTRY(widget),type->Arguments);
}

void
on_PropertyNoneSort_toggled            (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
	GtkWidget* ascchk;
	GtkWidget* deschk;
	GtkWidget* typchk;
	GtkWidget* nonchk;
	
	ascchk = lookup_widget(PropertiesDialog,"PropertyAscendingSort");
	deschk = lookup_widget(PropertiesDialog,"PropertyDescendingSort");
	typchk = lookup_widget(PropertiesDialog,"PropertyTypeSort");
	nonchk = lookup_widget(PropertiesDialog,"PropertyNoneSort");
	
	g_return_if_fail(ascchk != NULL || deschk != NULL || typchk != NULL || nonchk != NULL);
	
	if(!gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(nonchk)))
		return;
	
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(ascchk),FALSE);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(deschk),FALSE);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(typchk),FALSE);
}


void
on_PropertyTypeSort_toggled            (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
	GtkWidget* ascchk;
	GtkWidget* deschk;
	GtkWidget* typchk;
	GtkWidget* nonchk;
	
	ascchk = lookup_widget(PropertiesDialog,"PropertyAscendingSort");
	deschk = lookup_widget(PropertiesDialog,"PropertyDescendingSort");
	typchk = lookup_widget(PropertiesDialog,"PropertyTypeSort");
	nonchk = lookup_widget(PropertiesDialog,"PropertyNoneSort");

	g_return_if_fail(ascchk != NULL || deschk != NULL || typchk != NULL || nonchk != NULL);
	
	if(!gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(typchk)))
		return;

	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(ascchk),FALSE);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(deschk),FALSE);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(nonchk),FALSE);
}


void
on_PropertyDescendingSort_toggled      (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
	GtkWidget* ascchk;
	GtkWidget* deschk;
	GtkWidget* typchk;
	GtkWidget* nonchk;
	
	ascchk = lookup_widget(PropertiesDialog,"PropertyAscendingSort");
	deschk = lookup_widget(PropertiesDialog,"PropertyDescendingSort");
	typchk = lookup_widget(PropertiesDialog,"PropertyTypeSort");
	nonchk = lookup_widget(PropertiesDialog,"PropertyNoneSort");
	
	g_return_if_fail(ascchk != NULL || deschk != NULL || typchk != NULL || nonchk != NULL);
	
	if(!gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(deschk)))
		return;

	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(ascchk),FALSE);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(nonchk),FALSE);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(typchk),FALSE);
}


void
on_PropertyAscendingSort_toggled       (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
	GtkWidget* ascchk;
	GtkWidget* deschk;
	GtkWidget* typchk;
	GtkWidget* nonchk;
	
	ascchk = lookup_widget(PropertiesDialog,"PropertyAscendingSort");
	deschk = lookup_widget(PropertiesDialog,"PropertyDescendingSort");
	typchk = lookup_widget(PropertiesDialog,"PropertyTypeSort");
	nonchk = lookup_widget(PropertiesDialog,"PropertyNoneSort");
	
	g_return_if_fail(ascchk != NULL || deschk != NULL || typchk != NULL || nonchk != NULL);
	
	if(!gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(ascchk)))
		return;
	
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(nonchk),FALSE);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(deschk),FALSE);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(typchk),FALSE);
}

void
on_PropertyCloseBtn_clicked            (GtkButton       *button,
                                        gpointer         user_data)
{
	GtkWidget* ascchk;
	GtkWidget* deschk;
	GtkWidget* typchk;
	GtkWidget* nonchk;
	GtkWidget* terminal;
	GtkWidget* arguments;
	GtkWidget* usernames;
	GConfClient *gconf_client = NULL;
	
	gtk_widget_hide(PropertiesDialog);
	
	ascchk = lookup_widget(PropertiesDialog,"PropertyAscendingSort");
	deschk = lookup_widget(PropertiesDialog,"PropertyDescendingSort");
	typchk = lookup_widget(PropertiesDialog,"PropertyTypeSort");
	nonchk = lookup_widget(PropertiesDialog,"PropertyNoneSort");
	terminal = lookup_widget(PropertiesDialog,"PropertyTerminalEntry");
	arguments = lookup_widget(PropertiesDialog,"PropertyTerminalArgumentsEntry");
	usernames = lookup_widget(PropertiesDialog,"PropertyShowUserNames");
	
	TerminalProgram = (gchar*)gtk_entry_get_text(GTK_ENTRY(terminal));
	TerminalProgramOptions = (gchar*)gtk_entry_get_text(GTK_ENTRY(arguments));
	
	if(gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(ascchk)))
	{
		if(SortOption != SORT_ASCENDING)
		{
			rcm_ascending_sort();
			SortOption = SORT_ASCENDING;
		}
	}
	else if(gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(deschk)))
	{
		if(SortOption != SORT_DESCENDING)
		{
			rcm_descending_sort();
			SortOption = SORT_DESCENDING;
		}
	}
	else if(gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(typchk)))
	{
		if(SortOption != SORT_TYPE)
		{
			rcm_type_sort();
			SortOption = SORT_TYPE;
		}
	}
	else if(gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(nonchk)))
	{
		if(SortOption != SORT_ASCENDING)
		{
			SortOption = SORT_ASCENDING;
		}
	}
	DisplayUsernameInMainWindow = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(usernames));
	rcm_update_main_window();
	gconf_client = gconf_client_get_default ();
	gconf_client_set_int(gconf_client,GCONF_RCM_SORTING_OPTION,SortOption,NULL);
	g_object_unref (gconf_client);
}


void
on_PropertyCancelBtn_clicked           (GtkButton       *button,
                                        gpointer         user_data)
{
	gtk_widget_hide(PropertiesDialog);
}


void
on_popup_execute_activated             (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	on_TbExecuteBtn_clicked(NULL,NULL);
}


void
on_popup_edit_activated                (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	on_TbPropertiesBtn_clicked(NULL,NULL);
}


void
on_popup_delete_activated              (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	on_TbDeleteBtn_clicked(NULL,NULL);
}


