      program     he5_gd_writedimscaleF_32

      implicit    none

      include     'hdfeos5.inc'

      integer     status
      integer     i, j
      integer     he5_gdopen
      integer     he5_gdattach
      integer     he5_gdwrfld
      integer     he5_gdwrattr
      integer     he5_gdwrgattr
      integer     he5_ehwrglatt
      integer     he5_gdwrlattr 
      integer     he5_gddetach
      integer     he5_gdclose
      integer     HE5_GDsetdimscale
      integer     HE5_GDwritedscaleattr
      integer     he5_gddeffld

      integer     gdfid,gdid1,gdid2,gdid3
      real*4      datbuf_f(1) 
      integer*4   datbuf_i(3)
      real*4      veg1(120),veg2(200), temp1(100),temp2(100)
      real*4      geospecf(4)
      integer*4   nbands
      integer     bands(3)
      integer*4   datbuf_i2(2)
      integer     count(2)
      integer     xdim, ydim, ntime
      integer     data(10)
      integer     FAIL
      parameter   (FAIL=-1)

!  /*
!   * We first open the HDF-EOS grid file, "Grid.h5".  Because this file
!   * already exist and we wish to write to it, we use the H5F_ACC_RDWR access
!   * code in the open statement.  The HE5_GDopen routine returns the grid file
!   * id, gdfid, which is used to identify the file in subsequent routines.
!   */ 
      do j=1,10
         data(j)=(j+1)*2
      enddo

      gdfid = HE5_GDopen("grid.he5", HE5F_ACC_RDWR)
      write(*,*) 'File ID returned by he5_gdopen(): ',gdfid
!  /*
!   * If the grid file cannot be found, HE5_GDopen will return -1 for the file
!   * handle (gdfid).  We there check that this is not the case before
!   * proceeding with the other routines.
!   * 
!   * The HE5_GDattach routine returns the handle to the existing grid "Grid1",
!   * GDid.  If the grid is not found, HE5_GDattach returns -1 for the handle.
!   */ 

      if (gdfid .ne. FAIL) then
 
         GDid1 = HE5_GDattach(gdfid, "UTMGrid")
         write(*,*) 'Grid ID returned by he5_gdattach(): ',gdid1

!   /* the field Pollution has Time,YDim,XDim dimensions. 
!    * xdim = 120
!    * ydim = 200
!    * Time dim is set to 10
!    */

         if (GDid1 .eq. -1) then
            
            write(*,*) 'Error: Cannot attach to grid UTMGrid. Stpped.'
            status = HE5_GDclose(gdfid)
            stop
            
         endif
         
         xdim = 120
         ydim = 200 
         ntime = 10
         
         status = HE5_GDsetdimscale(GDid1, "Pollution", "XDim", 
     1       xdim, HE5T_NATIVE_DOUBLE, veg1)
         write(*,*) 'Status returned by HE5_GDsetdimscale: ',status
         
         if (status .eq. -1) then
            
            write(*,*) 'Error: Cannot set Dimension Scale for XDim',
     1                ' dimemnsion in field Pollution'
            status = HE5_GDdetach(GDid1)
            status = HE5_GDclose(gdfid)
            stop
         endif
         
         status = HE5_GDsetdimscale(GDid1, "Pollution", "Time", ntime,
     1                               HE5T_NATIVE_INT, data)
         write(*,*) 'Status returned by HE5_GDsetdimscale: ',status
         if (status .eq. -1) then
            
            write(*,*) 'Error: Cannot set Dimension Scale for Time',
     1           ' dimemnsion in field Pollution'
            status = HE5_GDdetach(GDid1)
            status = HE5_GDclose(gdfid)
            stop
         endif
         
         status = HE5_GDsetdimscale(GDid1, "Vegetation", "XDim", xdim,
     1                               HE5T_NATIVE_DOUBLE, veg1)
         write(*,*) 'Status returned by HE5_GDsetdimscale: ',status
         if (status .eq. -1) then
            
            write(*,*) 'Error: Cannot set Dimension Scale for XDim',
     1                 ' dimemnsion in field Vegetation'
            status = HE5_GDdetach(GDid1)
            status = HE5_GDclose(gdfid)
            stop
         endif

         status = HE5_GDsetdimscale(GDid1, "Vegetation", "YDim", ydim,
     1                               HE5T_NATIVE_DOUBLE, veg2)
         write(*,*) 'Status returned by HE5_GDsetdimscale: ',status
         if (status .eq. -1) then
            
            write(*,*) 'Error: Cannot set Dimension Scale for XDim',
     1                 ' dimemnsion in field Vegetation'
            status = HE5_GDdetach(GDid1)
            status = HE5_GDclose(gdfid)
            stop
         endif

         count(1)= 12
         status = HE5_GDwritedscaleattr(GDid1, "XDim", "label", 
     1                         HE5T_NATIVE_CHAR, count, "X Dimension")
         write(*,*) 'Status returned by HE5_GDwritedscaleattr: ',status
         if (status .eq. -1) then
            
            write(*,*) 'Error:Cannot set Dimension Scale strs for XDim',
     1                ' dimemnsion in field Pollution'
            status = HE5_GDdetach(GDid1)
            status = HE5_GDclose(gdfid)
            stop
         endif
         
         count(1)= 6
         status = HE5_GDwritedscaleattr(GDid1, "XDim", "unit", 
     1                              HE5T_NATIVE_CHAR, count, "meters")
         write(*,*) 'Status returned by HE5_GDwritedscaleattr: ',status
         if (status .eq. -1) then
            
            write(*,*) 'Error:Cannot set Dimension Scale strs for XDim',
     1                 ' dimemnsion in field Pollution'
            status = HE5_GDdetach(GDid1)
            status = HE5_GDclose(gdfid)
            stop
         endif
         
         count(1)= 4
         status = HE5_GDwritedscaleattr(GDid1, "XDim", "format", 
     1                                 HE5T_NATIVE_CHAR, count, "F7.2")
         write(*,*) 'Status returned by HE5_GDwritedscaleattr: ',status
         if (status .eq. -1) then
            
            write(*,*) 'Error:Cannot set Dimension Scale strs for XDim',
     1                 ' dimemnsion in field Pollution'
            status = HE5_GDdetach(GDid1)
            status =  HE5_GDclose(gdfid)
            stop
         endif
         
         datbuf_f(1) =  -999.0
         count(1)= 1
         status = HE5_GDwritedscaleattr(GDid1, "XDim", "MissingValue",
     1                               HE5T_NATIVE_FLOAT, count, datbuf_f)
         write(*,*) 'Status returned by HE5_GDwritedscaleattr: ',status
         if (status .eq. -1) then
            
            write(*,*) 'Error:Cannot set Dimension Scale strs for XDim',
     1                 ' dimemnsion in field Pollution'
            status = HE5_GDdetach(GDid1)
            status = HE5_GDclose(gdfid)
            stop
         endif
         
         datbuf_i(1) =  -999
         datbuf_i(2) =  0
         datbuf_i(3) =  999


         count(1)= 3
         status = HE5_GDwritedscaleattr(GDid1, "XDim", "IntValues", 
     1                               HE5T_NATIVE_INT, count, datbuf_i)
         write(*,*) 'Status returned by HE5_GDwritedscaleattr: ',status
         if (status .eq. -1) then
            
            write(*,*) 'Error:Cannot set Dimension Scale strs for XDim',
     1         ' dimemnsion in field Pollution'
            status = HE5_GDdetach(GDid1)
            status = HE5_GDclose(gdfid)
            stop
         endif
         
         count(1)= 8
         status = HE5_GDwritedscaleattr(GDid1, "Time", "label", 
     1                             HE5T_NATIVE_CHAR, count, "Time Dim")
         write(*,*) 'Status returned by HE5_GDwritedscaleattr: ',status
         if (status .eq. -1) then
            
            write(*,*) 'Error: Cannot set Dimension Scale strs for',
     1                ' Time dimemnsion in field Pollution'
            status = HE5_GDdetach(GDid1)
            status = HE5_GDclose(gdfid)
            stop
         endif
         
         count(1)= 1
         status = HE5_GDwritedscaleattr(GDid1, "Time", "unit", 
     1                                 HE5T_NATIVE_CHAR, count, "s")
         write(*,*) 'Status returned by HE5_GDwritedscaleattr: ',status
         if (status .eq. -1) then
            
            write(*,*) 'Error: Cannot set Dimension Scale strs for',
     1                ' Time dimemnsion in field Pollution'
            status = HE5_GDdetach(GDid1)
            status = HE5_GDclose(gdfid)
            stop
         endif
         
         count(1)= 4
         status = HE5_GDwritedscaleattr(GDid1, "Time", "format", 
     1                                HE5T_NATIVE_CHAR, count, "F2.3")
         write(*,*) 'Status returned by HE5_GDwritedscaleattr: ',status
         if (status .eq. -1) then
            
            write(*,*) 'Error: Cannot set Dimension Scale strs for',
     1                ' Time dimemnsion in field Pollution'
            status = HE5_GDdetach(GDid1)
            status = HE5_GDclose(gdfid)
            stop
         endif
         
         datbuf_i2(1) =  -999
         datbuf_i2(2) =  999
         count(1) = 2
         status = HE5_GDwritedscaleattr(GDid1, "Time", "MissingValue", 
     1                                HE5T_NATIVE_INT, count, datbuf_i2)
         write(*,*) 'Status returned by HE5_GDwritedscaleattr: ',status
         if (status .eq. -1) then
            
            write(*,*) 'Error: Cannot set Dimension Scale strs for',
     1                ' Time dimemnsion in field Pollution'
            status = HE5_GDdetach(GDid1)
            status = HE5_GDclose(gdfid)
            stop
         endif
         
         status = HE5_GDdetach(GDid1)
         write(*,*) 'Status returned by he5_gddetach(): ',status

! -----------------------------------------------------------------

!         /* the field Spectra has Bands,YDim,XDim dimensions. 
!	 xdim = 100
!	 ydim = 100
!	 Bands dim is set to 3
!         */
!         
         GDid2 = HE5_GDattach(gdfid, "PolarGrid")
         write(*,*) 'Grid ID returned by he5_gdattach(): ',gdid2
         if (GDid2 .eq. -1) then
            
            write(*,*) 'Error: Cannot attach to grid PolarGrid'
            status = HE5_GDclose(gdfid)
            stop
         endif
         
         ydim = 100
         nbands = 3
         
         status = HE5_GDsetdimscale(GDid2, "Spectra", "YDim", ydim, 
     1                              HE5T_NATIVE_DOUBLE, temp1)
         write(*,*) 'Status returned by HE5_GDsetdimscale: ',status
         if (status .eq. -1) then
            
            write(*,*) 'Error: Cannot set Dimension Scale for YDim',
     1                 ' dimemnsion in field Spectra'
            status = HE5_GDdetach(GDid2)
            status = HE5_GDclose(gdfid)
            stop
         endif
         
         bands(1) = 5
         bands(2) = 8
         bands(3) = 9

         status = HE5_GDsetdimscale(GDid2, "Spectra", "Bands", 
     1                               nbands, HE5T_NATIVE_INT, bands)
         write(*,*) 'Status returned by HE5_GDsetdimscale: ',status
         if (status .eq. -1) then
            
            write(*,*) 'Error: Cannot set Dimension Scale for',
     1                ' Bands dimemnsion in field Spectra'
            status = HE5_GDdetach(GDid2)
            status = HE5_GDclose(gdfid)
            stop
         endif
         
         count(1)= 5
         status = HE5_GDwritedscaleattr(GDid2, "YDim", "Label", 
     1                              HE5T_NATIVE_CHAR, count, "Y Dim")
         write(*,*) 'Status returned by HE5_GDwritedscaleattr: ',status
         if (status .eq. -1) then
            
            write(*,*) 'Error: Cannot set Dimension Scale strs for',
     1                ' XDim dimemnsion in field Pollution'
            status = HE5_GDdetach(GDid2)
            status = HE5_GDclose(gdfid)
            stop
         endif
         
         count(1) = 4
         status = HE5_GDwritedscaleattr(GDid2, "Bands", "Units", 
     1                                HE5T_NATIVE_CHAR, count, "None")
         write(*,*) 'Status returned by HE5_GDwritedscaleattr: ',status
         if (status .eq. -1) then
            
            write(*,*) 'Error: Cannot set Dimension Scale strs for',
     1                ' Time dimemnsion in field Pollution '
            status = HE5_GDdetach(GDid2)
            status = HE5_GDclose(gdfid)
            stop
         endif
         
         status = HE5_GDdetach(GDid2)
! -----------------------------------------------------------------         
         xdim = 60
         ydim = 40

         GDid3 = HE5_GDattach(gdfid, "GEOGrid")
         write(*,*) 'Grid ID returned by he5_gdattach(): ',GDid3
         if (GDid3 .eq. -1) then
            
	    write(*,*) 'Error: Cannot attach to grid GEOGrid'
            status = HE5_GDclose(gdfid)
	    stop
         endif


!     Define Fields
!     -------------	  
         status = he5_gddeffld(gdid3, "GeoSpectra", "XDim,YDim",
     1     " ", HE5T_NATIVE_FLOAT, 0)
         write(*,*) 'Status returned by he5_gddeffld(): ',status

         status = HE5_GDsetdimscale(GDid3, "GeoSpectra", "YDim", 
     1                         ydim, HE5T_NATIVE_DOUBLE, GeoSpecf)
         write(*,*) 'Status returned by HE5_GDsetdimscale: ',status
         if (status .eq. -1) then
            
	    write(*,*) 'Error: Cannot set Dimension Scale for',
     1                ' YDim dimemnsion in field GeoSpectra'
            status = HE5_GDdetach(GDid3)
            status = HE5_GDclose(gdfid)
	    stop
         endif
         
         count(1) = 15
         status = HE5_GDwritedscaleattr(GDid3, "YDim", "Units", 
     1                    HE5T_NATIVE_CHAR, count, "Decimal Degrees")
         write(*,*) 'Status returned by HE5_GDwritedscaleattr: ',status
         if (status .eq. -1) then
            
	    write(*,*) 'Error: Cannot set Dimension Scale strs for',
     1                ' YDim dimemnsion in field GeoSpectra'
            status = HE5_GDdetach(GDid3)
            status = HE5_GDclose(gdfid)
	    stop
         endif
         
         
         status = HE5_GDdetach(GDid3)
         write(*,*) 'Status returned by he5_gddetach(): ',status
         status = HE5_GDclose(gdfid)
         write(*,*) 'Status returned by he5_gdclose(): ',status

      endif
      stop
      end
