/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.stripes.validation.expression;

import java.beans.FeatureDescriptor;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.List;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.ELResolver;
import javax.el.ExpressionFactory;
import javax.el.FunctionMapper;
import javax.el.PropertyNotWritableException;
import javax.el.ValueExpression;
import javax.el.VariableMapper;
import javax.servlet.ServletContext;
import javax.servlet.jsp.JspApplicationContext;
import javax.servlet.jsp.JspFactory;
import net.sourceforge.stripes.action.ActionBean;
import net.sourceforge.stripes.controller.ParameterName;
import net.sourceforge.stripes.controller.StripesFilter;
import net.sourceforge.stripes.exception.StripesRuntimeException;
import net.sourceforge.stripes.util.Log;
import net.sourceforge.stripes.util.bean.BeanUtil;
import net.sourceforge.stripes.validation.ScopedLocalizableError;
import net.sourceforge.stripes.validation.ValidationErrors;
import net.sourceforge.stripes.validation.ValidationMetadata;
import net.sourceforge.stripes.validation.expression.ExpressionExecutor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Jsp21ExpressionExecutor
implements ExpressionExecutor {
    private static final Log log = Log.getInstance(Jsp21ExpressionExecutor.class);

    public Jsp21ExpressionExecutor() {
        if (this.getExpressionFactory() == null) {
            throw new StripesRuntimeException("Could not create a JSP2.1 ExpressionFactory.");
        }
    }

    @Override
    public void evaluate(ActionBean bean, ParameterName name, List<Object> values, ValidationMetadata validationInfo, ValidationErrors errors) {
        StripesELContext ctx = null;
        String expressionString = validationInfo.expression();
        ValueExpression expression = null;
        try {
            if (expressionString != null) {
                ExpressionFactory factory = this.getExpressionFactory();
                if (factory == null) {
                    return;
                }
                ctx = new StripesELContext(bean);
                expression = factory.createValueExpression((ELContext)ctx, expressionString, Boolean.class);
            }
        }
        catch (ELException ele) {
            throw new StripesRuntimeException("Could not parse the EL expression being used to validate field " + name.getName() + ". This is not a transient error. Please double " + "check the following expression for errors: " + validationInfo.expression(), ele);
        }
        for (Object value : values) {
            if (expression == null) continue;
            try {
                ctx.setCurrentValue(value);
                Boolean result = (Boolean)expression.getValue((ELContext)ctx);
                if (Boolean.TRUE.equals(result)) continue;
                ScopedLocalizableError error = new ScopedLocalizableError("validation.expression", "valueFailedExpression", new Object[0]);
                error.setFieldValue(String.valueOf(value));
                errors.add(name.getName(), error);
            }
            catch (ELException ele) {
                log.error("Error evaluating expression for property ", name.getName(), " of class ", bean.getClass().getSimpleName(), ". Expression: ", validationInfo.expression());
            }
        }
    }

    protected ExpressionFactory getExpressionFactory() {
        ServletContext ctx = StripesFilter.getConfiguration().getServletContext();
        JspApplicationContext jspCtx = JspFactory.getDefaultFactory().getJspApplicationContext(ctx);
        return jspCtx.getExpressionFactory();
    }

    protected static class StripesELContext
    extends ELContext {
        private ActionBean bean;
        private StripesELResolver resolver;
        private VariableMapper vmapper;
        private static final FunctionMapper fmapper = new FunctionMapper(){

            public Method resolveFunction(String s, String s1) {
                return null;
            }
        };

        public StripesELContext(ActionBean bean) {
            this.bean = bean;
            this.resolver = new StripesELResolver(bean);
            this.vmapper = new VariableMapper(){

                public ValueExpression resolveVariable(String s) {
                    return null;
                }

                public ValueExpression setVariable(String s, ValueExpression valueExpression) {
                    return null;
                }
            };
        }

        public void setCurrentValue(Object value) {
            this.resolver.setCurrentValue(value);
        }

        public StripesELResolver getELResolver() {
            return this.resolver;
        }

        public FunctionMapper getFunctionMapper() {
            return fmapper;
        }

        public VariableMapper getVariableMapper() {
            return this.vmapper;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class StripesELResolver
    extends ELResolver {
        private ActionBean bean;
        private Object currentValue;

        StripesELResolver(ActionBean bean) {
            this.bean = bean;
        }

        void setCurrentValue(Object value) {
            this.currentValue = value;
        }

        public Object getValue(ELContext ctx, Object base, Object prop) {
            if ("this".equals(prop)) {
                ctx.setPropertyResolved(true);
                return this.currentValue;
            }
            if ("actionBean".equals(prop)) {
                ctx.setPropertyResolved(true);
                return this.bean;
            }
            try {
                base = base == null ? this.bean : base;
                Object retval = BeanUtil.getPropertyValue(String.valueOf(prop), base);
                ctx.setPropertyResolved(true);
                return retval;
            }
            catch (Exception e) {
                return null;
            }
        }

        public Class<?> getType(ELContext ctx, Object base, Object prop) {
            ctx.setPropertyResolved(true);
            return Object.class;
        }

        public void setValue(ELContext elContext, Object o, Object o1, Object o2) throws PropertyNotWritableException {
            throw new PropertyNotWritableException("Unsupported Op");
        }

        public boolean isReadOnly(ELContext elContext, Object o, Object o1) {
            return true;
        }

        public Iterator<FeatureDescriptor> getFeatureDescriptors(ELContext elContext, Object o) {
            return null;
        }

        public Class<?> getCommonPropertyType(ELContext elContext, Object o) {
            return Object.class;
        }
    }
}

