package latexDraw.parsers;

/** 
 * This kind of exception occurs when the format of a command is incorrect.
 * 
 * This file is part of LaTeXDraw<br>
 * Copyright (c) 2005-2008 Arnaud BLOUIN<br>
 *<br>
 *  LaTeXDraw is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.<br>
 *<br>
 *  LaTeXDraw is distributed without any warranty; without even the 
 *  implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 *  PURPOSE.  See the GNU General Public License for more details.<br>
 * <br>
 * 02/15/06<br>
 * @author Arnaud BLOUIN<br>
 * @version 2.0.0<br>
 */
public class InvalidFormatCommandException extends UnknownCommandException
{
	private static final long serialVersionUID = 1L;

	
	/**
	 * The constructor using the number of the line of the ignored command.
	 * @param nl The number of line of the ignored command.
	 */
	public InvalidFormatCommandException(int nl)
	{ 
		this("", nl);//$NON-NLS-1$
	}
	
	
	
	/**
	 * The constructor using the name of the ignored command.
	 * @param ms The name of the ignored command.
	 * @param nl The number of line of the ignored command.
	 */
	public InvalidFormatCommandException(String ms, int nl)
	{ 
		super(ms, nl);
	}
	
	
	
	@Override
	public String toString()
	{
		if(command==null || command.length()==0)
			return "Line "+ nLine + " : the format of the command is invalid!";//$NON-NLS-1$//$NON-NLS-2$
		return "Line "+ nLine + " : the command "+command+" is invalid!";//$NON-NLS-1$//$NON-NLS-2$//$NON-NLS-3$
	}
}
