package latexDraw.parsers;

/** 
 *  This class allows the management of exceptions : a command
 *  "not yet managed" can generate an NotYetManagedException<br>
 *  
 * This file is part of LaTeXDraw<br>
 * Copyright (c) 2005-2008 Arnaud BLOUIN<br>
 *<br>
 *  LaTeXDraw is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.<br>
 *<br>
 *  LaTeXDraw is distributed without any warranty; without even the 
 *  implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 *  PURPOSE. See the GNU General Public License for more details.<br>
 *<br>
 * 01/24/06<br>
 * @author Arnaud BLOUIN<br>
 * @version 2.0.0<br>
 */
public class NotYetManagedException extends Exception
{
	private static final long serialVersionUID = 1L;
	
	/** The command which is not managed */
	String command;
	
	/** The number of the line that command was in the file */
	int nLine;
	
	
	/**
	 * The constructor using the name of the not managed command.
	 */
	public NotYetManagedException(String cmd, int nl)
	{ 
		command = cmd;
		nLine = nl;
	}
	
	
	
	@Override
	public String toString()
	{
		if(command==null || command.length()==0)
		return "Line "+ nLine + " : a command is unknown!";//$NON-NLS-1$//$NON-NLS-2$
		return "Line "+ nLine + " : the command "+command+" is not yet managed!";//$NON-NLS-1$//$NON-NLS-2$//$NON-NLS-3$
	}


	/**
	 * @return the command
	 */
	public String getCommand()
	{
		return command;
	}


	/**
	 * @return the nLine
	 */
	public int getNLine()
	{
		return nLine;
	}
}
