#! /bin/sh

### BEGIN INIT INFO
# Provides:          lcd4linux
# Required-Start:    $remote_fs
# Required-Stop:     $remote_fs
# Should-Start:      $syslog
# Should-Stop:       $syslog
# Default-Start:     2 3 4 5
# Default-Stop:      0 1 6
# Short-Description: daemon for driving LCD based displays
# Description:       LCD4Linux is a small program that grabs information from
#                    the kernel and some subsystems and displays it on an
#                    external liquid crystal display.
### END INIT INFO

PATH=/usr/local/sbin:/usr/local/bin:/sbin:/bin:/usr/sbin:/usr/bin
DAEMON=/usr/sbin/lcd4linux
NAME=lcd4linux
DESC=lcd4linux

. /lib/lsb/init-functions

test -x $DAEMON || exit 0
test -f /etc/lcd4linux.conf || exit 0

test -f /etc/default/lcd4linux && . /etc/default/lcd4linux
DAEMON_OPTS="$ARGS"

set -e

case "$1" in
  start)
	log_daemon_msg "Starting $DESC" "$NAME"
	chmod 600 /etc/lcd4linux.conf
	start-stop-daemon --start --quiet --pidfile /var/run/$NAME.pid \
		--exec $DAEMON -- $DAEMON_OPTS
	log_end_msg $?
	;;
  stop)
	log_daemon_msg "Stopping $DESC" "$NAME" 
	start-stop-daemon --stop --quiet --retry=TERM/15/KILL/5 \
		--pidfile /var/run/$NAME.pid --exec $DAEMON
	log_end_msg $?
	;;
  restart|force-reload)
	$0 stop
	sleep 2
	$0 start
	;;
  status)
	status_of_proc $DAEMON "$NAME"
	status=$?
	exit $status
	;;
  *)
	N=/etc/init.d/$NAME
	echo "Usage: $N {start|stop|restart|status|force-reload}" >&2
	exit 1
	;;
esac

exit 0
