//Generated by SyntaxValidityCheckerGenerator. DO NOT EDIT, DO NOT CHECK IN!

package lombok.ast.syntaxChecks;

import lombok.ast.*;

/**
 * Adds a {@link lombok.ast.Message} to a list for each syntactic problem with a node.
 * Something like {@code a +} is not syntactically valid (It's missing the second argument to binary operator),
 * but something like {@code a + b} would be valid, <i>even if</i> both {@code a} and {@code b} end up being objects,
 * which do not support the + operator.
 */
public class SyntacticValidityVisitor extends lombok.ast.syntaxChecks.SyntacticValidityVisitorBase {
	public SyntacticValidityVisitor(boolean recursing) {
		super(recursing);
	}
	
	@java.lang.Override public boolean visitAlternateConstructorInvocation(AlternateConstructorInvocation node) {
		this.getCheckerObject(lombok.ast.syntaxChecks.StructuralChecks.class).alternateConstructorInvocationMustBeFirst(node);
		
		return !this.recursing;
	}
	
	@java.lang.Override public boolean visitAnnotationDeclaration(AnnotationDeclaration node) {
		this.getCheckerObject(lombok.ast.syntaxChecks.KeywordChecks.class).annotationDeclarationModifiersCheck(node);
		
		return !this.recursing;
	}
	
	@java.lang.Override public boolean visitAnnotationMethodDeclaration(AnnotationMethodDeclaration node) {
		this.getCheckerObject(lombok.ast.syntaxChecks.KeywordChecks.class).annotationMethodModifiersCheck(node);
		
		return !this.recursing;
	}
	
	@java.lang.Override public boolean visitBreak(Break node) {
		this.getCheckerObject(lombok.ast.syntaxChecks.UnreachableStatementsChecks.class).unreachablesAfterBreak(node);
		
		return !this.recursing;
	}
	
	@java.lang.Override public boolean visitCase(Case node) {
		this.getCheckerObject(lombok.ast.syntaxChecks.StatementChecks.class).checkCaseChildOfSwitch(node);
		
		return !this.recursing;
	}
	
	@java.lang.Override public boolean visitCatch(Catch node) {
		this.getCheckerObject(lombok.ast.syntaxChecks.StatementChecks.class).checkVarDefOfCatch(node);
		
		return !this.recursing;
	}
	
	@java.lang.Override public boolean visitClassDeclaration(ClassDeclaration node) {
		this.getCheckerObject(lombok.ast.syntaxChecks.KeywordChecks.class).classDeclarationModifiersCheck(node);
		
		return !this.recursing;
	}
	
	@java.lang.Override public boolean visitConstructorDeclaration(ConstructorDeclaration node) {
		this.getCheckerObject(lombok.ast.syntaxChecks.StructuralChecks.class).checkConstructorParamsAreSimple(node);
		
		return !this.recursing;
	}
	
	@java.lang.Override public boolean visitContinue(Continue node) {
		this.getCheckerObject(lombok.ast.syntaxChecks.UnreachableStatementsChecks.class).unreachablesAfterContinue(node);
		
		return !this.recursing;
	}
	
	@java.lang.Override public boolean visitDefault(Default node) {
		this.getCheckerObject(lombok.ast.syntaxChecks.StatementChecks.class).checkDefaultChildOfSwitch(node);
		
		return !this.recursing;
	}
	
	@java.lang.Override public boolean visitDoWhile(DoWhile node) {
		this.getCheckerObject(lombok.ast.syntaxChecks.StatementChecks.class).checkDeclarationsAsDirectChildDo(node);
		
		return !this.recursing;
	}
	
	@java.lang.Override public boolean visitEmptyDeclaration(EmptyDeclaration node) {
		this.getCheckerObject(lombok.ast.syntaxChecks.KeywordChecks.class).emptyDeclarationMustHaveNoModifiers(node);
		
		return !this.recursing;
	}
	
	@java.lang.Override public boolean visitEnumDeclaration(EnumDeclaration node) {
		this.getCheckerObject(lombok.ast.syntaxChecks.KeywordChecks.class).enumDeclarationModifiersCheck(node);
		
		return !this.recursing;
	}
	
	@java.lang.Override public boolean visitFor(For node) {
		this.getCheckerObject(lombok.ast.syntaxChecks.StatementChecks.class).checkDeclarationsAsDirectChildFor(node);
		
		return !this.recursing;
	}
	
	@java.lang.Override public boolean visitForEach(ForEach node) {
		this.getCheckerObject(lombok.ast.syntaxChecks.StatementChecks.class).checkDeclarationsAsDirectChildForEach(node);
		this.getCheckerObject(lombok.ast.syntaxChecks.StatementChecks.class).checkVarDefOfForEach(node);
		
		return !this.recursing;
	}
	
	@java.lang.Override public boolean visitIdentifier(Identifier node) {
		this.getCheckerObject(lombok.ast.syntaxChecks.BasicChecks.class).checkNameOfIdentifier(node);
		
		return !this.recursing;
	}
	
	@java.lang.Override public boolean visitIf(If node) {
		this.getCheckerObject(lombok.ast.syntaxChecks.StatementChecks.class).checkDeclarationsAsDirectChildIf(node);
		
		return !this.recursing;
	}
	
	@java.lang.Override public boolean visitInstanceInitializer(InstanceInitializer node) {
		this.getCheckerObject(lombok.ast.syntaxChecks.StructuralChecks.class).initializersMustCompleteNormallyInstance(node);
		
		return !this.recursing;
	}
	
	@java.lang.Override public boolean visitInterfaceDeclaration(InterfaceDeclaration node) {
		this.getCheckerObject(lombok.ast.syntaxChecks.KeywordChecks.class).interfaceDeclarationModifiersCheck(node);
		
		return !this.recursing;
	}
	
	@java.lang.Override public boolean visitMethodDeclaration(MethodDeclaration node) {
		this.getCheckerObject(lombok.ast.syntaxChecks.KeywordChecks.class).methodModifiersCheck(node);
		this.getCheckerObject(lombok.ast.syntaxChecks.StructuralChecks.class).checkAbstractMembersOnlyInAbstractTypes(node);
		this.getCheckerObject(lombok.ast.syntaxChecks.StructuralChecks.class).checkMethodParamsAreSimple(node);
		
		return !this.recursing;
	}
	
	@java.lang.Override public boolean visitModifiers(Modifiers node) {
		this.getCheckerObject(lombok.ast.syntaxChecks.KeywordChecks.class).duplicateKeywordModifierCheck(node);
		
		return !this.recursing;
	}
	
	@java.lang.Override public boolean visitReturn(Return node) {
		this.getCheckerObject(lombok.ast.syntaxChecks.UnreachableStatementsChecks.class).unreachableAfterReturn(node);
		
		return !this.recursing;
	}
	
	@java.lang.Override public boolean visitStaticInitializer(StaticInitializer node) {
		this.getCheckerObject(lombok.ast.syntaxChecks.KeywordChecks.class).checkStaticInitializerInNonStaticType(node);
		this.getCheckerObject(lombok.ast.syntaxChecks.StructuralChecks.class).initializersMustCompleteNormallyStatic(node);
		
		return !this.recursing;
	}
	
	@java.lang.Override public boolean visitSuperConstructorInvocation(SuperConstructorInvocation node) {
		this.getCheckerObject(lombok.ast.syntaxChecks.StructuralChecks.class).superConstructorInvocationMustBeFirst(node);
		
		return !this.recursing;
	}
	
	@java.lang.Override public boolean visitSwitch(Switch node) {
		this.getCheckerObject(lombok.ast.syntaxChecks.StatementChecks.class).checkSwitchStartsWithDefaultOrCase(node);
		
		return !this.recursing;
	}
	
	@java.lang.Override public boolean visitTry(Try node) {
		this.getCheckerObject(lombok.ast.syntaxChecks.StatementChecks.class).checkNotLoneTry(node);
		
		return !this.recursing;
	}
	
	@java.lang.Override public boolean visitTypeReference(TypeReference node) {
		this.getCheckerObject(lombok.ast.syntaxChecks.TypeChecks.class).checkNoPrimitivesInGenerics(node);
		this.getCheckerObject(lombok.ast.syntaxChecks.TypeChecks.class).checkVoidNotLegalJustAboutEverywhere(node);
		
		return !this.recursing;
	}
	
	@java.lang.Override public boolean visitVariableDeclaration(VariableDeclaration node) {
		this.getCheckerObject(lombok.ast.syntaxChecks.KeywordChecks.class).fieldModifiersCheck(node);
		
		return !this.recursing;
	}
	
	@java.lang.Override public boolean visitVariableDefinition(VariableDefinition node) {
		this.getCheckerObject(lombok.ast.syntaxChecks.KeywordChecks.class).localVariableModifiersCheck(node);
		this.getCheckerObject(lombok.ast.syntaxChecks.StructuralChecks.class).varDefOfZero(node);
		this.getCheckerObject(lombok.ast.syntaxChecks.StructuralChecks.class).varargsOnlyLegalOnMethods(node);
		
		return !this.recursing;
	}
	
	@java.lang.Override public boolean visitVariableDefinitionEntry(VariableDefinitionEntry node) {
		this.getCheckerObject(lombok.ast.syntaxChecks.StructuralChecks.class).varargsAndExtendedDimsDontMix(node);
		
		return !this.recursing;
	}
	
	@java.lang.Override public boolean visitWhile(While node) {
		this.getCheckerObject(lombok.ast.syntaxChecks.StatementChecks.class).checkDeclarationsAsDirectChildWhile(node);
		
		return !this.recursing;
	}
}
