/***************************************************************************
  gen-case-folding-src.cpp  -  Converts CaseFolding.txt to case statements
                             -------------------
    begin                : Thu Jul 17 2008
    copyright            : (C) 2008 by Edward Sheldrake
    email                : ejs1920@yahoo.co.uk
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

/**
 * @author Edward Sheldrake
 *
 * This just converts the unicode case folding table into
 * a huge list of case statements.
 *
 * Alternatively it could have been written in gawk or perl
 * or something.
 *
 * Compile:
 * g++ -Wall -Wformat -o gensrc gen-case-folding-src.cpp
 *
 * Run:
 * ./gensrc < CaseFolding-5.1.0.txt > ccasefolder-generated-code.cpp
 */

#include <errno.h>
#include <stdio.h>

int main(int, char**)
{
	char buffer[1024];
	unsigned int source;
	char type;
	unsigned int res1, res2, res3, res4;
	int matched = EOF + 1;
	char * read = buffer;
	
	/* print header info */
	printf("/* Automatically generated file do not edit. */\n");
	printf("/* It's useless on it's own and is included */\n");
	printf("/* at the correct place in ccasefolder.cpp */\n");
	
	while ( read != 0 )
	{
		read = fgets( buffer, 1024, stdin );
		
		if ( read == 0 )
		{
			return 0;
		}
		
		matched = sscanf(buffer, "%5x; %1c; %5x %5x %5x %5x;", &source, &type, &res1, &res2, &res3, &res4);
		
		if ( matched == 0 )
		{
			continue;
		}
		else if ( (matched >= 3) && (matched <= 5) )
		{
			if ( (type == 'C') || (type == 'F') )
			{
				printf("case 0x%05X:\n",source);
				printf("\tfolded[outpos] = 0x%05X;\n",res1);
				printf("\t++outpos;\n");
				
				if ( matched >= 4 )
				{
					printf("\tfolded[outpos] = 0x%05X;\n",res2);
					printf("\t++outpos;\n");
				}
				
				if ( matched == 5 )
				{
					printf("\tfolded[outpos] = 0x%05X;\n",res3);
					printf("\t++outpos;\n");
				}
				
				printf("\tbreak;\n");
			}
		}
		else if ( matched > 5 )
		{
			printf("Error: converting 1 char to more than 3 chars isn't supported.\n");
			return 1;
		}
		
		if ( errno == EOF )
		{
			return 0;
		}
		else if ( errno != 0 )
		{
			perror("gensrc ");
			return 1;
		}
	}
	
	return 0;
}
