/* vfs-file-impl-gnome-vfs.c generated by valac 0.10.4, the Vala compiler
 * generated from vfs-file-impl-gnome-vfs.vala, do not modify */

/*
 * Desktop Agnostic Library: File implementation (with GNOME VFS).
 *
 * Copyright (C) 2009 Mark Lee <libdesktop-agnostic@lazymalevolence.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 *
 * Author : Mark Lee <libdesktop-agnostic@lazymalevolence.com>
 */

#include <glib.h>
#include <glib-object.h>
#include <libdesktop-agnostic/vfs.h>
#include <libgnomevfs/gnome-vfs.h>
#include <stdlib.h>
#include <string.h>
#include <libgnomevfs/gnome-vfs-mime-handlers.h>


#define DESKTOP_AGNOSTIC_VFS_TYPE_FILE_GNOME_VFS (desktop_agnostic_vfs_file_gnome_vfs_get_type ())
#define DESKTOP_AGNOSTIC_VFS_FILE_GNOME_VFS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DESKTOP_AGNOSTIC_VFS_TYPE_FILE_GNOME_VFS, DesktopAgnosticVFSFileGnomeVFS))
#define DESKTOP_AGNOSTIC_VFS_FILE_GNOME_VFS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DESKTOP_AGNOSTIC_VFS_TYPE_FILE_GNOME_VFS, DesktopAgnosticVFSFileGnomeVFSClass))
#define DESKTOP_AGNOSTIC_VFS_IS_FILE_GNOME_VFS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DESKTOP_AGNOSTIC_VFS_TYPE_FILE_GNOME_VFS))
#define DESKTOP_AGNOSTIC_VFS_IS_FILE_GNOME_VFS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DESKTOP_AGNOSTIC_VFS_TYPE_FILE_GNOME_VFS))
#define DESKTOP_AGNOSTIC_VFS_FILE_GNOME_VFS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DESKTOP_AGNOSTIC_VFS_TYPE_FILE_GNOME_VFS, DesktopAgnosticVFSFileGnomeVFSClass))

typedef struct _DesktopAgnosticVFSFileGnomeVFS DesktopAgnosticVFSFileGnomeVFS;
typedef struct _DesktopAgnosticVFSFileGnomeVFSClass DesktopAgnosticVFSFileGnomeVFSClass;
typedef struct _DesktopAgnosticVFSFileGnomeVFSPrivate DesktopAgnosticVFSFileGnomeVFSPrivate;
#define _gnome_vfs_uri_unref0(var) ((var == NULL) ? NULL : (var = (gnome_vfs_uri_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define DESKTOP_AGNOSTIC_VFS_TYPE_FILE_MONITOR_GNOME_VFS (desktop_agnostic_vfs_file_monitor_gnome_vfs_get_type ())
#define DESKTOP_AGNOSTIC_VFS_FILE_MONITOR_GNOME_VFS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DESKTOP_AGNOSTIC_VFS_TYPE_FILE_MONITOR_GNOME_VFS, DesktopAgnosticVFSFileMonitorGnomeVFS))
#define DESKTOP_AGNOSTIC_VFS_FILE_MONITOR_GNOME_VFS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DESKTOP_AGNOSTIC_VFS_TYPE_FILE_MONITOR_GNOME_VFS, DesktopAgnosticVFSFileMonitorGnomeVFSClass))
#define DESKTOP_AGNOSTIC_VFS_IS_FILE_MONITOR_GNOME_VFS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DESKTOP_AGNOSTIC_VFS_TYPE_FILE_MONITOR_GNOME_VFS))
#define DESKTOP_AGNOSTIC_VFS_IS_FILE_MONITOR_GNOME_VFS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DESKTOP_AGNOSTIC_VFS_TYPE_FILE_MONITOR_GNOME_VFS))
#define DESKTOP_AGNOSTIC_VFS_FILE_MONITOR_GNOME_VFS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DESKTOP_AGNOSTIC_VFS_TYPE_FILE_MONITOR_GNOME_VFS, DesktopAgnosticVFSFileMonitorGnomeVFSClass))

typedef struct _DesktopAgnosticVFSFileMonitorGnomeVFS DesktopAgnosticVFSFileMonitorGnomeVFS;
typedef struct _DesktopAgnosticVFSFileMonitorGnomeVFSClass DesktopAgnosticVFSFileMonitorGnomeVFSClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _gnome_vfs_file_info_unref0(var) ((var == NULL) ? NULL : (var = (gnome_vfs_file_info_unref (var), NULL)))
#define __g_list_free_g_free0(var) ((var == NULL) ? NULL : (var = (_g_list_free_g_free (var), NULL)))
#define __g_slist_free_g_object_unref0(var) ((var == NULL) ? NULL : (var = (_g_slist_free_g_object_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

struct _DesktopAgnosticVFSFileGnomeVFS {
	DesktopAgnosticVFSFile parent_instance;
	DesktopAgnosticVFSFileGnomeVFSPrivate * priv;
};

struct _DesktopAgnosticVFSFileGnomeVFSClass {
	DesktopAgnosticVFSFileClass parent_class;
};

struct _DesktopAgnosticVFSFileGnomeVFSPrivate {
	GnomeVFSURI* _uri;
	char* _uri_str;
};


static gpointer desktop_agnostic_vfs_file_gnome_vfs_parent_class = NULL;

GType desktop_agnostic_vfs_file_gnome_vfs_get_type (void) G_GNUC_CONST;
#define DESKTOP_AGNOSTIC_VFS_FILE_GNOME_VFS_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), DESKTOP_AGNOSTIC_VFS_TYPE_FILE_GNOME_VFS, DesktopAgnosticVFSFileGnomeVFSPrivate))
enum  {
	DESKTOP_AGNOSTIC_VFS_FILE_GNOME_VFS_DUMMY_PROPERTY,
	DESKTOP_AGNOSTIC_VFS_FILE_GNOME_VFS_IMPLEMENTATION,
	DESKTOP_AGNOSTIC_VFS_FILE_GNOME_VFS_IMPL_URI,
	DESKTOP_AGNOSTIC_VFS_FILE_GNOME_VFS_IMPL_PATH,
	DESKTOP_AGNOSTIC_VFS_FILE_GNOME_VFS_FILE_TYPE,
	DESKTOP_AGNOSTIC_VFS_FILE_GNOME_VFS_ACCESS_FLAGS,
	DESKTOP_AGNOSTIC_VFS_FILE_GNOME_VFS_PARENT
};
static void desktop_agnostic_vfs_file_gnome_vfs_real_init (DesktopAgnosticVFSFile* base, const char* uri);
static gboolean desktop_agnostic_vfs_file_gnome_vfs_real_exists (DesktopAgnosticVFSFile* base);
static DesktopAgnosticVFSFileMonitor* desktop_agnostic_vfs_file_gnome_vfs_real_monitor (DesktopAgnosticVFSFile* base);
DesktopAgnosticVFSFileMonitorGnomeVFS* desktop_agnostic_vfs_file_monitor_gnome_vfs_new (DesktopAgnosticVFSFileGnomeVFS* file);
DesktopAgnosticVFSFileMonitorGnomeVFS* desktop_agnostic_vfs_file_monitor_gnome_vfs_construct (GType object_type, DesktopAgnosticVFSFileGnomeVFS* file);
GType desktop_agnostic_vfs_file_monitor_gnome_vfs_get_type (void) G_GNUC_CONST;
static gboolean desktop_agnostic_vfs_file_gnome_vfs_handle_error (DesktopAgnosticVFSFileGnomeVFS* self, GnomeVFSResult res, GError** error);
static gboolean desktop_agnostic_vfs_file_gnome_vfs_real_load_contents (DesktopAgnosticVFSFile* base, char** contents, gsize* length, GError** error);
static gboolean desktop_agnostic_vfs_file_gnome_vfs_real_replace_contents (DesktopAgnosticVFSFile* base, const char* contents, GError** error);
static gboolean desktop_agnostic_vfs_file_gnome_vfs_real_launch (DesktopAgnosticVFSFile* base, GError** error);
static void _g_list_free_g_free (GList* self);
static GSList* desktop_agnostic_vfs_file_gnome_vfs_real_enumerate_children (DesktopAgnosticVFSFile* base, GError** error);
static void _g_slist_free_g_object_unref (GSList* self);
static gboolean desktop_agnostic_vfs_file_gnome_vfs_real_copy (DesktopAgnosticVFSFile* base, DesktopAgnosticVFSFile* destination, gboolean overwrite, GError** error);
static gboolean desktop_agnostic_vfs_file_gnome_vfs_real_remove (DesktopAgnosticVFSFile* base, GError** error);
static gboolean desktop_agnostic_vfs_file_gnome_vfs_real_is_native (DesktopAgnosticVFSFile* base);
static char* desktop_agnostic_vfs_file_gnome_vfs_real_get_mime_type (DesktopAgnosticVFSFile* base, GError** error);
static char** desktop_agnostic_vfs_file_gnome_vfs_real_get_icon_names (DesktopAgnosticVFSFile* base, int* result_length1, GError** error);
DesktopAgnosticVFSFileGnomeVFS* desktop_agnostic_vfs_file_gnome_vfs_new (void);
DesktopAgnosticVFSFileGnomeVFS* desktop_agnostic_vfs_file_gnome_vfs_construct (GType object_type);
static void desktop_agnostic_vfs_file_gnome_vfs_finalize (GObject* obj);
static void desktop_agnostic_vfs_file_gnome_vfs_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static int _vala_strcmp0 (const char * str1, const char * str2);



static void desktop_agnostic_vfs_file_gnome_vfs_real_init (DesktopAgnosticVFSFile* base, const char* uri) {
	DesktopAgnosticVFSFileGnomeVFS * self;
	char* _tmp0_;
	GnomeVFSURI* _tmp1_;
	self = (DesktopAgnosticVFSFileGnomeVFS*) base;
	g_return_if_fail (uri != NULL);
	self->priv->_uri_str = (_tmp0_ = g_strdup (uri), _g_free0 (self->priv->_uri_str), _tmp0_);
	self->priv->_uri = (_tmp1_ = gnome_vfs_uri_new (uri), _gnome_vfs_uri_unref0 (self->priv->_uri), _tmp1_);
}


static gboolean desktop_agnostic_vfs_file_gnome_vfs_real_exists (DesktopAgnosticVFSFile* base) {
	DesktopAgnosticVFSFileGnomeVFS * self;
	gboolean result = FALSE;
	self = (DesktopAgnosticVFSFileGnomeVFS*) base;
	result = gnome_vfs_uri_exists (self->priv->_uri);
	return result;
}


static DesktopAgnosticVFSFileMonitor* desktop_agnostic_vfs_file_gnome_vfs_real_monitor (DesktopAgnosticVFSFile* base) {
	DesktopAgnosticVFSFileGnomeVFS * self;
	DesktopAgnosticVFSFileMonitor* result = NULL;
	self = (DesktopAgnosticVFSFileGnomeVFS*) base;
	result = (DesktopAgnosticVFSFileMonitor*) desktop_agnostic_vfs_file_monitor_gnome_vfs_new (self);
	return result;
}


/**
     * @return %TRUE if it's an error
     */
static gpointer _g_error_copy0 (gpointer self) {
	return self ? g_error_copy (self) : NULL;
}


static gboolean desktop_agnostic_vfs_file_gnome_vfs_handle_error (DesktopAgnosticVFSFileGnomeVFS* self, GnomeVFSResult res, GError** error) {
	gboolean result = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	if (res == GNOME_VFS_OK) {
		result = FALSE;
		return result;
	} else {
		GError* err;
		err = (GError*) g_error_new (g_quark_from_string ("Gnome.VFS"), 0, gnome_vfs_result_to_string (res));
		_inner_error_ = _g_error_copy0 (err);
		{
			g_propagate_error (error, _inner_error_);
			_g_error_free0 (err);
			return FALSE;
		}
		_g_error_free0 (err);
	}
}


static gboolean desktop_agnostic_vfs_file_gnome_vfs_real_load_contents (DesktopAgnosticVFSFile* base, char** contents, gsize* length, GError** error) {
	DesktopAgnosticVFSFileGnomeVFS * self;
	gboolean result = FALSE;
	GnomeVFSFileInfo* info;
	GnomeVFSResult res = 0;
	GnomeVFSHandle* handle;
	gint buffer_length1;
	gint _buffer_size_;
	gchar* buffer;
	GnomeVFSFileInfo* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gchar* _tmp3_;
	gboolean _tmp4_;
	char* _tmp5_;
	gboolean _tmp6_;
	GError * _inner_error_ = NULL;
	self = (DesktopAgnosticVFSFileGnomeVFS*) base;
	if (contents != NULL) {
		*contents = NULL;
	}
	info = NULL;
	handle = NULL;
	buffer = (buffer_length1 = 0, NULL);
	info = (_tmp0_ = gnome_vfs_file_info_new (), _gnome_vfs_file_info_unref0 (info), _tmp0_);
	res = gnome_vfs_get_file_info_uri (self->priv->_uri, info, GNOME_VFS_FILE_INFO_DEFAULT);
	_tmp1_ = desktop_agnostic_vfs_file_gnome_vfs_handle_error (self, res, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		buffer = (g_free (buffer), NULL);
		_gnome_vfs_file_info_unref0 (info);
		return FALSE;
	}
	if (_tmp1_) {
		result = FALSE;
		buffer = (g_free (buffer), NULL);
		_gnome_vfs_file_info_unref0 (info);
		return result;
	}
	res = gnome_vfs_open_uri (&handle, self->priv->_uri, GNOME_VFS_OPEN_READ);
	_tmp2_ = desktop_agnostic_vfs_file_gnome_vfs_handle_error (self, res, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		buffer = (g_free (buffer), NULL);
		_gnome_vfs_file_info_unref0 (info);
		return FALSE;
	}
	if (_tmp2_) {
		result = FALSE;
		buffer = (g_free (buffer), NULL);
		_gnome_vfs_file_info_unref0 (info);
		return result;
	}
	buffer = (_tmp3_ = g_new0 (gchar, (gint) info->size), buffer = (g_free (buffer), NULL), buffer_length1 = (gint) info->size, _buffer_size_ = buffer_length1, _tmp3_);
	res = gnome_vfs_read (handle, (void*) buffer, info->size, NULL);
	_tmp4_ = desktop_agnostic_vfs_file_gnome_vfs_handle_error (self, res, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		buffer = (g_free (buffer), NULL);
		_gnome_vfs_file_info_unref0 (info);
		return FALSE;
	}
	if (_tmp4_) {
		result = FALSE;
		buffer = (g_free (buffer), NULL);
		_gnome_vfs_file_info_unref0 (info);
		return result;
	}
	*contents = (_tmp5_ = g_strdup ((const char*) buffer), _g_free0 (*contents), _tmp5_);
	res = gnome_vfs_close (handle);
	_tmp6_ = desktop_agnostic_vfs_file_gnome_vfs_handle_error (self, res, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		buffer = (g_free (buffer), NULL);
		_gnome_vfs_file_info_unref0 (info);
		return FALSE;
	}
	if (_tmp6_) {
		result = FALSE;
		buffer = (g_free (buffer), NULL);
		_gnome_vfs_file_info_unref0 (info);
		return result;
	}
	result = TRUE;
	buffer = (g_free (buffer), NULL);
	_gnome_vfs_file_info_unref0 (info);
	return result;
}


static gboolean desktop_agnostic_vfs_file_gnome_vfs_real_replace_contents (DesktopAgnosticVFSFile* base, const char* contents, GError** error) {
	DesktopAgnosticVFSFileGnomeVFS * self;
	gboolean result = FALSE;
	GnomeVFSResult res = 0;
	GnomeVFSHandle* handle;
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	GError * _inner_error_ = NULL;
	self = (DesktopAgnosticVFSFileGnomeVFS*) base;
	g_return_val_if_fail (contents != NULL, FALSE);
	handle = NULL;
	if (desktop_agnostic_vfs_file_exists ((DesktopAgnosticVFSFile*) self)) {
		res = gnome_vfs_open_uri (&handle, self->priv->_uri, GNOME_VFS_OPEN_WRITE);
	} else {
		res = gnome_vfs_create_uri (&handle, self->priv->_uri, GNOME_VFS_OPEN_WRITE, TRUE, (guint) 0644);
	}
	_tmp0_ = desktop_agnostic_vfs_file_gnome_vfs_handle_error (self, res, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return FALSE;
	}
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	res = gnome_vfs_write (handle, (void*) contents, (GnomeVFSFileSize) strlen (contents), NULL);
	_tmp1_ = desktop_agnostic_vfs_file_gnome_vfs_handle_error (self, res, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return FALSE;
	}
	if (_tmp1_) {
		result = FALSE;
		return result;
	}
	res = gnome_vfs_close (handle);
	_tmp2_ = desktop_agnostic_vfs_file_gnome_vfs_handle_error (self, res, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return FALSE;
	}
	if (_tmp2_) {
		result = FALSE;
		return result;
	}
	result = TRUE;
	return result;
}


static void _g_list_free_g_free (GList* self) {
	g_list_foreach (self, (GFunc) g_free, NULL);
	g_list_free (self);
}


static gboolean desktop_agnostic_vfs_file_gnome_vfs_real_launch (DesktopAgnosticVFSFile* base, GError** error) {
	DesktopAgnosticVFSFileGnomeVFS * self;
	gboolean result = FALSE;
	GnomeVFSFileInfo* info;
	GnomeVFSMimeApplication* mime_app;
	GList* uris;
	GnomeVFSFileInfo* _tmp0_;
	self = (DesktopAgnosticVFSFileGnomeVFS*) base;
	info = NULL;
	mime_app = NULL;
	uris = NULL;
	info = (_tmp0_ = gnome_vfs_file_info_new (), _gnome_vfs_file_info_unref0 (info), _tmp0_);
	gnome_vfs_get_file_info_uri (self->priv->_uri, info, GNOME_VFS_FILE_INFO_GET_MIME_TYPE);
	mime_app = gnome_vfs_mime_get_default_application_for_uri (self->priv->_uri_str, info->mime_type);
	uris = g_list_append (uris, g_strdup (self->priv->_uri_str));
	result = gnome_vfs_mime_application_launch (mime_app, uris) == GNOME_VFS_OK;
	__g_list_free_g_free0 (uris);
	_gnome_vfs_file_info_unref0 (info);
	return result;
}


static void _g_slist_free_g_object_unref (GSList* self) {
	g_slist_foreach (self, (GFunc) g_object_unref, NULL);
	g_slist_free (self);
}


static GSList* desktop_agnostic_vfs_file_gnome_vfs_real_enumerate_children (DesktopAgnosticVFSFile* base, GError** error) {
	DesktopAgnosticVFSFileGnomeVFS * self;
	GSList* result = NULL;
	GSList* _result_;
	GnomeVFSDirectoryHandle* dir;
	GnomeVFSResult res = 0;
	GSList* _tmp0_;
	GError * _inner_error_ = NULL;
	self = (DesktopAgnosticVFSFileGnomeVFS*) base;
	_result_ = NULL;
	dir = NULL;
	_result_ = (_tmp0_ = NULL, __g_slist_free_g_object_unref0 (_result_), _tmp0_);
	res = gnome_vfs_directory_open_from_uri (&dir, self->priv->_uri, GNOME_VFS_FILE_INFO_NAME_ONLY);
	if (res == GNOME_VFS_OK) {
		GnomeVFSFileInfo* file_info;
		file_info = gnome_vfs_file_info_new ();
		while (TRUE) {
			gboolean _tmp1_ = FALSE;
			if (!((res = gnome_vfs_directory_read_next (dir, file_info)) == GNOME_VFS_OK)) {
				break;
			}
			if (_vala_strcmp0 (file_info->name, ".") != 0) {
				_tmp1_ = _vala_strcmp0 (file_info->name, "..") != 0;
			} else {
				_tmp1_ = FALSE;
			}
			if (_tmp1_) {
				char* full_uri;
				DesktopAgnosticVFSFile* child;
				char* _tmp2_;
				DesktopAgnosticVFSFile* _tmp3_;
				DesktopAgnosticVFSFile* _tmp4_;
				DesktopAgnosticVFSFile* _tmp5_;
				full_uri = NULL;
				child = NULL;
				full_uri = (_tmp2_ = g_strdup_printf ("%s/%s", self->priv->_uri_str, gnome_vfs_escape_string (file_info->name)), _g_free0 (full_uri), _tmp2_);
				_tmp3_ = desktop_agnostic_vfs_file_new_for_uri (full_uri, &_inner_error_);
				if (_inner_error_ != NULL) {
					g_propagate_error (error, _inner_error_);
					_g_object_unref0 (child);
					_g_free0 (full_uri);
					_gnome_vfs_file_info_unref0 (file_info);
					__g_slist_free_g_object_unref0 (_result_);
					return NULL;
				}
				child = (_tmp4_ = _tmp3_, _g_object_unref0 (child), _tmp4_);
				_result_ = g_slist_append (_result_, (_tmp5_ = child, child = NULL, _tmp5_));
				_g_object_unref0 (child);
				_g_free0 (full_uri);
			}
		}
		gnome_vfs_directory_close (dir);
		_gnome_vfs_file_info_unref0 (file_info);
	} else {
		_inner_error_ = g_error_new (DESKTOP_AGNOSTIC_VFS_FILE_ERROR, DESKTOP_AGNOSTIC_VFS_FILE_ERROR_INVALID_TYPE, "VFS Error: %s", gnome_vfs_result_to_string (res));
		{
			g_propagate_error (error, _inner_error_);
			__g_slist_free_g_object_unref0 (_result_);
			return NULL;
		}
	}
	result = _result_;
	return result;
}


static gboolean desktop_agnostic_vfs_file_gnome_vfs_real_copy (DesktopAgnosticVFSFile* base, DesktopAgnosticVFSFile* destination, gboolean overwrite, GError** error) {
	DesktopAgnosticVFSFileGnomeVFS * self;
	gboolean result = FALSE;
	GnomeVFSXferOverwriteMode overwrite_mode = 0;
	GnomeVFSResult res = 0;
	self = (DesktopAgnosticVFSFileGnomeVFS*) base;
	g_return_val_if_fail (destination != NULL, FALSE);
	if (overwrite) {
		overwrite_mode = GNOME_VFS_XFER_OVERWRITE_MODE_REPLACE;
	} else {
		overwrite_mode = GNOME_VFS_XFER_OVERWRITE_MODE_ABORT;
	}
	res = gnome_vfs_xfer_uri ((GnomeVFSURI*) desktop_agnostic_vfs_file_get_implementation ((DesktopAgnosticVFSFile*) self), (GnomeVFSURI*) desktop_agnostic_vfs_file_get_implementation (destination), GNOME_VFS_XFER_DEFAULT, GNOME_VFS_XFER_ERROR_MODE_ABORT, overwrite_mode, NULL, NULL);
	result = res == GNOME_VFS_OK;
	return result;
}


static gboolean desktop_agnostic_vfs_file_gnome_vfs_real_remove (DesktopAgnosticVFSFile* base, GError** error) {
	DesktopAgnosticVFSFileGnomeVFS * self;
	gboolean result = FALSE;
	GError * _inner_error_ = NULL;
	self = (DesktopAgnosticVFSFileGnomeVFS*) base;
	if (!desktop_agnostic_vfs_file_exists ((DesktopAgnosticVFSFile*) self)) {
		char* _tmp0_;
		GError* _tmp1_;
		_inner_error_ = (_tmp1_ = g_error_new (DESKTOP_AGNOSTIC_VFS_FILE_ERROR, DESKTOP_AGNOSTIC_VFS_FILE_ERROR_FILE_NOT_FOUND, "The file '%s' does not exist.", _tmp0_ = desktop_agnostic_vfs_file_get_uri ((DesktopAgnosticVFSFile*) self)), _g_free0 (_tmp0_), _tmp1_);
		{
			g_propagate_error (error, _inner_error_);
			return FALSE;
		}
	}
	result = gnome_vfs_unlink_from_uri (self->priv->_uri) == GNOME_VFS_OK;
	return result;
}


static gboolean desktop_agnostic_vfs_file_gnome_vfs_real_is_native (DesktopAgnosticVFSFile* base) {
	DesktopAgnosticVFSFileGnomeVFS * self;
	gboolean result = FALSE;
	self = (DesktopAgnosticVFSFileGnomeVFS*) base;
	result = g_str_has_prefix (self->priv->_uri_str, "file:");
	return result;
}


static char* desktop_agnostic_vfs_file_gnome_vfs_real_get_mime_type (DesktopAgnosticVFSFile* base, GError** error) {
	DesktopAgnosticVFSFileGnomeVFS * self;
	char* result = NULL;
	self = (DesktopAgnosticVFSFileGnomeVFS*) base;
	result = g_strdup (gnome_vfs_get_mime_type_from_uri (self->priv->_uri));
	return result;
}


static char** desktop_agnostic_vfs_file_gnome_vfs_real_get_icon_names (DesktopAgnosticVFSFile* base, int* result_length1, GError** error) {
	DesktopAgnosticVFSFileGnomeVFS * self;
	char** result = NULL;
	char* _tmp0_;
	char* _tmp1_;
	gint _tmp2_;
	char** _tmp3_;
	char** _tmp4_;
	GError * _inner_error_ = NULL;
	self = (DesktopAgnosticVFSFileGnomeVFS*) base;
	_tmp0_ = desktop_agnostic_vfs_file_get_mime_type ((DesktopAgnosticVFSFile*) self, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return NULL;
	}
	result = (_tmp4_ = (_tmp3_ = desktop_agnostic_vfs_get_icon_names_for_mime_type (_tmp1_ = _tmp0_, &_tmp2_), _g_free0 (_tmp1_), _tmp3_), *result_length1 = _tmp2_, _tmp4_);
	return result;
}


DesktopAgnosticVFSFileGnomeVFS* desktop_agnostic_vfs_file_gnome_vfs_construct (GType object_type) {
	DesktopAgnosticVFSFileGnomeVFS * self = NULL;
	self = (DesktopAgnosticVFSFileGnomeVFS*) desktop_agnostic_vfs_file_construct (object_type);
	return self;
}


DesktopAgnosticVFSFileGnomeVFS* desktop_agnostic_vfs_file_gnome_vfs_new (void) {
	return desktop_agnostic_vfs_file_gnome_vfs_construct (DESKTOP_AGNOSTIC_VFS_TYPE_FILE_GNOME_VFS);
}


static void* desktop_agnostic_vfs_file_gnome_vfs_real_get_implementation (DesktopAgnosticVFSFile* base) {
	void* result;
	DesktopAgnosticVFSFileGnomeVFS* self;
	self = (DesktopAgnosticVFSFileGnomeVFS*) base;
	result = (void*) self->priv->_uri;
	return result;
}


static char* desktop_agnostic_vfs_file_gnome_vfs_real_get_impl_uri (DesktopAgnosticVFSFile* base) {
	char* result;
	DesktopAgnosticVFSFileGnomeVFS* self;
	self = (DesktopAgnosticVFSFileGnomeVFS*) base;
	result = g_strdup (self->priv->_uri_str);
	return result;
}


static char* desktop_agnostic_vfs_file_gnome_vfs_real_get_impl_path (DesktopAgnosticVFSFile* base) {
	char* result;
	DesktopAgnosticVFSFileGnomeVFS* self;
	self = (DesktopAgnosticVFSFileGnomeVFS*) base;
	result = g_strdup (gnome_vfs_uri_get_path (self->priv->_uri));
	return result;
}


static DesktopAgnosticVFSFileType desktop_agnostic_vfs_file_gnome_vfs_real_get_file_type (DesktopAgnosticVFSFile* base) {
	DesktopAgnosticVFSFileType result;
	DesktopAgnosticVFSFileGnomeVFS* self;
	DesktopAgnosticVFSFileType ft = 0;
	self = (DesktopAgnosticVFSFileGnomeVFS*) base;
	if (desktop_agnostic_vfs_file_exists ((DesktopAgnosticVFSFile*) self)) {
		GnomeVFSFileInfo* info;
		info = gnome_vfs_file_info_new ();
		gnome_vfs_get_file_info_uri (self->priv->_uri, info, GNOME_VFS_FILE_INFO_DEFAULT);
		switch (info->type) {
			case GNOME_VFS_FILE_TYPE_REGULAR:
			{
				ft = DESKTOP_AGNOSTIC_VFS_FILE_TYPE_REGULAR;
				break;
			}
			case GNOME_VFS_FILE_TYPE_DIRECTORY:
			{
				ft = DESKTOP_AGNOSTIC_VFS_FILE_TYPE_DIRECTORY;
				break;
			}
			case GNOME_VFS_FILE_TYPE_SYMBOLIC_LINK:
			{
				ft = DESKTOP_AGNOSTIC_VFS_FILE_TYPE_SYMBOLIC_LINK;
				break;
			}
			case GNOME_VFS_FILE_TYPE_FIFO:
			case GNOME_VFS_FILE_TYPE_SOCKET:
			case GNOME_VFS_FILE_TYPE_CHARACTER_DEVICE:
			case GNOME_VFS_FILE_TYPE_BLOCK_DEVICE:
			{
				ft = DESKTOP_AGNOSTIC_VFS_FILE_TYPE_SPECIAL;
				break;
			}
			default:
			{
				ft = DESKTOP_AGNOSTIC_VFS_FILE_TYPE_UNKNOWN;
				break;
			}
		}
		_gnome_vfs_file_info_unref0 (info);
	} else {
		ft = DESKTOP_AGNOSTIC_VFS_FILE_TYPE_UNKNOWN;
	}
	result = ft;
	return result;
}


static DesktopAgnosticVFSAccessFlags desktop_agnostic_vfs_file_gnome_vfs_real_get_access_flags (DesktopAgnosticVFSFile* base) {
	DesktopAgnosticVFSAccessFlags result;
	DesktopAgnosticVFSFileGnomeVFS* self;
	DesktopAgnosticVFSAccessFlags flags;
	self = (DesktopAgnosticVFSFileGnomeVFS*) base;
	flags = DESKTOP_AGNOSTIC_VFS_ACCESS_FLAGS_NONE;
	if (desktop_agnostic_vfs_file_exists ((DesktopAgnosticVFSFile*) self)) {
		GnomeVFSFileInfo* info;
		GnomeVFSFileInfoOptions options = 0;
		info = gnome_vfs_file_info_new ();
		options = GNOME_VFS_FILE_INFO_GET_ACCESS_RIGHTS;
		gnome_vfs_get_file_info_uri (self->priv->_uri, info, options);
		if ((info->permissions & GNOME_VFS_PERM_ACCESS_READABLE) != 0) {
			flags = flags | DESKTOP_AGNOSTIC_VFS_ACCESS_FLAGS_READ;
		}
		if ((info->permissions & GNOME_VFS_PERM_ACCESS_WRITABLE) != 0) {
			flags = flags | DESKTOP_AGNOSTIC_VFS_ACCESS_FLAGS_WRITE;
		}
		if ((info->permissions & GNOME_VFS_PERM_ACCESS_EXECUTABLE) != 0) {
			flags = flags | DESKTOP_AGNOSTIC_VFS_ACCESS_FLAGS_EXECUTE;
		}
		_gnome_vfs_file_info_unref0 (info);
	}
	result = flags;
	return result;
}


static DesktopAgnosticVFSFile* desktop_agnostic_vfs_file_gnome_vfs_real_get_parent (DesktopAgnosticVFSFile* base) {
	DesktopAgnosticVFSFile* result;
	DesktopAgnosticVFSFileGnomeVFS* self;
	GnomeVFSURI* uri;
	self = (DesktopAgnosticVFSFileGnomeVFS*) base;
	uri = NULL;
	uri = gnome_vfs_uri_get_parent (self->priv->_uri);
	if (uri == NULL) {
		result = NULL;
		return result;
	} else {
		DesktopAgnosticVFSFile* _result_;
		DesktopAgnosticVFSFile* _tmp0_;
		_result_ = NULL;
		_result_ = (_tmp0_ = (DesktopAgnosticVFSFile*) desktop_agnostic_vfs_file_gnome_vfs_new (), _g_object_unref0 (_result_), _tmp0_);
		desktop_agnostic_vfs_file_init (_result_, gnome_vfs_uri_to_string (uri, GNOME_VFS_URI_HIDE_NONE));
		result = _result_;
		return result;
	}
}


static void desktop_agnostic_vfs_file_gnome_vfs_class_init (DesktopAgnosticVFSFileGnomeVFSClass * klass) {
	desktop_agnostic_vfs_file_gnome_vfs_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DesktopAgnosticVFSFileGnomeVFSPrivate));
	DESKTOP_AGNOSTIC_VFS_FILE_CLASS (klass)->init = desktop_agnostic_vfs_file_gnome_vfs_real_init;
	DESKTOP_AGNOSTIC_VFS_FILE_CLASS (klass)->exists = desktop_agnostic_vfs_file_gnome_vfs_real_exists;
	DESKTOP_AGNOSTIC_VFS_FILE_CLASS (klass)->monitor = desktop_agnostic_vfs_file_gnome_vfs_real_monitor;
	DESKTOP_AGNOSTIC_VFS_FILE_CLASS (klass)->load_contents = desktop_agnostic_vfs_file_gnome_vfs_real_load_contents;
	DESKTOP_AGNOSTIC_VFS_FILE_CLASS (klass)->replace_contents = desktop_agnostic_vfs_file_gnome_vfs_real_replace_contents;
	DESKTOP_AGNOSTIC_VFS_FILE_CLASS (klass)->launch = desktop_agnostic_vfs_file_gnome_vfs_real_launch;
	DESKTOP_AGNOSTIC_VFS_FILE_CLASS (klass)->enumerate_children = desktop_agnostic_vfs_file_gnome_vfs_real_enumerate_children;
	DESKTOP_AGNOSTIC_VFS_FILE_CLASS (klass)->copy = desktop_agnostic_vfs_file_gnome_vfs_real_copy;
	DESKTOP_AGNOSTIC_VFS_FILE_CLASS (klass)->remove = desktop_agnostic_vfs_file_gnome_vfs_real_remove;
	DESKTOP_AGNOSTIC_VFS_FILE_CLASS (klass)->is_native = desktop_agnostic_vfs_file_gnome_vfs_real_is_native;
	DESKTOP_AGNOSTIC_VFS_FILE_CLASS (klass)->get_mime_type = desktop_agnostic_vfs_file_gnome_vfs_real_get_mime_type;
	DESKTOP_AGNOSTIC_VFS_FILE_CLASS (klass)->get_icon_names = desktop_agnostic_vfs_file_gnome_vfs_real_get_icon_names;
	DESKTOP_AGNOSTIC_VFS_FILE_CLASS (klass)->get_implementation = desktop_agnostic_vfs_file_gnome_vfs_real_get_implementation;
	DESKTOP_AGNOSTIC_VFS_FILE_CLASS (klass)->get_impl_uri = desktop_agnostic_vfs_file_gnome_vfs_real_get_impl_uri;
	DESKTOP_AGNOSTIC_VFS_FILE_CLASS (klass)->get_impl_path = desktop_agnostic_vfs_file_gnome_vfs_real_get_impl_path;
	DESKTOP_AGNOSTIC_VFS_FILE_CLASS (klass)->get_file_type = desktop_agnostic_vfs_file_gnome_vfs_real_get_file_type;
	DESKTOP_AGNOSTIC_VFS_FILE_CLASS (klass)->get_access_flags = desktop_agnostic_vfs_file_gnome_vfs_real_get_access_flags;
	DESKTOP_AGNOSTIC_VFS_FILE_CLASS (klass)->get_parent = desktop_agnostic_vfs_file_gnome_vfs_real_get_parent;
	G_OBJECT_CLASS (klass)->get_property = desktop_agnostic_vfs_file_gnome_vfs_get_property;
	G_OBJECT_CLASS (klass)->finalize = desktop_agnostic_vfs_file_gnome_vfs_finalize;
	g_object_class_override_property (G_OBJECT_CLASS (klass), DESKTOP_AGNOSTIC_VFS_FILE_GNOME_VFS_IMPLEMENTATION, "implementation");
	g_object_class_override_property (G_OBJECT_CLASS (klass), DESKTOP_AGNOSTIC_VFS_FILE_GNOME_VFS_IMPL_URI, "impl-uri");
	g_object_class_override_property (G_OBJECT_CLASS (klass), DESKTOP_AGNOSTIC_VFS_FILE_GNOME_VFS_IMPL_PATH, "impl-path");
	g_object_class_override_property (G_OBJECT_CLASS (klass), DESKTOP_AGNOSTIC_VFS_FILE_GNOME_VFS_FILE_TYPE, "file-type");
	g_object_class_override_property (G_OBJECT_CLASS (klass), DESKTOP_AGNOSTIC_VFS_FILE_GNOME_VFS_ACCESS_FLAGS, "access-flags");
	g_object_class_override_property (G_OBJECT_CLASS (klass), DESKTOP_AGNOSTIC_VFS_FILE_GNOME_VFS_PARENT, "parent");
}


static void desktop_agnostic_vfs_file_gnome_vfs_instance_init (DesktopAgnosticVFSFileGnomeVFS * self) {
	self->priv = DESKTOP_AGNOSTIC_VFS_FILE_GNOME_VFS_GET_PRIVATE (self);
}


static void desktop_agnostic_vfs_file_gnome_vfs_finalize (GObject* obj) {
	DesktopAgnosticVFSFileGnomeVFS * self;
	self = DESKTOP_AGNOSTIC_VFS_FILE_GNOME_VFS (obj);
	_gnome_vfs_uri_unref0 (self->priv->_uri);
	_g_free0 (self->priv->_uri_str);
	G_OBJECT_CLASS (desktop_agnostic_vfs_file_gnome_vfs_parent_class)->finalize (obj);
}


GType desktop_agnostic_vfs_file_gnome_vfs_get_type (void) {
	static volatile gsize desktop_agnostic_vfs_file_gnome_vfs_type_id__volatile = 0;
	if (g_once_init_enter (&desktop_agnostic_vfs_file_gnome_vfs_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DesktopAgnosticVFSFileGnomeVFSClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) desktop_agnostic_vfs_file_gnome_vfs_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DesktopAgnosticVFSFileGnomeVFS), 0, (GInstanceInitFunc) desktop_agnostic_vfs_file_gnome_vfs_instance_init, NULL };
		GType desktop_agnostic_vfs_file_gnome_vfs_type_id;
		desktop_agnostic_vfs_file_gnome_vfs_type_id = g_type_register_static (DESKTOP_AGNOSTIC_VFS_TYPE_FILE, "DesktopAgnosticVFSFileGnomeVFS", &g_define_type_info, 0);
		g_once_init_leave (&desktop_agnostic_vfs_file_gnome_vfs_type_id__volatile, desktop_agnostic_vfs_file_gnome_vfs_type_id);
	}
	return desktop_agnostic_vfs_file_gnome_vfs_type_id__volatile;
}


static void desktop_agnostic_vfs_file_gnome_vfs_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	DesktopAgnosticVFSFileGnomeVFS * self;
	self = DESKTOP_AGNOSTIC_VFS_FILE_GNOME_VFS (object);
	switch (property_id) {
		case DESKTOP_AGNOSTIC_VFS_FILE_GNOME_VFS_IMPLEMENTATION:
		g_value_set_pointer (value, desktop_agnostic_vfs_file_get_implementation ((DesktopAgnosticVFSFile*) self));
		break;
		case DESKTOP_AGNOSTIC_VFS_FILE_GNOME_VFS_IMPL_URI:
		g_value_take_string (value, desktop_agnostic_vfs_file_get_impl_uri ((DesktopAgnosticVFSFile*) self));
		break;
		case DESKTOP_AGNOSTIC_VFS_FILE_GNOME_VFS_IMPL_PATH:
		g_value_take_string (value, desktop_agnostic_vfs_file_get_impl_path ((DesktopAgnosticVFSFile*) self));
		break;
		case DESKTOP_AGNOSTIC_VFS_FILE_GNOME_VFS_FILE_TYPE:
		g_value_set_enum (value, desktop_agnostic_vfs_file_get_file_type ((DesktopAgnosticVFSFile*) self));
		break;
		case DESKTOP_AGNOSTIC_VFS_FILE_GNOME_VFS_ACCESS_FLAGS:
		g_value_set_enum (value, desktop_agnostic_vfs_file_get_access_flags ((DesktopAgnosticVFSFile*) self));
		break;
		case DESKTOP_AGNOSTIC_VFS_FILE_GNOME_VFS_PARENT:
		g_value_take_object (value, desktop_agnostic_vfs_file_get_parent ((DesktopAgnosticVFSFile*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




