/* network.c generated by valac 0.16.1, the Vala compiler
 * generated from network.vala, do not modify */

/*
 * Copyright (C) 2011-2012 Simon Busch <morphis@gravedo.de>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <netinet/in.h>
#include <linux/if.h>
#include <sys/ioctl.h>
#include <errno.h>
#include <sys/socket.h>
#include <unistd.h>
#include <linux/wireless.h>
#include <gobject/gvaluecollector.h>


#define FSO_FRAMEWORK_NETWORK_TYPE_INTERFACE (fso_framework_network_interface_get_type ())
#define FSO_FRAMEWORK_NETWORK_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FSO_FRAMEWORK_NETWORK_TYPE_INTERFACE, FsoFrameworkNetworkInterface))
#define FSO_FRAMEWORK_NETWORK_INTERFACE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FSO_FRAMEWORK_NETWORK_TYPE_INTERFACE, FsoFrameworkNetworkInterfaceClass))
#define FSO_FRAMEWORK_NETWORK_IS_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FSO_FRAMEWORK_NETWORK_TYPE_INTERFACE))
#define FSO_FRAMEWORK_NETWORK_IS_INTERFACE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FSO_FRAMEWORK_NETWORK_TYPE_INTERFACE))
#define FSO_FRAMEWORK_NETWORK_INTERFACE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FSO_FRAMEWORK_NETWORK_TYPE_INTERFACE, FsoFrameworkNetworkInterfaceClass))

typedef struct _FsoFrameworkNetworkInterface FsoFrameworkNetworkInterface;
typedef struct _FsoFrameworkNetworkInterfaceClass FsoFrameworkNetworkInterfaceClass;
typedef struct _FsoFrameworkNetworkInterfacePrivate FsoFrameworkNetworkInterfacePrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _fso_framework_network_interface_unref0(var) ((var == NULL) ? NULL : (var = (fso_framework_network_interface_unref (var), NULL)))
typedef struct _FsoFrameworkNetworkParamSpecInterface FsoFrameworkNetworkParamSpecInterface;

#define FSO_FRAMEWORK_NETWORK_TYPE_WEXT_INTERFACE (fso_framework_network_wext_interface_get_type ())
#define FSO_FRAMEWORK_NETWORK_WEXT_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FSO_FRAMEWORK_NETWORK_TYPE_WEXT_INTERFACE, FsoFrameworkNetworkWextInterface))
#define FSO_FRAMEWORK_NETWORK_WEXT_INTERFACE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FSO_FRAMEWORK_NETWORK_TYPE_WEXT_INTERFACE, FsoFrameworkNetworkWextInterfaceClass))
#define FSO_FRAMEWORK_NETWORK_IS_WEXT_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FSO_FRAMEWORK_NETWORK_TYPE_WEXT_INTERFACE))
#define FSO_FRAMEWORK_NETWORK_IS_WEXT_INTERFACE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FSO_FRAMEWORK_NETWORK_TYPE_WEXT_INTERFACE))
#define FSO_FRAMEWORK_NETWORK_WEXT_INTERFACE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FSO_FRAMEWORK_NETWORK_TYPE_WEXT_INTERFACE, FsoFrameworkNetworkWextInterfaceClass))

typedef struct _FsoFrameworkNetworkWextInterface FsoFrameworkNetworkWextInterface;
typedef struct _FsoFrameworkNetworkWextInterfaceClass FsoFrameworkNetworkWextInterfaceClass;
typedef struct _FsoFrameworkNetworkWextInterfacePrivate FsoFrameworkNetworkWextInterfacePrivate;

typedef enum  {
	FSO_FRAMEWORK_NETWORK_ERROR_INTERNAL_ERROR
} FsoFrameworkNetworkError;
#define FSO_FRAMEWORK_NETWORK_ERROR fso_framework_network_error_quark ()
struct _FsoFrameworkNetworkInterface {
	GTypeInstance parent_instance;
	volatile int ref_count;
	FsoFrameworkNetworkInterfacePrivate * priv;
	gint fd;
	gchar* name;
	gint index;
};

struct _FsoFrameworkNetworkInterfaceClass {
	GTypeClass parent_class;
	void (*finalize) (FsoFrameworkNetworkInterface *self);
};

struct _FsoFrameworkNetworkParamSpecInterface {
	GParamSpec parent_instance;
};

struct _FsoFrameworkNetworkWextInterface {
	FsoFrameworkNetworkInterface parent_instance;
	FsoFrameworkNetworkWextInterfacePrivate * priv;
};

struct _FsoFrameworkNetworkWextInterfaceClass {
	FsoFrameworkNetworkInterfaceClass parent_class;
};


static gpointer fso_framework_network_interface_parent_class = NULL;
static gpointer fso_framework_network_wext_interface_parent_class = NULL;

GQuark fso_framework_network_error_quark (void);
gpointer fso_framework_network_interface_ref (gpointer instance);
void fso_framework_network_interface_unref (gpointer instance);
GParamSpec* fso_framework_network_param_spec_interface (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void fso_framework_network_value_set_interface (GValue* value, gpointer v_object);
void fso_framework_network_value_take_interface (GValue* value, gpointer v_object);
gpointer fso_framework_network_value_get_interface (const GValue* value);
GType fso_framework_network_interface_get_type (void) G_GNUC_CONST;
enum  {
	FSO_FRAMEWORK_NETWORK_INTERFACE_DUMMY_PROPERTY
};
void fso_framework_network_interface_finish (FsoFrameworkNetworkInterface* self);
static gboolean fso_framework_network_interface_check_flags (FsoFrameworkNetworkInterface* self, guint flags, GError** error);
static gboolean fso_framework_network_interface_set_flags (FsoFrameworkNetworkInterface* self, guint set, guint clr);
static void fso_framework_network_interface_setup_interface_index (FsoFrameworkNetworkInterface* self, GError** error);
FsoFrameworkNetworkInterface* fso_framework_network_interface_new (const gchar* name, GError** error);
FsoFrameworkNetworkInterface* fso_framework_network_interface_construct (GType object_type, const gchar* name, GError** error);
void fso_framework_network_interface_up (FsoFrameworkNetworkInterface* self, GError** error);
gboolean fso_framework_network_interface_is_up (FsoFrameworkNetworkInterface* self, GError** error);
void fso_framework_network_interface_down (FsoFrameworkNetworkInterface* self, GError** error);
static void fso_framework_network_interface_finalize (FsoFrameworkNetworkInterface* obj);
GType fso_framework_network_wext_interface_get_type (void) G_GNUC_CONST;
enum  {
	FSO_FRAMEWORK_NETWORK_WEXT_INTERFACE_DUMMY_PROPERTY
};
FsoFrameworkNetworkWextInterface* fso_framework_network_wext_interface_new (const gchar* name, GError** error);
FsoFrameworkNetworkWextInterface* fso_framework_network_wext_interface_construct (GType object_type, const gchar* name, GError** error);
void fso_framework_network_wext_interface_set_power (FsoFrameworkNetworkWextInterface* self, gboolean on, GError** error);


GQuark fso_framework_network_error_quark (void) {
	return g_quark_from_static_string ("fso_framework_network_error-quark");
}


static gboolean fso_framework_network_interface_check_flags (FsoFrameworkNetworkInterface* self, guint flags, GError** error) {
	gboolean result = FALSE;
	struct ifreq ifr = {0};
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_ = 0;
	gint _tmp4_;
	gint _tmp5_ = 0;
	struct ifreq _tmp7_;
	gshort _tmp8_;
	guint _tmp9_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	memset (&ifr, 0, sizeof (struct ifreq));
	_tmp0_ = self->index;
	ifr.ifr_ifindex = _tmp0_;
	_tmp1_ = self->fd;
	_tmp2_ = ioctl (_tmp1_, SIOCGIFNAME, &ifr);
	if (_tmp2_ < 0) {
		GError* _tmp3_;
		_tmp3_ = g_error_new_literal (FSO_FRAMEWORK_NETWORK_ERROR, FSO_FRAMEWORK_NETWORK_ERROR_INTERNAL_ERROR, "Could not set interface name " "for request: $(Posix.strerror(Posix.errno))");
		_inner_error_ = _tmp3_;
		if (_inner_error_->domain == FSO_FRAMEWORK_NETWORK_ERROR) {
			g_propagate_error (error, _inner_error_);
			 (&ifr);
			return FALSE;
		} else {
			 (&ifr);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	_tmp4_ = self->fd;
	_tmp5_ = ioctl (_tmp4_, SIOCGIFFLAGS, &ifr);
	if (_tmp5_ < 0) {
		GError* _tmp6_;
		_tmp6_ = g_error_new_literal (FSO_FRAMEWORK_NETWORK_ERROR, FSO_FRAMEWORK_NETWORK_ERROR_INTERNAL_ERROR, "Could not process ioctl to gather " "interface status: $(Posix.strerror(Posix.errno))");
		_inner_error_ = _tmp6_;
		if (_inner_error_->domain == FSO_FRAMEWORK_NETWORK_ERROR) {
			g_propagate_error (error, _inner_error_);
			 (&ifr);
			return FALSE;
		} else {
			 (&ifr);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	_tmp7_ = ifr;
	_tmp8_ = _tmp7_.ifr_flags;
	_tmp9_ = flags;
	result = (gboolean) (_tmp8_ & _tmp9_);
	 (&ifr);
	return result;
}


/**
         * Set flags for interface. With @param set you specify the flag you want to set
           and with @param clr the flag you want to unset.
         **/
static gboolean fso_framework_network_interface_set_flags (FsoFrameworkNetworkInterface* self, guint set, guint clr) {
	gboolean result = FALSE;
	struct ifreq ifr = {0};
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_ = 0;
	gint _tmp4_;
	gint _tmp5_ = 0;
	struct ifreq _tmp6_;
	gshort _tmp7_;
	guint _tmp8_;
	guint _tmp9_;
	gint _tmp10_;
	gint _tmp11_ = 0;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	memset (&ifr, 0, sizeof (struct ifreq));
	_tmp0_ = self->index;
	ifr.ifr_ifindex = _tmp0_;
	_tmp1_ = self->fd;
	_tmp2_ = ioctl (_tmp1_, SIOCGIFNAME, &ifr);
	if (_tmp2_ < 0) {
		GError* _tmp3_;
		_tmp3_ = g_error_new_literal (FSO_FRAMEWORK_NETWORK_ERROR, FSO_FRAMEWORK_NETWORK_ERROR_INTERNAL_ERROR, "Could not set interface name " "for request: $(Posix.strerror(Posix.errno))");
		_inner_error_ = _tmp3_;
		 (&ifr);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	_tmp4_ = self->fd;
	_tmp5_ = ioctl (_tmp4_, SIOCSIFFLAGS, &ifr);
	if (_tmp5_ < 0) {
		result = FALSE;
		 (&ifr);
		return result;
	}
	_tmp6_ = ifr;
	_tmp7_ = _tmp6_.ifr_flags;
	_tmp8_ = clr;
	_tmp9_ = set;
	ifr.ifr_flags = (_tmp7_ & (~_tmp8_)) | _tmp9_;
	_tmp10_ = self->fd;
	_tmp11_ = ioctl (_tmp10_, SIOCSIFFLAGS, &ifr);
	if (_tmp11_ < 0) {
		result = FALSE;
		 (&ifr);
		return result;
	}
	result = TRUE;
	 (&ifr);
	return result;
}


static const gchar* string_to_string (const gchar* self) {
	const gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}


static void fso_framework_network_interface_setup_interface_index (FsoFrameworkNetworkInterface* self, GError** error) {
	struct ifreq ifr = {0};
	struct ifreq* ifrp;
	struct ifreq* _tmp0_;
	gchar* _tmp1_;
	gint _tmp1__length1;
	const gchar* _tmp2_;
	gint _tmp3_;
	gint _tmp4_ = 0;
	gint rc;
	gint _tmp5_;
	struct ifreq _tmp15_;
	gint _tmp16_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	memset (&ifr, 0, sizeof (struct ifreq));
	ifrp = (struct ifreq*) (&ifr);
	_tmp0_ = ifrp;
	_tmp1_ = (*_tmp0_).ifr_name;
	_tmp1__length1 = -1;
	_tmp2_ = self->name;
	strncpy ((const gchar*) _tmp1_, _tmp2_, (gsize) IFNAMSIZ);
	_tmp3_ = self->fd;
	_tmp4_ = ioctl (_tmp3_, SIOCGIFINDEX, &ifr);
	rc = _tmp4_;
	_tmp5_ = rc;
	if (_tmp5_ < 0) {
		const gchar* _tmp6_;
		const gchar* _tmp7_ = NULL;
		gint _tmp8_;
		const gchar* _tmp9_ = NULL;
		const gchar* _tmp10_ = NULL;
		gchar* _tmp11_ = NULL;
		gchar* _tmp12_;
		GError* _tmp13_;
		GError* _tmp14_;
		_tmp6_ = self->name;
		_tmp7_ = string_to_string (_tmp6_);
		_tmp8_ = errno;
		_tmp9_ = strerror (_tmp8_);
		_tmp10_ = string_to_string (_tmp9_);
		_tmp11_ = g_strconcat ("Could not get index for interface ", _tmp7_, ": ", _tmp10_, NULL);
		_tmp12_ = _tmp11_;
		_tmp13_ = g_error_new_literal (FSO_FRAMEWORK_NETWORK_ERROR, FSO_FRAMEWORK_NETWORK_ERROR_INTERNAL_ERROR, _tmp12_);
		_tmp14_ = _tmp13_;
		_g_free0 (_tmp12_);
		_inner_error_ = _tmp14_;
		if (_inner_error_->domain == FSO_FRAMEWORK_NETWORK_ERROR) {
			g_propagate_error (error, _inner_error_);
			 (&ifr);
			return;
		} else {
			 (&ifr);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp15_ = ifr;
	_tmp16_ = _tmp15_.ifr_ifindex;
	self->index = _tmp16_;
	 (&ifr);
}


FsoFrameworkNetworkInterface* fso_framework_network_interface_construct (GType object_type, const gchar* name, GError** error) {
	FsoFrameworkNetworkInterface* self = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gint _tmp2_ = 0;
	gint _tmp3_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (name != NULL, NULL);
	self = (FsoFrameworkNetworkInterface*) g_type_create_instance (object_type);
	_tmp0_ = name;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->name);
	self->name = _tmp1_;
	_tmp2_ = socket (AF_INET, SOCK_DGRAM, 0);
	self->fd = _tmp2_;
	_tmp3_ = self->fd;
	if (_tmp3_ < 0) {
		gint _tmp4_;
		const gchar* _tmp5_ = NULL;
		const gchar* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
		gchar* _tmp8_;
		GError* _tmp9_;
		GError* _tmp10_;
		_tmp4_ = errno;
		_tmp5_ = strerror (_tmp4_);
		_tmp6_ = string_to_string (_tmp5_);
		_tmp7_ = g_strconcat ("Could not create socket for interface configuration: ", _tmp6_, NULL);
		_tmp8_ = _tmp7_;
		_tmp9_ = g_error_new_literal (FSO_FRAMEWORK_NETWORK_ERROR, FSO_FRAMEWORK_NETWORK_ERROR_INTERNAL_ERROR, _tmp8_);
		_tmp10_ = _tmp9_;
		_g_free0 (_tmp8_);
		_inner_error_ = _tmp10_;
		if (_inner_error_->domain == FSO_FRAMEWORK_NETWORK_ERROR) {
			g_propagate_error (error, _inner_error_);
			_fso_framework_network_interface_unref0 (self);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	fso_framework_network_interface_setup_interface_index (self, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == FSO_FRAMEWORK_NETWORK_ERROR) {
			g_propagate_error (error, _inner_error_);
			_fso_framework_network_interface_unref0 (self);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	return self;
}


FsoFrameworkNetworkInterface* fso_framework_network_interface_new (const gchar* name, GError** error) {
	return fso_framework_network_interface_construct (FSO_FRAMEWORK_NETWORK_TYPE_INTERFACE, name, error);
}


/**
         * Will bring the interface up if it is down before.
         **/
void fso_framework_network_interface_up (FsoFrameworkNetworkInterface* self, GError** error) {
	gboolean _tmp0_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = fso_framework_network_interface_set_flags (self, (guint) IFF_UP, (guint) 0);
	if (!_tmp0_) {
		const gchar* _tmp1_;
		const gchar* _tmp2_ = NULL;
		gint _tmp3_;
		const gchar* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		gchar* _tmp7_;
		GError* _tmp8_;
		GError* _tmp9_;
		_tmp1_ = self->name;
		_tmp2_ = string_to_string (_tmp1_);
		_tmp3_ = errno;
		_tmp4_ = strerror (_tmp3_);
		_tmp5_ = string_to_string (_tmp4_);
		_tmp6_ = g_strconcat ("Could not bring interface ", _tmp2_, " up: ", _tmp5_, NULL);
		_tmp7_ = _tmp6_;
		_tmp8_ = g_error_new_literal (FSO_FRAMEWORK_NETWORK_ERROR, FSO_FRAMEWORK_NETWORK_ERROR_INTERNAL_ERROR, _tmp7_);
		_tmp9_ = _tmp8_;
		_g_free0 (_tmp7_);
		_inner_error_ = _tmp9_;
		if (_inner_error_->domain == FSO_FRAMEWORK_NETWORK_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


gboolean fso_framework_network_interface_is_up (FsoFrameworkNetworkInterface* self, GError** error) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = fso_framework_network_interface_check_flags (self, (guint) IFF_UP, &_inner_error_);
	_tmp1_ = _tmp0_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == FSO_FRAMEWORK_NETWORK_ERROR) {
			g_propagate_error (error, _inner_error_);
			return FALSE;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	result = _tmp1_;
	return result;
}


/**
         * Will bring the interface down if it is up before.
         **/
void fso_framework_network_interface_down (FsoFrameworkNetworkInterface* self, GError** error) {
	gboolean _tmp0_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = fso_framework_network_interface_set_flags (self, (guint) 0, (guint) IFF_UP);
	if (!_tmp0_) {
		const gchar* _tmp1_;
		const gchar* _tmp2_ = NULL;
		gint _tmp3_;
		const gchar* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		gchar* _tmp7_;
		GError* _tmp8_;
		GError* _tmp9_;
		_tmp1_ = self->name;
		_tmp2_ = string_to_string (_tmp1_);
		_tmp3_ = errno;
		_tmp4_ = strerror (_tmp3_);
		_tmp5_ = string_to_string (_tmp4_);
		_tmp6_ = g_strconcat ("Could not bring interface ", _tmp2_, " down: ", _tmp5_, NULL);
		_tmp7_ = _tmp6_;
		_tmp8_ = g_error_new_literal (FSO_FRAMEWORK_NETWORK_ERROR, FSO_FRAMEWORK_NETWORK_ERROR_INTERNAL_ERROR, _tmp7_);
		_tmp9_ = _tmp8_;
		_g_free0 (_tmp7_);
		_inner_error_ = _tmp9_;
		if (_inner_error_->domain == FSO_FRAMEWORK_NETWORK_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


/**
         * If you're finish with interface configuration this will cleanup and close open
         * sockets.
         **/
void fso_framework_network_interface_finish (FsoFrameworkNetworkInterface* self) {
	gint _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->fd;
	if (_tmp0_ > 0) {
		gint _tmp1_;
		_tmp1_ = self->fd;
		close (_tmp1_);
		self->fd = -1;
	}
}


static void fso_framework_network_value_interface_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void fso_framework_network_value_interface_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		fso_framework_network_interface_unref (value->data[0].v_pointer);
	}
}


static void fso_framework_network_value_interface_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = fso_framework_network_interface_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer fso_framework_network_value_interface_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* fso_framework_network_value_interface_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		FsoFrameworkNetworkInterface* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = fso_framework_network_interface_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* fso_framework_network_value_interface_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	FsoFrameworkNetworkInterface** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = fso_framework_network_interface_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* fso_framework_network_param_spec_interface (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	FsoFrameworkNetworkParamSpecInterface* spec;
	g_return_val_if_fail (g_type_is_a (object_type, FSO_FRAMEWORK_NETWORK_TYPE_INTERFACE), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer fso_framework_network_value_get_interface (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, FSO_FRAMEWORK_NETWORK_TYPE_INTERFACE), NULL);
	return value->data[0].v_pointer;
}


void fso_framework_network_value_set_interface (GValue* value, gpointer v_object) {
	FsoFrameworkNetworkInterface* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, FSO_FRAMEWORK_NETWORK_TYPE_INTERFACE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, FSO_FRAMEWORK_NETWORK_TYPE_INTERFACE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		fso_framework_network_interface_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		fso_framework_network_interface_unref (old);
	}
}


void fso_framework_network_value_take_interface (GValue* value, gpointer v_object) {
	FsoFrameworkNetworkInterface* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, FSO_FRAMEWORK_NETWORK_TYPE_INTERFACE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, FSO_FRAMEWORK_NETWORK_TYPE_INTERFACE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		fso_framework_network_interface_unref (old);
	}
}


static void fso_framework_network_interface_class_init (FsoFrameworkNetworkInterfaceClass * klass) {
	fso_framework_network_interface_parent_class = g_type_class_peek_parent (klass);
	FSO_FRAMEWORK_NETWORK_INTERFACE_CLASS (klass)->finalize = fso_framework_network_interface_finalize;
}


static void fso_framework_network_interface_instance_init (FsoFrameworkNetworkInterface * self) {
	self->ref_count = 1;
}


static void fso_framework_network_interface_finalize (FsoFrameworkNetworkInterface* obj) {
	FsoFrameworkNetworkInterface * self;
	self = FSO_FRAMEWORK_NETWORK_INTERFACE (obj);
	fso_framework_network_interface_finish (self);
	_g_free0 (self->name);
}


/**
     * @class Interface
     *
     * Wraps a Linux network interface using ioctls to implement access.
     *
     * Eventually this should use the netlink APIs rather than ioctls.
     **/
GType fso_framework_network_interface_get_type (void) {
	static volatile gsize fso_framework_network_interface_type_id__volatile = 0;
	if (g_once_init_enter (&fso_framework_network_interface_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { fso_framework_network_value_interface_init, fso_framework_network_value_interface_free_value, fso_framework_network_value_interface_copy_value, fso_framework_network_value_interface_peek_pointer, "p", fso_framework_network_value_interface_collect_value, "p", fso_framework_network_value_interface_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (FsoFrameworkNetworkInterfaceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) fso_framework_network_interface_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FsoFrameworkNetworkInterface), 0, (GInstanceInitFunc) fso_framework_network_interface_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType fso_framework_network_interface_type_id;
		fso_framework_network_interface_type_id = g_type_register_fundamental (g_type_fundamental_next (), "FsoFrameworkNetworkInterface", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&fso_framework_network_interface_type_id__volatile, fso_framework_network_interface_type_id);
	}
	return fso_framework_network_interface_type_id__volatile;
}


gpointer fso_framework_network_interface_ref (gpointer instance) {
	FsoFrameworkNetworkInterface* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void fso_framework_network_interface_unref (gpointer instance) {
	FsoFrameworkNetworkInterface* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		FSO_FRAMEWORK_NETWORK_INTERFACE_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


FsoFrameworkNetworkWextInterface* fso_framework_network_wext_interface_construct (GType object_type, const gchar* name, GError** error) {
	FsoFrameworkNetworkWextInterface* self = NULL;
	const gchar* _tmp0_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = name;
	self = (FsoFrameworkNetworkWextInterface*) fso_framework_network_interface_construct (object_type, _tmp0_, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == FSO_FRAMEWORK_NETWORK_ERROR) {
			g_propagate_error (error, _inner_error_);
			_fso_framework_network_interface_unref0 (self);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	return self;
}


FsoFrameworkNetworkWextInterface* fso_framework_network_wext_interface_new (const gchar* name, GError** error) {
	return fso_framework_network_wext_interface_construct (FSO_FRAMEWORK_NETWORK_TYPE_WEXT_INTERFACE, name, error);
}


void fso_framework_network_wext_interface_set_power (FsoFrameworkNetworkWextInterface* self, gboolean on, GError** error) {
	struct iwreq req = {0};
	struct iwreq* reqp;
	struct iwreq* _tmp0_;
	gchar* _tmp1_;
	gint _tmp1__length1;
	const gchar* _tmp2_;
	gint _tmp3_ = 0;
	gboolean _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	gint _tmp7_ = 0;
	gint rc;
	gint _tmp8_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	memset (&req, 0, sizeof (struct iwreq));
	reqp = (struct iwreq*) (&req);
	_tmp0_ = reqp;
	_tmp1_ = (*_tmp0_).ifr_name;
	_tmp1__length1 = -1;
	_tmp2_ = ((FsoFrameworkNetworkInterface*) self)->name;
	strncpy ((const gchar*) _tmp1_, _tmp2_, (gsize) IFNAMSIZ);
	_tmp4_ = on;
	if (_tmp4_) {
		_tmp3_ = 0;
	} else {
		_tmp3_ = 1;
	}
	_tmp5_ = _tmp3_;
	req.u.power.disabled = (guint8) _tmp5_;
	_tmp6_ = ((FsoFrameworkNetworkInterface*) self)->fd;
	_tmp7_ = ioctl (_tmp6_, SIOCSIWPOWER, &req);
	rc = _tmp7_;
	_tmp8_ = rc;
	if (_tmp8_ < 0) {
		const gchar* _tmp9_;
		const gchar* _tmp10_ = NULL;
		gchar* _tmp11_ = NULL;
		gchar* _tmp12_;
		GError* _tmp13_;
		GError* _tmp14_;
		_tmp9_ = ((FsoFrameworkNetworkInterface*) self)->name;
		_tmp10_ = string_to_string (_tmp9_);
		_tmp11_ = g_strconcat ("Could not process ioctl for setting wireless power status of interface" \
" ", _tmp10_, NULL);
		_tmp12_ = _tmp11_;
		_tmp13_ = g_error_new_literal (FSO_FRAMEWORK_NETWORK_ERROR, FSO_FRAMEWORK_NETWORK_ERROR_INTERNAL_ERROR, _tmp12_);
		_tmp14_ = _tmp13_;
		_g_free0 (_tmp12_);
		_inner_error_ = _tmp14_;
		if (_inner_error_->domain == FSO_FRAMEWORK_NETWORK_ERROR) {
			g_propagate_error (error, _inner_error_);
			 (&req);
			return;
		} else {
			 (&req);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	 (&req);
}


static void fso_framework_network_wext_interface_class_init (FsoFrameworkNetworkWextInterfaceClass * klass) {
	fso_framework_network_wext_interface_parent_class = g_type_class_peek_parent (klass);
}


static void fso_framework_network_wext_interface_instance_init (FsoFrameworkNetworkWextInterface * self) {
}


/**
     * @class WextInterface
     *
     * Wraps a wireless interface using the Wireless Extension API (WEXT).
     *
     * This is actually already deprecated and we should rather implement
     * nl80211 as soon as possible.
     **/
GType fso_framework_network_wext_interface_get_type (void) {
	static volatile gsize fso_framework_network_wext_interface_type_id__volatile = 0;
	if (g_once_init_enter (&fso_framework_network_wext_interface_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (FsoFrameworkNetworkWextInterfaceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) fso_framework_network_wext_interface_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FsoFrameworkNetworkWextInterface), 0, (GInstanceInitFunc) fso_framework_network_wext_interface_instance_init, NULL };
		GType fso_framework_network_wext_interface_type_id;
		fso_framework_network_wext_interface_type_id = g_type_register_static (FSO_FRAMEWORK_NETWORK_TYPE_INTERFACE, "FsoFrameworkNetworkWextInterface", &g_define_type_info, 0);
		g_once_init_leave (&fso_framework_network_wext_interface_type_id__volatile, fso_framework_network_wext_interface_type_id);
	}
	return fso_framework_network_wext_interface_type_id__volatile;
}



