/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.io;

import com.sun.cdc.io.InternalConnector;
import com.sun.cdc.io.InternalConnectorImpl;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.microedition.io.Connection;
import javax.microedition.io.InputConnection;
import javax.microedition.io.OutputConnection;
import sun.misc.CVM;

public class Connector {
    public static final int READ = 1;
    public static final int WRITE = 2;
    public static final int READ_WRITE = 3;
    private static InternalConnector midpConnector;
    private static InternalConnector foundationConnector;

    private Connector() {
    }

    public static Connection open(String string) throws IOException {
        return Connector.open(string, 3);
    }

    public static Connection open(String string, int n) throws IOException {
        return Connector.open(string, n, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Connection open(String string, int n, boolean bl) throws IOException {
        InternalConnector internalConnector = null;
        if (n != 1 && n != 2 && n != 3) {
            throw new IllegalArgumentException("illegal access mode: " + n);
        }
        if (string == null) {
            throw new IllegalArgumentException("Null URL");
        }
        try {
            if (CVM.isMIDPContext()) {
                internalConnector = Connector.getMidpConnector();
            }
        }
        catch (Throwable throwable) {
        }
        finally {
            if (internalConnector == null) {
                internalConnector = Connector.getFoundationConnector();
            }
        }
        return internalConnector.open(string, n, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DataInputStream openDataInputStream(String string) throws IOException {
        InputConnection inputConnection = null;
        try {
            inputConnection = (InputConnection)Connector.open(string, 1);
        }
        catch (ClassCastException classCastException) {
            throw new IllegalArgumentException(string);
        }
        try {
            DataInputStream dataInputStream = inputConnection.openDataInputStream();
            return dataInputStream;
        }
        finally {
            inputConnection.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DataOutputStream openDataOutputStream(String string) throws IOException {
        OutputConnection outputConnection = null;
        try {
            outputConnection = (OutputConnection)Connector.open(string, 2);
        }
        catch (ClassCastException classCastException) {
            throw new IllegalArgumentException(string);
        }
        try {
            DataOutputStream dataOutputStream = outputConnection.openDataOutputStream();
            return dataOutputStream;
        }
        finally {
            outputConnection.close();
        }
    }

    public static InputStream openInputStream(String string) throws IOException {
        return Connector.openDataInputStream(string);
    }

    public static OutputStream openOutputStream(String string) throws IOException {
        return Connector.openDataOutputStream(string);
    }

    private static InternalConnector getMidpConnector() throws Exception {
        if (midpConnector == null) {
            Class clazz = Class.forName("sun.misc.MIDPInternalConnectorImpl");
            midpConnector = (InternalConnector)clazz.newInstance();
        }
        return midpConnector;
    }

    private static InternalConnector getFoundationConnector() {
        if (foundationConnector == null) {
            foundationConnector = new InternalConnectorImpl();
        }
        return foundationConnector;
    }
}

