#include "osl/effect_util/sendOffSquare.h"
#include "osl/record/csaString.h"

#include <cppunit/TestCase.h>
#include <cppunit/extensions/HelperMacros.h>
#include <iostream>
using namespace osl;
using namespace osl::effect_util;

class SendOffSquareTest : public CppUnit::TestFixture 
{
  CPPUNIT_TEST_SUITE(SendOffSquareTest);
  CPPUNIT_TEST(testSimple);
  CPPUNIT_TEST(testDefense);
  CPPUNIT_TEST(testEdge);
  CPPUNIT_TEST_SUITE_END();
public:
  void testSimple();
  void testDefense();
  void testEdge();
};

CPPUNIT_TEST_SUITE_REGISTRATION(SendOffSquareTest);

typedef osl::effect_util::SendOffSquare::SendOff8 SendOff8;

void SendOffSquareTest::testSimple()
{
  {
    NumEffectState state(CsaString(
			   "P1 *  *  *  *  *  * +HI *  * \n"
			   "P2 *  * -OU-KI *  *  *  *  * \n"
			   "P3 *  *  *  *  *  *  *  *  * \n"
			   "P4 *  *  *  *  *  *  *  *  * \n"
			   "P5 *  *  *  *  *  *  *  *  * \n"
			   "P6 *  *  *  *  *  *  *  *  * \n"
			   "P7 *  *  *  *  *  *  *  *  * \n"
			   "P8 *  *  *  *  *  *  *  *  * \n"
			   "P9+OU *  *  *  *  *  *  *  * \n"
			   "P+00AL\n"
			   "+\n").getInitialState());
    Square8 sendoffs, sendoffs2;
    Square king(7,2);
    SendOff8 data = SendOffSquare::find<BLACK>(state, king, sendoffs);
    CPPUNIT_ASSERT(sendoffs.empty());
    SendOffSquare::unpack(data, king, sendoffs2);
    CPPUNIT_ASSERT_EQUAL(sendoffs, sendoffs2);
  }
  {
    NumEffectState state(CsaString(
			   "P1 *  *  *  *  *  *  *  *  * \n"
			   "P2 *  * -OU-KI *  * +HI *  * \n"
			   "P3 *  *  *  *  *  *  *  *  * \n"
			   "P4 *  *  *  *  *  *  *  *  * \n"
			   "P5 *  *  *  *  *  *  *  *  * \n"
			   "P6 *  *  *  *  *  *  *  *  * \n"
			   "P7 *  *  *  *  *  *  *  *  * \n"
			   "P8 *  *  *  *  *  *  *  *  * \n"
			   "P9+OU *  *  *  *  *  *  *  * \n"
			   "P+00AL\n"
			   "+\n").getInitialState());
    Square8 sendoffs, sendoffs2;
    Square king(7,2);
    SendOff8 data = SendOffSquare::find<BLACK>(state, king, sendoffs);
    CPPUNIT_ASSERT_EQUAL((size_t)3, sendoffs.size());
    SendOffSquare::unpack(data, king, sendoffs2);
    CPPUNIT_ASSERT_EQUAL(sendoffs, sendoffs2);
  }
  {
    NumEffectState state(CsaString(
			   "P1 *  *  *  *  *  *  *  *  * \n"
			   "P2 *  *  * -KI *  * +HI *  * \n"
			   "P3 *  * -OU *  *  *  *  *  * \n"
			   "P4 *  *  *  *  *  *  *  *  * \n"
			   "P5 *  *  *  *  *  *  *  *  * \n"
			   "P6 *  *  *  *  *  *  *  *  * \n"
			   "P7 *  *  *  *  *  *  *  *  * \n"
			   "P8 *  *  *  *  *  *  *  *  * \n"
			   "P9+OU *  *  *  *  *  *  *  * \n"
			   "P+00AL\n"
			   "+\n").getInitialState());
    Square8 sendoffs, sendoffs2;
    Square king(7,3);
    SendOff8 data = SendOffSquare::find<BLACK>(state, king, sendoffs);
    CPPUNIT_ASSERT_EQUAL((size_t)5, sendoffs.size());
    SendOffSquare::unpack(data, king, sendoffs2);
    CPPUNIT_ASSERT_EQUAL(sendoffs, sendoffs2);
  }
}
void SendOffSquareTest::testDefense()
{
  {
    NumEffectState state(CsaString(
			   "P1 *  *  *  *  *  *  *  *  * \n"
			   "P2 *  *  * -KI *  * +HI *  * \n"
			   "P3 *  * -OU *  *  *  *  *  * \n"
			   "P4 *  * -KI *  *  *  *  *  * \n"
			   "P5 *  *  *  *  *  *  *  *  * \n"
			   "P6 *  *  *  *  *  *  *  *  * \n"
			   "P7 *  *  *  *  *  *  *  *  * \n"
			   "P8 *  *  *  *  *  *  *  *  * \n"
			   "P9+OU *  *  *  *  *  *  *  * \n"
			   "P+00AL\n"
			   "+\n").getInitialState());
    Square8 sendoffs, sendoffs2;
    Square king(7,3);
    SendOff8 data = SendOffSquare::find<BLACK>(state, king, sendoffs);
#if 0
    for (Square8::const_iterator p=sendoffs.begin(); p!=sendoffs.end(); ++p)
    {
      std::cerr << *p << "\n";
    }
#endif
    CPPUNIT_ASSERT_EQUAL((size_t)3, sendoffs.size()); // 82, 83, 72
    SendOffSquare::unpack(data, king, sendoffs2);
    CPPUNIT_ASSERT_EQUAL(sendoffs, sendoffs2);
  }
}

void SendOffSquareTest::testEdge()
{
  {
    NumEffectState state(CsaString(
			   "P1 * -KI * +HI *  *  *  *  * \n"
			   "P2-OU *  *  *  *  *  *  *  * \n"
			   "P3 *  *  *  *  *  *  *  *  * \n"
			   "P4 *  *  *  *  *  *  *  *  * \n"
			   "P5 *  *  *  *  *  *  *  *  * \n"
			   "P6 *  *  *  *  *  *  *  *  * \n"
			   "P7 *  *  *  *  *  *  *  *  * \n"
			   "P8 *  *  *  *  *  *  *  *  * \n"
			   "P9+OU *  *  *  *  *  *  *  * \n"
			   "P+00AL\n"
			   "+\n").getInitialState());
    Square8 sendoffs, sendoffs2;
    Square king(9,2);
    SendOff8 data = SendOffSquare::find<BLACK>(state, king, sendoffs);
    CPPUNIT_ASSERT_EQUAL((size_t)2, sendoffs.size()); // 93, 83
    SendOffSquare::unpack(data, king, sendoffs2);
    CPPUNIT_ASSERT_EQUAL(sendoffs, sendoffs2);
  }
}

// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
