[comment {-*- tcl -*- doctools}]
[manpage_begin img-intro n 1.4]
[moddesc Img]
[titledesc {Introduction to Img}]
[copyright {1995-2023 Jan Nijtmans <nijtmans@users.sourceforge.net>}]
[require Tk]
[require Img [opt 1.4]]
[description]

[package Img] is a [package Tk] extension, adding support for many
other Image formats, as listed below. The individual formats are
described in more detail on their own pages.

[list_begin definitions]

[def [term bmp]]
Windows bitmap format.
See [cmd img-bmp].

[def [term dted]]
Digital Terrain Elevation Data (DTED) interpreted as image.
See [cmd img-dted].

[def [term flir]]
FLIR FPF Public Image format.
See [cmd img-flir].

[def [term gif]]
The Graphics Interchange Format (GIF) (with transparency, but
without LZW. The latter due to patent issues).
See [cmd img-gif].

[def [term ico]]
Windows icon format
See [cmd img-ico].

[def [term jpeg]]
Joint Picture Experts Group (JPEG) format.
See [cmd img-jpeg].

[def [term pcx]]
Paintbrush image format.
See [cmd img-pcx].

[def [term pixmap]]
While the other formats are handlers for the [package Tk] photo image
type this is a new image type for [package Tk].
See [cmd img-pixmap].

[def [term png]]
Portable Network Graphics (PNG) format.
See [cmd img-png].

[def [term ppm]]
Portable Pixmap format.
See [cmd img-ppm].

[def [term ps]]
Postscript and PDF format.
Requires an external application, [syscmd ghostview] for its operation.
See [cmd img-ps].

[def [term raw]]
Raw matrix data interpreted as image.
See [cmd img-raw].

[def [term sgi]]
Silicon Graphics (SGI) format.
See [cmd img-sgi].

[def [term sun]]
Sun raster format.
See [cmd img-sun].

[def [term tga]]
Truevision Targa format.
See [cmd img-tga].

[def [term tiff]]
Tagged Image File Format (TIFF).
See [cmd img-tiff].

[def [term window]]
Put the content of a Tk window into an image.
See [cmd img-window].

[def [term xbm]]
X Bitmap format.
See [cmd img-xbm].

[def [term xpm]]
X Pixmap format.
See [cmd img-xpm].

[list_end]

This version only works with Tcl/Tk 8.3 or higher.
If you are using Tk 8.2, please use Img 1.3.
If you are using Tk 8.1 or lower please stick with Img 1.2.4 (which is still available).
And if you are using Tk4.2 or lower, please stick with Img 1.1.4 (which is also still available).

[see_also img-bmp img-dted img-flir img-gif img-ico img-jpeg img-pcx img-pixmap img-png img-ppm img-ps img-raw img-sgi img-sun img-tga img-tiff img-window img-xbm img-xpm]
[keywords {image handling} tk xpm xbm gif png ppm tiff tga sun sgi postscript ps pdf pixmap pcx ico bmp window jpeg]
[manpage_end]
