#
# Copyright (c) 2010 Canonical
#
# Written by Gustavo Niemeyer <gustavo@niemeyer.net>
#
# This file is part of the Xpresser GUI automation library.
#
# Xpresser is free software; you can redistribute it and/or modify
# it under the terms of the GNU Lesser General Public License version 3,
# as published by the Free Software Foundation.
#
# Xpresser is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
import os

from xpresser.image import Image, DEFAULT_SIMILARITY

from xpresser.lib.testing import TestCase


class ImageTest(TestCase):

    def test_default_constructor(self):
        image = Image()
        self.assertEquals(image.name, None)
        self.assertEquals(image.similarity, DEFAULT_SIMILARITY)
        self.assertEquals(image.focus_delta, (0, 0))
        self.assertEquals(image.width, None)
        self.assertEquals(image.height, None)
        self.assertEquals(image.filename, None)
        self.assertEquals(image.array, None)
        self.assertEquals(image.cache, {})

    def test_constructor_with_positional_arguments(self):
        image = Image("name", 0.5, (1, 2), 3, 4, "image.png", [[[0,0,0]]])
        self.assertEquals(image.name, "name")
        self.assertEquals(image.similarity, 0.5)
        self.assertEquals(image.focus_delta, (1, 2))
        self.assertEquals(image.width, 3)
        self.assertEquals(image.height, 4)
        self.assertEquals(image.filename, "image.png")
        self.assertEquals(image.array, [[[0,0,0]]])

    def test_constructor_with_keyword_arguments(self):
        image = Image(name="name", similarity=0.5, focus_delta=(1, 2),
                      width=3, height=4, filename="image.png")
        self.assertEquals(image.name, "name")
        self.assertEquals(image.similarity, 0.5)
        self.assertEquals(image.focus_delta, (1, 2))
        self.assertEquals(image.width, 3)
        self.assertEquals(image.height, 4)
        self.assertEquals(image.filename, "image.png")

    def test_bad_similarity(self):
        self.assertRaises(ValueError, Image, similarity=1.1)

