#!/usr/bin/env python

import sys
import random
import string

def main():
    print "# generated by tokudb_fast_update_varchar.py"
    print "source include/have_tokudb.inc;"
    print "source include/have_innodb.inc;"
    print "set default_storage_engine='tokudb';"
    print "disable_warnings;"
    print "drop table if exists t;"
    print "enable_warnings;"

    nrows = 100

    for t in [ 'varchar', 'varbinary' ]:
        for l in [ 32, 256 ]:
            for n in [ 'null', 'not null' ]:
                test_varchar(t, l, n, nrows)
    return 0

def test_varchar(t, l, n, nrows):
    print "create table tt (id bigint unsigned primary key,"
    print "    f0 int %s," % (n)
    for i in range(4):
        print "     v%d %s(%d) %s," % (i, t, l, n)
    print "     b0 text %s" % (n)
    print ") engine=tokudb;"

    if n == 'null':
        print "insert into tt (id) values (0);"
    print "insert into tt values (1,2,'a','b','c','d','e');"
    for i in range(2,nrows):
        print "insert into tt values (%d,%d,'','','','','');" % (i,i+1)

    print "create table ti like tt;"
    print "alter table ti engine=innodb;"
    print "insert into ti select * from tt;"

    nulltest = [ 'null this', 'null is', 'null a', 'null test' ]
    for i in range(4):
        print "update noar tt set v%d='%s %s' where id=0;" % (i, nulltest[i], str(i))
        print "update noar ti set v%d='%s %s' where id=0;" % (i, nulltest[i], str(i))

    test = [ 'this' ,'is', 'another', 'test']
    for i in range(4):
        print "update noar tt set v%d='%s %s' where id=1;" % (i, test[i], str(i))
        print "update noar ti set v%d='%s %s' where id=1;" % (i, test[i], str(i))

    for id in range(2,nrows):
        for i in range(4):
            long_str = ''.join(random.choice(string.ascii_uppercase + string.digits) for x in range(l+1))
            print "update noar tt set v%d='%s' where id=%d;" % (i, long_str, id)
            print "update noar ti set v%d='%s' where id=%d;" % (i, long_str, id)

    print "let $diff_tables = test.tt, test.ti;"
    print "source include/diff_tables.inc;"

    print "drop table tt, ti;"

sys.exit(main())
