# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.object import Object


class LineIntegralConvolution2D(Object):
    r"""
    LineIntegralConvolution2D - GPU-based implementation of Line
     Integral Convolution (LIC)
    
    Superclass: Object
    
    This class resorts to GLSL to implement GPU-based Line Integral
    Convolution
     (LIC) for visualizing a 2D vector field that may be obtained by
    projecting
     an original 3D vector field onto a surface (such that the resulting
    2D
     vector at each grid point on the surface is tangential to the local
    normal,
     as done in SurfaceLICPainter).
    
    
     As an image-based technique, 2D LIC works by (1) integrating a
    bidirectional
     streamline from the center of each pixel (of the LIC output image),
    (2)
     locating the pixels along / hit by this streamline as the correlated
    pixels
     of the starting pixel (seed point / pixel), (3) indexing a (usually
    white)
     noise texture (another input to LIC, in addition to the 2D vector
    field,
     usually with the same size as that of the 2D vector field) to
    determine the
     values (colors) of these pixels (the starting and the correlated
    pixels),
     typically through bi-linear interpolation, and (4) performing
    convolution
     (weighted averaging) on these values, by adopting a low-pass filter
    (such
     as box, ramp, and Hanning kernels), to obtain the result value
    (color) that
     is then assigned to the seed pixel.
    
    
     The GLSL-based GPU implementation herein maps the aforementioned
    pipeline to
     fragment shaders and a box kernel is employed. Both the white noise
    and the
     vector field are provided to the GPU as texture objects (supported
    by the
     multi-texturing capability). In addition, there are four texture
    objects
     (color buffers) allocated to constitute two pairs that work in a
    ping-pong
     fashion, with one as the read buffers and the other as the write /
    render
     targets. Maintained by a frame buffer object
    (GL_EXT_framebuffer_object),
     each pair employs one buffer to store the current (dynamically
    updated)
     position (by means of the texture coordinate that keeps being warped
    by the
     underlying vector) of the (virtual) particle initially released from
    each
     fragment while using the bother buffer to store the current
    (dynamically
     updated too) accumulated texture value that each seed fragment
    (before the
     'mesh' is warped) collects. Given number_of_steps integration steps in
    each
     direction, there are a total of (2 * number_of_steps + 1) fragments
    (including
     the seed fragment) are convolved and each contributes 1 / (2 *
    number_of_steps
     + 1) of the associated texture value to fulfill the box filter.
    
    
     One pass of LIC (basic LIC) tends to produce low-contrast / blurred
    images and
     LineIntegralConvolution2D provides an option for creating
    enhanced LIC
     images. Enhanced LIC improves image quality by increasing
    inter-streamline
     contrast while suppressing artifacts. It performs two passes of LIC,
    with a
     3x3 Laplacian high-pass filter in between that processes the output
    of pass
    #1 LIC and forwards the result as the input 'noise' to pass #2 LIC.
    
    
     LineIntegralConvolution2D applies masking to zero-vector
    fragments so
     that un-filtered white noise areas are made totally transparent by
    class
     SurfaceLICPainter to show the underlying geometry surface.
    
    
     The convolution process tends to decrease both contrast and dynamic
    range,
     sometimes leading to dull dark images. In order to counteract this,
    optional
     contrast ehnancement stages have been added. These increase the
    dynamic range and
     contrast and sharpen streaking patterns that emerge from the LIC
    process.
    
    
     Under some circumstances, typically depending on the contrast and
    dynamic
     range and graininess of the noise texture, jagged or pixelated
    patterns emerge
     in the LIC. These can be reduced by enabling the optional
    anti-aliasing pass.
    
    
     The internal pipeline is as follows, with optional stages denoted by
    ()
     nested optional stages depend on their parent stage.
    
    
      noise texture
              |
              [ LIC ((CE) HPF LIC) (AA) (CE) ]
              |                              |
     vector field                       LIC'd image 
     where LIC is the LIC stage, HPF is the high-pass filter stage, CE is
    the
     contrast ehnacement stage, and AA is the antialias stage.
    
    @sa
     ImageDataLIC2D StructuredGridLIC2D
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkLineIntegralConvolution2D, obj, update, **traits)
    
    anti_alias = tvtk_base.false_bool_trait(desc=\
        r"""
        Enable/Disable the anti-aliasing pass. This optional pass
        (disabled by default) can be enabled to reduce jagged patterns in
        the final LIC image. Values greater than 0 control the number of
        iterations, one is typically sufficient.
        """
    )

    def _anti_alias_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetAntiAlias,
                        self.anti_alias_)

    enhance_contrast = tvtk_base.false_bool_trait(desc=\
        r"""
        
        """
    )

    def _enhance_contrast_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetEnhanceContrast,
                        self.enhance_contrast_)

    enhanced_lic = tvtk_base.true_bool_trait(desc=\
        r"""
        enhanced_lic mean compute the LIC twice with the second pass using
        the edge-enhanced result of the first pass as a noise texture.
        Edge enhancedment is made by a simple Laplace convolution.
        """
    )

    def _enhanced_lic_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetEnhancedLIC,
                        self.enhanced_lic_)

    component_ids = traits.Array(enter_set=True, auto_set=False, shape=(2,), dtype="int", value=(0, 1), cols=2, desc=\
        r"""
        If vector_field has >= 3 components, we must choose which 2
        components form the (X, Y) components for the vector field. Must
        be in the range [0, 3].
        """
    )

    def _component_ids_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetComponentIds,
                        self.component_ids)

    def _get_context(self):
        return wrap_vtk(self._vtk_obj.GetContext())
    def _set_context(self, arg):
        old_val = self._get_context()
        self._wrap_call(self._vtk_obj.SetContext,
                        deref_vtk(arg))
        self.trait_property_changed('context', old_val, arg)
    context = traits.Property(_get_context, _set_context, desc=\
        r"""
        
        """
    )

    high_contrast_enhancement_factor = traits.Trait(0.0, traits.Range(0.0, 1.0, enter_set=True, auto_set=False), desc=\
        r"""
        
        """
    )

    def _high_contrast_enhancement_factor_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetHighContrastEnhancementFactor,
                        self.high_contrast_enhancement_factor)

    low_contrast_enhancement_factor = traits.Trait(0.0, traits.Range(0.0, 1.0, enter_set=True, auto_set=False), desc=\
        r"""
        This feature is used to fine tune the contrast enhancement.
        Values are provided indicating the fraction of the range to
        adjust m and M by during contrast enahncement histogram
        stretching.  M and m are the intensity/lightness values that map
        to 1 and 0. (see enhance_contrast for an explanation of the
        mapping procedure). m and M are computed using the factors as
        follows:
        
        * m = min(C) - mFactor * (max(C) - min(C))
        * M = max(C) - MFactor * (max(C) - min(C))
        
        * the default values for mFactor and MFactor are 0 which result
          in
        * m = min(C), M = max(C), where C is all of the colors in the
          image. Adjusting
        * mFactor and MFactor above zero provide a means to control the
          saturation of
        * normalization. These settings only affect the final
          normalization, the
        * normalization that occurs on the input to the high-pass filter
          always uses
        * the min and max.
        """
    )

    def _low_contrast_enhancement_factor_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetLowContrastEnhancementFactor,
                        self.low_contrast_enhancement_factor)

    mask_threshold = traits.Trait(0.0, traits.Range(-1.0, 9.999999680285692e+37, enter_set=True, auto_set=False), desc=\
        r"""
        The mask_threshold controls blanking of the LIC texture. For
        fragments with |V|<threshold the LIC fragment is not rendered.
        The default value is 0.0.
        
        * For surface LIC mask_threshold units are in the original vector
          space. For image LIC
        * be aware that while the vector field is transformed to image
          space while the mask
        * threshold is not. Therefore the mask threshold must be
          specified in image space
        * units.
        """
    )

    def _mask_threshold_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetMaskThreshold,
                        self.mask_threshold)

    max_noise_value = traits.Trait(0.0, traits.Range(0.0, 1.0), enter_set=True, auto_set=False, desc=\
        r"""
        Set the max noise value for use during LIC integration
        normalization. The integration normalization factor is the max
        noise value times the number of steps taken. The default value is
        1.
        """
    )

    def _max_noise_value_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetMaxNoiseValue,
                        self.max_noise_value)

    normalize_vectors = traits.Int(1, enter_set=True, auto_set=False, desc=\
        r"""
        Normalize vectors during integration. When set(the default) the
        input vector field is normalized during integration, and each
        integration occurs over the same arclength. When not set each
        integration occurs over an arc length proportional to the field
        magnitude as is customary in traditional numerical methods. See,
        "Imaging Vector Fields Using Line Integral Convolution" for an
        axample where normalization is used. See, "Image Space Based Visualization of Unsteady Flow on
        Surfaces" for an example of where no normalization is used.
        """
    )

    def _normalize_vectors_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetNormalizeVectors,
                        self.normalize_vectors)

    number_of_steps = traits.Trait(1, traits.Range(0, 2147483647, enter_set=True, auto_set=False), desc=\
        r"""
        Number of streamline integration steps (initial value is 1). In
        term of visual quality, the greater (within some range) the
        better.
        """
    )

    def _number_of_steps_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetNumberOfSteps,
                        self.number_of_steps)

    step_size = traits.Trait(0.01, traits.Range(0.0, 9.999999680285692e+37, enter_set=True, auto_set=False), desc=\
        r"""
        Get/Set the streamline integration step size (0.01 by default).
        This is the length of each step in normalized image space i.e. in
        range [0, FLOAT_MAX]. In term of visual quality, the smaller the
        better. The type for the interface is double as VTK interface is,
        but GPU only supports float. Thus it will be converted to float
        in the execution of the algorithm.
        """
    )

    def _step_size_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetStepSize,
                        self.step_size)

    transform_vectors = traits.Int(1, enter_set=True, auto_set=False, desc=\
        r"""
        This class performs LIC in the normalized image space. Hence, by
        default it transforms the input vectors to the normalized image
        space (using the grid_spacings and input vector field dimensions).
        Set this to 0 to disable transformation if the vectors are
        already transformed.
        """
    )

    def _transform_vectors_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetTransformVectors,
                        self.transform_vectors)

    def _get_anti_alias_max_value(self):
        return self._vtk_obj.GetAntiAliasMaxValue()
    anti_alias_max_value = traits.Property(_get_anti_alias_max_value, desc=\
        r"""
        
        """
    )

    def _get_anti_alias_min_value(self):
        return self._vtk_obj.GetAntiAliasMinValue()
    anti_alias_min_value = traits.Property(_get_anti_alias_min_value, desc=\
        r"""
        
        """
    )

    def _get_enhance_contrast_max_value(self):
        return self._vtk_obj.GetEnhanceContrastMaxValue()
    enhance_contrast_max_value = traits.Property(_get_enhance_contrast_max_value, desc=\
        r"""
        
        """
    )

    def _get_enhance_contrast_min_value(self):
        return self._vtk_obj.GetEnhanceContrastMinValue()
    enhance_contrast_min_value = traits.Property(_get_enhance_contrast_min_value, desc=\
        r"""
        
        """
    )

    def _get_enhanced_lic_max_value(self):
        return self._vtk_obj.GetEnhancedLICMaxValue()
    enhanced_lic_max_value = traits.Property(_get_enhanced_lic_max_value, desc=\
        r"""
        
        """
    )

    def _get_enhanced_lic_min_value(self):
        return self._vtk_obj.GetEnhancedLICMinValue()
    enhanced_lic_min_value = traits.Property(_get_enhanced_lic_min_value, desc=\
        r"""
        
        """
    )

    def execute(self, *args):
        """
        execute(self, vectorTex:TextureObject,
            noiseTex:TextureObject) -> TextureObject
        C++: TextureObject *execute(TextureObject *vectorTex,
            TextureObject *noiseTex)
        execute(self, extent:(int, int, int, int),
            vectorTex:TextureObject, noiseTex:TextureObject)
            -> TextureObject
        C++: TextureObject *execute(const int extent[4],
            TextureObject *vectorTex, TextureObject *noiseTex)
        Compute the lic on the entire vector field texture.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.Execute, *my_args)
        return wrap_vtk(ret)

    def is_supported(self, *args):
        """
        is_supported(renWin:RenderWindow) -> bool
        C++: static bool is_supported(RenderWindow *renWin)
        Returns if the context supports the required extensions.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.IsSupported, *my_args)
        return ret

    def set_noise_tex_parameters(self, *args):
        """
        set_noise_tex_parameters(noise:TextureObject) -> None
        C++: static void set_noise_tex_parameters(TextureObject *noise)"""
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.SetNoiseTexParameters, *my_args)
        return ret

    def set_vector_tex_parameters(self, *args):
        """
        set_vector_tex_parameters(vectors:TextureObject) -> None
        C++: static void set_vector_tex_parameters(TextureObject *vectors)
        Convenience functions to ensure that the input textures are
        configured correctly.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.SetVectorTexParameters, *my_args)
        return ret

    def write_timer_log(self, *args):
        """
        write_timer_log(self, __a:str) -> None
        C++: virtual void write_timer_log(const char *)
        Methods used for parallel benchmarks. Use cmake to define
        LineIntegralConviolution2DTIME to enable benchmarks. During
        each update timing information is stored, it can be written to
        disk by calling write_log.
        """
        ret = self._wrap_call(self._vtk_obj.WriteTimerLog, *args)
        return ret

    _updateable_traits_ = \
    (('anti_alias', 'GetAntiAlias'), ('enhance_contrast',
    'GetEnhanceContrast'), ('enhanced_lic', 'GetEnhancedLIC'), ('debug',
    'GetDebug'), ('global_warning_display', 'GetGlobalWarningDisplay'),
    ('component_ids', 'GetComponentIds'),
    ('high_contrast_enhancement_factor',
    'GetHighContrastEnhancementFactor'),
    ('low_contrast_enhancement_factor',
    'GetLowContrastEnhancementFactor'), ('mask_threshold',
    'GetMaskThreshold'), ('max_noise_value', 'GetMaxNoiseValue'),
    ('normalize_vectors', 'GetNormalizeVectors'), ('number_of_steps',
    'GetNumberOfSteps'), ('step_size', 'GetStepSize'),
    ('transform_vectors', 'GetTransformVectors'), ('object_name',
    'GetObjectName'), ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ('max_noise_value',)
    
    _full_traitnames_list_ = \
    (['anti_alias', 'debug', 'enhance_contrast', 'enhanced_lic',
    'global_warning_display', 'component_ids',
    'high_contrast_enhancement_factor', 'low_contrast_enhancement_factor',
    'mask_threshold', 'max_noise_value', 'normalize_vectors',
    'number_of_steps', 'object_name', 'step_size', 'transform_vectors'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(LineIntegralConvolution2D, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit LineIntegralConvolution2D properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['anti_alias', 'enhance_contrast', 'enhanced_lic'], [],
            ['component_ids', 'high_contrast_enhancement_factor',
            'low_contrast_enhancement_factor', 'mask_threshold',
            'max_noise_value', 'normalize_vectors', 'number_of_steps',
            'object_name', 'step_size', 'transform_vectors']),
            title='Edit LineIntegralConvolution2D properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit LineIntegralConvolution2D properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

