/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#ifndef MvVersionInfo_H
#define MvVersionInfo_H

using namespace std;


/*
    class MvVersionInfo
    purpose: to provide information about Metview's version numbers, date, etc.
    Note: the constructor loads the relevant information.
*/
class MvAbstractVersionInfo
{
public:
    virtual ~MvAbstractVersionInfo(){};

    bool infoFound()               {return info_found_;};
    int  fileVersion()             {return file_version_;};
    int  majorVersion()            {return major_;};
    int  minorVersion()            {return minor_;};
    int  revision()                {return revision_;};
    int  version()                 {return version_;};
    int  year()                    {return year_;};
    const string &name()           {return name_;};
    const string &nameAndVersion() {return nameAndVersion_;};
    const string &label()          {return label_;};
    const string &period()         {return copyright_period_;};
    const string &releaseDate()    {return release_date_;};
    const string &errorMessage()   {return error_message_;};
    const string &installDir()     {return install_dir_;};

protected:
    MvAbstractVersionInfo(){};

    bool info_found_;
    int  file_version_;
    int  major_;
    int  minor_;
    int  revision_;
    int  version_;
    int  year_;
    string name_;
    string nameAndVersion_;
    string label_;
    string copyright_period_;
    string release_date_;
    string error_message_;
    string install_dir_;
};

class MvVersionInfo : public MvAbstractVersionInfo
{
public:
    	MvVersionInfo();
    	~MvVersionInfo(){};

protected:
    void init();	
};

class MvGribApiVersionInfo : public MvAbstractVersionInfo
{
public:
	MvGribApiVersionInfo();
    	~MvGribApiVersionInfo(){};
};

class MvNetcdfVersionInfo : public MvAbstractVersionInfo
{
public:
	MvNetcdfVersionInfo();
    	~MvNetcdfVersionInfo(){};
};

#endif
