(* Handling of a single account. *)

type account

type txn = { year : int;
             month : int;
             day : int;
             creditor : string;
             amount : Sumofmoney.amount;
             description : string;
             automatically_added : bool;
             do_not_symmetrise : bool;
             linked : bool }

val create : string -> string -> (string * string) list -> account
val create_virtual : string -> string -> (string * string) list -> account
val copy : account -> account -> string -> account
val short_name : account -> string
val full_name : account -> string
val is_virtual : account -> bool
val lookup_variable : string -> account -> string
val lookup_integer_variable : string -> account -> int
val lookup_boolean_variable : string -> account -> bool
val add_txn : txn -> account -> account
val add_txn_negated : txn -> account -> account
val iter_txns : (txn -> unit) -> account -> unit
val iter_txns_sorted : (txn -> unit) -> account -> unit
val map_txns : (txn -> txn) -> account -> account
val fold_txns : ('a -> txn -> 'a) -> 'a -> account -> 'a
val total : account -> Sumofmoney.default_units_amount
val create_account_from_channel : string -> in_channel -> account
val number_of_txns : account -> int
val income : account -> Sumofmoney.default_units_amount
val expenditure : account -> Sumofmoney.default_units_amount

