// Copyright 2016 The Snappy-Go Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

package snappy

// extendMatchGoldenTestCases is the i and j arguments, and the returned value,
// for every extendMatch call issued when encoding the
// testdata/Mark.Twain-Tom.Sawyer.txt file. It is used to benchmark the
// extendMatch implementation.
//
// It was generated manually by adding some print statements to the (pure Go)
// extendMatch implementation:
//
//	func extendMatch(src []byte, i, j int) int {
//		i0, j0 := i, j
//		for ; j < len(src) && src[i] == src[j]; i, j = i+1, j+1 {
//		}
//		println("{", i0, ",", j0, ",", j, "},")
//		return j
//	}
//
// and running "go test -test.run=EncodeGoldenInput -tags=noasm".
var extendMatchGoldenTestCases = []struct {
	i, j, want int
}{
	{11, 61, 62},
	{80, 81, 82},
	{86, 87, 101},
	{85, 133, 149},
	{152, 153, 162},
	{133, 168, 193},
	{168, 207, 225},
	{81, 255, 275},
	{278, 279, 283},
	{306, 417, 417},
	{373, 428, 430},
	{389, 444, 447},
	{474, 510, 512},
	{465, 533, 533},
	{47, 547, 547},
	{307, 551, 554},
	{420, 582, 587},
	{309, 604, 604},
	{604, 625, 625},
	{538, 629, 629},
	{328, 640, 640},
	{573, 645, 645},
	{319, 657, 657},
	{30, 664, 664},
	{45, 679, 680},
	{621, 684, 684},
	{376, 700, 700},
	{33, 707, 708},
	{601, 733, 733},
	{334, 744, 745},
	{625, 758, 759},
	{382, 763, 763},
	{550, 769, 771},
	{533, 789, 789},
	{804, 813, 813},
	{342, 841, 842},
	{742, 847, 847},
	{74, 852, 852},
	{810, 864, 864},
	{758, 868, 869},
	{714, 883, 883},
	{582, 889, 891},
	{61, 934, 935},
	{894, 942, 942},
	{939, 949, 949},
	{785, 956, 957},
	{886, 978, 978},
	{792, 998, 998},
	{998, 1005, 1005},
	{572, 1032, 1032},
	{698, 1051, 1053},
	{599, 1067, 1069},
	{1056, 1079, 1079},
	{942, 1089, 1090},
	{831, 1094, 1096},
	{1088, 1100, 1103},
	{732, 1113, 1114},
	{1037, 1118, 1118},
	{872, 1128, 1130},
	{1079, 1140, 1142},
	{332, 1162, 1162},
	{207, 1168, 1186},
	{1189, 1190, 1225},
	{105, 1229, 1230},
	{79, 1256, 1257},
	{1190, 1261, 1283},
	{255, 1306, 1306},
	{1319, 1339, 1358},
	{364, 1370, 1370},
	{955, 1378, 1380},
	{122, 1403, 1403},
	{1325, 1407, 1419},
	{664, 1423, 1424},
	{941, 1461, 1463},
	{867, 1477, 1478},
	{757, 1488, 1489},
	{1140, 1499, 1499},
	{31, 1506, 1506},
	{1487, 1510, 1512},
	{1089, 1520, 1521},
	{1467, 1525, 1529},
	{1394, 1537, 1537},
	{1499, 1541, 1541},
	{367, 1558, 1558},
	{1475, 1564, 1564},
	{1525, 1568, 1571},
	{1541, 1582, 1583},
	{864, 1587, 1588},
	{704, 1597, 1597},
	{336, 1602, 1602},
	{1383, 1613, 1613},
	{1498, 1617, 1618},
	{1051, 1623, 1625},
	{401, 1643, 1645},
	{1072, 1654, 1655},
	{1067, 1667, 1669},
	{699, 1673, 1674},
	{1587, 1683, 1684},
	{920, 1696, 1696},
	{1505, 1710, 1710},
	{1550, 1723, 1723},
	{996, 1727, 1727},
	{833, 1733, 1734},
	{1638, 1739, 1740},
	{1654, 1744, 1744},
	{753, 1761, 1761},
	{1548, 1773, 1773},
	{1568, 1777, 1780},
	{1683, 1793, 1794},
	{948, 1801, 1801},
	{1666, 1805, 1808},
	{1502, 1814, 1814},
	{1696, 1822, 1822},
	{502, 1836, 1837},
	{917, 1843, 1843},
	{1733, 1854, 1855},
	{970, 1859, 1859},
	{310, 1863, 1863},
	{657, 1872, 1872},
	{1005, 1876, 1876},
	{1662, 1880, 1880},
	{904, 1892, 1892},
	{1427, 1910, 1910},
	{1772, 1929, 1930},
	{1822, 1937, 1940},
	{1858, 1949, 1950},
	{1602, 1956, 1956},
	{1150, 1962, 1962},
	{1504, 1966, 1967},
	{51, 1971, 1971},
	{1605, 1979, 1979},
	{1458, 1983, 1988},
	{1536, 2001, 2006},
	{1373, 2014, 2018},
	{1494, 2025, 2025},
	{1667, 2029, 2031},
	{1592, 2035, 2035},
	{330, 2045, 2045},
	{1376, 2053, 2053},
	{1991, 2058, 2059},
	{1635, 2065, 2065},
	{1992, 2073, 2074},
	{2014, 2080, 2081},
	{1546, 2085, 2087},
	{59, 2099, 2099},
	{1996, 2106, 2106},
	{1836, 2110, 2110},
	{2068, 2114, 2114},
	{1338, 2122, 2122},
	{1562, 2128, 2130},
	{1934, 2134, 2134},
	{2114, 2141, 2142},
	{977, 2149, 2150},
	{956, 2154, 2155},
	{1407, 2162, 2162},
	{1773, 2166, 2166},
	{883, 2171, 2171},
	{623, 2175, 2178},
	{1520, 2191, 2192},
	{1162, 2200, 2200},
	{912, 2204, 2204},
	{733, 2208, 2208},
	{1777, 2212, 2215},
	{1532, 2219, 2219},
	{718, 2223, 2225},
	{2069, 2229, 2229},
	{2207, 2245, 2246},
	{1139, 2264, 2264},
	{677, 2274, 2274},
	{2099, 2279, 2279},
	{1863, 2283, 2283},
	{1966, 2305, 2306},
	{2279, 2313, 2313},
	{1628, 2319, 2319},
	{755, 2329, 2329},
	{1461, 2334, 2334},
	{2117, 2340, 2340},
	{2313, 2349, 2349},
	{1859, 2353, 2353},
	{1048, 2362, 2362},
	{895, 2366, 2366},
	{2278, 2373, 2373},
	{1884, 2377, 2377},
	{1402, 2387, 2392},
	{700, 2398, 2398},
	{1971, 2402, 2402},
	{2009, 2419, 2419},
	{1441, 2426, 2428},
	{2208, 2432, 2432},
	{2038, 2436, 2436},
	{932, 2443, 2443},
	{1759, 2447, 2448},
	{744, 2452, 2452},
	{1875, 2458, 2458},
	{2405, 2468, 2468},
	{1596, 2472, 2473},
	{1953, 2480, 2482},
	{736, 2487, 2487},
	{1913, 2493, 2493},
	{774, 2497, 2497},
	{1484, 2506, 2508},
	{2432, 2512, 2512},
	{752, 2519, 2519},
	{2497, 2523, 2523},
	{2409, 2528, 2529},
	{2122, 2533, 2533},
	{2396, 2537, 2538},
	{2410, 2547, 2548},
	{1093, 2555, 2560},
	{551, 2564, 2565},
	{2268, 2569, 2569},
	{1362, 2580, 2580},
	{1916, 2584, 2585},
	{994, 2589, 2590},
	{1979, 2596, 2596},
	{1041, 2602, 2602},
	{2104, 2614, 2616},
	{2609, 2621, 2628},
	{2329, 2638, 2638},
	{2211, 2657, 2658},
	{2638, 2662, 2667},
	{2578, 2676, 2679},
	{2153, 2685, 2686},
	{2608, 2696, 2697},
	{598, 2712, 2712},
	{2620, 2719, 2720},
	{1888, 2724, 2728},
	{2709, 2732, 2732},
	{1365, 2739, 2739},
	{784, 2747, 2748},
	{424, 2753, 2753},
	{2204, 2759, 2759},
	{812, 2768, 2769},
	{2455, 2773, 2773},
	{1722, 2781, 2781},
	{1917, 2792, 2792},
	{2705, 2799, 2799},
	{2685, 2806, 2807},
	{2742, 2811, 2811},
	{1370, 2818, 2818},
	{2641, 2830, 2830},
	{2512, 2837, 2837},
	{2457, 2841, 2841},
	{2756, 2845, 2845},
	{2719, 2855, 2855},
	{1423, 2859, 2859},
	{2849, 2863, 2865},
	{1474, 2871, 2871},
	{1161, 2875, 2876},
	{2282, 2880, 2881},
	{2746, 2888, 2888},
	{1783, 2893, 2893},
	{2401, 2899, 2900},
	{2632, 2920, 2923},
	{2422, 2928, 2930},
	{2715, 2939, 2939},
	{2162, 2943, 2943},
	{2859, 2947, 2947},
	{1910, 2951, 2951},
	{1431, 2955, 2956},
	{1439, 2964, 2964},
	{2501, 2968, 2969},
	{2029, 2973, 2976},
	{689, 2983, 2984},
	{1658, 2988, 2988},
	{1031, 2996, 2996},
	{2149, 3001, 3002},
	{25, 3009, 3013},
	{2964, 3023, 3023},
	{953, 3027, 3028},
	{2359, 3036, 3036},
	{3023, 3049, 3049},
	{2880, 3055, 3056},
	{2973, 3076, 3077},
	{2874, 3090, 3090},
	{2871, 3094, 3094},
	{2532, 3100, 3100},
	{2938, 3107, 3108},
	{350, 3115, 3115},
	{2196, 3119, 3121},
	{1133, 3127, 3129},
	{1797, 3134, 3150},
	{3032, 3158, 3158},
	{3016, 3172, 3172},
	{2533, 3179, 3179},
	{3055, 3187, 3188},
	{1384, 3192, 3193},
	{2799, 3199, 3199},
	{2126, 3203, 3207},
	{2334, 3215, 3215},
	{2105, 3220, 3221},
	{3199, 3229, 3229},
	{2891, 3233, 3233},
	{855, 3240, 3240},
	{1852, 3253, 3256},
	{2140, 3263, 3263},
	{1682, 3268, 3270},
	{3243, 3274, 3274},
	{924, 3279, 3279},
	{2212, 3283, 3283},
	{2596, 3287, 3287},
	{2999, 3291, 3291},
	{2353, 3295, 3295},
	{2480, 3302, 3304},
	{1959, 3308, 3311},
	{3000, 3318, 3318},
	{845, 3330, 3330},
	{2283, 3334, 3334},
	{2519, 3342, 3342},
	{3325, 3346, 3348},
	{2397, 3353, 3354},
	{2763, 3358, 3358},
	{3198, 3363, 3364},
	{3211, 3368, 3372},
	{2950, 3376, 3377},
	{3245, 3388, 3391},
	{2264, 3398, 3398},
	{795, 3403, 3403},
	{3287, 3407, 3407},
	{3358, 3411, 3411},
	{3317, 3415, 3415},
	{3232, 3431, 3431},
	{2128, 3435, 3437},
	{3236, 3441, 3441},
	{3398, 3445, 3446},
	{2814, 3450, 3450},
	{3394, 3466, 3466},
	{2425, 3470, 3470},
	{3330, 3476, 3476},
	{1612, 3480, 3480},
	{1004, 3485, 3486},
	{2732, 3490, 3490},
	{1117, 3494, 3495},
	{629, 3501, 3501},
	{3087, 3514, 3514},
	{684, 3518, 3518},
	{3489, 3522, 3524},
	{1760, 3529, 3529},
	{617, 3537, 3537},
	{3431, 3541, 3541},
	{997, 3547, 3547},
	{882, 3552, 3553},
	{2419, 3558, 3558},
	{610, 3562, 3563},
	{1903, 3567, 3569},
	{3005, 3575, 3575},
	{3076, 3585, 3586},
	{3541, 3590, 3590},
	{3490, 3594, 3594},
	{1899, 3599, 3599},
	{3545, 3606, 3606},
	{3290, 3614, 3615},
	{2056, 3619, 3620},
	{3556, 3625, 3625},
	{3294, 3632, 3633},
	{637, 3643, 3644},
	{3609, 3648, 3650},
	{3175, 3658, 3658},
	{3498, 3665, 3665},
	{1597, 3669, 3669},
	{1983, 3673, 3673},
	{3215, 3682, 3682},
	{3544, 3689, 3689},
	{3694, 3698, 3698},
	{3228, 3715, 3716},
	{2594, 3720, 3722},
	{3573, 3726, 3726},
	{2479, 3732, 3735},
	{3191, 3741, 3742},
	{1113, 3746, 3747},
	{2844, 3751, 3751},
	{3445, 3756, 3757},
	{3755, 3766, 3766},
	{3421, 3775, 3780},
	{3593, 3784, 3786},
	{3263, 3796, 3796},
	{3469, 3806, 3806},
	{2602, 3815, 3815},
	{723, 3819, 3821},
	{1608, 3826, 3826},
	{3334, 3830, 3830},
	{2198, 3835, 3835},
	{2635, 3840, 3840},
	{3702, 3852, 3853},
	{3406, 3858, 3859},
	{3681, 3867, 3870},
	{3407, 3880, 3880},
	{340, 3889, 3889},
	{3772, 3893, 3893},
	{593, 3897, 3897},
	{2563, 3914, 3916},
	{2981, 3929, 3929},
	{1835, 3933, 3934},
	{3906, 3951, 3951},
	{1459, 3958, 3958},
	{3889, 3974, 3974},
	{2188, 3982, 3982},
	{3220, 3986, 3987},
	{3585, 3991, 3993},
	{3712, 3997, 4001},
	{2805, 4007, 4007},
	{1879, 4012, 4013},
	{3618, 4018, 4018},
	{1145, 4031, 4032},
	{3901, 4037, 4037},
	{2772, 4046, 4047},
	{2802, 4053, 4054},
	{3299, 4058, 4058},
	{3725, 4066, 4066},
	{2271, 4070, 4070},
	{385, 4075, 4076},
	{3624, 4089, 4090},
	{3745, 4096, 4098},
	{1563, 4102, 4102},
	{4045, 4106, 4111},
	{3696, 4115, 4119},
	{3376, 4125, 4126},
	{1880, 4130, 4130},
	{2048, 4140, 4141},
	{2724, 4149, 4149},
	{1767, 4156, 4156},
	{2601, 4164, 4164},
	{2757, 4168, 4168},
	{3974, 4172, 4172},
	{3914, 4178, 4178},
	{516, 4185, 4185},
	{1032, 4189, 4190},
	{3462, 4197, 4198},
	{3805, 4202, 4203},
	{3910, 4207, 4212},
	{3075, 4221, 4221},
	{3756, 4225, 4226},
	{1872, 4236, 4237},
	{3844, 4241, 4241},
	{3991, 4245, 4249},
	{2203, 4258, 4258},
	{3903, 4267, 4268},
	{705, 4272, 4272},
	{1896, 4276, 4276},
	{1955, 4285, 4288},
	{3746, 4302, 4303},
	{2672, 4311, 4311},
	{3969, 4317, 4317},
	{3883, 4322, 4322},
	{1920, 4339, 4340},
	{3527, 4344, 4346},
	{1160, 4358, 4358},
	{3648, 4364, 4366},
	{2711, 4387, 4387},
	{3619, 4391, 4392},
	{1944, 4396, 4396},
	{4369, 4400, 4400},
	{2736, 4404, 4407},
	{2546, 4411, 4412},
	{4390, 4422, 4422},
	{3610, 4426, 4427},
	{4058, 4431, 4431},
	{4374, 4435, 4435},
	{3463, 4445, 4446},
	{1813, 4452, 4452},
	{3669, 4456, 4456},
	{3830, 4460, 4460},
	{421, 4464, 4465},
	{1719, 4471, 4471},
	{3880, 4475, 4475},
	{1834, 4485, 4487},
	{3590, 4491, 4491},
	{442, 4496, 4497},
	{4435, 4501, 4501},
	{3814, 4509, 4509},
	{987, 4513, 4513},
	{4494, 4518, 4521},
	{3218, 4526, 4529},
	{4221, 4537, 4537},
	{2778, 4543, 4545},
	{4422, 4552, 4552},
	{4031, 4558, 4559},
	{4178, 4563, 4563},
	{3726, 4567, 4574},
	{4027, 4578, 4578},
	{4339, 4585, 4587},
	{3796, 4592, 4595},
	{543, 4600, 4613},
	{2855, 4620, 4621},
	{2795, 4627, 4627},
	{3440, 4631, 4632},
	{4279, 4636, 4639},
	{4245, 4643, 4645},
	{4516, 4649, 4650},
	{3133, 4654, 4654},
	{4042, 4658, 4659},
	{3422, 4663, 4663},
	{4046, 4667, 4668},
	{4267, 4672, 4672},
	{4004, 4676, 4677},
	{2490, 4682, 4682},
	{2451, 4697, 4697},
	{3027, 4705, 4705},
	{4028, 4717, 4717},
	{4460, 4721, 4721},
	{2471, 4725, 4727},
	{3090, 4735, 4735},
	{3192, 4739, 4740},
	{3835, 4760, 4760},
	{4540, 4764, 4764},
	{4007, 4772, 4774},
	{619, 4784, 4784},
	{3561, 4789, 4791},
	{3367, 4805, 4805},
	{4490, 4810, 4811},
	{2402, 4815, 4815},
	{3352, 4819, 4822},
	{2773, 4828, 4828},
	{4552, 4832, 4832},
	{2522, 4840, 4841},
	{316, 4847, 4852},
	{4715, 4858, 4858},
	{2959, 4862, 4862},
	{4858, 4868, 4869},
	{2134, 4873, 4873},
	{578, 4878, 4878},
	{4189, 4889, 4890},
	{2229, 4894, 4894},
	{4501, 4898, 4898},
	{2297, 4903, 4903},
	{2933, 4909, 4909},
	{3008, 4913, 4913},
	{3153, 4917, 4917},
	{4819, 4921, 4921},
	{4921, 4932, 4933},
	{4920, 4944, 4945},
	{4814, 4954, 4955},
	{576, 4966, 4966},
	{1854, 4970, 4971},
	{1374, 4975, 4976},
	{3307, 4980, 4980},
	{974, 4984, 4988},
	{4721, 4992, 4992},
	{4898, 4996, 4996},
	{4475, 5006, 5006},
	{3819, 5012, 5012},
	{1948, 5019, 5021},
	{4954, 5027, 5029},
	{3740, 5038, 5040},
	{4763, 5044, 5045},
	{1936, 5051, 5051},
	{4844, 5055, 5060},
	{4215, 5069, 5072},
	{1146, 5076, 5076},
	{3845, 5082, 5082},
	{4865, 5090, 5090},
	{4624, 5094, 5094},
	{4815, 5098, 5098},
	{5006, 5105, 5105},
	{4980, 5109, 5109},
	{4795, 5113, 5115},
	{5043, 5119, 5121},
	{4782, 5129, 5129},
	{3826, 5139, 5139},
	{3876, 5156, 5156},
	{3111, 5167, 5171},
	{1470, 5177, 5177},
	{4431, 5181, 5181},
	{546, 5189, 5189},
	{4225, 5193, 5193},
	{1672, 5199, 5201},
	{4207, 5205, 5209},
	{4220, 5216, 5217},
	{4658, 5224, 5225},
	{3295, 5235, 5235},
	{2436, 5239, 5239},
	{2349, 5246, 5246},
	{2175, 5250, 5250},
	{5180, 5257, 5258},
	{3161, 5263, 5263},
	{5105, 5272, 5272},
	{3552, 5282, 5282},
	{4944, 5299, 5300},
	{4130, 5312, 5313},
	{902, 5323, 5323},
	{913, 5327, 5327},
	{2987, 5333, 5334},
	{5150, 5344, 5344},
	{5249, 5348, 5348},
	{1965, 5358, 5359},
	{5330, 5364, 5364},
	{2012, 5373, 5377},
	{712, 5384, 5386},
	{5235, 5390, 5390},
	{5044, 5398, 5399},
	{564, 5406, 5406},
	{39, 5410, 5410},
	{4642, 5422, 5425},
	{4421, 5437, 5438},
	{2347, 5449, 5449},
	{5333, 5453, 5454},
	{4136, 5458, 5459},
	{3793, 5468, 5468},
	{2243, 5480, 5480},
	{4889, 5492, 5493},
	{4295, 5504, 5504},
	{2785, 5511, 5511},
	{2377, 5518, 5518},
	{3662, 5525, 5525},
	{5097, 5529, 5530},
	{4781, 5537, 5538},
	{4697, 5547, 5548},
	{436, 5552, 5553},
	{5542, 5558, 5558},
	{3692, 5562, 5562},
	{2696, 5568, 5569},
	{4620, 5578, 5578},
	{2898, 5590, 5590},
	{5557, 5596, 5618},
	{2797, 5623, 5625},
	{2792, 5629, 5629},
	{5243, 5633, 5633},
	{5348, 5637, 5637},
	{5547, 5643, 5643},
	{4296, 5654, 5655},
	{5568, 5662, 5662},
	{3001, 5670, 5671},
	{3794, 5679, 5679},
	{4006, 5685, 5686},
	{4969, 5690, 5692},
	{687, 5704, 5704},
	{4563, 5708, 5708},
	{1723, 5738, 5738},
	{649, 5742, 5742},
	{5163, 5748, 5755},
	{3907, 5759, 5759},
	{3074, 5764, 5764},
	{5326, 5771, 5771},
	{2951, 5776, 5776},
	{5181, 5780, 5780},
	{2614, 5785, 5788},
	{4709, 5794, 5794},
	{2784, 5799, 5799},
	{5518, 5803, 5803},
	{4155, 5812, 5815},
	{921, 5819, 5819},
	{5224, 5823, 5824},
	{2853, 5830, 5836},
	{5776, 5840, 5840},
	{2955, 5844, 5845},
	{5745, 5853, 5853},
	{3291, 5857, 5857},
	{2988, 5861, 5861},
	{2647, 5865, 5865},
	{5398, 5869, 5870},
	{1085, 5874, 5875},
	{4906, 5881, 5881},
	{802, 5886, 5886},
	{5119, 5890, 5893},
	{5802, 5899, 5900},
	{3415, 5904, 5904},
	{5629, 5908, 5908},
	{3714, 5912, 5914},
	{5558, 5921, 5921},
	{2710, 5927, 5928},
	{1094, 5932, 5934},
	{2653, 5940, 5941},
	{4735, 5954, 5954},
	{5861, 5958, 5958},
	{1040, 5971, 5971},
	{5514, 5977, 5977},
	{5048, 5981, 5982},
	{5953, 5992, 5993},
	{3751, 5997, 5997},
	{4991, 6001, 6002},
	{5885, 6006, 6007},
	{5529, 6011, 6012},
	{4974, 6019, 6020},
	{5857, 6024, 6024},
	{3483, 6032, 6032},
	{3594, 6036, 6036},
	{1997, 6040, 6040},
	{5997, 6044, 6047},
	{5197, 6051, 6051},
	{1764, 6055, 6055},
	{6050, 6059, 6059},
	{5239, 6063, 6063},
	{5049, 6067, 6067},
	{5957, 6073, 6074},
	{1022, 6078, 6078},
	{3414, 6083, 6084},
	{3809, 6090, 6090},
	{4562, 6095, 6096},
	{5878, 6104, 6104},
	{594, 6108, 6109},
	{3353, 6115, 6116},
	{4992, 6120, 6121},
	{2424, 6125, 6125},
	{4484, 6130, 6130},
	{3900, 6134, 6135},
	{5793, 6139, 6141},
	{3562, 6145, 6145},
	{1438, 6152, 6153},
	{6058, 6157, 6158},
	{4411, 6162, 6163},
	{4590, 6167, 6171},
	{4748, 6175, 6175},
	{5517, 6183, 6184},
	{6095, 6191, 6192},
	{1471, 6203, 6203},
	{2643, 6209, 6210},
	{450, 6220, 6220},
	{5266, 6226, 6226},
	{2576, 6233, 6233},
	{2607, 6239, 6240},
	{5164, 6244, 6251},
	{6054, 6255, 6255},
	{1789, 6260, 6261},
	{5250, 6265, 6265},
	{6062, 6273, 6278},
	{5990, 6282, 6282},
	{3283, 6286, 6286},
	{5436, 6290, 6290},
	{6059, 6294, 6294},
	{5668, 6298, 6300},
	{3072, 6324, 6329},
	{3132, 6338, 6339},
	{3246, 6343, 6344},
	{28, 6348, 6349},
	{1503, 6353, 6355},
	{6067, 6359, 6359},
	{3384, 6364, 6364},
	{545, 6375, 6376},
	{5803, 6380, 6380},
	{5522, 6384, 6385},
	{5908, 6389, 6389},
	{2796, 6393, 6396},
	{4831, 6403, 6404},
	{6388, 6412, 6412},
	{6005, 6417, 6420},
	{4450, 6430, 6430},
	{4050, 6435, 6435},
	{5372, 6441, 6441},
	{4378, 6447, 6447},
	{6199, 6452, 6452},
	{3026, 6456, 6456},
	{2642, 6460, 6462},
	{6392, 6470, 6470},
	{6459, 6474, 6474},
	{2829, 6487, 6488},
	{2942, 6499, 6504},
	{5069, 6508, 6511},
	{5341, 6515, 6516},
	{5853, 6521, 6525},
	{6104, 6531, 6531},
	{5759, 6535, 6538},
	{4672, 6542, 6543},
	{2443, 6550, 6550},
	{5109, 6554, 6554},
	{6494, 6558, 6560},
	{6006, 6570, 6572},
	{6424, 6576, 6580},
	{4693, 6591, 6592},
	{6439, 6596, 6597},
	{3179, 6601, 6601},
	{5299, 6606, 6607},
	{4148, 6612, 6613},
	{3774, 6617, 6617},
	{3537, 6623, 6624},
	{4975, 6628, 6629},
	{3848, 6636, 6636},
	{856, 6640, 6640},
	{5724, 6645, 6645},
	{6632, 6651, 6651},
	{4630, 6656, 6658},
	{1440, 6662, 6662},
	{4281, 6666, 6667},
	{4302, 6671, 6672},
	{2589, 6676, 6677},
	{5647, 6681, 6687},
	{6082, 6691, 6693},
	{6144, 6698, 6698},
	{6103, 6709, 6710},
	{3710, 6714, 6714},
	{4253, 6718, 6721},
	{2467, 6730, 6730},
	{4778, 6734, 6734},
	{6528, 6738, 6738},
	{4358, 6747, 6747},
	{5889, 6753, 6753},
	{5193, 6757, 6757},
	{5797, 6761, 6761},
	{3858, 6765, 6766},
	{5951, 6776, 6776},
	{6487, 6781, 6782},
	{3282, 6786, 6787},
	{4667, 6797, 6799},
	{1927, 6803, 6806},
	{6583, 6810, 6810},
	{4937, 6814, 6814},
	{6099, 6824, 6824},
	{4415, 6835, 6836},
	{6332, 6840, 6841},
	{5160, 6850, 6850},
	{4764, 6854, 6854},
	{6814, 6858, 6859},
	{3018, 6864, 6864},
	{6293, 6868, 6869},
	{6359, 6877, 6877},
	{3047, 6884, 6886},
	{5262, 6890, 6891},
	{5471, 6900, 6900},
	{3268, 6910, 6912},
	{1047, 6916, 6916},
	{5904, 6923, 6923},
	{5798, 6933, 6938},
	{4149, 6942, 6942},
	{1821, 6946, 6946},
	{3599, 6952, 6952},
	{6470, 6957, 6957},
	{5562, 6961, 6961},
	{6268, 6965, 6967},
	{6389, 6971, 6971},
	{6596, 6975, 6976},
	{6553, 6980, 6981},
	{6576, 6985, 6989},
	{1375, 6993, 6993},
	{652, 6998, 6998},
	{4876, 7002, 7003},
	{5768, 7011, 7013},
	{3973, 7017, 7017},
	{6802, 7025, 7025},
	{6955, 7034, 7036},
	{6974, 7040, 7040},
	{5944, 7044, 7044},
	{6992, 7048, 7054},
	{6872, 7059, 7059},
	{2943, 7063, 7063},
	{6923, 7067, 7067},
	{5094, 7071, 7071},
	{4873, 7075, 7075},
	{5819, 7079, 7079},
	{5945, 7085, 7085},
	{1540, 7090, 7091},
	{2090, 7095, 7095},
	{5024, 7104, 7105},
	{6900, 7109, 7109},
	{6024, 7113, 7114},
	{6000, 7118, 7120},
	{2187, 7124, 7125},
	{6760, 7129, 7130},
	{5898, 7134, 7136},
	{7032, 7144, 7144},
	{4271, 7148, 7148},
	{3706, 7152, 7152},
	{6970, 7156, 7157},
	{7088, 7161, 7163},
	{2718, 7168, 7169},
	{5674, 7175, 7175},
	{4631, 7182, 7182},
	{7070, 7188, 7189},
	{6220, 7196, 7196},
	{3458, 7201, 7202},
	{2041, 7211, 7212},
	{1454, 7216, 7216},
	{5199, 7225, 7227},
	{3529, 7234, 7234},
	{6890, 7238, 7238},
	{3815, 7242, 7243},
	{5490, 7250, 7253},
	{6554, 7257, 7263},
	{5890, 7267, 7269},
	{6877, 7273, 7273},
	{4877, 7277, 7277},
	{2502, 7285, 7285},
	{1483, 7289, 7295},
	{7210, 7304, 7308},
	{6845, 7313, 7316},
	{7219, 7320, 7320},
	{7001, 7325, 7329},
	{6853, 7333, 7334},
	{6120, 7338, 7338},
	{6606, 7342, 7343},
	{7020, 7348, 7350},
	{3509, 7354, 7354},
	{7133, 7359, 7363},
	{3434, 7371, 7374},
	{2787, 7384, 7384},
	{7044, 7388, 7388},
	{6960, 7394, 7395},
	{6676, 7399, 7400},
	{7161, 7404, 7404},
	{7285, 7417, 7418},
	{4558, 7425, 7426},
	{4828, 7430, 7430},
	{6063, 7436, 7436},
	{3597, 7442, 7442},
	{914, 7446, 7446},
	{7320, 7452, 7454},
	{7267, 7458, 7460},
	{5076, 7464, 7464},
	{7430, 7468, 7469},
	{6273, 7473, 7474},
	{7440, 7478, 7487},
	{7348, 7491, 7494},
	{1021, 7510, 7510},
	{7473, 7515, 7515},
	{2823, 7519, 7519},
	{6264, 7527, 7527},
	{7302, 7531, 7531},
	{7089, 7535, 7535},
	{7342, 7540, 7541},
	{3688, 7547, 7551},
	{3054, 7558, 7560},
	{4177, 7566, 7567},
	{6691, 7574, 7575},
	{7156, 7585, 7586},
	{7147, 7590, 7592},
	{7407, 7598, 7598},
	{7403, 7602, 7603},
	{6868, 7607, 7607},
	{6636, 7611, 7611},
	{4805, 7617, 7617},
	{5779, 7623, 7623},
	{7063, 7627, 7627},
	{5079, 7632, 7632},
	{7377, 7637, 7637},
	{7337, 7641, 7642},
	{6738, 7655, 7655},
	{7338, 7659, 7659},
	{6541, 7669, 7671},
	{595, 7675, 7675},
	{7658, 7679, 7680},
	{7647, 7685, 7686},
	{2477, 7690, 7690},
	{5823, 7694, 7694},
	{4156, 7699, 7699},
	{5931, 7703, 7706},
	{6854, 7712, 7712},
	{4931, 7718, 7718},
	{6979, 7722, 7722},
	{5085, 7727, 7727},
	{6965, 7732, 7732},
	{7201, 7736, 7737},
	{3639, 7741, 7743},
	{7534, 7749, 7749},
	{4292, 7753, 7753},
	{3427, 7759, 7763},
	{7273, 7767, 7767},
	{940, 7778, 7778},
	{4838, 7782, 7785},
	{4216, 7790, 7792},
	{922, 7800, 7801},
	{7256, 7810, 7811},
	{7789, 7815, 7819},
	{7225, 7823, 7825},
	{7531, 7829, 7829},
	{6997, 7833, 7833},
	{7757, 7837, 7838},
	{4129, 7842, 7842},
	{7333, 7848, 7849},
	{6776, 7855, 7855},
	{7527, 7859, 7859},
	{4370, 7863, 7863},
	{4512, 7868, 7868},
	{5679, 7880, 7880},
	{3162, 7884, 7885},
	{3933, 7892, 7894},
	{7804, 7899, 7902},
	{6363, 7906, 7907},
	{7848, 7911, 7912},
	{5584, 7917, 7921},
	{874, 7926, 7926},
	{3342, 7930, 7930},
	{4507, 7935, 7937},
	{3672, 7943, 7944},
	{7911, 7948, 7949},
	{6402, 7956, 7956},
	{7940, 7960, 7960},
	{7113, 7964, 7964},
	{1073, 7968, 7968},
	{7740, 7974, 7974},
	{7601, 7978, 7982},
	{6797, 7987, 7988},
	{3528, 7994, 7995},
	{5483, 7999, 7999},
	{5717, 8011, 8011},
	{5480, 8017, 8017},
	{7770, 8023, 8030},
	{2452, 8034, 8034},
	{5282, 8047, 8047},
	{7967, 8051, 8051},
	{1128, 8058, 8066},
	{6348, 8070, 8070},
	{8055, 8077, 8077},
	{7925, 8081, 8086},
	{6810, 8090, 8090},
	{5051, 8101, 8101},
	{4696, 8109, 8110},
	{5129, 8119, 8119},
	{4449, 8123, 8123},
	{7222, 8127, 8127},
	{4649, 8131, 8134},
	{7994, 8138, 8138},
	{5954, 8148, 8148},
	{475, 8152, 8153},
	{7906, 8157, 8157},
	{7458, 8164, 8166},
	{7632, 8171, 8173},
	{3874, 8177, 8183},
	{4391, 8187, 8187},
	{561, 8191, 8191},
	{2417, 8195, 8195},
	{2357, 8204, 8204},
	{2269, 8216, 8218},
	{3968, 8222, 8222},
	{2200, 8226, 8227},
	{3453, 8247, 8247},
	{2439, 8251, 8252},
	{7175, 8257, 8257},
	{976, 8262, 8264},
	{4953, 8273, 8273},
	{4219, 8278, 8278},
	{6, 8285, 8291},
	{5703, 8295, 8296},
	{5272, 8300, 8300},
	{8037, 8304, 8304},
	{8186, 8314, 8314},
	{8304, 8318, 8318},
	{8051, 8326, 8326},
	{8318, 8330, 8330},
	{2671, 8334, 8335},
	{2662, 8339, 8339},
	{8081, 8349, 8350},
	{3328, 8356, 8356},
	{2879, 8360, 8362},
	{8050, 8370, 8371},
	{8330, 8375, 8376},
	{8375, 8386, 8386},
	{4961, 8390, 8390},
	{1017, 8403, 8405},
	{3533, 8416, 8416},
	{4555, 8422, 8422},
	{6445, 8426, 8426},
	{8169, 8432, 8432},
	{990, 8436, 8436},
	{4102, 8440, 8440},
	{7398, 8444, 8446},
	{3480, 8450, 8450},
	{6324, 8462, 8462},
	{7948, 8466, 8467},
	{5950, 8471, 8471},
	{5189, 8476, 8476},
	{4026, 8490, 8490},
	{8374, 8494, 8495},
	{4682, 8501, 8501},
	{7387, 8506, 8506},
	{8164, 8510, 8515},
	{4079, 8524, 8524},
	{8360, 8529, 8531},
	{7446, 8540, 8543},
	{7971, 8547, 8548},
	{4311, 8552, 8552},
	{5204, 8556, 8557},
	{7968, 8562, 8562},
	{7847, 8571, 8573},
	{8547, 8577, 8577},
	{5320, 8581, 8581},
	{8556, 8585, 8586},
	{8504, 8590, 8590},
	{7669, 8602, 8604},
	{5874, 8608, 8609},
	{5828, 8613, 8613},
	{7998, 8617, 8617},
	{8519, 8625, 8625},
	{7250, 8637, 8637},
	{426, 8641, 8641},
	{8436, 8645, 8645},
	{5986, 8649, 8656},
	{8157, 8660, 8660},
	{7182, 8665, 8665},
	{8421, 8675, 8675},
	{8509, 8681, 8681},
	{5137, 8688, 8689},
	{8625, 8694, 8695},
	{5228, 8701, 8702},
	{6661, 8714, 8714},
	{1010, 8719, 8719},
	{6648, 8723, 8723},
	{3500, 8728, 8728},
	{2442, 8735, 8735},
	{8494, 8740, 8741},
	{8171, 8753, 8755},
	{7242, 8763, 8764},
	{4739, 8768, 8769},
	{7079, 8773, 8773},
	{8386, 8777, 8777},
	{8624, 8781, 8787},
	{661, 8791, 8794},
	{8631, 8801, 8801},
	{7753, 8805, 8805},
	{4783, 8809, 8810},
	{1673, 8814, 8815},
	{6623, 8819, 8819},
	{4404, 8823, 8823},
	{8089, 8827, 8828},
	{8773, 8832, 8832},
	{5394, 8836, 8836},
	{6231, 8841, 8843},
	{1015, 8852, 8853},
	{6873, 8857, 8857},
	{6289, 8865, 8865},
	{8577, 8869, 8869},
	{8114, 8873, 8875},
	{8534, 8883, 8883},
	{3007, 8887, 8888},
	{8827, 8892, 8893},
	{4788, 8897, 8900},
	{5698, 8906, 8907},
	{7690, 8911, 8911},
	{6643, 8919, 8919},
	{7206, 8923, 8924},
	{7866, 8929, 8931},
	{8880, 8942, 8942},
	{8630, 8951, 8952},
	{6027, 8958, 8958},
	{7749, 8966, 8967},
	{4932, 8972, 8973},
	{8892, 8980, 8981},
	{634, 9003, 9003},
	{8109, 9007, 9008},
	{8777, 9012, 9012},
	{3981, 9016, 9017},
	{5723, 9025, 9025},
	{7662, 9034, 9038},
	{8955, 9042, 9042},
	{8070, 9060, 9062},
	{8910, 9066, 9066},
	{5363, 9070, 9071},
	{7699, 9075, 9076},
	{8991, 9081, 9081},
	{6850, 9085, 9085},
	{5811, 9092, 9094},
	{9079, 9098, 9102},
	{6456, 9106, 9106},
	{2259, 9111, 9111},
	{4752, 9116, 9116},
	{9060, 9120, 9123},
	{8090, 9127, 9127},
	{5305, 9131, 9132},
	{8623, 9137, 9137},
	{7417, 9141, 9141},
	{6564, 9148, 9149},
	{9126, 9157, 9158},
	{4285, 9169, 9170},
	{8698, 9174, 9174},
	{8869, 9178, 9178},
	{2572, 9182, 9183},
	{6482, 9188, 9190},
	{9181, 9201, 9201},
	{2968, 9208, 9209},
	{2506, 9213, 9215},
	{9127, 9219, 9219},
	{7910, 9225, 9227},
	{5422, 9235, 9239},
	{8813, 9244, 9246},
	{9178, 9250, 9250},
	{8748, 9255, 9255},
	{7354, 9265, 9265},
	{7767, 9269, 9269},
	{7710, 9281, 9283},
	{8826, 9288, 9290},
	{861, 9295, 9295},
	{4482, 9301, 9301},
	{9264, 9305, 9306},
	{8805, 9310, 9310},
	{4995, 9314, 9314},
	{6730, 9318, 9318},
	{7457, 9328, 9328},
	{2547, 9335, 9336},
	{6298, 9340, 9343},
	{9305, 9353, 9354},
	{9269, 9358, 9358},
	{6338, 9370, 9370},
	{7289, 9376, 9379},
	{5780, 9383, 9383},
	{7607, 9387, 9387},
	{2065, 9392, 9392},
	{7238, 9396, 9396},
	{8856, 9400, 9400},
	{8069, 9412, 9413},
	{611, 9420, 9420},
	{7071, 9424, 9424},
	{3089, 9430, 9431},
	{7117, 9435, 9438},
	{1976, 9445, 9445},
	{6640, 9449, 9449},
	{5488, 9453, 9453},
	{8739, 9457, 9459},
	{5958, 9466, 9466},
	{7985, 9470, 9470},
	{8735, 9475, 9475},
	{5009, 9479, 9479},
	{8073, 9483, 9484},
	{2328, 9490, 9491},
	{9250, 9495, 9495},
	{4043, 9502, 9502},
	{7712, 9506, 9506},
	{9012, 9510, 9510},
	{9028, 9514, 9515},
	{2190, 9521, 9524},
	{9029, 9528, 9528},
	{9519, 9532, 9532},
	{9495, 9536, 9536},
	{8527, 9540, 9540},
	{2137, 9550, 9550},
	{8419, 9557, 9557},
	{9383, 9561, 9562},
	{8970, 9575, 9578},
	{8911, 9582, 9582},
	{7828, 9595, 9596},
	{6180, 9600, 9600},
	{8738, 9604, 9607},
	{7540, 9611, 9612},
	{9599, 9616, 9618},
	{9187, 9623, 9623},
	{9294, 9628, 9629},
	{4536, 9639, 9639},
	{3867, 9643, 9643},
	{6305, 9648, 9648},
	{1617, 9654, 9657},
	{5762, 9666, 9666},
	{8314, 9670, 9670},
	{9666, 9674, 9675},
	{9506, 9679, 9679},
	{9669, 9685, 9686},
	{9683, 9690, 9690},
	{8763, 9697, 9698},
	{7468, 9702, 9702},
	{460, 9707, 9707},
	{3115, 9712, 9712},
	{9424, 9716, 9717},
	{7359, 9721, 9724},
	{7547, 9728, 9729},
	{7151, 9733, 9738},
	{7627, 9742, 9742},
	{2822, 9747, 9747},
	{8247, 9751, 9753},
	{9550, 9758, 9758},
	{7585, 9762, 9763},
	{1002, 9767, 9767},
	{7168, 9772, 9773},
	{6941, 9777, 9780},
	{9728, 9784, 9786},
	{9770, 9792, 9796},
	{6411, 9801, 9802},
	{3689, 9806, 9808},
	{9575, 9814, 9816},
	{7025, 9820, 9821},
	{2776, 9826, 9826},
	{9806, 9830, 9830},
	{9820, 9834, 9835},
	{9800, 9839, 9847},
	{9834, 9851, 9852},
	{9829, 9856, 9862},
	{1400, 9866, 9866},
	{3197, 9870, 9871},
	{9851, 9875, 9876},
	{9742, 9883, 9884},
	{3362, 9888, 9889},
	{9883, 9893, 9893},
	{5711, 9899, 9910},
	{7806, 9915, 9915},
	{9120, 9919, 9919},
	{9715, 9925, 9934},
	{2580, 9938, 9938},
	{4907, 9942, 9944},
	{6239, 9953, 9954},
	{6961, 9963, 9963},
	{5295, 9967, 9968},
	{1915, 9972, 9973},
	{3426, 9983, 9985},
	{9875, 9994, 9995},
	{6942, 9999, 9999},
	{6621, 10005, 10005},
	{7589, 10010, 10012},
	{9286, 10020, 10020},
	{838, 10024, 10024},
	{9980, 10028, 10031},
	{9994, 10035, 10041},
	{2702, 10048, 10051},
	{2621, 10059, 10059},
	{10054, 10065, 10065},
	{8612, 10073, 10074},
	{7033, 10078, 10078},
	{916, 10082, 10082},
	{10035, 10086, 10087},
	{8613, 10097, 10097},
	{9919, 10107, 10108},
	{6133, 10114, 10115},
	{10059, 10119, 10119},
	{10065, 10126, 10127},
	{7732, 10131, 10131},
	{7155, 10135, 10136},
	{6728, 10140, 10140},
	{6162, 10144, 10145},
	{4724, 10150, 10150},
	{1665, 10154, 10154},
	{10126, 10163, 10163},
	{9783, 10168, 10168},
	{1715, 10172, 10173},
	{7152, 10177, 10182},
	{8760, 10187, 10187},
	{7829, 10191, 10191},
	{9679, 10196, 10196},
	{9369, 10201, 10201},
	{2928, 10206, 10208},
	{6951, 10214, 10217},
	{5633, 10221, 10221},
	{7199, 10225, 10225},
	{10118, 10230, 10231},
	{9999, 10235, 10236},
	{10045, 10240, 10249},
	{5565, 10256, 10256},
	{9866, 10261, 10261},
	{10163, 10268, 10268},
	{9869, 10272, 10272},
	{9789, 10276, 10283},
	{10235, 10287, 10288},
	{10214, 10298, 10299},
	{6971, 10303, 10303},
	{3346, 10307, 10307},
	{10185, 10311, 10312},
	{9993, 10318, 10320},
	{2779, 10332, 10334},
	{1726, 10338, 10338},
	{741, 10354, 10360},
	{10230, 10372, 10373},
	{10260, 10384, 10385},
	{10131, 10389, 10398},
	{6946, 10406, 10409},
	{10158, 10413, 10420},
	{10123, 10424, 10424},
	{6157, 10428, 10429},
	{4518, 10434, 10434},
	{9893, 10438, 10438},
	{9865, 10442, 10446},
	{7558, 10454, 10454},
	{10434, 10460, 10460},
	{10064, 10466, 10468},
	{2703, 10472, 10474},
	{9751, 10478, 10479},
	{6714, 10485, 10485},
	{8020, 10490, 10490},
	{10303, 10494, 10494},
	{3521, 10499, 10500},
	{9281, 10513, 10515},
	{6028, 10519, 10523},
	{9387, 10527, 10527},
	{7614, 10531, 10531},
	{3611, 10536, 10536},
	{9162, 10540, 10540},
	{10081, 10546, 10547},
	{10034, 10560, 10562},
	{6726, 10567, 10571},
	{8237, 10575, 10575},
	{10438, 10579, 10583},
	{10140, 10587, 10587},
	{5784, 10592, 10592},
	{9819, 10597, 10600},
	{10567, 10604, 10608},
	{9335, 10613, 10613},
	{8300, 10617, 10617},
	{10575, 10621, 10621},
	{9678, 10625, 10626},
	{9962, 10632, 10633},
	{10535, 10637, 10638},
	{8199, 10642, 10642},
	{10372, 10647, 10648},
	{10637, 10656, 10657},
	{10579, 10667, 10668},
	{10465, 10677, 10680},
	{6702, 10684, 10685},
	{10073, 10691, 10692},
	{4505, 10696, 10697},
	{9042, 10701, 10701},
	{6460, 10705, 10706},
	{10010, 10714, 10716},
	{10656, 10720, 10722},
	{7282, 10727, 10729},
	{2327, 10733, 10733},
	{2491, 10740, 10741},
	{10704, 10748, 10750},
	{6465, 10754, 10754},
	{10647, 10758, 10759},
	{10424, 10763, 10763},
	{10748, 10776, 10776},
	{10546, 10780, 10781},
	{10758, 10785, 10786},
	{10287, 10790, 10797},
	{10785, 10801, 10807},
	{10240, 10811, 10826},
	{9509, 10830, 10830},
	{2579, 10836, 10838},
	{9801, 10843, 10845},
	{7555, 10849, 10850},
	{10776, 10860, 10865},
	{8023, 10869, 10869},
	{10046, 10876, 10884},
	{10253, 10888, 10892},
	{9941, 10897, 10897},
	{7898, 10901, 10905},
	{6725, 10909, 10913},
	{10757, 10921, 10923},
	{10160, 10931, 10931},
	{10916, 10935, 10942},
	{10261, 10946, 10946},
	{10318, 10952, 10954},
	{5911, 10959, 10961},
	{10801, 10965, 10966},
	{10946, 10970, 10977},
	{10592, 10982, 10984},
	{9913, 10988, 10990},
	{8510, 10994, 10996},
	{9419, 11000, 11001},
	{6765, 11006, 11007},
	{10725, 11011, 11011},
	{5537, 11017, 11019},
	{9208, 11024, 11025},
	{5850, 11030, 11030},
	{9610, 11034, 11036},
	{8846, 11041, 11047},
	{9697, 11051, 11051},
	{1622, 11055, 11058},
	{2370, 11062, 11062},
	{8393, 11067, 11067},
	{9756, 11071, 11071},
	{10172, 11076, 11076},
	{27, 11081, 11081},
	{7357, 11087, 11092},
	{8151, 11104, 11106},
	{6115, 11110, 11110},
	{10667, 11114, 11115},
	{11099, 11121, 11123},
	{10705, 11127, 11127},
	{8938, 11131, 11131},
	{11114, 11135, 11136},
	{1390, 11140, 11141},
	{10964, 11146, 11148},
	{11140, 11152, 11155},
	{9813, 11159, 11166},
	{624, 11171, 11172},
	{3118, 11177, 11179},
	{11029, 11184, 11186},
	{10186, 11190, 11190},
	{10306, 11196, 11196},
	{8665, 11201, 11201},
	{7382, 11205, 11205},
	{1100, 11210, 11210},
	{2337, 11216, 11217},
	{1609, 11221, 11223},
	{5763, 11228, 11229},
	{5220, 11233, 11233},
	{11061, 11241, 11241},
	{10617, 11246, 11246},
	{11190, 11250, 11251},
	{10144, 11255, 11256},
	{11232, 11260, 11260},
	{857, 11264, 11265},
	{10994, 11269, 11271},
	{3879, 11280, 11281},
	{11184, 11287, 11289},
	{9611, 11293, 11295},
	{11250, 11299, 11299},
	{4495, 11304, 11304},
	{7574, 11308, 11309},
	{9814, 11315, 11317},
	{1713, 11321, 11324},
	{1905, 11328, 11328},
	{8745, 11335, 11340},
	{8883, 11351, 11351},
	{8119, 11358, 11358},
	{1842, 11363, 11364},
	{11237, 11368, 11368},
	{8814, 11373, 11374},
	{5684, 11378, 11378},
	{11011, 11382, 11382},
	{6520, 11389, 11389},
	{11183, 11393, 11396},
	{1790, 11404, 11404},
	{9536, 11408, 11408},
	{11298, 11418, 11419},
	{3929, 11425, 11425},
	{5588, 11429, 11429},
	{8476, 11436, 11436},
	{4096, 11440, 11442},
	{11084, 11446, 11454},
	{10603, 11458, 11463},
	{7332, 11472, 11474},
	{7611, 11483, 11486},
	{4836, 11490, 11491},
	{10024, 11495, 11495},
	{4917, 11501, 11506},
	{6486, 11510, 11512},
	{11269, 11516, 11518},
	{3603, 11522, 11525},
	{11126, 11535, 11535},
	{11418, 11539, 11541},
	{11408, 11545, 11545},
	{9021, 11549, 11552},
	{6745, 11557, 11557},
	{5118, 11561, 11564},
	{7590, 11568, 11569},
	{4426, 11573, 11578},
	{9790, 11582, 11583},
	{6447, 11587, 11587},
	{10229, 11591, 11594},
	{10457, 11598, 11598},
	{10168, 11604, 11604},
	{10543, 11608, 11608},
	{7404, 11612, 11612},
	{11127, 11616, 11616},
	{3337, 11620, 11620},
	{11501, 11624, 11628},
	{4543, 11633, 11635},
	{8449, 11642, 11642},
	{4943, 11646, 11648},
	{10526, 11652, 11654},
	{11620, 11659, 11659},
	{8927, 11664, 11669},
	{532, 11673, 11673},
	{10513, 11677, 11679},
	{10428, 11683, 11683},
	{10999, 11689, 11690},
	{9469, 11695, 11695},
	{3606, 11699, 11699},
	{9560, 11708, 11709},
	{1564, 11714, 11714},
	{10527, 11718, 11718},
	{3071, 11723, 11726},
	{11590, 11731, 11732},
	{6605, 11737, 11737},
	{11624, 11741, 11745},
	{7822, 11749, 11752},
	{5269, 11757, 11758},
	{1339, 11767, 11767},
	{1363, 11771, 11773},
	{3704, 11777, 11777},
	{10952, 11781, 11783},
	{6764, 11793, 11795},
	{8675, 11800, 11800},
	{9963, 11804, 11804},
	{11573, 11808, 11809},
	{9548, 11813, 11813},
	{11591, 11817, 11818},
	{11446, 11822, 11822},
	{9224, 11828, 11828},
	{3158, 11836, 11836},
	{10830, 11840, 11840},
	{7234, 11846, 11846},
	{11299, 11850, 11850},
	{11544, 11854, 11855},
	{11498, 11859, 11859},
	{10993, 11865, 11868},
	{9720, 11872, 11878},
	{10489, 11882, 11890},
	{11712, 11898, 11904},
	{11516, 11908, 11910},
	{11568, 11914, 11915},
	{10177, 11919, 11924},
	{11363, 11928, 11929},
	{10494, 11933, 11933},
	{9870, 11937, 11938},
	{9427, 11942, 11942},
	{11481, 11949, 11949},
	{6030, 11955, 11957},
	{11718, 11961, 11961},
	{10531, 11965, 11983},
	{5126, 11987, 11987},
	{7515, 11991, 11991},
	{10646, 11996, 11997},
	{2947, 12001, 12001},
	{9582, 12009, 12010},
	{6202, 12017, 12018},
	{11714, 12022, 12022},
	{9235, 12033, 12037},
	{9721, 12041, 12044},
	{11932, 12051, 12052},
	{12040, 12056, 12056},
	{12051, 12060, 12060},
	{11601, 12066, 12066},
	{8426, 12070, 12070},
	{4053, 12077, 12077},
	{4262, 12081, 12081},
	{9761, 12086, 12088},
	{11582, 12092, 12093},
	{10965, 12097, 12098},
	{11803, 12103, 12104},
	{11933, 12108, 12109},
	{10688, 12117, 12117},
	{12107, 12125, 12126},
	{6774, 12130, 12132},
	{6286, 12137, 12137},
	{9543, 12141, 12141},
	{12097, 12145, 12146},
	{10790, 12150, 12150},
	{10125, 12154, 12156},
	{12125, 12164, 12164},
	{12064, 12168, 12172},
	{10811, 12178, 12188},
	{12092, 12192, 12193},
	{10058, 12197, 12198},
	{11611, 12211, 12212},
	{3459, 12216, 12216},
	{10291, 12225, 12228},
	{12191, 12232, 12234},
	{12145, 12238, 12238},
	{12001, 12242, 12250},
	{3840, 12255, 12255},
	{12216, 12259, 12259},
	{674, 12272, 12272},
	{12141, 12276, 12276},
	{10766, 12280, 12280},
	{11545, 12284, 12284},
	{6496, 12290, 12290},
	{11381, 12294, 12295},
	{603, 12302, 12303},
	{12276, 12308, 12308},
	{11850, 12313, 12314},
	{565, 12319, 12319},
	{9351, 12324, 12324},
	{11822, 12328, 12328},
	{2691, 12333, 12334},
	{11840, 12338, 12338},
	{11070, 12343, 12343},
	{9510, 12347, 12347},
	{11024, 12352, 12353},
	{7173, 12359, 12359},
	{517, 12363, 12363},
	{6311, 12367, 12368},
	{11367, 12372, 12373},
	{12008, 12377, 12377},
	{11372, 12382, 12384},
	{11358, 12391, 12392},
	{11382, 12396, 12396},
	{6882, 12400, 12401},
	{11246, 12405, 12405},
	{8359, 12409, 12412},
	{10154, 12418, 12418},
	{12016, 12425, 12426},
	{8972, 12434, 12435},
	{10478, 12439, 12440},
	{12395, 12449, 12449},
	{11612, 12454, 12454},
	{12347, 12458, 12458},
	{10700, 12466, 12467},
	{3637, 12471, 12476},
	{1042, 12480, 12481},
	{6747, 12488, 12488},
	{12396, 12492, 12493},
	{9420, 12497, 12497},
	{11285, 12501, 12510},
	{4470, 12515, 12515},
	{9374, 12519, 12519},
	{11293, 12528, 12528},
	{2058, 12534, 12535},
	{6521, 12539, 12539},
	{12492, 12543, 12543},
	{3043, 12547, 12547},
	{2982, 12551, 12553},
	{11030, 12557, 12563},
	{7636, 12568, 12568},
	{9639, 12572, 12572},
	{12543, 12576, 12576},
	{5989, 12580, 12583},
	{11051, 12587, 12587},
	{1061, 12592, 12594},
	{12313, 12599, 12601},
	{11846, 12605, 12605},
	{12576, 12609, 12609},
	{11040, 12618, 12625},
	{12479, 12629, 12629},
	{6903, 12633, 12633},
	{12322, 12639, 12639},
	{12253, 12643, 12645},
	{5594, 12651, 12651},
	{12522, 12655, 12655},
	{11703, 12659, 12659},
	{1377, 12665, 12665},
	{8022, 12669, 12669},
	{12280, 12674, 12674},
	{9023, 12680, 12681},
	{12328, 12685, 12685},
	{3085, 12689, 12693},
	{4700, 12698, 12698},
	{10224, 12702, 12702},
	{8781, 12706, 12706},
	{1651, 12710, 12710},
	{12458, 12714, 12714},
	{12005, 12718, 12721},
	{11908, 12725, 12726},
	{8202, 12733, 12733},
	{11708, 12739, 12740},
	{12599, 12744, 12745},
	{12284, 12749, 12749},
	{5285, 12756, 12756},
	{12055, 12775, 12777},
	{6919, 12782, 12782},
	{12242, 12786, 12786},
	{12009, 12790, 12790},
	{9628, 12794, 12796},
	{11354, 12801, 12802},
	{10225, 12806, 12807},
	{579, 12813, 12813},
	{8935, 12817, 12822},
	{8753, 12827, 12829},
	{11006, 12835, 12835},
	{858, 12841, 12845},
	{476, 12849, 12849},
	{7667, 12854, 12854},
	{12760, 12860, 12871},
	{11677, 12875, 12877},
	{12714, 12881, 12881},
	{12731, 12885, 12890},
	{7108, 12894, 12896},
	{1165, 12900, 12900},
	{4021, 12906, 12906},
	{10829, 12910, 12911},
	{12331, 12915, 12915},
	{8887, 12919, 12921},
	{11639, 12925, 12925},
	{7964, 12929, 12929},
	{12528, 12937, 12937},
	{8148, 12941, 12941},
	{12770, 12948, 12950},
	{12609, 12954, 12954},
	{12685, 12958, 12958},
	{2803, 12962, 12962},
	{9561, 12966, 12966},
	{6671, 12972, 12973},
	{12056, 12977, 12977},
	{6380, 12981, 12981},
	{12048, 12985, 12985},
	{11961, 12989, 12993},
	{3368, 12997, 12999},
	{6634, 13004, 13004},
	{6775, 13009, 13010},
	{12136, 13014, 13019},
	{10341, 13023, 13023},
	{13002, 13027, 13027},
	{10587, 13031, 13031},
	{10307, 13035, 13035},
	{12736, 13039, 13039},
	{12744, 13043, 13044},
	{6175, 13048, 13048},
	{9702, 13053, 13054},
	{662, 13059, 13061},
	{12718, 13065, 13068},
	{12893, 13072, 13075},
	{8299, 13086, 13091},
	{12604, 13095, 13096},
	{12848, 13100, 13101},
	{12749, 13105, 13105},
	{12526, 13109, 13114},
	{9173, 13122, 13122},
	{12769, 13128, 13128},
	{13038, 13132, 13132},
	{12725, 13136, 13137},
	{12639, 13146, 13146},
	{9711, 13150, 13151},
	{12137, 13155, 13155},
	{13039, 13159, 13159},
	{4681, 13163, 13164},
	{12954, 13168, 13168},
	{13158, 13175, 13176},
	{13105, 13180, 13180},
	{10754, 13184, 13184},
	{13167, 13188, 13188},
	{12658, 13192, 13192},
	{4294, 13199, 13200},
	{11682, 13204, 13205},
	{11695, 13209, 13209},
	{11076, 13214, 13214},
	{12232, 13218, 13218},
	{9399, 13223, 13224},
	{12880, 13228, 13229},
	{13048, 13234, 13234},
	{9701, 13238, 13239},
	{13209, 13243, 13243},
	{3658, 13248, 13248},
	{3698, 13252, 13254},
	{12237, 13260, 13260},
	{8872, 13266, 13266},
	{12957, 13272, 13273},
	{1393, 13281, 13281},
	{2013, 13285, 13288},
	{4244, 13296, 13299},
	{9428, 13303, 13303},
	{12702, 13307, 13307},
	{13078, 13311, 13311},
	{6071, 13315, 13315},
	{3061, 13319, 13319},
	{2051, 13324, 13324},
	{11560, 13328, 13331},
	{6584, 13336, 13336},
	{8482, 13340, 13340},
	{5331, 13344, 13344},
	{4171, 13348, 13348},
	{8501, 13352, 13352},
	{9219, 13356, 13356},
	{9473, 13360, 13363},
	{12881, 13367, 13367},
	{13065, 13371, 13375},
	{2979, 13379, 13384},
	{1518, 13388, 13388},
	{11177, 13392, 13392},
	{9457, 13398, 13398},
	{12293, 13407, 13410},
	{3697, 13414, 13417},
	{10338, 13425, 13425},
	{13367, 13429, 13429},
	{11074, 13433, 13437},
	{4201, 13441, 13443},
	{1812, 13447, 13448},
	{13360, 13452, 13456},
	{13188, 13463, 13463},
	{9732, 13470, 13470},
	{11332, 13477, 13477},
	{9918, 13487, 13487},
	{6337, 13497, 13497},
	{13429, 13501, 13501},
	{11413, 13505, 13505},
	{4685, 13512, 13513},
	{13136, 13517, 13519},
	{7416, 13528, 13530},
	{12929, 13534, 13534},
	{11110, 13539, 13539},
	{11521, 13543, 13543},
	{12825, 13553, 13553},
	{13447, 13557, 13558},
	{12299, 13562, 13563},
	{9003, 13570, 13570},
	{12500, 13577, 13577},
	{13501, 13581, 13581},
	{9392, 13586, 13586},
	{12454, 13590, 13590},
	{6189, 13595, 13595},
	{13053, 13599, 13599},
	{11881, 13604, 13604},
	{13159, 13608, 13608},
	{4894, 13612, 13612},
	{13221, 13621, 13621},
	{8950, 13625, 13625},
	{13533, 13629, 13629},
	{9633, 13633, 13633},
	{7892, 13637, 13639},
	{13581, 13643, 13643},
	{13616, 13647, 13649},
	{12794, 13653, 13654},
	{8919, 13659, 13659},
	{9674, 13663, 13663},
	{13577, 13668, 13668},
	{12966, 13672, 13672},
	{12659, 13676, 13683},
	{6124, 13688, 13688},
	{9225, 13693, 13695},
	{11833, 13702, 13702},
	{12904, 13709, 13717},
	{13647, 13721, 13722},
	{11687, 13726, 13727},
	{12434, 13731, 13732},
	{12689, 13736, 13742},
	{13168, 13746, 13746},
	{6151, 13751, 13752},
	{11821, 13756, 13757},
	{6467, 13764, 13764},
	{5730, 13769, 13769},
	{5136, 13780, 13780},
	{724, 13784, 13785},
	{13517, 13789, 13791},
	{640, 13795, 13796},
	{7721, 13800, 13802},
	{11121, 13806, 13807},
	{5791, 13811, 13815},
	{12894, 13819, 13819},
	{11100, 13824, 13824},
	{7011, 13830, 13830},
	{7129, 13834, 13837},
	{13833, 13841, 13841},
	{11276, 13847, 13847},
	{13621, 13853, 13853},
	{13589, 13862, 13863},
	{12989, 13867, 13867},
	{12789, 13871, 13871},
	{1239, 13875, 13875},
	{4675, 13879, 13881},
	{4686, 13885, 13885},
	{707, 13889, 13889},
	{5449, 13897, 13898},
	{13867, 13902, 13903},
	{10613, 13908, 13908},
	{13789, 13912, 13914},
	{4451, 13918, 13919},
	{9200, 13924, 13924},
	{2011, 13930, 13930},
	{11433, 13934, 13936},
	{4695, 13942, 13943},
	{9435, 13948, 13951},
	{13688, 13955, 13957},
	{11694, 13961, 13962},
	{5712, 13966, 13966},
	{5991, 13970, 13972},
	{13477, 13976, 13976},
	{10213, 13987, 13987},
	{11839, 13991, 13993},
	{12272, 13997, 13997},
	{6206, 14001, 14001},
	{13179, 14006, 14007},
	{2939, 14011, 14011},
	{12972, 14016, 14017},
	{13918, 14021, 14022},
	{7436, 14026, 14027},
	{7678, 14032, 14034},
	{13586, 14040, 14040},
	{13347, 14044, 14044},
	{13109, 14048, 14051},
	{9244, 14055, 14057},
	{13315, 14061, 14061},
	{13276, 14067, 14067},
	{11435, 14073, 14074},
	{13853, 14078, 14078},
	{13452, 14082, 14082},
	{14044, 14087, 14087},
	{4440, 14091, 14095},
	{4479, 14100, 14103},
	{9395, 14107, 14109},
	{6834, 14119, 14119},
	{10458, 14123, 14124},
	{1429, 14129, 14129},
	{8443, 14135, 14135},
	{10365, 14140, 14140},
	{5267, 14145, 14145},
	{11834, 14151, 14153},
}
