/*
 * Decompiled with CFR 0.152.
 */
package sharpen.core;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.launching.JavaRuntime;
import sharpen.core.JavaModelUtility;
import sharpen.core.framework.resources.SimpleProject;
import sharpen.core.framework.resources.WorkspaceUtilities;

public class JavaProject
extends SimpleProject {
    private IJavaProject _javaProject;
    private final List<IPackageFragmentRoot> _sourceFolders = new ArrayList<IPackageFragmentRoot>();

    public JavaProject() throws CoreException {
        this("TestProject");
    }

    public JavaProject(String projectName) throws CoreException {
        super(projectName);
        this._javaProject = JavaCore.create((IProject)this._project);
        this.setJavaNature();
        this.initializeClassPath();
        this.createOutputFolder(this.getBinFolder());
        this.addSystemLibraries();
    }

    public JavaProject(IJavaProject javaProject) throws CoreException {
        super(javaProject.getProject(), null);
        this._javaProject = javaProject;
    }

    private void initializeClassPath() throws JavaModelException {
        this._javaProject.setRawClasspath(new IClasspathEntry[0], null);
    }

    @Override
    public void addReferencedProject(IProject reference, IProgressMonitor monitor) throws CoreException {
        super.addReferencedProject(reference, monitor);
        this.addClasspathEntry(JavaCore.newProjectEntry((IPath)reference.getFullPath(), (boolean)true));
    }

    public IPackageFragmentRoot addSourceFolder(String path) throws CoreException {
        IPackageFragmentRoot sourceFolder = this.createSourceFolder(path);
        this._sourceFolders.add(sourceFolder);
        return sourceFolder;
    }

    public void buildProject(IProgressMonitor monitor) throws CoreException {
        this._project.build(6, monitor);
    }

    public void joinAutoBuild() {
        this.joinBuild(ResourcesPlugin.FAMILY_AUTO_BUILD);
    }

    public void joinBuild() {
        this.joinBuild(ResourcesPlugin.FAMILY_MANUAL_BUILD);
    }

    public void joinBuild(Object buildFamily) {
        try {
            Job.getJobManager().join(buildFamily, null);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public IJavaProject getJavaProject() {
        return this._javaProject;
    }

    public void addClasspathEntry(String absolutePath) throws JavaModelException {
        if (this.containsClasspathEntry(absolutePath)) {
            return;
        }
        this.addClasspathEntry((IPath)new Path(absolutePath));
    }

    private boolean containsClasspathEntry(String absolutePath) throws JavaModelException {
        IClasspathEntry[] iClasspathEntryArray = this._javaProject.getRawClasspath();
        int n = iClasspathEntryArray.length;
        int n2 = 0;
        while (n2 < n) {
            IClasspathEntry entry = iClasspathEntryArray[n2];
            if (1 == entry.getEntryKind() && entry.getPath().toFile().getAbsolutePath().equals(absolutePath)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private void addClasspathEntry(IPath absolutePath) throws JavaModelException {
        IClasspathEntry newLibraryEntry = JavaCore.newLibraryEntry((IPath)absolutePath, null, null);
        this.addClasspathEntry(newLibraryEntry);
    }

    private void addClasspathEntry(IClasspathEntry newLibraryEntry) throws JavaModelException {
        IClasspathEntry[] oldEntries = this._javaProject.getRawClasspath();
        IClasspathEntry[] newEntries = new IClasspathEntry[oldEntries.length + 1];
        System.arraycopy(oldEntries, 0, newEntries, 0, oldEntries.length);
        newEntries[oldEntries.length] = newLibraryEntry;
        this._javaProject.setRawClasspath(newEntries, null);
    }

    public IPackageFragment createPackage(String name) throws CoreException {
        return this.getMainSourceFolder().createPackageFragment(name, false, null);
    }

    public IPackageFragmentRoot getMainSourceFolder() throws CoreException {
        if (this._sourceFolders.size() == 0) {
            this._sourceFolders.add(this.createDefaultSourceFolder());
        }
        return this._sourceFolders.get(0);
    }

    public ICompilationUnit createCompilationUnit(String packageName, String cuName, String source) throws CoreException {
        return this.createCompilationUnit(this.getMainSourceFolder(), packageName, cuName, source);
    }

    public ICompilationUnit createCompilationUnit(IPackageFragmentRoot sourceFolder, String packageName, String cuName, String contents) throws JavaModelException, CoreException {
        IPackageFragment packageFragment = sourceFolder.getPackageFragment(packageName);
        if (!packageFragment.exists()) {
            packageFragment = sourceFolder.createPackageFragment(packageName, false, null);
        }
        return this.createCompilationUnit(packageFragment, cuName, contents);
    }

    public ICompilationUnit createCompilationUnit(IPackageFragment packageFragment, String cuName, String source) throws CoreException {
        return packageFragment.createCompilationUnit(cuName, source, false, null);
    }

    private IFolder getBinFolder() throws CoreException {
        return this.safeGetFolder("bin");
    }

    private IFolder safeGetFolder(String folderName) throws CoreException {
        IFolder folder = this._project.getFolder(folderName);
        return folder.exists() ? folder : this.createFolder(folderName);
    }

    private void setJavaNature() throws CoreException {
        this.addNature("org.eclipse.jdt.core.javanature");
    }

    public void addNature(String natureId) throws CoreException {
        WorkspaceUtilities.addProjectNature(this._project, natureId);
    }

    private void createOutputFolder(IFolder binFolder) throws JavaModelException {
        IPath outputLocation = binFolder.getFullPath();
        this._javaProject.setOutputLocation(outputLocation, null);
    }

    private IPackageFragmentRoot createDefaultSourceFolder() throws CoreException {
        return this.createSourceFolder("src");
    }

    private IPackageFragmentRoot createSourceFolder(String path) throws CoreException, JavaModelException {
        IFolder folder = this.safeGetFolder(path);
        IPackageFragmentRoot root = this._javaProject.getPackageFragmentRoot((IResource)folder);
        IClasspathEntry newSourceEntry = JavaCore.newSourceEntry((IPath)root.getPath(), (IPath[])new IPath[0]);
        this.addClasspathEntry(newSourceEntry);
        return root;
    }

    private void addSystemLibraries() throws JavaModelException {
        this.addClasspathEntry(JavaRuntime.getDefaultJREContainerEntry());
    }

    public List<ICompilationUnit> getAllCompilationUnits() throws CoreException {
        return JavaModelUtility.collectCompilationUnits(this.getJavaProject());
    }

    public static class Builder {
        public final IProgressMonitor progressMonitor;
        public final JavaProject project;

        public Builder(IProgressMonitor pm, String projectName) throws CoreException {
            this.progressMonitor = pm;
            this.project = new JavaProject(projectName);
        }

        public Builder sourceFolders(Iterable<String> sourceFolders) throws CoreException {
            for (String srcFolder : sourceFolders) {
                this.sourceFolder(srcFolder);
            }
            return this;
        }

        public Builder sourceFolder(String srcFolder) throws CoreException {
            this.progressMonitor.subTask("source folder: " + srcFolder);
            this.project.addSourceFolder(srcFolder);
            return this;
        }

        public Builder classpath(Iterable<String> classpath) throws JavaModelException {
            for (String cp : classpath) {
                this.progressMonitor.subTask("classpath entry: " + cp);
                if (!new File(cp).exists()) {
                    throw new IllegalArgumentException("'" + cp + "' not found.");
                }
                this.project.addClasspathEntry(cp);
            }
            return this;
        }

        public Builder nature(String natureId) throws CoreException {
            this.project.addNature(natureId);
            return this;
        }

        public Builder projectReferences(Iterable<String> projectReferences) throws CoreException {
            for (String projectReference : projectReferences) {
                IProject reference = WorkspaceUtilities.getProject(projectReference);
                this.project.addReferencedProject(reference, null);
            }
            return this;
        }

        public Builder persistentProperty(QualifiedName key, String value) throws CoreException {
            this.project.getProject().setPersistentProperty(key, value);
            return this;
        }
    }
}

