/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 2010 Oracle and/or its affiliates. All rights reserved.
 *
 * Oracle and Java are registered trademarks of Oracle and/or its affiliates.
 * Other names may be trademarks of their respective owners.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 *
 * Contributor(s):
 *
 * Portions Copyrighted 2009 Sun Microsystems, Inc.
 */
package org.netbeans.modules.dlight.indicators;

import java.awt.Color;
import java.util.Collection;
import org.netbeans.modules.dlight.api.storage.DataTableMetadata.Column;
import org.netbeans.modules.dlight.indicators.impl.TimeSeriesDescriptorAccessor;

/**
 * Describes a time series representation.
 *
 * @author Alexey Vladykin
 */
public final class TimeSeriesDescriptor {

    static{
        TimeSeriesDescriptorAccessor.setDefault(new TimeSeriesDescriptorAccessorImpl());
    }

    private final String name;
    private final String displayName;
    private final Color color;
    private final Kind kind;
    private Collection<Column> columns;

    public TimeSeriesDescriptor(String name, String displayName, Color color, Kind kind) {
        this.name = name;
        this.displayName = displayName;
        this.color = color;
        this.kind = kind;
    }

    public final void setSourceColumns(Collection<Column> columns){
        this.columns = columns;
    }

    private String getName() {
        return name;
    }

    private String getDisplayName() {
        return displayName;
    }

    private Color getColor() {
        return color;
    }

    private Kind getKind() {
        return kind;
    }

    public static enum Kind {
        LINE,
        ABS_SURFACE,
        REL_SURFACE
    }

    private static class TimeSeriesDescriptorAccessorImpl extends TimeSeriesDescriptorAccessor {

        @Override
        public String getName(TimeSeriesDescriptor descriptor) {
            return descriptor.getName();
        }

        @Override
        public String getDisplayName(TimeSeriesDescriptor descriptor) {
            return descriptor.getDisplayName();
        }

        @Override
        public Color getColor(TimeSeriesDescriptor descriptor) {
            return descriptor.getColor();
        }

        @Override
        public Kind getKind(TimeSeriesDescriptor descriptor) {
            return descriptor.getKind();
        }

        @Override
        public Collection<Column> getSourceColumns(TimeSeriesDescriptor descriptor) {
            return descriptor.columns;
        }

    }
}
