<!--startmeta
custom_edit_url: "https://github.com/netdata/netdata/edit/master/collectors/cups.plugin/README.md"
meta_yaml: "https://github.com/netdata/netdata/edit/master/collectors/cups.plugin/metadata.yaml"
sidebar_label: "CUPS"
learn_status: "Published"
learn_rel_path: "Data Collection/Hardware Devices and Sensors"
message: "DO NOT EDIT THIS FILE DIRECTLY, IT IS GENERATED BY THE COLLECTOR'S metadata.yaml FILE"
endmeta-->

# CUPS


<img src="https://netdata.cloud/img/cups.png" width="150"/>


Plugin: cups.plugin
Module: cups.plugin

<img src="https://img.shields.io/badge/maintained%20by-Netdata-%2300ab44" />

## Overview

Monitor CUPS performance for achieving optimal printing system operations. Monitor job statuses, queue lengths, and error rates to ensure smooth printing tasks.

The plugin uses CUPS shared library to connect and monitor the server.

This collector is supported on all platforms.

This collector supports collecting metrics from multiple instances of this integration, including remote instances.

The plugin needs to access the server. Netdata sets permissions during installation time to reach the server through its library.

### Default Behavior

#### Auto-Detection

The plugin detects when CUPS server is running and tries to connect to it.

#### Limits

The default configuration for this integration does not impose any limits on data collection.

#### Performance Impact

The default configuration for this integration is not expected to impose a significant performance impact on the system.


## Metrics

Metrics grouped by *scope*.

The scope defines the instance that the metric belongs to. An instance is uniquely identified by a set of labels.



### Per CUPS instance



This scope has no labels.

Metrics:

| Metric | Dimensions | Unit |
|:------|:----------|:----|
| cups.dests_state | idle, printing, stopped | dests |
| cups.dests_option | total, acceptingjobs, shared | dests |
| cups.job_num | pending, held, processing | jobs |
| cups.job_size | pending, held, processing | KB |

### Per destination



This scope has no labels.

Metrics:

| Metric | Dimensions | Unit |
|:------|:----------|:----|
| cups.destination_job_num | pending, held, processing | jobs |
| cups.destination_job_size | pending, held, processing | KB |



## Alerts

There are no alerts configured by default for this integration.


## Setup

### Prerequisites

#### Minimum setup

The CUPS server must be installed and running. If you installed `netdata` using a package manager, it is also necessary to install the package `netdata-plugin-cups`.


### Configuration

#### File

The configuration file name for this integration is `netdata.conf`.
Configuration for this specific integration is located in the `[plugin:cups]` section within that file.

The file format is a modified INI syntax. The general structure is:

```ini
[section1]
    option1 = some value
    option2 = some other value

[section2]
    option3 = some third value
```
You can edit the configuration file using the `edit-config` script from the
Netdata [config directory](https://github.com/netdata/netdata/blob/master/docs/configure/nodes.md#the-netdata-config-directory).

```bash
cd /etc/netdata 2>/dev/null || cd /opt/netdata/etc/netdata
sudo ./edit-config netdata.conf
```
#### Options



<details><summary>Config options</summary>

| Name | Description | Default | Required |
|:----|:-----------|:-------|:--------:|
| update every | Data collection frequency. | 1 | False |
| command options | Additional parameters for the collector |  | False |

</details>

#### Examples
There are no configuration examples.


