'use strict';

module.exports = require('joe/tester').tests({ reporter: require.resolve('..') }, [

// ------------------------------------
{
	script: require.resolve('joe-examples/lib/multi.js'),
	expected: '\nmulti sync test example\nmulti sync test example \u2714\nmulti async test example\nmulti async test example \u2714\nmulti empty sync suite test example\nmulti empty sync suite test example \u2714\nmulti empty async suite test example\nmulti empty async suite test example \u2714\nmulti sync suite example\nmulti sync suite example \u279E sub sync test example\nmulti sync suite example \u279E sub sync test example \u2714\nmulti sync suite example \u279E sub async test example\nmulti sync suite example \u279E sub async test example \u2714\nmulti sync suite example \u2714\nmulti async suite example\nmulti async suite example \u279E sub sync test example\nmulti async suite example \u279E sub sync test example \u2714\nmulti async suite example \u279E sub async test example\nmulti async suite example \u279E sub async test example \u2714\nmulti async suite example \u2714\nmulti extra async test example\nmulti extra async test example \u2714\nmulti extra sync test example\nmulti extra sync test example \u2714\n\n8/8 tests ran successfully, everything passed'
},

// ------------------------------------
{
	script: require.resolve('joe-examples/lib/timing.js'),
	expected: '\ntiming example\nthis will be outputted first\ntiming example \u279E first test\nthis will be outputted second\ntiming example \u279E first test \u2714\ntiming example \u279E second test\nthis will be outputted third\ntiming example \u279E second test \u2714\ntiming example \u2714\n\n2/2 tests ran successfully, everything passed'
},

// ------------------------------------
{
	script: require.resolve('joe-examples/lib/standard.js'),
	expected: '\nstandard example\nstandard example \u279E tests\nstandard example \u279E tests \u279E async-tests\nstandard example \u279E tests \u279E async-tests \u279E 1/2\nstandard example \u279E tests \u279E async-tests \u279E 1/2 \u2714\nstandard example \u279E tests \u279E async-tests \u279E 2/2\nstandard example \u279E tests \u279E async-tests \u279E 2/2 \u2714\nstandard example \u279E tests \u279E async-tests \u2714\nstandard example \u279E tests \u279E sync\nstandard example \u279E tests \u279E sync \u279E 1/2\nstandard example \u279E tests \u279E sync \u279E 1/2 \u2714\nstandard example \u279E tests \u279E sync \u279E 2/2\nstandard example \u279E tests \u279E sync \u279E 2/2 \u2714\nstandard example \u279E tests \u279E sync \u2714\nstandard example \u279E tests \u279E async-sync\nstandard example \u279E tests \u279E async-sync \u279E 1/2\nstandard example \u279E tests \u279E async-sync \u279E 1/2 \u2714\nstandard example \u279E tests \u279E async-sync \u279E 2/2\nstandard example \u279E tests \u279E async-sync \u279E 2/2 \u2714\nstandard example \u279E tests \u279E async-sync \u2714\nstandard example \u279E tests \u279E async-suite\nstandard example \u279E tests \u279E async-suite \u279E 1/2\nstandard example \u279E tests \u279E async-suite \u279E 1/2 \u2714\nstandard example \u279E tests \u279E async-suite \u279E 2/2\nstandard example \u279E tests \u279E async-suite \u279E 2/2 \u2714\nstandard example \u279E tests \u279E async-suite \u2714\nstandard example \u279E tests \u279E before and after\nstandard example \u279E tests \u279E before and after \u279E test 1\nstandard example \u279E tests \u279E before and after \u279E test 1 \u2714\nstandard example \u279E tests \u279E before and after \u279E test 2\nstandard example \u279E tests \u279E before and after \u279E test 2 \u2714\nstandard example \u279E tests \u279E before and after \u279E test 3\nstandard example \u279E tests \u279E before and after \u279E test 3 \u2714\nstandard example \u279E tests \u279E before and after \u279E test 4\nstandard example \u279E tests \u279E before and after \u279E test 4 \u2714\nstandard example \u279E tests \u279E before and after \u2714\nstandard example \u279E tests \u279E deliberate-suite-failure ignored\nstandard example \u279E tests \u279E deliberate-suite-failure ignored \u2714\nstandard example \u279E tests \u279E deliberate-test-failure ignored\nstandard example \u279E tests \u279E deliberate-test-failure ignored \u279E 1/2\nstandard example \u279E tests \u279E deliberate-test-failure ignored \u279E 1/2 \u2718\nstandard example \u279E tests \u279E deliberate-test-failure ignored \u279E 2/2\nstandard example \u279E tests \u279E deliberate-test-failure ignored \u279E 2/2 \u2718\nstandard example \u279E tests \u279E deliberate-test-failure ignored \u2714\nstandard example \u279E tests \u279E deliberate-test-failure\nstandard example \u279E tests \u279E deliberate-test-failure \u279E 1/2\nstandard example \u279E tests \u279E deliberate-test-failure \u279E 1/2 \u2718\nstandard example \u279E tests \u279E deliberate-test-failure \u2718\nstandard example \u279E tests \u2718\nstandard example \u2718\n\nFAILURE: 12/15 tests ran successfully; 3 failed, 0 incomplete, 3 errors\n\nError #1:\nstandard example \u279E tests \u279E deliberate-test-failure ignored \u279E 1/2\nError: deliberate error 1\n\nError #2:\nstandard example \u279E tests \u279E deliberate-test-failure ignored \u279E 2/2\nError: deliberate error 2\n\nError #3:\nstandard example \u279E tests \u279E deliberate-test-failure \u279E 1/2\nError: deliberate error'
},

// ------------------------------------
{
	script: require.resolve('joe-examples/lib/fail-never-finish.js'),
	expected: '\nfail never finish example\n\nFAILURE: 0/1 tests ran successfully; 0 failed, 1 incomplete, 0 errors'
},

// ------------------------------------
{
	script: require.resolve('joe-examples/lib/fail-throw-suite.js'),
	expected: '\nfail throw suite example\nfail throw suite example \u2718\n\nFAILURE: 0/0 tests ran successfully; 0 failed, 0 incomplete, 1 errors\n\nError #1:\nfail throw suite example\nError: I am the deliberate throw that occured during the suite'
},

// ------------------------------------
{
	script: require.resolve('joe-examples/lib/fail-throw-test-uncaught.js'),
	expected: '\nfail throw test uncaught example\nfail throw test uncaught example \u279E throw after timeout\nfail throw test uncaught example \u279E throw after timeout \u2714\nfail throw test uncaught example \u2714\n\nFAILURE: 1/1 tests ran successfully; 0 failed, 0 incomplete, 1 errors\n\nError #1:\nuncaughtException\nError: I am the deliberate throw that occured in the test, but after the test has completed'
}

// All done
]);