## Usage

```js
var not = require('regex-not');
```

The main export is a function that takes a string an options object.

```js
not(string[, options]);
```

**Example**

```js
var not = require('regex-not');
console.log(not('foo'));
//=> /^(?:(?!^(?:foo)$).)+$/
```

**Strict matching**

By default, the returned regex is for strictly (not) matching the exact given pattern (in other words, "match this string if it does NOT _exactly equal_ `foo`"):

```js
var re = not('foo');
console.log(re.test('foo'));     //=> false
console.log(re.test('bar'));     //=> true
console.log(re.test('foobar'));  //=> true
console.log(re.test('barfoo'));  //=> true
```

### .create

Returns a string to allow you to create your own regex:

```js
console.log(not.create('foo'));
//=> '(?:(?!^(?:foo)$).)+'
```

### Options

**options.contains**

You can relax strict matching by setting `options.contains` to true (in other words, "match this string if it does NOT _contain_ `foo`"):

```js
var re = not('foo');
console.log(re.test('foo', {contains: true}));     //=> false
console.log(re.test('bar', {contains: true}));     //=> true
console.log(re.test('foobar', {contains: true}));  //=> false
console.log(re.test('barfoo', {contains: true}));  //=> false
```
