// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _math_FunctionRoot_HeaderFile
#define _math_FunctionRoot_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_DefineAlloc_HeaderFile
#include <Standard_DefineAlloc.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Standard_OStream_HeaderFile
#include <Standard_OStream.hxx>
#endif
class StdFail_NotDone;
class math_FunctionWithDerivative;



//! This class implements the computation of a root of a function of <br>
//! a single variable which is near an initial guess using a minimization <br>
//! algorithm.Knowledge of the derivative is required. The <br>
//! algorithm used is the same as in <br>
class math_FunctionRoot  {
public:

  DEFINE_STANDARD_ALLOC

  
//! The Newton-Raphson method is done to find the root of the function F <br>
//! from the initial guess Guess.The tolerance required on <br>
//! the root is given by Tolerance. Iterations are stopped if <br>
//! the expected solution does not stay in the range A..B. <br>
//! The solution is found when abs(Xi - Xi-1) <= Tolerance; <br>
//! The maximum number of iterations allowed is given by NbIterations. <br>
  Standard_EXPORT   math_FunctionRoot(math_FunctionWithDerivative& F,const Standard_Real Guess,const Standard_Real Tolerance,const Standard_Integer NbIterations = 100);
  
//! The Newton-Raphson method is done to find the root of the function F <br>
//! from the initial guess Guess. <br>
//! The tolerance required on the root is given by Tolerance. <br>
//! Iterations are stopped if the expected solution does not stay in the <br>
//! range A..B <br>
//! The solution is found when abs(Xi - Xi-1) <= Tolerance; <br>
//! The maximum number of iterations allowed is given by NbIterations. <br>
  Standard_EXPORT   math_FunctionRoot(math_FunctionWithDerivative& F,const Standard_Real Guess,const Standard_Real Tolerance,const Standard_Real A,const Standard_Real B,const Standard_Integer NbIterations = 100);
  //! Returns true if the computations are successful, otherwise returns false. <br>
        Standard_Boolean IsDone() const;
  //! returns the value of the root. <br>
//! Exception NotDone is raised if the root was not found. <br>
        Standard_Real Root() const;
  //! returns the value of the derivative at the root. <br>
//! Exception NotDone is raised if the root was not found. <br>
        Standard_Real Derivative() const;
  //! returns the value of the function at the root. <br>
//! Exception NotDone is raised if the root was not found. <br>
        Standard_Real Value() const;
  //! returns the number of iterations really done on the <br>
//! computation of the Root. <br>
//! Exception NotDone is raised if the root was not found. <br>
        Standard_Integer NbIterations() const;
  //! Prints on the stream o information on the current state <br>
//!          of the object. <br>
//!          Is used to redefine the operator <<. <br>
  Standard_EXPORT     void Dump(Standard_OStream& o) const;





protected:





private:



Standard_Boolean Done;
Standard_Real TheRoot;
Standard_Real TheError;
Standard_Real TheDerivative;
Standard_Integer NbIter;


};


#include <math_FunctionRoot.lxx>



// other Inline functions and methods (like "C++: function call" methods)


#endif
