// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _IFSelect_SelectSignedSharing_HeaderFile
#define _IFSelect_SelectSignedSharing_HeaderFile

#include <Standard.hxx>
#include <Standard_DefineHandle.hxx>
#include <Handle_IFSelect_SelectSignedSharing.hxx>

#include <Handle_IFSelect_Signature.hxx>
#include <TCollection_AsciiString.hxx>
#include <Standard_Boolean.hxx>
#include <IFSelect_SelectExplore.hxx>
#include <Standard_CString.hxx>
#include <Standard_Integer.hxx>
#include <Handle_Standard_Transient.hxx>
class IFSelect_Signature;
class TCollection_AsciiString;
class Standard_Transient;
class Interface_Graph;
class Interface_EntityIterator;


//! In the graph, explore the sharings of the input entities,
//! until it encounters some which match a given Signature
//! (for a limited level, filters the returned list)
//! By default, fitted for any level
class IFSelect_SelectSignedSharing : public IFSelect_SelectExplore
{

public:

  
  //! Creates a SelectSignedSharing, defaulted for any level
  //! with a given Signature and text to match
  Standard_EXPORT IFSelect_SelectSignedSharing(const Handle(IFSelect_Signature)& matcher, const Standard_CString signtext, const Standard_Boolean exact = Standard_True, const Standard_Integer level = 0);
  
  //! Returns the used Signature, then it is possible to access it,
  //! modify it as required
  Standard_EXPORT   Handle(IFSelect_Signature) Signature()  const;
  
  //! Returns Text used to Sort Entity on its Signature
  Standard_EXPORT  const  TCollection_AsciiString& SignatureText()  const;
  
  //! Returns True if match must be exact
  Standard_EXPORT   Standard_Boolean IsExact()  const;
  
  //! Explores an entity : its sharing entities
  //! <ent> to take if it matches the Signature
  //! At level max, filters the result. Else gives all sharings
  Standard_EXPORT   Standard_Boolean Explore (const Standard_Integer level, const Handle(Standard_Transient)& ent, const Interface_Graph& G, Interface_EntityIterator& explored)  const;
  
  //! Returns a text defining the criterium.
  //! (it refers to the text and exact flag to be matched, and is
  //! qualified by the Name provided by the Signature)
  Standard_EXPORT   TCollection_AsciiString ExploreLabel()  const;




  DEFINE_STANDARD_RTTI(IFSelect_SelectSignedSharing)

protected:




private: 


  Handle(IFSelect_Signature) thematcher;
  TCollection_AsciiString thesigntext;
  Standard_Boolean theexact;


};







#endif // _IFSelect_SelectSignedSharing_HeaderFile
