# New and Noteworthy in OGRE 1.10

This is only a high level overview. For a detailed changes, see the git changelog.

## Core Improvements
* [Unified documentation](https://ogrecave.github.io/ogre/api/1.10/index.html) API reference, manual and some of the wiki tutorials are now all available through Doxygen and editable using Markdown. Now there is syntax highlighting in the snippets and automatic links to corresponding function documentation. To locally build the docs, just do `make OgreDoc`. The sources are in `Docs/src/`.
* by default Ogre will now automatically fetch and build its core dependencies. This way your deps have the same compile options like Ogre and you do not have to track the separate OgreDeps repository.
* Pass now uses a proper HashFunc and defaults to `MinGpuProgramChangeHashFunc`. This should give a performance boost when using the RTSS and with shader based materials.
* new `OgreAssertDbg` macro that only fires in Debug configuration. To be used in performance critical code. In turn the existing `OgreAssert` macro is now enabled in Release/ RelWithDebug configurations.
* FileSystemLayer: use `$XDG_CACHE_HOME` as base path on Linux
* FileSystemLayer: resolve paths inside snap packages on Linux
* allow using `std::thread` (with c++11) for background resource loading
* `Ogre::Any` and `Ogre::SharedPtr` now support the corresponding c++11/ c++17 API. (deprecating the previous API)
* using a duplicate resource name is an error now and throws an exception
* STBICodec using an embedded stb_image copy for image reading/ writing. No need using the bloated freetype. However you should not use this in a security critical environment.
* the nedmalloc allocator is now deprecated and disabled by default due to memory leaks. Use the default STL allocator.
* several functions were deprecated and will be dropped in the next major release. [See the deprecation list here.](https://ogrecave.github.io/ogre/api/1.10/deprecated.html)
* several SceneNode and Node functions were de-virtualised as they are internal API and were not overridden. If this breaks you code though, this will be considered a regression and be reverted/ fixed.
* performance improvements for `Ogre::ResourceGroupManager`
* upgraded embedded TinyXML from 2.5.2 to 2.6.2

### ResourceManager strict mode
By defining `OGRE_RESOURCEMANAGER_STRICT=ON` in CMake the Resource System is put into the a "strict" mode. In this mode resource managers default to *retrieving* resources rather than *searching* for them.
This means that you must specify not only the resource name, but also the resource group as resources are only uniquely identified by the `(name, group)` tuple. Furthermore lookup is case sensitive and all quirks are disabled.
This greatly improves performance as now usually only one group has to be searched - also this makes the lookup predictable. If you specify a group and the resource is not found, the managers will not fall back to some arbitrary other resource with the same name.
If you want OGRE to really search for a resource, you have to explicitly specify `AUTODETECT_RESOURCE_GROUP_NAME`. 

While enabling the strict mode is highly recommended, the default is the legacy mode to ensure compatibility with existing projects.

### CMake Config-File support
A CMake config-file package is now installed making it easy to discover OGRE for third-party projects. This means that you no longer have to copy paste the `FindOGRE.cmake` script into your project. Instead you can specify `OGRE_DIR` to point to the installed `OGREConfig.cmake` and thats it. On Linux CMake will even automatically find OGRE if it is installed in one of the default system paths like `/usr/local/`.

The config also provides the following variables for a better OGRE integration:

* `OGRE_CONFIG_DIR` - the `resources.cfg` and `plugins.cfg` are located here
* `OGRE_MEDIA_DIR` - path to the sample media and RTShaderLib

You are strongly advised to migrate away any custom/ local `FindOGRE.cmake` (i.e. just delete it).  
In case you must support Ogre 1.10 and previous Ogre releases simultaneously, rename the local find script to e.g. `FindOldOGRE.cmake` and adapt your `CMakeLists.txt` as:
```
find_package(OGRE)
if(NOT ${OGRE_FOUND})
    find_package(OldOGRE)
endif()
```
this will give precedence to the upstream script and fall back to your local copy.

### Plugins
* the EXRCodec can now be build again by setting `OGRE_BUILD_PLUGIN_EXRCODEC=TRUE`
* the BSPSceneManger now works when using the RTSS: i.e. it can be used with GLES2/ GL3Plus/ D3D11.

### Testing / Continuous Integration
* PlayPen and Visual Tests are up and running again. They must pass if you want to get your code into Ogre now.
* Unit Tests ported from CppUnit to GTest. This allows to build them easily on all platforms and even run on Android. (see NDK docs how)
* similarly all warnings were eliminated from the code base and `-Werror` was turned on the GCC and MSVC builds.

### Emscripten
In case you want to bring your existing code-base to the web or just continue using a familiar development environment, there is now Emscripten/ HTML5 support with Ogre. [You can see it live here](https://ogrecave.github.io/ogre/emscripten/).

The sources are in `Samples/Emscripten` and build instructions in BuildingOgre.md.

## RenderSystems

### GLSupport
This module includes the platform specific parts that are needed to create a GL Context. (i.e. GLX, WGL, Cocoa, EGL)
They had been copy/ pasted but stayed largely the same across the different GL Rendersytems.

The result is the GLNativeSupport API that can be plugged in the exiting GL*Support classes (e.g. GL3PlusSupport) to handle the context creation.

Furthermore the API was extended to allow specifying a context profile. This way the GL3Plus RS creates a core profile, while the old GL RS uses the compatibility profile. Additionally you can create a GLES context using GLX/WGL on a desktop machine and use/ test the GLES2 RenderSystem there.
In case you are in the embedded world or on Wayland/ Mir already it can also use EGL to be compatible with those.

### GLES2
Due to the ubiquitous availability of GLES2 this RenderSystem got a large overhaul.
All legacy workarounds without justifications were removed from the code which makes it behave the same on all platforms and also fixing several VTests.
The extension handling was fixed, it is now possible running in GLES2 mode on GLES3 contexts which previously led to a crash on Android.

Furthermore,

* 3D textures are now also available in GLES2 mode
* Emscripten: GL_ANGLE_instanced_arrays is supported
* declare glsl300es/ glsl310es/ glsl320es shader profiles

## Components
    
### OgreBites
The reusable parts of the SampleBrowser were factored out forming the new OgreBites Component.
It handles Ogre startup/ tear down (including Overlay, RTShaderSystem) and also includes the SdkTrays and SdkCameraManager.

This is useful if all you want is to get a Scene with a FPS counter up and running (i.e. rapid prototyping).
If available it also uses SDL2 for input - you now just have to implement the callbacks.

By making the SampleBrowser code useful by third-party apps, both benefit.

Furthermore the Android specific parts of SampleBrowser were merged into OgreBites. This eases porting your application to Android if it uses the ApplicationContext.

### Python
After python bindings are now SWIG based with the corresponding siwg interfaces being part of ogre. This means that if you checkout the git version you can have up-to-date bindings for it. The work took some inspiration by the [ruby-ogre](https://github.com/abexsoft/ruby-ogre) project.
This means that it would be trivial to bring up an Ogre-Ruby component if needed by someone.
As there is some demand for it a [Ogre-C# (Mono) component was prototyped](https://github.com/OGRECave/ogre/pull/192). However some help is needed here.

Currently the OgreMain, RTShaderSystem, Overlay and OgreBites Components are covered. However most iterator APIs are broken, as the way they are implemented in Ogre is rather exotic.

For usage see the code in `Samples/Python`.

### RTShaderSystem
The duplicated GLSL, GLSLES and GLSL150 shaders were merged into one common GLSL codebase. Furthermore the lighting equations were fixed such that they produce the equal light intensity as fixed function GL. This allows pixel perfect replication of the fixed function pipeline [in some cases](https://ogrecave.github.io/ogre/#opengl-rendersystem-status).

In general the GLSL support was improved:

- Environment Map (reflection) shaders no longer produce a flipped reflection
- The hardware skeletal animation support was finished. See the skeletal animation sample for how to enable it in your code.

### High Level Material System (HLMS)
This component is a backport from the 2.1 branch and is a different take to shader management. Basically it solves the same problem like the RTShaderSystem, but instead of relying on C++ classes generating the final shader it rather uses a custom preprocessor language.
Currently the HLMS only implements a PBS material which is not compatible with the legacy Ogre materials that implement fog, diffuse_color etc. .

If you want to implement your own materials and use custom shaders all the way, this is the way to go. If on the other hand you like the flexibility and convenience of the legacy Ogre materials, you should keep with the RTSS.

### MeshLodGenerator
This code was factored out from OgreMain and is now a separate Component.

## Tools
Some Tools that were dysfunctional and unmaintained were removed from the repository. Notably:

* **MaterialEditor**: was relying on an no longer maintained wxWidgets component. Copy paste parts of [Ogitor](https://github.com/OGRECave/ogitor) if you need it.
* **Blender26Export**: dysfunctional. Use [blender2ogre](https://github.com/OGRECave/blender2ogre) instead.
* **BlenderExport**: same as above

On the plus side **VRMLConverter** was brought back from the dead.

## SampleBrowser
As the SampleBrowser is now based on the OgreBites component it also uses SDL2 for input, which finally means a modern input system instead of OIS.
The drawback is that the NaCL platform is currently broken due to missing bits in OgreBites. However porting should be straightforward.

Furthermore the following Samples were updated/ added:

* ComputeShader: shows how to use ComputeShaders with the GL3+ RS
* ShaderSystemMultiLight: ported to GLES3
* VolumeTerrain: fixed the triplanar texturing part
* HLMS: resolve conflict with RTSS
* Shadows: fixed GLSL shaders for Stencil shadowing (now working on GL3+)
* DeferredShading: resolve conflict with RTSS (now working on GL3+ and GLES2)
