/*
 *  Copyright (c) 2008 Cyrille Berger <cberger@cberger.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation;
 * either version 2, or (at your option) any later version of the License.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#include "LexerNG.h"

#include "../Debug.h"

#include "GTLCore/Token_p.h"

using namespace OpenCTL;

LexerNG::LexerNG(std::istream* sstream) : GTLCore::LexerBase(sstream)
{
}
LexerNG::~LexerNG()
{
}

GTLCore::Token LexerNG::nextToken()
{
  int lastChar = getNextNonSeparatorChar();
  GTLCore::String identifierStr;
  int initial_line = line() - 1;
  int initial_col = column() - 1;
  if( eof() ) return GTLCore::Token(GTLCore::Token::END_OF_FILE, line(), initial_col);
  
  // Test for comment
  GTLCore::Token commentToken;
  if( ignoreComment( commentToken, lastChar ) )
  {
    return commentToken;
  }
  // if it is alpha, it's an identifier or a keyword
  if(isalpha(lastChar) or lastChar == '_')
  {
    identifierStr = getIdentifier(lastChar);
    IDENTIFIER_IS_KEYWORD( "bool", BOOL );
    IDENTIFIER_IS_KEYWORD( "const", CONST );
    IDENTIFIER_IS_KEYWORD( "float", FLOAT );
    IDENTIFIER_IS_KEYWORD( "else", ELSE );
    IDENTIFIER_IS_KEYWORD( "for", FOR );
    IDENTIFIER_IS_KEYWORD( "if", IF );
    IDENTIFIER_IS_KEYWORD( "import", IMPORT );
    IDENTIFIER_IS_KEYWORD( "int", INT );
    IDENTIFIER_IS_KEYWORD( "long", LONG );
    IDENTIFIER_IS_KEYWORD( "return", RETURN );
    IDENTIFIER_IS_KEYWORD( "short", SHORT );
    IDENTIFIER_IS_KEYWORD( "signed", SIGNED );
    IDENTIFIER_IS_KEYWORD( "size", SIZE );
    IDENTIFIER_IS_KEYWORD( "struct", STRUCT );
    IDENTIFIER_IS_KEYWORD( "unsigned", UNSIGNED );
    IDENTIFIER_IS_KEYWORD( "void", VOID );
    IDENTIFIER_IS_KEYWORD( "while", WHILE );
    IDENTIFIER_IS_KEYWORD( "namespace", NAMESPACE );
    IDENTIFIER_IS_KEYWORD( "ctlversion", CTLVERSION );
    IDENTIFIER_IS_KEYWORD( "half", HALF );
    IDENTIFIER_IS_KEYWORD( "input", INPUT );
    IDENTIFIER_IS_KEYWORD( "output", OUTPUT );
    IDENTIFIER_IS_KEYWORD( "print", PRINT );
    IDENTIFIER_IS_KEYWORD( "uniform", UNIFORM );
    IDENTIFIER_IS_KEYWORD( "varying", VARYING );
    IDENTIFIER_IS_KEYWORD( "true", TTRUE );
    IDENTIFIER_IS_KEYWORD( "false", TFALSE );
    return GTLCore::Token(GTLCore::Token::IDENTIFIER, identifierStr,line(), initial_col);
  } else if( isdigit(lastChar) )
  { // if it's a digit 
    return getDigit(lastChar);
  } else if( lastChar == '"' ) {
    return getString(lastChar);
  } else {
    CHAR_IS_TOKEN(';', SEMI );
    if( lastChar == ':' and getNextChar() == ':' )
    {
        return GTLCore::Token(GTLCore::Token::COLONCOLON, line(), initial_col);
    }
    CHAR_IS_TOKEN( ',', COMA );
    CHAR_IS_TOKEN( '.', DOT );
    CHAR_IS_TOKEN( '{', STARTBRACE );
    CHAR_IS_TOKEN( '}', ENDBRACE );
    CHAR_IS_TOKEN( '(', STARTBRACKET );
    CHAR_IS_TOKEN( ')', ENDBRACKET );
    CHAR_IS_TOKEN( '[', STARTBOXBRACKET );
    CHAR_IS_TOKEN( ']', ENDBOXBRACKET );
    CHAR_IS_TOKEN_OR_TOKEN( '=', '=', EQUAL, EQUALEQUAL );
    CHAR_IS_TOKEN_OR_TOKEN( '!', '=', NOT, DIFFERENT );
    CHAR_IS_TOKEN_OR_TOKEN( '&', '&', BITAND, AND);
    CHAR_IS_TOKEN_OR_TOKEN( '|', '|', BITOR, OR );
    CHAR_IS_TOKEN( '^', BITXOR );
    CHAR_IS_TOKEN_OR_TOKEN_OR_TOKEN( '<', '=', '<', INFERIOR, INFERIOREQUAL, LEFTSHIFT );
    CHAR_IS_TOKEN_OR_TOKEN_OR_TOKEN( '>', '=', '>', SUPPERIOR, SUPPERIOREQUAL, RIGHTSHIFT );
    CHAR_IS_TOKEN_OR_TOKEN( '+', '+', PLUS, PLUSPLUS );
    CHAR_IS_TOKEN_OR_TOKEN( '-', '-', MINUS, MINUSMINUS );
    CHAR_IS_TOKEN( '*', MULTIPLY );
    CHAR_IS_TOKEN( '/', DIVIDE );
    CHAR_IS_TOKEN( '%', MODULO );
    CHAR_IS_TOKEN( '~', TILDE );
  }
  if( lastChar > 128 ) return nextToken();
  identifierStr = lastChar;
  OCTL_DEBUG("Unknown token : " << lastChar << " '" << identifierStr << "'");
  return GTLCore::Token(GTLCore::Token::UNKNOWN, initial_line, initial_col);
}

