# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1454-1 (freetype)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(60109);
 script_cve_id("CVE-2007-1351");
 script_version ("$");
 script_tag(name:"cvss_base", value:"8.5");
 script_tag(name:"risk_factor", value:"Critical");
 name = "Debian Security Advisory DSA 1454-1 (freetype)";
 script_name(name);

 desc = "The remote host is missing an update to freetype
announced via advisory DSA 1454-1.

Greg MacManus discovered an integer overflow in the font handling of
libfreetype, a FreeType 2 font engine, which might lead to denial of
service or possibly the execution of arbitrary code if a user is tricked
into opening a malformed font.

For the unstable distribution (sid), this problem has been fixed in
version 2.3.5-1.

For the stable distribution (etch), this problem has been fixed in
version 2.2.1-5+etch2.

For the old stable distribution (sarge) this problem will be fixed
soon.

We recommend that you upgrade your freetype packages.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201454-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 1454-1 (freetype)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"libfreetype6-dev", ver:"2.2.1-5+etch2", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"freetype2-demos", ver:"2.2.1-5+etch2", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libfreetype6", ver:"2.2.1-5+etch2", rls:"DEB4.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
