# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1943-1 (openldap openldap2.3)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(66455);
 script_cve_id("CVE-2009-3767");
 script_version ("$Revision$");
 script_tag(name:"cvss_base", value:"6.8");
 script_tag(name:"risk_factor", value:"High");
 script_name("Debian Security Advisory DSA 1943-1 (openldap openldap2.3)");

 desc = "The remote host is missing an update to openldap openldap2.3
announced via advisory DSA 1943-1.

It was discovered that OpenLDAP, a free implementation of the Lightweight
Directory Access Protocol, when OpenSSL is used, does not properly handle a '\0'
character in a domain name in the subject's Common Name (CN) field of an X.509
certificate, which allows man-in-the-middle attackers to spoof arbitrary SSL
servers via a crafted certificate issued by a legitimate Certification Authority.

For the oldstable distribution (etch), this problem has been fixed in version
2.3.30-5+etch3 for openldap2.3.

For the stable distribution (lenny), this problem has been fixed in version
2.4.11-1+lenny1 for openldap.

For the testing distribution (squeeze), and the  unstable distribution (sid),
this problem has been fixed in version 2.4.17-2.1 for openldap.


We recommend that you upgrade your openldap2.3/openldap packages.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201943-1

Risk factor : High";

 script_description(desc);

 script_summary("Debian Security Advisory DSA 1943-1 (openldap openldap2.3)");

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 script_family("Debian Local Security Checks");
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"libldap-2.3-0", ver:"2.3.30-5+etch3", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"slapd", ver:"2.3.30-5+etch3", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"ldap-utils", ver:"2.3.30-5+etch3", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"slapd-dbg", ver:"2.4.11-1+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libldap-2.4-2", ver:"2.4.11-1+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"ldap-utils", ver:"2.4.11-1+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"slapd", ver:"2.4.11-1+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libldap2-dev", ver:"2.4.11-1+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libldap-2.4-2-dbg", ver:"2.4.11-1+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
