# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 380-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53665);
 script_cve_id("CVE-2003-0063", "CVE-2003-0071", "CVE-2002-0164", "CVE-2003-0730");
 script_version ("$");
 script_tag(name:"cvss_base", value:"7.5");
 script_tag(name:"risk_factor", value:"High");
 name = "Debian Security Advisory DSA 380-1 (xfree86)";
 script_name(name);

 desc = "The remote host is missing an update to xfree86
announced via advisory DSA 380-1.

Four vulnerabilities have been discovered in XFree86.

For a more detailed description of the problems addressed,
please visit the referenced security advisory.

For the stable distribution (woody) these problems have been fixed in
version 4.1.0-16woody1.

For the unstable distribution (sid) all problems except CVE-2003-0730
are fixed in version 4.2.1-11.  CVE-2003-0730 will be fixed in
4.2.1-12, currently in preparation.

We recommend that you update your xfree86 package.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20380-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 380-1 (xfree86)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"x-window-system", ver:"4.1.0-16woody1", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"xfonts-100dpi-transcoded", ver:"4.1.0-16woody1", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"xfonts-100dpi", ver:"4.1.0-16woody1", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"xfonts-75dpi-transcoded", ver:"4.1.0-16woody1", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"xfonts-75dpi", ver:"4.1.0-16woody1", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"xfonts-base-transcoded", ver:"4.1.0-16woody1", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"xfonts-base", ver:"4.1.0-16woody1", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"xfonts-cyrillic", ver:"4.1.0-16woody1", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"xfonts-pex", ver:"4.1.0-16woody1", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"xfonts-scalable", ver:"4.1.0-16woody1", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"xfree86-common", ver:"4.1.0-16woody1", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"xlib6g-dev", ver:"4.1.0-16woody1", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"xlib6g", ver:"4.1.0-16woody1", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"xspecs", ver:"4.1.0-16woody1", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"lbxproxy", ver:"4.1.0-16woody1", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libdps-dev", ver:"4.1.0-16woody1", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libdps1", ver:"4.1.0-16woody1", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libdps1-dbg", ver:"4.1.0-16woody1", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libxaw6", ver:"4.1.0-16woody1", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libxaw6-dbg", ver:"4.1.0-16woody1", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libxaw6-dev", ver:"4.1.0-16woody1", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libxaw7", ver:"4.1.0-16woody1", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libxaw7-dbg", ver:"4.1.0-16woody1", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libxaw7-dev", ver:"4.1.0-16woody1", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"proxymngr", ver:"4.1.0-16woody1", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"twm", ver:"4.1.0-16woody1", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"x-window-system-core", ver:"4.1.0-16woody1", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"xbase-clients", ver:"4.1.0-16woody1", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"xdm", ver:"4.1.0-16woody1", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"xfs", ver:"4.1.0-16woody1", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"xfwp", ver:"4.1.0-16woody1", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"xlibmesa-dev", ver:"4.1.0-16woody1", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"xlibmesa3", ver:"4.1.0-16woody1", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"xlibmesa3-dbg", ver:"4.1.0-16woody1", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"xlibosmesa-dev", ver:"4.1.0-16woody1", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"xlibosmesa3", ver:"4.1.0-16woody1", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"xlibosmesa3-dbg", ver:"4.1.0-16woody1", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"xlibs", ver:"4.1.0-16woody1", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"xlibs-dbg", ver:"4.1.0-16woody1", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"xlibs-dev", ver:"4.1.0-16woody1", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"xlibs-pic", ver:"4.1.0-16woody1", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"xmh", ver:"4.1.0-16woody1", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"xnest", ver:"4.1.0-16woody1", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"xprt", ver:"4.1.0-16woody1", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"xserver-common", ver:"4.1.0-16woody1", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"xserver-xfree86", ver:"4.1.0-16woody1", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"xterm", ver:"4.1.0-16woody1", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"xutils", ver:"4.1.0-16woody1", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"xvfb", ver:"4.1.0-16woody1", rls:"DEB3.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
