# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 585-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53277);
 script_cve_id("CVE-2004-1001");
 script_version ("$");
 script_tag(name:"cvss_base", value:"4.6");
 script_tag(name:"risk_factor", value:"Medium");
 name = "Debian Security Advisory DSA 585-1 (shadow)";
 script_name(name);

 desc = "The remote host is missing an update to shadow
announced via advisory DSA 585-1.

A vulnerability has been discovered in the shadow suite which provides
programs like chfn and chsh.  It is possible for a user, who is logged
in but has an expired password to alter his account information with
chfn or chsh without having to change the password.  The problem was
originally thought to be more severe.

For the stable distribution (woody) this problem has been fixed in
version 20000902-12woody1.

For the unstable distribution (sid) this problem has been fixed in
version 4.0.3-30.3.

We recommend that you upgrade your passwd package (from the shadow


Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20585-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 585-1 (shadow)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"login", ver:"20000902-12woody1", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"passwd", ver:"20000902-12woody1", rls:"DEB3.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
