#
#VID f241641e-f5ea-11d9-a6db-000d608ed240
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from vuxml or freebsd advisories
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(54366);
 script_cve_id("CVE-2005-1921", "CVE-2005-2106");
 script_version ("$");
 script_tag(name:"cvss_base", value:"7.5");
 script_tag(name:"risk_factor", value:"High");
 name = "FreeBSD Ports: drupal";
 script_name(name);

 desc = "The remote host is missing an update to the system
as announced in the referenced advisory.

The following package is affected: drupal

CVE-2005-1921
PEAR XML_RPC 1.3.0 and earlier (aka XML-RPC or xmlrpc), as used in
products such as WordPress, Serendipity, Drupal, egroupware, and
others, allows remote attackers to execute arbitrary PHP code via an
XML file, which is not properly sanitized before being used in an eval
statement.

CVE-2005-2106
Unknown vulnerability in Drupal 4.5.0 through 4.5.3, 4.6.0, and 4.6.1
allows remote attackers to execute arbitrary PHP code via a public
comment or posting.

Solution:
Update your system with the appropriate patches or
software upgrades.

http://drupal.org/files/sa-2005-002/advisory.txt
http://www.vuxml.org/freebsd/f241641e-f5ea-11d9-a6db-000d608ed240.html

Risk factor : High";

 script_description(desc);

 summary = "FreeBSD Ports: drupal";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "FreeBSD Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdrel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
bver = portver(pkg:"drupal");
if(!isnull(bver) && revcomp(a:bver, b:"4.6.2")<0) {
    security_note(0, data:"Package drupal version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
