###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_firefox_dos_vuln_win_jan10.nasl 6642 2010-01-12 16:05:33Z jan $
#
# Firefox 'nsObserverList::FillObserverArray' DOS Vulnerability (Win)
#
# Authors:
# Antu Sanadi <santu@secpod.com>
#
# Copyright:
# Copyright (c) 2010 Greenbone Networks GmbH, http://www.greenbone.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800416);
  script_version("$Revision: 7612 $: 1.0");
  script_tag(name:"cvss_base", value:"5.0");
  script_tag(name:"risk_factor", value:"Medium");
  script_cve_id("CVE-2010-0220");
  script_name("Firefox 'nsObserverList::FillObserverArray' DOS Vulnerability (Win)");
  desc = "
  Overview: The host is installed with Mozilla Firefox browser and is prone to
  Denial of Service vulnerability.

  Vulnerability Insight:
  The flaw is caused due to error in 'nsObserverList::FillObserverArray()' function
  in 'xpcom/ds/nsObserverList.cpp'

  Impact:
  Successful remote exploitation will let the attacker to  crash application
  via a crafted web site that triggers memory consumption and an accompanying
  Low Memory alert dialog, and also triggers attempted removal of an observer
  from an empty observers array.

  Impact Level: Application.

  Affected Software/OS:
  Mozilla Firefox version prior to 3.5.7 on Windows.

  Fix: Upgrade to Firefox version 3.5.7
  http://www.mozilla.com/en-US/firefox/all.html

  References:
  http://isc.sans.org/diary.html?storyid=7897
  https://bugzilla.mozilla.org/show_bug.cgi?id=507114
  http://www.mozilla.com/en-US/firefox/3.5.7/releasenotes

  CVSS Score:
    CVSS Base Score      : 5.0 (AV:N/AC:L/Au:NR/C:N/I:N/A:P)
    CVSS Temporal Score  : 3.7
  Risk factor : Medium";

  script_description(desc);
  script_summary("Check for the version of Mozilla Firefox");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (c) 2010 Greenbone Networks GmbH");
  script_family("Denial of Service");
  script_dependencies("gb_firefox_detect_win.nasl");
  script_require_keys("Firefox/Win/Ver");
  exit(0);
}


include("version_func.inc");

firefoxVer = get_kb_item("Firefox/Win/Ver");
if(!firefoxVer){
  exit(0);
}

if(version_is_less(version:firefoxVer, test_version:"3.5.7")){
  security_warning(0);
}
