###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_samba_sec_bypass_vuln.nasl 3188 2009-06-25 17:25:10Z jun $
#
# Samba Security Bypass Vulnerability
#
# Authors:
# Antu Sanadi <santu@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################


if(description)
{
  script_id(900685);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"4.3");
  script_tag(name:"risk_factor", value:"Medium");
  script_cve_id("CVE-2009-1888");
  script_bugtraq_id(35472);
  script_name("Samba Format String Vulnerability");
  desc = "

  Overview: The host has Samba installed and is prone to Security Bypass
  Vulnerability.

  Vulnerability Insight:
  The flaw is due to uninitialised memory access error in 'smbd' when denying
  attempts to modify a restricted access control list. This can be exploited
  to modify the ACL of an already writable file without required permissions.

  Impact:
  When dos filemode is set to yes in the smb.conf, attackers can exploit this
  issue to bypass certain security restrictions and compromise a user's system.

  Impact Level: System

  Affected Software/OS:
  Samba 3.0.0 before 3.0.35 on Linux.
  Samba 3.1.x on Linux.
  Samba 3.2.4 before 3.2.13 on Linux.
  Samba 3.3.0 before 3.3.6 on Linux.

  Fix: Upgrade to 3.3.6 of Samba,
  http://us3.samba.org/samba/

  References:
  http://secunia.com/advisories/35539
  http://www.vupen.com/english/advisories/2009/1664

  ******************************************************************************
  Note: This may be a false positive as the package version is only being checked.
  Each operating system vendor might have shipped Samba with backported versions.
  ******************************************************************************

  CVSS Score:
    CVSS Base Score      : 4.3 (AV:N/AC:M/Au:NR/C:N/I:N/A:P)
    CVSS Temporal Score  : 3.2
  Risk factor : Medium";

  script_description(desc);
  script_summary("Check for the version of Samba");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Remote file access");
  script_dependencies("gb_samba_detect.nasl");
  script_require_keys("Samba/Version");
  exit(0);
}


include("version_func.inc");

smbVer = get_kb_item("Samba/Version");
smbVer = ereg_replace(pattern:"-", string:smbVer, replace:".");
smbVer = ereg_replace(pattern:"\.([a-z|A-Z].*)", string:smbVer, replace:"");
if(!smbVer){
  exit(0);
}

if(version_in_range(version:smbVer, test_version:"3.0", test_version2:"3.0.34")||
   version_in_range(version:smbVer, test_version:"3.2", test_version2:"3.2.12")||
   version_in_range(version:smbVer, test_version:"3.3", test_version2:"3.3.5")||
   (smbVer =~ "3.1")){
  security_warning(0);
}
