################################################################################
# This script was written by Carsten Koch-Mauthe <c.koch-mauthe at dn-systems.de>
#
# This script is released under the GNU GPLv2
#
# $Revision: 03 $
#
# Modified to Implement 'smb_nt.inc'
#  - By Nikita MR <rnikita@secpod.com> On 2009-09-18
################################################################################

if(description)
{
  script_id(90015);
  script_version ("$Revision: 03 $");
  script_tag(name:"cvss_base", value:"10.0");
  script_tag(name:"risk_factor", value:"Critical");
  script_cve_id("CVE-2008-0080");
  script_bugtraq_id(27670);
  script_name("Mini-Redirector Heap Overflow Vulnerability");
  desc = "
  Overview: This host has critical security update missing according to
  Microsoft Bulletin MS008-007

  Vulnerability Insight:
  A boundary error occurs in the WebDAV Mini-Redirector when handling long
  pathnames in WebDAV responses.

  Impact:
  Succesful exploitation will allow attackes to execute arbitrary code and
  completely compromise the affected computer.

  References:
  http://secunia.com/advisories/28894
  http://www.cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2008-0080
  http://www.microsoft.com/technet/security/bulletin/ms08-007.mspx

  Workarounds:
  Disable the WebClient Service.

  Solution:
  Run Windows Update and update the listed hotfixes or download and
  update mentioned hotfixes in the advisory from the below link,
  http://www.microsoft.com/technet/security/bulletin/ms08-007.mspx

  Risk factor : Critical";

  script_description(desc);
  script_summary("Mini-Redirector Heap Overflow Vulnerability");
  script_category(ACT_GATHER_INFO);
  script_copyright("This script is under GPLv2");
  script_family("Windows : Microsoft Bulletins");
  script_dependencies("secpod_reg_enum.nasl");
  script_require_ports(139, 445);
  exit(0);
}


include("smb_nt.inc");
include("secpod_reg.inc");
include("version_func.inc");
include("secpod_smb_func.inc");

if(hotfix_check_sp(xp:3, win2003:3) <= 0)
{
  exit(0);
}

# MS08-007 Hotfix check
if(hotfix_missing(name:"946026") == 0)
{
  exit(0);
}

sysPath = registry_get_sz(item:"Install Path",
                          key:"SOFTWARE\Microsoft\COM3\Setup");
if(!sysPath)
{
  exit(0);
}

share = ereg_replace(pattern:"([A-Z]):.*", replace:"\1$", string:sysPath);
file = ereg_replace(pattern:"[A-Z]:(.*)", replace:"\1",
                    string:sysPath + "\drivers\mrxdav.sys");
sysVer = GetVer(file:file, share:share);
if(!sysVer)
{
  exit(0);
}

# Windows XP
if(hotfix_check_sp(xp:3) > 0)
{
  SP = get_kb_item("SMB/WinXP/ServicePack");
  if("Service Pack 2" >< SP)
  {
    # Grep for mrxdav.sys version < 5.1.2600.3276
    if(version_in_range(version:sysVer, test_version:"5.1",
                                       test_version2:"5.1.2600.3275")){
      security_hole(0);
    }
  }
  else
    security_hole(0);
}

# Windows 2003
else if(hotfix_check_sp(win2003:3) > 0)
{
  SP = get_kb_item("SMB/Win2003/ServicePack");
  if("Service Pack 2" >< SP)
  {
    # Grep for mrxdav.sys version < 5.2.3790.4206
    if(version_in_range(version:sysVer, test_version:"5.2",
                                       test_version2:"5.2.3790.4205")){
      security_hole(0);
    }
  }
  else if("Service Pack 1" >< SP)
  {
    # Grep for mrxdav.sys version < 5.2.3790.3060
    if(version_in_range(version:sysVer, test_version:"5.2",
                                       test_version2:"5.2.3790.3059")){
      security_hole(0);
    }
  }
  else
    security_hole(0);
}
