//*******************************************************************
// Copyright (C) 2000 ImageLinks Inc. 
//
// License:  See top level LICENSE.txt file
//
// Author: Ken Melero (kmelero@remotesensing.org)
// 
// Description: Common file for global Keywords.
//
//*************************************************************************
// $Id: ossimKeywordNames.cpp 15464 2009-09-23 19:30:35Z okramer $

#include <ossim/base/ossimKeywordNames.h>

const char* ossimKeywordNames::AZIMUTH_ANGLE_KW = "azimuth_angle";
const char* ossimKeywordNames::BAND_KW = "band";
const char* ossimKeywordNames::BORDER_SIZE_KW = "border_size";
const char* ossimKeywordNames::BRUSH_COLOR_KW = "brush_color";
const char* ossimKeywordNames::BYTE_ORDER_KW = "byte_order";
const char* ossimKeywordNames::CENTRAL_MERIDIAN_KW = "central_meridian";
const char* ossimKeywordNames::CENTRAL_POINT1_LAT_KW = "central_point1_lat";
const char* ossimKeywordNames::CENTRAL_POINT1_LON_KW = "central_point1_lon";
const char* ossimKeywordNames::CENTRAL_POINT2_LAT_KW = "central_point2_lat";
const char* ossimKeywordNames::CENTRAL_POINT2_LON_KW = "central_point2_lon";
const char* ossimKeywordNames::CENTER_PIXEL_X_KW = "center_pixel_x";
const char* ossimKeywordNames::CENTER_PIXEL_Y_KW = "center_pixel_y";
const char* ossimKeywordNames::COMPRESS_KW = "compress";
const char* ossimKeywordNames::COMPRESSION_QUALITY_KW = "compression_quality";
const char* ossimKeywordNames::COMPRESSION_TYPE_KW = "compression_type";
const char* ossimKeywordNames::CONVERGENCE_THRESHOLD_KW = "convergence_threshold";
const char* ossimKeywordNames::CREATE_EXTERNAL_GEOMETRY_KW = "create_external_geometry";
const char* ossimKeywordNames::CREATE_IMAGE_KW = "create_image";
const char* ossimKeywordNames::CREATE_HISTOGRAM_KW = "create_histogram";
const char* ossimKeywordNames::CREATE_OVERVIEW_KW = "create_overview";
const char* ossimKeywordNames::DATA_FILE_KW = "data_file";
const char* ossimKeywordNames::DATE_KW = "date";
const char* ossimKeywordNames::DATE_YEAR_KW = "year";
const char* ossimKeywordNames::DATE_MONTH_KW = "month";
const char* ossimKeywordNames::DATE_DAY_KW = "day";
const char* ossimKeywordNames::DATE_HOUR_KW = "hour";
const char* ossimKeywordNames::DATE_MIN_KW = "min";
const char* ossimKeywordNames::DATE_SEC_KW = "sec";
const char* ossimKeywordNames::DATE_FRACT_SEC_KW = "fract_sec";
const char* ossimKeywordNames::DATUM_KW = "datum";
const char* ossimKeywordNames::DECIMAL_DEGREES_PER_PIXEL_LAT = "decimal_degrees_per_pixel_lat";
const char* ossimKeywordNames::DECIMAL_DEGREES_PER_PIXEL_LON = "decimal_degrees_per_pixel_lon";
const char* ossimKeywordNames::DESCRIPTION_KW = "description";
const char* ossimKeywordNames::ELEVATION_ANGLE_KW = "elevation_angle";
const char* ossimKeywordNames::ELEVATION_CELL_KW = "elevation_cell";
const char* ossimKeywordNames::ELEVATION_SOURCE_KW = "elevation_source";
const char* ossimKeywordNames::ELEVATION_LOOKUP_FLAG_KW = "elevation_lookup_flag";
const char* ossimKeywordNames::ELLIPSE_CODE_KW = "ellipse_code";
const char* ossimKeywordNames::ELLIPSE_NAME_KW = "ellipse_name";
const char* ossimKeywordNames::ENABLED_KW = "enabled";
const char* ossimKeywordNames::ENABLE_CACHE_KW = "enable_cache";
const char* ossimKeywordNames::ENTRY_KW = "entry";
const char* ossimKeywordNames::FALSE_EASTING_NORTHING_KW = "false_easting_northing";
const char* ossimKeywordNames::FALSE_EASTING_NORTHING_UNITS_KW = "false_easting_northing_units";
const char* ossimKeywordNames::FALSE_EASTING_KW = "false_easting";
const char* ossimKeywordNames::FALSE_NORTHING_KW = "false_northing";
const char* ossimKeywordNames::FEATURE_NAME_KW = "feature_name";
const char* ossimKeywordNames::FILENAME_KW = "filename";
const char* ossimKeywordNames::FILEPATH_KW = "filepath";
const char* ossimKeywordNames::FILL_FLAG_KW = "fill_flag";
const char* ossimKeywordNames::GEOM_FILE_KW = "geom_file";
const char* ossimKeywordNames::HEMISPHERE_KW = "hemisphere";
const char* ossimKeywordNames::HORIZONTAL_SIZE_KW = "horizontal_size";
const char* ossimKeywordNames::ID_KW ="id";
const char* ossimKeywordNames::IMAGE_FILE_KW = "image_file";
const char* ossimKeywordNames::IMAGE_ID_KW = "image_id";
const char* ossimKeywordNames::IMAGE_MODEL_TRANSFORM_MATRIX_KW = "image_model_transform_matrix";
const char* ossimKeywordNames::IMAGE_MODEL_TRANSFORM_UNIT_KW = "image_model_transform_unit";
const char* ossimKeywordNames::IMAGE_PATH_KW = "image_path";
const char* ossimKeywordNames::IMAGE_TYPE_KW = "image_type";
const char* ossimKeywordNames::IMAGE_DATE_KW = "image_date";
const char* ossimKeywordNames::IMAGE_FILE_SIZE_KW = "image_file_size";
const char* ossimKeywordNames::INPUT_RR_LEVEL_KW = "input_rr_level";
const char* ossimKeywordNames::INTERLEAVE_TYPE_KW = "interleave_type";
const char* ossimKeywordNames::JULIAN_DAY_KW = "julian_day";
const char* ossimKeywordNames::LAT_INCREMENT_KW = "lat_increment";
const char* ossimKeywordNames::LL_LAT_KW = "ll_lat";
const char* ossimKeywordNames::LL_LON_KW = "ll_lon";
const char* ossimKeywordNames::LR_LAT_KW = "lr_lat";
const char* ossimKeywordNames::LR_LON_KW = "lr_lon";
const char* ossimKeywordNames::LL_X_KW = "ll_x";
const char* ossimKeywordNames::LL_Y_KW = "ll_y";
const char* ossimKeywordNames::LR_X_KW = "lr_x";
const char* ossimKeywordNames::LR_Y_KW = "lr_y";
const char* ossimKeywordNames::LON_INCREMENT_KW = "lon_increment";
const char* ossimKeywordNames::MAJOR_AXIS_KW = "major_axis";
const char* ossimKeywordNames::MAX_VALUE_KW = "max_value";
const char* ossimKeywordNames::MAX_ITERATIONS_KW = "max_iterations";
const char* ossimKeywordNames::MAX_QUADTREE_LEVELS_KW = "max_quadtree_levels";
const char* ossimKeywordNames::METADATA_TYPE_KW = "metadata_type";
const char* ossimKeywordNames::METERS_PER_PIXEL_X_KW = "meters_per_pixel_x";
const char* ossimKeywordNames::METERS_PER_PIXEL_Y_KW = "meters_per_pixel_y";
const char* ossimKeywordNames::MINOR_AXIS_KW = "minor_axis";
const char* ossimKeywordNames::MIN_VALUE_KW = "min_value";
const char* ossimKeywordNames::NULL_VALUE_KW = "null_value";
const char* ossimKeywordNames::NUMBER_BANDS_KW = "number_bands";
const char* ossimKeywordNames::NUMBER_ENTRIES_KW = "number_entries";
const char* ossimKeywordNames::NUMBER_INPUT_BANDS_KW = "number_input_bands";
const char* ossimKeywordNames::NUMBER_INPUTS_KW = "number_inputs";
const char* ossimKeywordNames::NUMBER_OUTPUTS_KW = "number_outputs";
const char* ossimKeywordNames::NUMBER_OUTPUT_BANDS_KW = "number_output_bands";
const char* ossimKeywordNames::NUMBER_LINES_KW = "number_lines";
const char* ossimKeywordNames::NUMBER_REDUCED_RES_SETS_KW = "number_reduced_res_sets";
const char* ossimKeywordNames::NUMBER_SAMPLES_KW = "number_samples";
const char* ossimKeywordNames::ORIGIN_X_KW = "origin_x";
const char* ossimKeywordNames::ORIGIN_Y_KW = "origin_y";
const char* ossimKeywordNames::ORIGIN_LATITUDE_KW = "origin_latitude";
const char* ossimKeywordNames::OUTPUT_FILE_KW = "output_file";
const char* ossimKeywordNames::OUTPUT_FILE_PREFIX_KW = "output_file_prefix";
const char* ossimKeywordNames::OUTPUT_FILE_EXTENSION_KW = "output_file_extension";
const char* ossimKeywordNames::OUTPUT_TILE_SIZE_KW = "output_tile_size";
const char* ossimKeywordNames::OVERVIEW_COMPRESSION_QUALITY_KW = "overview_compression_quality";
const char* ossimKeywordNames::OVERVIEW_COMPRESSION_TYPE_KW = "overview_compression_type";
const char* ossimKeywordNames::OVERVIEW_FILE_KW  = "overview_file";
const char* ossimKeywordNames::PCS_CODE_KW = "pcs_code";
const char* ossimKeywordNames::PEN_COLOR_KW = "pen_color";
const char* ossimKeywordNames::PHOTOMETRIC_KW    = "photometric";
const char* ossimKeywordNames::PIXEL_SCALE_XY_KW = "pixel_scale_xy";
// const char* ossimKeywordNames::PIXEL_SCALE_Y_KW = "pixel_scale_y";
const char* ossimKeywordNames::PIXEL_SCALE_UNITS_KW = "pixel_scale_units";

const char* ossimKeywordNames::PIXEL_TYPE_KW  = "pixel_type";
const char* ossimKeywordNames::PLANAR_CONFIG_KW  = "planar_config";
const char* ossimKeywordNames::POINT_WIDTH_HEIGHT_KW = "point_width_height";
const char* ossimKeywordNames::PROJECTION_KW     = "projection";
const char* ossimKeywordNames::QUALITY_KW        = "quality";
const char* ossimKeywordNames::RADIOMETRY_KW = "radiometry";
const char* ossimKeywordNames::REDUCED_RES_LEVEL_KW = "reduced_res_level";
const char* ossimKeywordNames::REF_GPT_LAT_KW  = "ref_point_lat";
const char* ossimKeywordNames::REF_GPT_LON_KW  = "ref_point_lon";
const char* ossimKeywordNames::REF_GPT_HGT_KW  = "ref_point_hgt";
const char* ossimKeywordNames::REF_IPT_LINE_KW = "ref_point_line";
const char* ossimKeywordNames::REF_IPT_SAMP_KW = "ref_point_samp";
const char* ossimKeywordNames::ROTATION_KW = "rotation";
const char* ossimKeywordNames::SCALE_PER_PIXEL_X_KW = "scale_per_pixel_x";
const char* ossimKeywordNames::SCALE_PER_PIXEL_Y_KW = "scale_per_pixel_y";
const char* ossimKeywordNames::SCALAR_TYPE_KW    = "scalar_type";
const char* ossimKeywordNames::SCALE_FACTOR_KW   = "scale_factor";
const char* ossimKeywordNames::SCALE_FACTOR_X_KW = "scale_factor_x";
const char* ossimKeywordNames::SCALE_FACTOR_Y_KW = "scale_factor_y";
const char* ossimKeywordNames::SCALE_X_KW = "scale_x";
const char* ossimKeywordNames::SCALE_Y_KW = "scale_y";
const char* ossimKeywordNames::SENSOR_ID_KW = "sensor";
const char* ossimKeywordNames::STD_PARALLEL_1_KW = "std_parallel_1";
const char* ossimKeywordNames::STD_PARALLEL_2_KW = "std_parallel_2";
const char* ossimKeywordNames::THICKNESS_KW = "thickness";
const char* ossimKeywordNames::TIE_POINT_EASTING_KW = "tie_point_easting";  // ????
const char* ossimKeywordNames::TIE_POINT_NORTHING_KW = "tie_point_northing";  // ????
const char* ossimKeywordNames::TIE_POINT_XY_KW = "tie_point_xy";  // ????
// const char* ossimKeywordNames::TIE_POINT_Y_KW = "tie_point_y";  // ????
const char* ossimKeywordNames::TIE_POINT_UNITS_KW = "tie_point_units";
const char* ossimKeywordNames::TIE_POINT_LAT_KW = "tie_point_lat";
const char* ossimKeywordNames::TIE_POINT_LON_KW = "tie_point_lon";
const char* ossimKeywordNames::TILE_SIZE_X_KW = "tile_size_x";
const char* ossimKeywordNames::TILE_SIZE_Y_KW = "tile_size_y";
const char* ossimKeywordNames::TILE_SOURCE_KW = "tile_source";
const char* ossimKeywordNames::TILE_TYPE_KW = "tile_type";
const char* ossimKeywordNames::TRANSLATION_X_KW = "translation_x";
const char* ossimKeywordNames::TRANSLATION_Y_KW = "translation_y";
const char* ossimKeywordNames::TYPE_KW = "type";
const char* ossimKeywordNames::UL_LAT_KW = "ul_lat";
const char* ossimKeywordNames::UL_LON_KW = "ul_lon";
const char* ossimKeywordNames::UNITS_KW = "units";
const char* ossimKeywordNames::UR_LAT_KW = "ur_lat";
const char* ossimKeywordNames::UR_LON_KW = "ur_lon";
const char* ossimKeywordNames::UL_X_KW = "ul_x";
const char* ossimKeywordNames::UL_Y_KW = "ul_y";
const char* ossimKeywordNames::UR_X_KW = "ur_x";
const char* ossimKeywordNames::UR_Y_KW = "ur_y";
const char* ossimKeywordNames::VERTICAL_SIZE_KW = "vertical_size";
const char* ossimKeywordNames::ZONE_KW = "zone";

ossimKeywordNames::ossimKeywordNames()
{}

ossimKeywordNames::ossimKeywordNames(const ossimKeywordNames& /* rhs */)
{}

const ossimKeywordNames& ossimKeywordNames::operator=(const ossimKeywordNames& /* rhs */)
{
   return *this;
}
