///////////////////////////////////////////////////////////////////////////////
//
//  Copyright (2008) Alexander Stukowski
//
//  This file is part of OVITO (Open Visualization Tool).
//
//  OVITO is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  OVITO is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
///////////////////////////////////////////////////////////////////////////////

#ifndef __ATOMVIZ_ALPHA_SHAPE_UTILITY_H
#define __ATOMVIZ_ALPHA_SHAPE_UTILITY_H

#include <core/Core.h>
#include <core/plugins/utility/UtilityPlugin.h>
#include <core/gui/SpinnerWidget.h>
#include <mesh/tri/TriMesh.h>

#include "../CrystalAnalysis.h"

namespace CrystalAnalysis {

/**
 * \brief This utility applet lets the user create an alpha shape from a set of atoms.
 *
 * \author Alexander Stukowski
 */
class ATOMVIZ_DLLEXPORT AlphaShapeUtility : public UtilityPlugin
{
public:

	/// Default constructor.
	AlphaShapeUtility();

	/// Shows the UI of the utility in the given RolloutContainer.
	virtual void openUtility(RolloutContainer* container, const RolloutInsertionParameters& rolloutParams = RolloutInsertionParameters());

	/// Removes the UI of the utility from the rollout container.
	virtual void closeUtility(RolloutContainer* container);

protected Q_SLOTS:

	/// Is called when the user presses the Create Shape button.
	void onCreateShape();

private:

	/// Calls the CGAL library to build the slpha shape.
	bool createAlphaShape(FloatType alpha, bool smooth, const QVector<Point3>& points, TriMesh& mesh);

	/// The applet panel.
	QWidget* rollout;

	SpinnerWidget* alphaValueSpinner;
	QCheckBox* smoothCheckBox;
	QCheckBox* processAllClustersCheckBox;
	QCheckBox* deleteProcessedAtomsCheckBox;

	Q_OBJECT
	DECLARE_PLUGIN_CLASS(AlphaShapeUtility)
};

};

#endif // __ATOMVIZ_ALPHA_SHAPE_UTILITY_H
